/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.LocalizedFtpReply;

public class OPTS_MLST
extends AbstractCommand {
    private static final String[] AVAILABLE_TYPES = new String[]{"Size", "Modify", "Type", "Perm"};

    @Override
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        String listTypes;
        String[] types;
        session.resetState();
        String argument = request.getArgument();
        int spIndex = argument.indexOf(32);
        if (spIndex == -1) {
            types = new String[]{};
            listTypes = "";
        } else {
            listTypes = argument.substring(spIndex + 1);
            StringTokenizer st = new StringTokenizer(listTypes, ";");
            types = new String[st.countTokens()];
            for (int i = 0; i < types.length; ++i) {
                types[i] = st.nextToken();
            }
        }
        String[] validatedTypes = this.validateSelectedTypes(types);
        session.setAttribute("MLST.types", validatedTypes);
        session.write((Object)LocalizedFtpReply.translate(session, request, context, 200, "OPTS.MLST", listTypes));
    }

    private String[] validateSelectedTypes(String ... types) {
        if (types == null) {
            return new String[0];
        }
        ArrayList<String> selectedTypes = new ArrayList<String>();
        block0: for (String type : types) {
            for (String availableType : AVAILABLE_TYPES) {
                if (!availableType.equalsIgnoreCase(type)) continue;
                selectedTypes.add(availableType);
                continue block0;
            }
        }
        return selectedTypes.toArray(new String[0]);
    }
}

