/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation;

import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.xmind.gef.IViewer;
import org.xmind.gef.service.AbstractViewerService;
import org.xmind.ui.util.Cancelable;

public class HideCursorService
extends AbstractViewerService
implements Listener {
    private static Cursor EMPTY_POINTER = null;
    private boolean cursorHidden = false;
    private Cancelable hideJob = null;

    private static final Cursor getEmptyPointer() {
        if (EMPTY_POINTER == null) {
            Point[] sizes;
            int w = 16;
            int h = 16;
            Display display = Display.getCurrent();
            if (display != null && (sizes = display.getCursorSizes()) != null && sizes.length > 0) {
                Point size = sizes[0];
                w = size.x;
                h = size.y;
            }
            ImageData source = new ImageData(w, h, 16, new PaletteData(0xFF0000, 65280, 255));
            int x = 0;
            while (x < w) {
                int y = 0;
                while (y < h) {
                    source.setPixel(x, y, 0xFFFFFF);
                    ++y;
                }
                ++x;
            }
            ImageData mask = new ImageData(w, h, 16, new PaletteData(0xFF0000, 65280, 255));
            EMPTY_POINTER = new Cursor((Device)display, source, mask, w / 2, h / 2);
        }
        return EMPTY_POINTER;
    }

    public HideCursorService(IViewer viewer) {
        super(viewer);
    }

    protected void activate() {
    }

    protected void deactivate() {
    }

    public boolean isCursorHidden() {
        return this.cursorHidden;
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        control.addListener(32, (Listener)this);
        control.addListener(5, (Listener)this);
        control.addListener(3, (Listener)this);
        this.slightMoveMouse(control.getDisplay());
    }

    private void slightMoveMouse(final Display display) {
        Point loc = display.getCursorLocation();
        Rectangle bounds = display.getBounds();
        int x = loc.x > bounds.x ? loc.x - 1 : loc.x + 1;
        final Event event = new Event();
        event.type = 5;
        event.x = x;
        event.y = loc.y;
        display.asyncExec(new Runnable(){

            public void run() {
                display.post(event);
            }
        });
    }

    protected void unhookControl(Control control) {
        control.removeListener(32, (Listener)this);
        control.removeListener(5, (Listener)this);
        control.removeListener(3, (Listener)this);
        super.unhookControl(control);
    }

    public void handleEvent(Event event) {
        if (event.type == 32) {
            this.hideCursor();
        } else {
            this.showCursor();
        }
    }

    private void showCursor() {
        if (this.hideJob != null) {
            this.hideJob.cancel();
            this.hideJob = null;
        }
        if (!this.cursorHidden) {
            return;
        }
        this.getControl().setCursor(null);
        this.cursorHidden = false;
    }

    private void hideCursor() {
        if (this.hideJob != null) {
            return;
        }
        this.hideJob = new Cancelable(){

            protected void doJob() {
                if (HideCursorService.this.getControl() == null || HideCursorService.this.getControl().isDisposed()) {
                    return;
                }
                HideCursorService.this.hideJob = null;
                if (HideCursorService.this.cursorHidden) {
                    return;
                }
                HideCursorService.this.cursorHidden = true;
                HideCursorService.this.getControl().setCursor(HideCursorService.getEmptyPointer());
                HideCursorService.this.getViewer().setPreselected(null);
            }
        };
        this.getControl().getDisplay().timerExec(1000, (Runnable)this.hideJob);
    }
}

