/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.util.Calendar;
import org.xmind.ui.internal.taskinfo.DateInfo;

public class DateRange {
    public Calendar start;
    public Calendar end;
    private boolean isFirst;

    public DateRange() {
        this.start = DateInfo.today();
        this.end = DateInfo.today();
    }

    public void setFirst(boolean isFirst) {
        this.isFirst = isFirst;
    }

    public boolean isFirst() {
        return this.isFirst;
    }

    public DateRange(Calendar start, Calendar end) {
        this.start = start;
        this.end = end;
    }

    public static Calendar copyDate(Calendar source) {
        Calendar date = DateInfo.today();
        date.setTimeInMillis(source.getTimeInMillis());
        return date;
    }

    public static Calendar rollDate(Calendar source, int field, int amount) {
        Calendar date = DateRange.copyDate(source);
        date.add(field, amount);
        switch (field) {
            case 1: {
                date.set(2, 0);
            }
            case 2: {
                date.set(5, 1);
            }
            case 5: {
                date.set(10, 0);
            }
            case 10: {
                date.set(12, 0);
            }
            case 12: {
                date.set(13, 0);
            }
        }
        date.set(14, 0);
        return date;
    }

    public static DateRange rangeStartedFrom(Calendar start, int addField, int duration) {
        return new DateRange(DateRange.copyDate(start), DateRange.rollDate(start, addField, duration));
    }

    public static DateRange rangeEndedTo(Calendar end, int minusField, int duration) {
        return new DateRange(DateRange.rollDate(end, minusField, -duration), DateRange.copyDate(end));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof DateRange)) {
            return false;
        }
        DateRange that = (DateRange)obj;
        return this.start.equals(that.start) && this.end.equals(that.start);
    }

    public String toString() {
        return String.format("%1$tD %1$tT - %2$tD %2$tT", this.start, this.end);
    }

    public int hashCode() {
        return this.start.hashCode() ^ this.end.hashCode();
    }
}

