/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import com.ibm.icu.text.BreakIterator;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.draw2d.AbstractBackground;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Display;
import org.xmind.gef.draw2d.IRotatable;
import org.xmind.gef.draw2d.IRotatableFigure;
import org.xmind.gef.draw2d.ITextFigure;
import org.xmind.gef.draw2d.ITransparentableFigure;
import org.xmind.gef.draw2d.IWrapFigure;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionInsets;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.draw2d.geometry.PrecisionRotator;
import org.xmind.gef.draw2d.graphics.GraphicsUtils;
import org.xmind.gef.draw2d.graphics.Path;
import org.xmind.gef.util.GEFUtils;

public class RotatableWrapLabel
extends Figure
implements ITextFigure,
IWrapFigure,
IRotatableFigure,
ITransparentableFigure {
    private static final int FLAG_SINGLE_LINE = MAX_FLAG << 1;
    private static final int FLAG_ABBREVIATED;
    private static final float PADDING = 1.5f;
    private static final float RIGHT_MARGIN = 1.0f;
    private static final float[] RECT;
    private static final PrecisionDimension D;
    private static final PrecisionRectangle R;
    protected static final Dimension NO_TEXT_SIZE;
    public static final int NORMAL = 0;
    public static final int ADVANCED = 1;
    public static final String ELLIPSE = "...";
    private String text = "";
    private TextStyle style = null;
    private int align = 1;
    private int textCase = 1;
    private int renderStyle = 0;
    private int lineSpacing = -1;
    private int textAlpha = 255;
    private int fillAlpha = 255;
    private int prefWidth = -1;
    private Dimension cachedPrefSize = null;
    private String appliedText = null;
    private PrecisionRectangle textArea = null;
    private PrecisionDimension nonRotatedPrefSize = null;
    private PrecisionInsets rotatedInsets = null;
    private int cachedWidthHint = -1;
    private PrecisionRotator rotator = new PrecisionRotator();

    static {
        MAX_FLAG = FLAG_ABBREVIATED = MAX_FLAG << 2;
        RECT = new float[4];
        D = new PrecisionDimension();
        R = new PrecisionRectangle();
        NO_TEXT_SIZE = new Dimension(1, 10);
    }

    public RotatableWrapLabel() {
    }

    public RotatableWrapLabel(String text) {
        this.setText(text);
    }

    public RotatableWrapLabel(int renderStyle) {
        this.renderStyle = renderStyle;
    }

    public RotatableWrapLabel(String text, int renderStyle) {
        this.setText(text);
        this.renderStyle = renderStyle;
    }

    public int getPrefWidth() {
        return this.prefWidth;
    }

    public void setPrefWidth(int prefWidth) {
        if (prefWidth == this.prefWidth) {
            return;
        }
        this.prefWidth = prefWidth;
        this.revalidate();
        this.repaint();
    }

    public boolean isSingleLine() {
        return this.getFlag(FLAG_SINGLE_LINE);
    }

    public void setSingleLine(boolean singleLine) {
        if (singleLine == this.isSingleLine()) {
            return;
        }
        this.setFlag(FLAG_SINGLE_LINE, singleLine);
        this.revalidate();
        this.repaint();
    }

    public boolean isAbbreviated() {
        return this.getFlag(FLAG_ABBREVIATED);
    }

    public void setAbbreviated(boolean abbreviated) {
        if (abbreviated == this.isAbbreviated()) {
            return;
        }
        this.setFlag(FLAG_ABBREVIATED, abbreviated);
        this.revalidate();
        this.repaint();
    }

    public void setMainAlpha(int alpha) {
        if (alpha == this.textAlpha) {
            return;
        }
        this.textAlpha = alpha;
        this.repaint();
    }

    public int getMainAlpha() {
        return this.textAlpha;
    }

    public void setSubAlpha(int alpha) {
        if (alpha == this.fillAlpha) {
            return;
        }
        this.fillAlpha = alpha;
        this.repaint();
    }

    public int getSubAlpha() {
        return this.fillAlpha;
    }

    public TextStyle getStyle() {
        return this.style;
    }

    public int getRenderStyle() {
        return this.renderStyle;
    }

    public String getText() {
        return this.text;
    }

    public int getTextAlignment() {
        return this.align;
    }

    public int getTextCase() {
        return this.textCase;
    }

    public double getRotationDegrees() {
        return this.rotator.getAngle();
    }

    public void setRotationDegrees(double degrees) {
        double oldAngle = this.getRotationDegrees();
        this.rotator.setAngle(degrees);
        if (this.getBorder() instanceof IRotatable) {
            ((IRotatable)this.getBorder()).setRotationDegrees(degrees);
        }
        if (this.getLayoutManager() instanceof IRotatable) {
            ((IRotatable)this.getLayoutManager()).setRotationDegrees(degrees);
        }
        for (Object child : this.getChildren()) {
            if (!(child instanceof IRotatable)) continue;
            ((IRotatable)child).setRotationDegrees(degrees);
        }
        if (degrees != oldAngle) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setStyle(TextStyle style) {
        if (GEFUtils.equals(this.style, style)) {
            return;
        }
        this.style = style;
        if (style != null) {
            super.setFont(style.font);
            super.setForegroundColor(style.foreground);
        } else {
            super.setFont(null);
            super.setForegroundColor(null);
        }
        this.repaint();
    }

    public void setFont(Font f) {
        Font old = this.getLocalFont();
        super.setFont(f);
        if (this.getLocalFont() != old && this.style != null) {
            this.style.font = f;
        }
    }

    public void setForegroundColor(Color fg) {
        Color old = this.getLocalForegroundColor();
        super.setForegroundColor(fg);
        if (this.getLocalForegroundColor() != old && this.style != null) {
            this.style.foreground = fg;
        }
    }

    public void setRenderStyle(int style) {
        if (style == this.renderStyle || style != 0 && style != 1) {
            return;
        }
        this.renderStyle = style;
        this.revalidate();
        this.repaint();
    }

    public void setText(String text) {
        String t;
        if (text == null) {
            text = "";
        }
        if (this.text.equals(t = text.replaceAll("\\r\\n|\\r", "\n"))) {
            return;
        }
        this.text = t;
        this.revalidate();
        this.repaint();
    }

    public void setTextAlignment(int align) {
        if (this.align == align) {
            return;
        }
        this.align = align;
        this.repaint();
    }

    public void setTextCase(int textCase) {
        if (this.textCase == textCase) {
            return;
        }
        this.textCase = textCase;
        this.revalidate();
        this.repaint();
    }

    protected void receiveWidthCaches(int wHint) {
        if (wHint != this.cachedWidthHint) {
            this.flushCaches();
        }
        this.cachedWidthHint = wHint;
    }

    protected void flushCaches() {
        this.cachedPrefSize = null;
        this.appliedText = null;
        this.textArea = null;
        this.nonRotatedPrefSize = null;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        if (this.prefSize != null) {
            return this.prefSize;
        }
        if (this.prefWidth > 0) {
            wHint = Math.max(0, this.prefWidth - this.getInsets().getWidth());
        } else if (wHint > 0) {
            wHint = Math.max(0, wHint - this.getInsets().getWidth());
        }
        this.receiveWidthCaches(wHint);
        if (this.getText().length() == 0) {
            return NO_TEXT_SIZE;
        }
        if (this.cachedPrefSize == null) {
            this.cachedPrefSize = this.calculateRotatedPreferredSize(wHint, hHint).toBiggerDraw2DDimension();
            this.cachedPrefSize.union(this.getMinimumSize(wHint, hHint));
        }
        return this.cachedPrefSize;
    }

    protected PrecisionDimension calculateRotatedPreferredSize(int wHint, int hHint) {
        PrecisionDimension d = this.getNormalPreferredSize(wHint, hHint);
        return this.rotator.td(d);
    }

    public PrecisionDimension getNormalPreferredSize(int wHint, int hHint) {
        if (this.prefWidth > 0) {
            wHint = Math.max(0, this.prefWidth - this.getInsets().getWidth());
        } else if (wHint > 0) {
            wHint = Math.max(0, wHint - this.getInsets().getWidth());
        }
        this.receiveWidthCaches(wHint);
        if (this.nonRotatedPrefSize == null) {
            this.nonRotatedPrefSize = this.calculateNormalPreferredSize(wHint);
        }
        return this.nonRotatedPrefSize;
    }

    protected PrecisionDimension calculateNormalPreferredSize(int wHint) {
        PrecisionDimension d = this.getTextArea(wHint).getSize();
        Insets insets = this.getInsets();
        d.expand(insets.getWidth(), insets.getHeight());
        return d;
    }

    public String getAppliedText() {
        return this.getAppliedText(this.cachedWidthHint);
    }

    protected String getAppliedText(int wHint) {
        this.receiveWidthCaches(wHint);
        if (this.appliedText == null) {
            this.appliedText = this.calculateAppliedText(wHint);
        }
        return this.appliedText;
    }

    protected String calculateAppliedText(double wHint) {
        String theText = this.getText();
        if (wHint < 0.0 || theText.length() == 0) {
            return theText;
        }
        Font f = this.getFont();
        if (this.isSingleLine()) {
            if (this.isAbbreviated()) {
                return this.getAbbreviatedText(theText, f, wHint);
            }
            return theText;
        }
        String[] lines = RotatableWrapLabel.forceSplit(theText);
        StringBuilder accumlatedText = new StringBuilder(theText.length() + 10);
        int lineIndex = 0;
        while (lineIndex < lines.length) {
            String line = lines[lineIndex];
            if (line.length() == 0) {
                accumlatedText.append('\n');
            } else {
                StringBuilder remainingLine = new StringBuilder(line);
                int i = 0;
                while (remainingLine.length() > 0) {
                    i = this.getLineWrapPosition(remainingLine.toString(), f, wHint);
                    if (i == 0) break;
                    String substring = RotatableWrapLabel.trim(remainingLine.substring(0, i));
                    if (this.isAbbreviated()) {
                        substring = this.getAbbreviatedText(substring, f, wHint);
                    }
                    accumlatedText.append(substring);
                    remainingLine.delete(0, i);
                    accumlatedText.append('\n');
                }
            }
            ++lineIndex;
        }
        if (accumlatedText.charAt(accumlatedText.length() - 1) == '\n') {
            accumlatedText.deleteCharAt(accumlatedText.length() - 1);
        }
        return accumlatedText.toString();
    }

    private static String[] forceSplit(String s) {
        ArrayList<String> buffer = new ArrayList<String>(s.length());
        int start = 0;
        int end = 0;
        while (end < s.length()) {
            char c = s.charAt(end);
            if (c == '\n') {
                buffer.add(s.substring(start, end));
                start = end + 1;
            }
            ++end;
        }
        buffer.add(s.substring(start));
        return buffer.toArray(new String[buffer.size()]);
    }

    private String getAbbreviatedText(String theText, Font f, double wHint) {
        int textWidth;
        String result = theText;
        int textLength = result.length();
        if (wHint > 0.0 && textLength > 0 && (double)(textWidth = this.getLooseTextSize((String)result, (Font)f).width) > wHint) {
            int tructionPosition = (int)((double)result.length() / (double)textWidth * (double)((int)wHint));
            if (tructionPosition < textLength && tructionPosition > ELLIPSE.length()) {
                tructionPosition -= ELLIPSE.length();
            }
            return String.valueOf(result.substring(0, tructionPosition)) + ELLIPSE;
        }
        return result;
    }

    protected int getLineWrapPosition(String s, Font f, double w) {
        BreakIterator iter = BreakIterator.getLineInstance();
        iter.setText(s);
        int start = iter.first();
        int end = iter.next();
        if ((double)this.getSubTextSize((String)s, (int)start, (int)end, (Font)f).width > w) {
            iter = BreakIterator.getWordInstance();
            iter.setText(s);
            start = iter.first();
            end = iter.next();
            if (end == -1) {
                return iter.last();
            }
            if ((double)this.getSubTextSize((String)s, (int)start, (int)end, (Font)f).width > w) {
                return end;
            }
        }
        while ((end = iter.next()) != -1 && (double)this.getSubTextSize((String)s, (int)start, (int)end, (Font)f).width <= w) {
        }
        return end == -1 ? iter.last() : iter.previous();
    }

    private Dimension getSubTextSize(String s, int start, int end, Font f) {
        String t = RotatableWrapLabel.trim(s.substring(start, end));
        t = this.getShowText(t, this.getTextCase());
        Dimension size = this.getLooseTextSize(t, f);
        return size;
    }

    protected String getShowText(String t, int textCase) {
        switch (textCase) {
            case 1: {
                return t;
            }
            case 2: {
                return t.toUpperCase();
            }
            case 4: {
                return t.toLowerCase();
            }
            case 8: {
                return this.capitalize(t);
            }
        }
        return t;
    }

    private String capitalize(String str) {
        StringBuffer stringbf = new StringBuffer();
        Matcher m = Pattern.compile("([a-z])([a-z]*)", 2).matcher(str);
        while (m.find()) {
            m.appendReplacement(stringbf, String.valueOf(m.group(1).toUpperCase()) + m.group(2).toLowerCase());
        }
        return m.appendTail(stringbf).toString();
    }

    private static String trim(String s) {
        return s.replaceAll("\\n", "");
    }

    protected Dimension getLooseTextSize(String s, Font f) {
        if (s.length() == 0) {
            int height = GraphicsUtils.getAdvanced().getFontMetrics(f).getHeight();
            return new Dimension(0, height);
        }
        Dimension size = GraphicsUtils.getAdvanced().getTextSize(s, f);
        if (!this.isNormalRenderStyle()) {
            Path p = new Path((Device)Display.getCurrent());
            p.addString(s, 0.0f, 0.0f, f);
            p.getBounds(RECT);
            if (Util.isWindows()) {
                float[] autoScaleDown = DPIUtil.autoScaleDown((float[])RECT);
                RotatableWrapLabel.RECT[0] = autoScaleDown[0];
                RotatableWrapLabel.RECT[1] = autoScaleDown[1];
                RotatableWrapLabel.RECT[2] = autoScaleDown[2];
                RotatableWrapLabel.RECT[3] = autoScaleDown[3];
            }
            p.dispose();
            size.width = Math.max(size.width, (int)Math.ceil(RECT[2]));
            size.height = Math.max(size.height, (int)Math.ceil(RECT[3]));
        }
        return size;
    }

    protected PrecisionRectangle getTextArea() {
        return this.getTextArea(this.cachedWidthHint);
    }

    protected PrecisionRectangle getTextArea(int wHint) {
        this.receiveWidthCaches(wHint);
        if (this.textArea == null) {
            PrecisionDimension size = this.calculateTextSize(wHint);
            this.textArea = new PrecisionRectangle();
            float rightMargin = 1.0f;
            int height = this.getFont().getFontData()[0].getHeight();
            if (height > 30) {
                rightMargin += 5.0f;
            }
            this.textArea.width = size.width + 3.0 + (double)rightMargin;
            this.textArea.height = size.height + 3.0;
            this.textArea.x = -(this.textArea.width / 2.0);
            this.textArea.y = -(this.textArea.height / 2.0);
        }
        return this.textArea;
    }

    protected PrecisionDimension calculateTextSize(int wHint) {
        Font f = this.getFont();
        String theText = this.getAppliedText(wHint);
        String[] split = RotatableWrapLabel.forceSplit(theText);
        PrecisionDimension size = D.setSize(0.0, 0.0);
        int textCase = this.getTextCase();
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String t = this.getShowText(s, textCase);
            Dimension d = this.getLooseTextSize(t, f);
            if (size.height > 0.0) {
                size.height += (double)this.getLineSpacing();
            }
            size.height += (double)d.height;
            size.width = Math.max(size.width, (double)d.width);
            ++n2;
        }
        return size;
    }

    public int getLineSpacing() {
        if (this.lineSpacing < 0) {
            this.lineSpacing = this.calculateDefaultLineSpacing();
        }
        return this.lineSpacing;
    }

    public void setLineSpacing(int spacing) {
        if (this.lineSpacing >= 0 && spacing == this.lineSpacing) {
            return;
        }
        this.lineSpacing = spacing;
        this.revalidate();
        this.repaint();
    }

    protected int calculateDefaultLineSpacing() {
        Dimension s1 = this.getLooseTextSize("X\nX", this.getFont());
        Dimension s = this.getLooseTextSize("X", this.getFont());
        return Math.max(0, s1.height - s.height * 2);
    }

    public Insets getInsets() {
        if (this.isRotated()) {
            return this.getRotatedInsets().toDraw2DInsets();
        }
        return super.getInsets();
    }

    protected PrecisionInsets getRotatedInsets() {
        if (this.rotatedInsets == null) {
            this.rotatedInsets = this.calculateRotatedInsets();
        }
        return this.rotatedInsets;
    }

    protected PrecisionInsets calculateRotatedInsets() {
        PrecisionInsets ins = new PrecisionInsets(super.getInsets());
        return this.isRotated() ? this.rotator.t(ins) : ins;
    }

    public void invalidate() {
        this.flushCaches();
        this.rotatedInsets = null;
        super.invalidate();
    }

    protected boolean isRotated() {
        return Math.abs(this.getRotationDegrees()) > 1.0E-7;
    }

    protected void paintBorder(Graphics graphics) {
        graphics.setAlpha(this.getSubAlpha());
        super.paintBorder(graphics);
    }

    protected void paintFigure(Graphics graphics) {
        graphics.setAntialias(1);
        graphics.setTextAntialias(1);
        if (this.getBorder() instanceof AbstractBackground) {
            int oldAlpha = graphics.getAlpha();
            graphics.setAlpha(this.getSubAlpha());
            ((AbstractBackground)this.getBorder()).paintBackground((IFigure)this, graphics, NO_INSETS);
            graphics.setAlpha(oldAlpha);
        }
        PrecisionPoint pCenter = this.calculateTextCenterLocation();
        Point center = null;
        boolean rotated = this.isRotated();
        Rectangle clientArea = this.getClientArea();
        double wHint = this.rotator.r((PrecisionDimension)RotatableWrapLabel.D.setSize((double)((double)clientArea.width), (double)((double)clientArea.height))).width;
        PrecisionRectangle rect = new PrecisionRectangle(this.getTextArea((int)wHint));
        PrecisionDimension d = new PrecisionDimension(this.getSize());
        Insets ins = this.getInsets();
        double insWidth = ins.getWidth();
        double insHeight = ins.getHeight();
        if (rotated) {
            d = this.rotator.r(d, -1.0, rect.height + (double)super.getInsets().getHeight());
            d.expand(-insWidth, -insHeight);
            rect.x -= (d.width - rect.width) / 2.0;
            rect.width = d.width;
            center = pCenter.toRoundedDraw2DPoint();
            rect.translate(new PrecisionPoint(center).getDifference(pCenter));
            graphics.translate(center);
            graphics.rotate((float)this.getRotationDegrees());
        } else {
            d.expand(-insWidth, -insHeight);
            rect.x -= (d.width - rect.width) / 2.0;
            rect.width = d.width;
            rect.translate(pCenter);
        }
        this.paintTextArea(graphics, rect);
        if (rotated && center != null) {
            graphics.translate(center.negate());
            graphics.rotate(-((float)this.getRotationDegrees()));
        }
    }

    private PrecisionPoint calculateTextCenterLocation() {
        PrecisionRectangle rect = R.setBounds(this.getBounds());
        return rect.crop(this.getRotatedInsets()).getCenter();
    }

    protected void paintTextArea(Graphics graphics, PrecisionRectangle textArea) {
        int oldAlpha;
        if (this.isOpaque() && this.getLocalBackgroundColor() != null) {
            oldAlpha = graphics.getAlpha();
            graphics.setAlpha(this.getSubAlpha());
            Path bg = new Path((Device)Display.getCurrent());
            bg.addRectangle(textArea);
            graphics.fillPath((org.eclipse.swt.graphics.Path)bg);
            bg.dispose();
            graphics.setAlpha(oldAlpha);
        }
        oldAlpha = graphics.getAlpha();
        graphics.setAlpha(this.getMainAlpha());
        this.paintText(graphics, this.getAppliedText((int)Math.ceil(textArea.width)), textArea, this.getFont());
        graphics.setAlpha(oldAlpha);
    }

    protected void paintText(Graphics graphics, String text, PrecisionRectangle textArea, Font f) {
        String[] tokens = RotatableWrapLabel.forceSplit(text);
        float textWidth = (float)textArea.width - 3.0f;
        float y = (float)textArea.y + 1.5f;
        float vSpacing = this.getLineSpacing();
        int wrapAlignment = this.getTextAlignment();
        int textCase = this.getTextCase();
        boolean isUnderlined = this.isTextUnderlined();
        boolean isStrikedThrough = this.isTextStrikedThrough();
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            float x = (float)textArea.x + 1.5f;
            String t = this.getShowText(token, textCase);
            Dimension tokenSize = this.getLooseTextSize(t, f);
            float tokenWidth = tokenSize.width;
            float tokenHeight = tokenSize.height;
            float tokenHeightHalf = tokenHeight / 2.0f;
            switch (wrapAlignment) {
                case 2: {
                    x += (textWidth - tokenWidth) / 2.0f;
                    break;
                }
                case 4: {
                    x += textWidth - tokenWidth - 1.0f;
                }
            }
            this.paintText(graphics, t, x, y, tokenWidth, tokenHeight, f);
            y += tokenHeight;
            if (isUnderlined) {
                Path underline = new Path((Device)Display.getCurrent());
                underline.moveTo(x, y - 1.0f);
                underline.lineTo(x + tokenWidth, y - 1.0f);
                graphics.drawPath((org.eclipse.swt.graphics.Path)underline);
                underline.dispose();
            }
            if (isStrikedThrough) {
                Path strikeOutLine = new Path((Device)Display.getCurrent());
                strikeOutLine.moveTo(x, y - tokenHeightHalf + 1.0f);
                strikeOutLine.lineTo(x + tokenWidth, y - tokenHeightHalf + 1.0f);
                graphics.drawPath((org.eclipse.swt.graphics.Path)strikeOutLine);
                strikeOutLine.dispose();
            }
            y += vSpacing;
            ++n2;
        }
    }

    protected void paintText(Graphics graphics, String token, float x, float y, float width, float height, Font f) {
        if (this.isNormalRenderStyle()) {
            graphics.translate(x, y);
            graphics.drawText(token, 0, 0);
            graphics.translate(-x, -y);
            return;
        }
        Path shape = new Path((Device)Display.getCurrent());
        shape.addString(token, 0.0f, 0.0f, f);
        shape.getBounds(RECT);
        if (Util.isWindows()) {
            float[] autoScaleDown = DPIUtil.autoScaleDown((float[])RECT);
            RotatableWrapLabel.RECT[0] = autoScaleDown[0];
            RotatableWrapLabel.RECT[1] = autoScaleDown[1];
            RotatableWrapLabel.RECT[2] = autoScaleDown[2];
            RotatableWrapLabel.RECT[3] = autoScaleDown[3];
        }
        float dx = (width - RECT[2]) / 2.0f - RECT[0];
        float dy = (height - RECT[3]) / 2.0f - RECT[1];
        if ((double)Math.abs(dx) > 1.0E-10 || (double)Math.abs(dy) > 1.0E-10) {
            shape.dispose();
            shape = new Path((Device)Display.getCurrent());
            shape.addString(token, x + dx, y + dy, f);
        }
        this.drawTextShape(graphics, shape);
        shape.dispose();
    }

    protected void drawTextShape(Graphics graphics, Path shape) {
        graphics.setLineStyle(1);
        graphics.setLineWidth(1);
        graphics.setFillRule(2);
        graphics.setBackgroundColor(graphics.getForegroundColor());
        graphics.fillPath((org.eclipse.swt.graphics.Path)shape);
    }

    protected boolean isNormalRenderStyle() {
        boolean shownWrong = false;
        String fontName = null;
        if (this.getFont() != null) {
            fontName = this.getFont().getFontData()[0].getName();
        }
        String[] wrongFontNames = new String[]{"Cambria Math", "Gabriola", "Javanese Text", "Lucida Sans Unicode", "Microsoft Himalaya", "MV Boli", "Myanmar Text", "Segoe MDL2 Assets"};
        String[] wrongFontPrefixs = new String[]{"Sitka"};
        if (fontName != null) {
            String[] stringArray = wrongFontNames;
            int n = wrongFontNames.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (fontName.equals(name)) {
                    shownWrong = true;
                    break;
                }
                ++n2;
            }
            if (!shownWrong) {
                stringArray = wrongFontPrefixs;
                n = wrongFontPrefixs.length;
                n2 = 0;
                while (n2 < n) {
                    String prefix = stringArray[n2];
                    if (fontName.startsWith(prefix)) {
                        shownWrong = true;
                        break;
                    }
                    ++n2;
                }
            }
        }
        return this.renderStyle == 0 && !shownWrong;
    }

    private boolean isTextStrikedThrough() {
        return this.getStyle() != null && this.getStyle().strikeout;
    }

    private boolean isTextUnderlined() {
        return this.getStyle() != null && this.getStyle().underline;
    }

    public String toString() {
        return "RotatableWrapLabl (" + this.getText() + ")";
    }
}

