/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.editor.MindMapEditorInput;
import org.xmind.ui.mindmap.IWorkbookRef;

public class MindMapEditorInputFactory
implements IElementFactory {
    public static final String ID = "org.xmind.ui.MindMapEditorInputFactory";
    private static final String TAG_URI = "uri";
    private static final String TAG_STATE = "state";

    public IAdaptable createElement(IMemento memento) {
        IWorkbookRef workbookRef;
        URI uri;
        String uriString = memento.getString(TAG_URI);
        if (uriString == null) {
            return null;
        }
        try {
            uri = new URI(uriString);
        }
        catch (URISyntaxException e) {
            MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.xmind.ui.mindmap", "Invalid URI: " + uriString, (Throwable)e));
            return null;
        }
        IMemento state = memento.getChild(TAG_STATE);
        if (state != null && (workbookRef = MindMapUIPlugin.getDefault().getWorkbookRefFactory().createWorkbookRef(uri, state)) != null) {
            return new MindMapEditorInput(workbookRef);
        }
        return new MindMapEditorInput(uri);
    }

    public static void saveState(MindMapEditorInput input, IMemento memento) {
        IPersistable persistable;
        URI uri = input.getURI();
        if (uri == null) {
            return;
        }
        String uriString = uri.toString();
        memento.putString(TAG_URI, uriString);
        IWorkbookRef workbookRef = input.getWorkbookRef();
        if (workbookRef != null && (persistable = MindMapUIPlugin.getAdapter(workbookRef, IPersistable.class)) != null) {
            IMemento state = memento.createChild(TAG_STATE);
            persistable.saveState(state);
        }
    }
}

