/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import java.util.Map;
import org.xmind.ui.internal.svgsupport.ColorName2HexRGBValue;
import org.xmind.ui.internal.svgsupport.LinearGradient;
import org.xmind.ui.internal.svgsupport.SVGColor;
import org.xmind.ui.internal.svgsupport.SVGDefinition;

public class ColorRecognizer {
    public static final String PROPERTIES_RESOURCE_URL = "platform:/plugin/org.xmind.ui.mindmap/org/xmind/ui/internal/svgsupport/ColorName2HexRGBValue.properties";
    public static final int INVALID_RGB_VALUE = -1;

    static SVGColor recognizeColor(String colorStr, Map<String, SVGDefinition> id2svgDefinitions) {
        if (colorStr == null || "".equals(colorStr)) {
            return null;
        }
        colorStr = colorStr.trim();
        SVGColor color = null;
        color = colorStr.startsWith("#") ? ColorRecognizer.getColorWithHexValue(colorStr) : (colorStr.startsWith("url") ? ColorRecognizer.getLinearGradient(colorStr, id2svgDefinitions) : (colorStr.startsWith("rgb") ? ColorRecognizer.getColorWithRGBStrring(colorStr) : ColorRecognizer.getColorWithName(colorStr)));
        return color;
    }

    private static SVGColor getColorWithHexValue(String colorStr) {
        String hexRGBStr = colorStr.split("#")[1].trim();
        int rgb = Integer.parseInt(hexRGBStr, 16);
        return new SVGColor(rgb);
    }

    private static SVGColor getLinearGradient(String colorStr, Map<String, SVGDefinition> id2svgDefinitions) {
        String key;
        SVGDefinition def;
        if (id2svgDefinitions != null && (def = id2svgDefinitions.get((key = colorStr.split("#")[1].split("[)]")[0]).trim())) instanceof LinearGradient) {
            return new SVGColor((LinearGradient)def);
        }
        return null;
    }

    private static SVGColor getColorWithRGBStrring(String colorStr) {
        String[] strs = colorStr.split("rgb[(]")[1].split("[)]")[0].split(",");
        int r = Integer.parseInt(strs[0].trim());
        r = r << 16 & 0xFF0000;
        int g = Integer.parseInt(strs[1].trim());
        g = g << 8 & 0xFF00;
        int b = Integer.parseInt(strs[2].trim());
        return new SVGColor(r | g | (b &= 0xFF));
    }

    private static SVGColor getColorWithName(String name) {
        String str = ColorName2HexRGBValue.getHexRGBString(name);
        if (str != null) {
            int hex = Integer.parseInt(str.split("#")[1].trim(), 16);
            return new SVGColor(hex);
        }
        return null;
    }
}

