/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.svgsupport;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xmind.gef.draw2d.graphics.Path;

public class SvgPathParser {
    private static SvgPathParser instance;
    private float centralX;
    private float centralY;
    private float clientWidth;
    private float clientHeight;
    private float lastPointX = 0.0f;
    private float lastPointY = 0.0f;
    private float lastKnotX = 0.0f;
    private float lastKnotY = 0.0f;
    private float top = 0.0f;
    private float bottom = 0.0f;
    private float left = 0.0f;
    private float right = 0.0f;

    private SvgPathParser() {
    }

    public void parseSvgPath(Path path, float centralX, float centralY, float clientWidth, float clientHeight, String svgPath) {
        this.centralX = centralX;
        this.centralY = centralY;
        this.clientWidth = clientWidth;
        this.clientHeight = clientHeight;
        int i = 0;
        while (i < 2) {
            Matcher matchPathCmd = Pattern.compile("([MmLlHhVvAaQqTtCcSsZz])|([-+]?((\\d*\\.\\d+)|(\\d+))([eE][-+]?\\d+)?)").matcher(svgPath);
            LinkedList<String> tokens = new LinkedList<String>();
            while (matchPathCmd.find()) {
                tokens.addLast(matchPathCmd.group());
            }
            int curCmd = 90;
            while (tokens.size() != 0) {
                String curToken = (String)tokens.removeFirst();
                char initChar = curToken.charAt(0);
                if (initChar >= 'A' && initChar <= 'Z' || initChar >= 'a' && initChar <= 'z') {
                    curCmd = initChar;
                } else {
                    tokens.addFirst(curToken);
                }
                switch (curCmd) {
                    case 77: {
                        this.movetoAbs(path, this.nextFloat(tokens), this.nextFloat(tokens), i != 0);
                        curCmd = 76;
                        break;
                    }
                    case 109: {
                        this.movetoRel(path, this.nextFloat(tokens), this.nextFloat(tokens), i != 0);
                        curCmd = 108;
                        break;
                    }
                    case 76: {
                        this.linetoAbs(path, this.nextFloat(tokens), this.nextFloat(tokens), i != 0);
                        break;
                    }
                    case 108: {
                        this.linetoRel(path, this.nextFloat(tokens), this.nextFloat(tokens), i != 0);
                        break;
                    }
                    case 72: {
                        this.linetoHorizontalAbs(path, this.nextFloat(tokens), i != 0);
                        break;
                    }
                    case 104: {
                        this.linetoHorizontalRel(path, this.nextFloat(tokens), i != 0);
                        break;
                    }
                    case 86: {
                        this.linetoVerticalAbs(path, this.nextFloat(tokens), i != 0);
                        break;
                    }
                    case 118: {
                        this.linetoVerticalRel(path, this.nextFloat(tokens), i != 0);
                        break;
                    }
                    case 65: 
                    case 97: {
                        break;
                    }
                    case 81: {
                        this.curvetoQuadraticAbs(path, this.nextFloat(tokens), this.nextFloat(tokens), this.nextFloat(tokens), this.nextFloat(tokens), i != 0);
                        break;
                    }
                    case 113: {
                        this.curvetoQuadraticRel(path, this.nextFloat(tokens), this.nextFloat(tokens), this.nextFloat(tokens), this.nextFloat(tokens), i != 0);
                        break;
                    }
                    case 84: {
                        this.curvetoQuadraticSmoothAbs(path, this.nextFloat(tokens), this.nextFloat(tokens), i != 0);
                        break;
                    }
                    case 116: {
                        this.curvetoQuadraticSmoothRel(path, this.nextFloat(tokens), this.nextFloat(tokens), i != 0);
                        break;
                    }
                    case 67: {
                        this.curvetoCubicAbs(path, this.nextFloat(tokens), this.nextFloat(tokens), this.nextFloat(tokens), this.nextFloat(tokens), this.nextFloat(tokens), this.nextFloat(tokens), i != 0);
                        break;
                    }
                    case 99: {
                        this.curvetoCubicRel(path, this.nextFloat(tokens), this.nextFloat(tokens), this.nextFloat(tokens), this.nextFloat(tokens), this.nextFloat(tokens), this.nextFloat(tokens), i != 0);
                        break;
                    }
                    case 83: {
                        this.curvetoCubicSmoothAbs(path, this.nextFloat(tokens), this.nextFloat(tokens), this.nextFloat(tokens), this.nextFloat(tokens), i != 0);
                        break;
                    }
                    case 115: {
                        this.curvetoCubicSmoothRel(path, this.nextFloat(tokens), this.nextFloat(tokens), this.nextFloat(tokens), this.nextFloat(tokens), i != 0);
                        break;
                    }
                    case 90: 
                    case 122: {
                        if (i != 0) {
                            path.close();
                            this.left = 0.0f;
                            this.right = 0.0f;
                            this.top = 0.0f;
                            this.bottom = 0.0f;
                        }
                        this.lastPointX = 0.0f;
                        this.lastPointY = 0.0f;
                        this.lastKnotX = 0.0f;
                        this.lastKnotY = 0.0f;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Invalid path element");
                    }
                }
            }
            ++i;
        }
    }

    private void movetoAbs(Path path, float x, float y, boolean draw) {
        if (draw) {
            path.moveTo(this.correctX(x), this.correctY(y));
        }
        this.lastPointX = x;
        this.lastPointY = y;
        if (!draw) {
            this.left = x;
            this.right = x;
            this.top = y;
            this.bottom = y;
        }
    }

    private void movetoRel(Path path, float x, float y, boolean draw) {
        this.movetoAbs(path, x + this.lastPointX, y + this.lastPointY, draw);
    }

    private void linetoAbs(Path path, float x, float y, boolean draw) {
        if (draw) {
            path.lineTo(this.correctX(x), this.correctY(y));
        }
        this.lastPointX = x;
        this.lastPointY = y;
        this.lastKnotX = x;
        this.lastKnotY = y;
        if (!draw) {
            this.calcTBLR(x, y);
        }
    }

    private void linetoRel(Path path, float x, float y, boolean draw) {
        this.linetoAbs(path, x + this.lastPointX, y + this.lastPointY, draw);
    }

    private void linetoHorizontalAbs(Path path, float x, boolean draw) {
        this.linetoAbs(path, x, this.lastPointY, draw);
    }

    private void linetoHorizontalRel(Path path, float x, boolean draw) {
        this.linetoHorizontalAbs(path, x + this.lastPointX, draw);
    }

    private void linetoVerticalAbs(Path path, float y, boolean draw) {
        this.linetoAbs(path, this.lastPointX, y, draw);
    }

    private void linetoVerticalRel(Path path, float y, boolean draw) {
        this.linetoVerticalAbs(path, y + this.lastPointY, draw);
    }

    private void curvetoQuadraticAbs(Path path, float x1, float y1, float x, float y, boolean draw) {
        if (draw) {
            path.quadTo(this.correctX(x1), this.correctY(y1), this.correctX(x), this.correctY(y));
        }
        this.lastPointX = x;
        this.lastPointY = y;
        this.lastKnotX = x1;
        this.lastKnotY = y1;
        if (!draw) {
            this.calcTBLR(x, y);
        }
    }

    private void curvetoQuadraticRel(Path path, float x1, float y1, float x, float y, boolean draw) {
        this.curvetoQuadraticAbs(path, x1 + this.lastPointX, y1 + this.lastPointY, x + this.lastPointX, y + this.lastPointY, draw);
    }

    private void curvetoQuadraticSmoothAbs(Path path, float x, float y, boolean draw) {
        this.curvetoQuadraticAbs(path, this.lastKnotX, this.lastKnotY, x, y, draw);
    }

    private void curvetoQuadraticSmoothRel(Path path, float x, float y, boolean draw) {
        this.curvetoQuadraticSmoothAbs(path, x + this.lastPointX, y + this.lastPointY, draw);
    }

    private void curvetoCubicAbs(Path path, float x1, float y1, float x2, float y2, float x, float y, boolean draw) {
        if (draw) {
            path.cubicTo(this.correctX(x1), this.correctY(y1), this.correctX(x2), this.correctY(y2), this.correctX(x), this.correctY(y));
        }
        this.lastPointX = x;
        this.lastPointY = y;
        this.lastKnotX = x2;
        this.lastKnotY = y2;
        if (!draw) {
            this.calcTBLR(x, y);
        }
    }

    private void curvetoCubicRel(Path path, float x1, float y1, float x2, float y2, float x, float y, boolean draw) {
        this.curvetoCubicAbs(path, x1 + this.lastPointX, y1 + this.lastPointY, x2 + this.lastPointX, y2 + this.lastPointY, x + this.lastPointX, y + this.lastPointY, draw);
    }

    private void curvetoCubicSmoothAbs(Path path, float x2, float y2, float x, float y, boolean draw) {
        this.curvetoCubicAbs(path, this.lastKnotX * 2.0f - this.lastPointX, this.lastKnotY * 2.0f - this.lastPointY, x2, y2, x, y, draw);
    }

    private void curvetoCubicSmoothRel(Path path, float x2, float y2, float x, float y, boolean draw) {
        this.curvetoCubicSmoothAbs(path, x2 + this.lastPointX, y2 + this.lastPointY, x + this.lastPointX, y + this.lastPointY, draw);
    }

    private float nextFloat(LinkedList<String> tokens) {
        String token = tokens.removeFirst();
        return Float.parseFloat(token);
    }

    private void calcTBLR(float x, float y) {
        this.left = Math.min(this.left, x);
        this.right = Math.max(this.right, x);
        this.top = Math.min(this.top, y);
        this.bottom = Math.max(this.bottom, y);
    }

    private float correctX(float x) {
        float baseX = x - (this.left + this.right) / 2.0f;
        baseX = baseX * this.clientWidth / (this.right - this.left);
        return baseX + this.centralX;
    }

    private float correctY(float y) {
        float baseY = y - (this.top + this.bottom) / 2.0f;
        baseY = baseY * this.clientHeight / (this.bottom - this.top);
        return baseY + this.centralY;
    }

    public static SvgPathParser getInstance() {
        if (instance == null) {
            instance = new SvgPathParser();
        }
        return instance;
    }
}

