/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import java.util.Calendar;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.internal.taskinfo.TaskMessages;
import org.xmind.ui.internal.utils.E4Utils;
import org.xmind.ui.mindmap.AbstractInfoItemContributor;
import org.xmind.ui.mindmap.IInfoPart;
import org.xmind.ui.mindmap.ITopicPart;

public class TaskInfoItemContributor
extends AbstractInfoItemContributor {
    private static final String[] wtb = new String[]{TaskMessages.TaskInfoItemContributor_January, TaskMessages.TaskInfoItemContributor_February, TaskMessages.TaskInfoItemContributor_March, TaskMessages.TaskInfoItemContributor_April, TaskMessages.TaskInfoItemContributor_May, TaskMessages.TaskInfoItemContributor_June, TaskMessages.TaskInfoItemContributor_July, TaskMessages.TaskInfoItemContributor_Auguest, TaskMessages.TaskInfoItemContributor_September, TaskMessages.TaskInfoItemContributor_October, TaskMessages.TaskInfoItemContributor_November, TaskMessages.TaskInfoItemContributor_December};

    public IAction createAction(ITopicPart topicPart, ITopic topic) {
        if (this.getContent(topic) == null) {
            return null;
        }
        if (this.isProOrSub()) {
            ShowTaskInfoViewAction action = new ShowTaskInfoViewAction(topicPart);
            action.setToolTipText(this.getContent(topic));
            return action;
        }
        return null;
    }

    private boolean isProOrSub() {
        String type = System.getProperty("org.xmind.product.license_type");
        return "Pro".equals(type) || "Sub".equals(type);
    }

    public String getContent(ITopic topic) {
        DateInfo start = TaskInfoUtils.calculateStartDateInfo(topic);
        String assignedTo = TaskInfoUtils.getContent(topic, "assigned-to");
        if (start == null && assignedTo == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (assignedTo != null) {
            sb.append(assignedTo).append(" ");
        }
        if (start != null) {
            DateInfo end = TaskInfoUtils.calculateEndDateInfo(topic);
            sb.append(this.getFormatTime(start.date)).append(" ~ ").append(this.getFormatTime(end.date));
        }
        return sb.toString();
    }

    public String getSVGFilePath(ITopic topic, IAction action) {
        return "platform:/plugin/org.xmind.ui.taskinfo/icons/taskinfo.svg";
    }

    private String getFormatTime(Calendar date) {
        StringBuilder sb = new StringBuilder();
        sb.append(wtb[date.get(2)]).append(" ").append(date.get(5));
        return sb.toString();
    }

    public boolean isCardModeAvailable(ITopic topic, ITopicPart topicPart) {
        return !this.isIconTipOnly(topicPart);
    }

    protected void registerTopicEvent(ITopicPart topicPart, ITopic topic, ICoreEventRegister register) {
        register.register("taskInfoChange");
    }

    protected void handleTopicEvent(IInfoPart infoPart, CoreEvent event) {
        infoPart.refresh();
    }

    protected void handleTopicEvent(ITopicPart topicPart, CoreEvent event) {
        topicPart.refresh();
    }

    private static class ShowTaskInfoViewAction
    extends Action {
        private ITopicPart topicPart;

        public ShowTaskInfoViewAction(ITopicPart topicPart) {
            super(TaskMessages.ShowTaskInfoAction_name, AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.xmind.ui.taskinfo", (String)"icons/taskinfo.png"));
            this.topicPart = topicPart;
        }

        public void run() {
            if (!this.topicPart.getStatus().isActive()) {
                return;
            }
            E4Utils.showPart((String)"org.xmind.ui.command.showModelPart", (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), (String)"org.xmind.ui.modelPart.taskinfo", null, (String)"org.xmind.ui.stack.right");
        }
    }
}

