/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.styleeditor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.xmind.ui.color.ColorPickerConfigurer;
import org.xmind.ui.decorations.IDecorationDescriptor;
import org.xmind.ui.dialogs.PopupFilteredList;
import org.xmind.ui.internal.properties.LinePattern;
import org.xmind.ui.internal.properties.LineWidth;
import org.xmind.ui.internal.styleeditor.StyleEditorMessages;
import org.xmind.ui.internal.styleeditor.StylePropertyLabelDescriptor;
import org.xmind.ui.internal.styleeditor.WallpaperPropertyDescriptor;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.properties.ColorPropertyDescriptor;
import org.xmind.ui.properties.FilterableMultiChoicePropertyDescriptor;
import org.xmind.ui.properties.IPropertyDescriptor;
import org.xmind.ui.properties.MultiChoicePropertyDescriptor;
import org.xmind.ui.resources.FontUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StylePropertyDescriptors {
    private static final StylePropertyDescriptors INSTANCE = new StylePropertyDescriptors();
    private static final IPropertyDescriptor[] NO_PROPERTY_DESCRIPTORS = new IPropertyDescriptor[0];
    private static final String CATEGORY_TEXT = StyleEditorMessages.StyleProperty_CategoryName_TextProperties;
    private static final String CATEGORY_LINE = StyleEditorMessages.StyleProperty_CategoryName_LineProperties;
    private static final String CATEGORY_SHAPE = StyleEditorMessages.StyleProperty_CategoryName_ShapeProperties;
    private static final String CATEGORY_SHEET = StyleEditorMessages.StyleProperty_CategoryName_MapProperties;
    private static final String CATEGORY_BORDER = StyleEditorMessages.StyleProperty_CategoryName_BorderProperties;
    private static final String CATEGORY_WALLPAPER = StyleEditorMessages.StyleProperty_CategoryName_WallpaperProperties;
    private static final List<String> FONT_SIZES = new ArrayList<String>();
    private static final Comparator<String> FONT_SIZE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String s1, String s2) {
            return this.toSize(s1) - this.toSize(s2);
        }

        private int toSize(String s) {
            try {
                return s.endsWith("pt") ? Integer.parseInt(s.substring(0, s.length() - 2), 10) : 0;
            }
            catch (Throwable throwable) {
                return 0;
            }
        }
    };
    private static final PopupFilteredList.IElementCreator FONT_SIZE_CREATOR = new PopupFilteredList.IElementCreator(){

        public Object createElement(String text) {
            try {
                int value = Integer.parseInt(text, 10);
                String element = String.format("%spt", value);
                if (!FONT_SIZES.contains(element)) {
                    FONT_SIZES.add(element);
                    Collections.sort(FONT_SIZES, FONT_SIZE_COMPARATOR);
                }
                return element;
            }
            catch (Throwable throwable) {
                if (!text.endsWith("pt")) {
                    return String.valueOf(text) + "pt";
                }
                return text;
            }
        }
    };
    private final Map<String, IPropertyDescriptor[]> propertyDescriptors = new HashMap<String, IPropertyDescriptor[]>();

    private StylePropertyDescriptors() {
    }

    public IPropertyDescriptor[] getPropertyDescriptors(String type) {
        IPropertyDescriptor[] descriptors = this.propertyDescriptors.get(type);
        if (descriptors != null) {
            return descriptors;
        }
        if ("theme".equals(type)) {
            descriptors = StylePropertyDescriptors.createThemePropertyDescriptors();
        } else if ("topic".equals(type)) {
            descriptors = StylePropertyDescriptors.createTopicPropertyDescriptors();
        } else if ("boundary".equals(type)) {
            descriptors = StylePropertyDescriptors.createBoundaryPropertyDescriptors();
        } else if ("relationship".equals(type)) {
            descriptors = StylePropertyDescriptors.createRelationshipPropertyDescriptors();
        } else if ("map".equals(type)) {
            descriptors = StylePropertyDescriptors.createMapPropertyDescriptors();
        } else if ("summary".equals(type)) {
            descriptors = StylePropertyDescriptors.createSummaryPropertyDescriptors();
        } else {
            return NO_PROPERTY_DESCRIPTORS;
        }
        this.propertyDescriptors.put(type, descriptors);
        return descriptors;
    }

    private static IPropertyDescriptor[] createThemePropertyDescriptors() {
        return new IPropertyDescriptor[]{new MultiChoicePropertyDescriptor("shape-class", StyleEditorMessages.StyleProperty_PropertyName_TopicShape).setChoices((Object)StylePropertyDescriptors.toIds(MindMapUI.getDecorationManager().getDescriptors("org.xmind.ui.topicDecorations"))).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forDecorations()).setCategory(CATEGORY_SHAPE), new ColorPropertyDescriptor("svg:fill", StyleEditorMessages.StyleProperty_PropertyName_FillColor, new ColorPickerConfigurer().popupStyle(7).autoValue(null).noneValue((Object)"none")).setLabelDescriptor(StylePropertyLabelDescriptor.forColors()).setCategory(CATEGORY_SHAPE), new MultiChoicePropertyDescriptor("border-line-width", StyleEditorMessages.StyleProperty_PropertyName_LineWidth).setChoices((Object)LineWidth.getValues()).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forLineWidths()).setCategory(CATEGORY_BORDER), new ColorPropertyDescriptor("border-line-color", StyleEditorMessages.StyleProperty_PropertyName_LineColor, new ColorPickerConfigurer().popupStyle(5).autoValue(null).noneValue((Object)"none")).setLabelDescriptor(StylePropertyLabelDescriptor.forColors()).setCategory(CATEGORY_BORDER), new MultiChoicePropertyDescriptor("line-class", StyleEditorMessages.StyleProperty_PropertyName_LineShape).setChoices((Object)StylePropertyDescriptors.toIds(MindMapUI.getDecorationManager().getDescriptors("org.xmind.ui.branchConnections"))).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forDecorations()).setCategory(CATEGORY_LINE), new ColorPropertyDescriptor("line-color", StyleEditorMessages.StyleProperty_PropertyName_LineColor, new ColorPickerConfigurer().popupStyle(5).autoValue(null).noneValue((Object)"none")).setLabelDescriptor(StylePropertyLabelDescriptor.forColors()).setCategory(CATEGORY_LINE), new MultiChoicePropertyDescriptor("line-width", StyleEditorMessages.StyleProperty_PropertyName_LineWidth).setChoices((Object)LineWidth.getValues()).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forLineWidths()).setCategory(CATEGORY_LINE), new FilterableMultiChoicePropertyDescriptor("fo:font-family", StyleEditorMessages.StyleProperty_PropertyName_FontFamily).setChoices(new Object()).setChoiceProvider((IStructuredContentProvider)new FontFamilyContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.getDefault()).setCategory(CATEGORY_TEXT), new FilterableMultiChoicePropertyDescriptor("fo:font-size", StyleEditorMessages.StyleProperty_PropertyName_FontSize).allowCustomizedValues().setElementCreator(FONT_SIZE_CREATOR).setChoices(StylePropertyDescriptors.getFontSizes()).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forFontSize()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:font-style", StyleEditorMessages.StyleProperty_PropertyName_FontStyle).setChoices((Object)new String[]{"normal", "italic"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forTextStyles()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:font-weight", StyleEditorMessages.StyleProperty_PropertyName_FontWeight).setChoices((Object)new String[]{"normal", "bold"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forTextStyles()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:text-decoration", StyleEditorMessages.StyleProperty_PropertyName_TextDecoration).setChoices((Object)new String[]{"none", "line-through", "underline", "underline line-through"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forTextStyles()).setCategory(CATEGORY_TEXT), new ColorPropertyDescriptor("fo:color", StyleEditorMessages.StyleProperty_PropertyName_TextColor, new ColorPickerConfigurer().popupStyle(5).autoValue(null).noneValue((Object)"none")).setLabelDescriptor(StylePropertyLabelDescriptor.forColors()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:text-align", StyleEditorMessages.StyleProperty_PropertyName_TextAlignment).setChoices((Object)new String[]{"left", "center", "right"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forAlignments()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:text-transform", StyleEditorMessages.StyleProperty_PropertyName_TextCase).setChoices((Object)new String[]{"manual", "uppercase", "lowercase", "capitalize"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forTextCase()).setCategory(CATEGORY_TEXT)};
    }

    private static IPropertyDescriptor[] createSummaryPropertyDescriptors() {
        return new IPropertyDescriptor[]{new MultiChoicePropertyDescriptor("shape-class", StyleEditorMessages.StyleProperty_PropertyName_SummaryShape).setChoices((Object)StylePropertyDescriptors.toIds(MindMapUI.getDecorationManager().getDescriptors("org.xmind.ui.summaryDecorations"))).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forDecorations()).setCategory(CATEGORY_SHAPE), new ColorPropertyDescriptor("line-color", StyleEditorMessages.StyleProperty_PropertyName_LineColor, new ColorPickerConfigurer().popupStyle(5).autoValue(null).noneValue((Object)"none")).setLabelDescriptor(StylePropertyLabelDescriptor.forColors()).setCategory(CATEGORY_LINE), new MultiChoicePropertyDescriptor("line-width", StyleEditorMessages.StyleProperty_PropertyName_LineWidth).setChoices((Object)LineWidth.getValues()).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forLineWidths()).setCategory(CATEGORY_LINE)};
    }

    private static IPropertyDescriptor[] createTopicPropertyDescriptors() {
        return new IPropertyDescriptor[]{new MultiChoicePropertyDescriptor("callout-shape-class", StyleEditorMessages.StyleProperty_PropertyName_CalloutShape).setChoices((Object)StylePropertyDescriptors.toIds(MindMapUI.getDecorationManager().getDescriptors("org.xmind.ui.calloutTopicDecorations"))).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forDecorations()).setCategory(CATEGORY_SHAPE), new MultiChoicePropertyDescriptor("shape-class", StyleEditorMessages.StyleProperty_PropertyName_TopicShape).setChoices((Object)StylePropertyDescriptors.toIds(MindMapUI.getDecorationManager().getDescriptors("org.xmind.ui.topicDecorations"))).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forDecorations()).setCategory(CATEGORY_SHAPE), new ColorPropertyDescriptor("svg:fill", StyleEditorMessages.StyleProperty_PropertyName_FillColor, new ColorPickerConfigurer().popupStyle(7).autoValue(null).noneValue((Object)"none")).setLabelDescriptor(StylePropertyLabelDescriptor.forColors()).setCategory(CATEGORY_SHAPE), new MultiChoicePropertyDescriptor("border-line-width", StyleEditorMessages.StyleProperty_PropertyName_LineWidth).setChoices((Object)LineWidth.getValues()).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forLineWidths()).setCategory(CATEGORY_BORDER), new ColorPropertyDescriptor("border-line-color", StyleEditorMessages.StyleProperty_PropertyName_LineColor, new ColorPickerConfigurer().popupStyle(5).autoValue(null).noneValue((Object)"none")).setLabelDescriptor(StylePropertyLabelDescriptor.forColors()).setCategory(CATEGORY_BORDER), new MultiChoicePropertyDescriptor("line-class", StyleEditorMessages.StyleProperty_PropertyName_LineShape).setChoices((Object)StylePropertyDescriptors.toIds(MindMapUI.getDecorationManager().getDescriptors("org.xmind.ui.branchConnections"))).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forDecorations()).setCategory(CATEGORY_LINE), new ColorPropertyDescriptor("line-color", StyleEditorMessages.StyleProperty_PropertyName_LineColor, new ColorPickerConfigurer().popupStyle(5).autoValue(null).noneValue((Object)"none")).setLabelDescriptor(StylePropertyLabelDescriptor.forColors()).setCategory(CATEGORY_LINE), new MultiChoicePropertyDescriptor("line-width", StyleEditorMessages.StyleProperty_PropertyName_LineWidth).setChoices((Object)LineWidth.getValues()).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forLineWidths()).setCategory(CATEGORY_LINE), new FilterableMultiChoicePropertyDescriptor("fo:font-family", StyleEditorMessages.StyleProperty_PropertyName_FontFamily).setChoices(new Object()).setChoiceProvider((IStructuredContentProvider)new FontFamilyContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.getDefault()).setCategory(CATEGORY_TEXT), new FilterableMultiChoicePropertyDescriptor("fo:font-size", StyleEditorMessages.StyleProperty_PropertyName_FontSize).allowCustomizedValues().setElementCreator(FONT_SIZE_CREATOR).setChoices(StylePropertyDescriptors.getFontSizes()).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forFontSize()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:font-style", StyleEditorMessages.StyleProperty_PropertyName_FontStyle).setChoices((Object)new String[]{"normal", "italic"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forTextStyles()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:font-weight", StyleEditorMessages.StyleProperty_PropertyName_FontWeight).setChoices((Object)new String[]{"normal", "bold"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forTextStyles()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:text-decoration", StyleEditorMessages.StyleProperty_PropertyName_TextDecoration).setChoices((Object)new String[]{"none", "line-through", "underline", "underline line-through"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forTextStyles()).setCategory(CATEGORY_TEXT), new ColorPropertyDescriptor("fo:color", StyleEditorMessages.StyleProperty_PropertyName_TextColor, new ColorPickerConfigurer().popupStyle(5).autoValue(null).noneValue((Object)"none")).setLabelDescriptor(StylePropertyLabelDescriptor.forColors()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:text-align", StyleEditorMessages.StyleProperty_PropertyName_TextAlignment).setChoices((Object)new String[]{"left", "center", "right"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forAlignments()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:text-transform", StyleEditorMessages.StyleProperty_PropertyName_TextCase).setChoices((Object)new String[]{"manual", "uppercase", "lowercase", "capitalize"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forTextCase()).setCategory(CATEGORY_TEXT)};
    }

    private static IPropertyDescriptor[] createBoundaryPropertyDescriptors() {
        return new IPropertyDescriptor[]{new MultiChoicePropertyDescriptor("shape-class", StyleEditorMessages.StyleProperty_PropertyName_BoundaryShape).setChoices((Object)StylePropertyDescriptors.toIds(MindMapUI.getDecorationManager().getDescriptors("org.xmind.ui.boundaryDecorations"))).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forDecorations()).setCategory(CATEGORY_SHAPE), new ColorPropertyDescriptor("svg:fill", StyleEditorMessages.StyleProperty_PropertyName_FillColor, new ColorPickerConfigurer().popupStyle(7).autoValue(null).noneValue((Object)"none")).setLabelDescriptor(StylePropertyLabelDescriptor.forColors()).setCategory(CATEGORY_SHAPE), new MultiChoicePropertyDescriptor("svg:opacity", StyleEditorMessages.StyleProperty_PropertyName_Opacity).setChoices((Object)new String[]{"0", ".1", ".2", ".3", ".4", ".5", ".6", ".7", ".8", ".9", "1"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forOpacities()).setCategory(CATEGORY_SHAPE), new MultiChoicePropertyDescriptor("line-pattern", StyleEditorMessages.StyleProperty_PropertyName_LinePattern).setChoices((Object)LinePattern.getValues()).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forLinePatterns()).setCategory(CATEGORY_LINE), new ColorPropertyDescriptor("line-color", StyleEditorMessages.StyleProperty_PropertyName_LineColor, new ColorPickerConfigurer().popupStyle(5).autoValue(null).noneValue((Object)"none")).setLabelDescriptor(StylePropertyLabelDescriptor.forColors()).setCategory(CATEGORY_LINE), new MultiChoicePropertyDescriptor("line-width", StyleEditorMessages.StyleProperty_PropertyName_LineWidth).setChoices((Object)LineWidth.getValues()).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forLineWidths()).setCategory(CATEGORY_LINE), new FilterableMultiChoicePropertyDescriptor("fo:font-family", StyleEditorMessages.StyleProperty_PropertyName_FontFamily).setChoices(new Object()).setChoiceProvider((IStructuredContentProvider)new FontFamilyContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.getDefault()).setCategory(CATEGORY_TEXT), new FilterableMultiChoicePropertyDescriptor("fo:font-size", StyleEditorMessages.StyleProperty_PropertyName_FontSize).allowCustomizedValues().setElementCreator(FONT_SIZE_CREATOR).setChoices(StylePropertyDescriptors.getFontSizes()).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forFontSize()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:font-style", StyleEditorMessages.StyleProperty_PropertyName_FontStyle).setChoices((Object)new String[]{"normal", "italic"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forTextStyles()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:font-weight", StyleEditorMessages.StyleProperty_PropertyName_FontWeight).setChoices((Object)new String[]{"normal", "bold"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forTextStyles()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:text-decoration", StyleEditorMessages.StyleProperty_PropertyName_TextDecoration).setChoices((Object)new String[]{"none", "line-through", "underline", "underline line-through"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forTextStyles()).setCategory(CATEGORY_TEXT), new ColorPropertyDescriptor("fo:color", StyleEditorMessages.StyleProperty_PropertyName_TextColor, new ColorPickerConfigurer().popupStyle(5).autoValue(null).noneValue((Object)"none")).setLabelDescriptor(StylePropertyLabelDescriptor.forColors()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:text-align", StyleEditorMessages.StyleProperty_PropertyName_TextAlignment).setChoices((Object)new String[]{"left", "center", "right"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forAlignments()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:text-transform", StyleEditorMessages.StyleProperty_PropertyName_TextCase).setChoices((Object)new String[]{"manual", "uppercase", "lowercase", "capitalize"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forTextCase()).setCategory(CATEGORY_TEXT)};
    }

    private static IPropertyDescriptor[] createRelationshipPropertyDescriptors() {
        return new IPropertyDescriptor[]{new MultiChoicePropertyDescriptor("shape-class", StyleEditorMessages.StyleProperty_PropertyName_RelationshipShape).setChoices((Object)StylePropertyDescriptors.toIds(MindMapUI.getDecorationManager().getDescriptors("org.xmind.ui.relationshipDecorations"))).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forDecorations()).setCategory(CATEGORY_SHAPE), new MultiChoicePropertyDescriptor("arrow-begin-class", StyleEditorMessages.StyleProperty_PropertyName_ArrowBeginShape).setChoices((Object)StylePropertyDescriptors.toIds(MindMapUI.getDecorationManager().getDescriptors("org.xmind.ui.arrowDecorations"))).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forDecorations()).setCategory(CATEGORY_SHAPE), new MultiChoicePropertyDescriptor("arrow-end-class", StyleEditorMessages.StyleProperty_PropertyName_ArrowEndShape).setChoices((Object)StylePropertyDescriptors.toIds(MindMapUI.getDecorationManager().getDescriptors("org.xmind.ui.arrowDecorations"))).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forDecorations()).setCategory(CATEGORY_SHAPE), new MultiChoicePropertyDescriptor("line-pattern", StyleEditorMessages.StyleProperty_PropertyName_LinePattern).setChoices((Object)LinePattern.getValues()).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forLinePatterns()).setCategory(CATEGORY_LINE), new ColorPropertyDescriptor("line-color", StyleEditorMessages.StyleProperty_PropertyName_LineColor, new ColorPickerConfigurer().popupStyle(5).autoValue(null).noneValue((Object)"none")).setLabelDescriptor(StylePropertyLabelDescriptor.forColors()).setCategory(CATEGORY_LINE), new MultiChoicePropertyDescriptor("line-width", StyleEditorMessages.StyleProperty_PropertyName_LineWidth).setChoices((Object)LineWidth.getValues()).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forLineWidths()).setCategory(CATEGORY_LINE), new FilterableMultiChoicePropertyDescriptor("fo:font-family", StyleEditorMessages.StyleProperty_PropertyName_FontFamily).setChoices(new Object()).setChoiceProvider((IStructuredContentProvider)new FontFamilyContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.getDefault()).setCategory(CATEGORY_TEXT), new FilterableMultiChoicePropertyDescriptor("fo:font-size", StyleEditorMessages.StyleProperty_PropertyName_FontSize).allowCustomizedValues().setElementCreator(FONT_SIZE_CREATOR).setChoices(StylePropertyDescriptors.getFontSizes()).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forFontSize()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:font-style", StyleEditorMessages.StyleProperty_PropertyName_FontStyle).setChoices((Object)new String[]{"normal", "italic"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forTextStyles()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:font-weight", StyleEditorMessages.StyleProperty_PropertyName_FontWeight).setChoices((Object)new String[]{"normal", "bold"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forTextStyles()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:text-decoration", StyleEditorMessages.StyleProperty_PropertyName_TextDecoration).setChoices((Object)new String[]{"none", "line-through", "underline", "underline line-through"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forTextStyles()).setCategory(CATEGORY_TEXT), new ColorPropertyDescriptor("fo:color", StyleEditorMessages.StyleProperty_PropertyName_TextColor, new ColorPickerConfigurer().popupStyle(5).autoValue(null).noneValue((Object)"none")).setLabelDescriptor(StylePropertyLabelDescriptor.forColors()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:text-align", StyleEditorMessages.StyleProperty_PropertyName_TextAlignment).setChoices((Object)new String[]{"left", "center", "right"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forAlignments()).setCategory(CATEGORY_TEXT), new MultiChoicePropertyDescriptor("fo:text-transform", StyleEditorMessages.StyleProperty_PropertyName_TextCase).setChoices((Object)new String[]{"manual", "uppercase", "lowercase", "capitalize"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forTextCase()).setCategory(CATEGORY_TEXT)};
    }

    private static IPropertyDescriptor[] createMapPropertyDescriptors() {
        return new IPropertyDescriptor[]{new ColorPropertyDescriptor("svg:fill", StyleEditorMessages.StyleProperty_PropertyName_BackgroundColor, new ColorPickerConfigurer().popupStyle(5).autoValue(null).noneValue((Object)"none")).setLabelDescriptor(StylePropertyLabelDescriptor.forColors()).setCategory(CATEGORY_SHEET), new MultiChoicePropertyDescriptor("line-tapered", StyleEditorMessages.StyleProperty_PropertyName_TaperedLines).setChoices((Object)new String[]{"none", "tapered"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.getDefault()).setCategory(CATEGORY_SHEET), new MultiChoicePropertyDescriptor("multi-line-colors", StyleEditorMessages.StyleProperty_PropertyName_MultiBranchColors).setChoices((Object)new String[]{"none", "#017c98 #00b2a1 #ffdd00 #fc8f00 #ff1500 #00b04c"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forMultiBranchColor()).setCategory(CATEGORY_SHEET), new MultiChoicePropertyDescriptor("color-gradient", StyleEditorMessages.StyleProperty_PropertyName_GradientColor).setChoices((Object)new String[]{"none", "gradient"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.getDefault()).setCategory(CATEGORY_SHEET), new WallpaperPropertyDescriptor("background", StyleEditorMessages.StyleProperty_PropertyName_Wallpaper).setLabelDescriptor(StylePropertyLabelDescriptor.getBlank()).setCategory(CATEGORY_WALLPAPER), new MultiChoicePropertyDescriptor("svg:opacity", StyleEditorMessages.StyleProperty_PropertyName_Opacity).setChoices((Object)new String[]{"0", ".1", ".2", ".3", ".4", ".5", ".6", ".7", ".8", ".9", "1"}).setChoiceProvider((IStructuredContentProvider)new ArrayContentProvider()).setLabelDescriptor(StylePropertyLabelDescriptor.forOpacities()).setCategory(CATEGORY_WALLPAPER), new ColorPropertyDescriptor("yellowBoxFillColor", StyleEditorMessages.StyleProperty_PropertyName_YellowBox_BackgroundColor, new ColorPickerConfigurer().popupStyle(5).autoValue(null).noneValue((Object)"none")).setLabelDescriptor(StylePropertyLabelDescriptor.forColors()).setCategory(CATEGORY_SHEET), new ColorPropertyDescriptor("legendFillColor", StyleEditorMessages.StyleProperty_PropertyName_Legend_BackgroundColor, new ColorPickerConfigurer().popupStyle(5).autoValue(null).noneValue((Object)"none")).setLabelDescriptor(StylePropertyLabelDescriptor.forColors()).setCategory(CATEGORY_SHEET)};
    }

    private static String[] toIds(List<IDecorationDescriptor> decorations) {
        String[] ids = new String[decorations.size()];
        int i = 0;
        while (i < decorations.size()) {
            ids[i] = decorations.get(i).getId();
            ++i;
        }
        return ids;
    }

    private static List<String> getFontSizes() {
        if (FONT_SIZES.isEmpty()) {
            FONT_SIZES.add("8pt");
            FONT_SIZES.add("9pt");
            FONT_SIZES.add("10pt");
            FONT_SIZES.add("11pt");
            FONT_SIZES.add("12pt");
            FONT_SIZES.add("14pt");
            FONT_SIZES.add("16pt");
            FONT_SIZES.add("18pt");
            FONT_SIZES.add("20pt");
            FONT_SIZES.add("22pt");
            FONT_SIZES.add("24pt");
            FONT_SIZES.add("36pt");
            FONT_SIZES.add("48pt");
            FONT_SIZES.add("56pt");
        }
        return FONT_SIZES;
    }

    public static StylePropertyDescriptors getSingleton() {
        return INSTANCE;
    }

    private static final class FontFamilyContentProvider
    implements IStructuredContentProvider {
        private FontFamilyContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return FontUtils.getAvailableFontNames().toArray();
        }
    }
}

