/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.cathy.internal.dashboard;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.tabfolder.MTabFolder;
import org.xmind.ui.tabfolder.MTabItem;
import org.xmind.ui.util.StyleProvider;

public class DashboardStyleProvider
extends StyleProvider {
    private ResourceManager resourceManager;
    private Map<String, RGB> keyToRGB = new HashMap<String, RGB>();

    public DashboardStyleProvider(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public Color getColor(Object widget, String key) {
        String defaultValue = null;
        if (widget instanceof MTabItem) {
            MTabItem item = (MTabItem)widget;
            if ("fill".equals(key) && (item.isSelected() || item.isPreselected())) {
                defaultValue = "#FFFFFF";
            } else if ("text".equals(key)) {
                defaultValue = "#FFFFFF";
            }
        } else if (widget instanceof MTabFolder) {
            if ("tabBar".equals(key)) {
                defaultValue = "#535f5e";
            }
            if ("body".equals(key)) {
                defaultValue = "#F2F2F2";
            }
        }
        if (defaultValue != null) {
            RGB rgb = ColorUtils.toRGB(defaultValue);
            if (this.keyToRGB.containsKey(key)) {
                rgb = this.keyToRGB.get(key);
            }
            return (Color)this.resourceManager.get((DeviceResourceDescriptor)ColorDescriptor.createFrom((RGB)rgb));
        }
        return super.getColor(widget, key);
    }

    public int getAlpha(Object widget, String key, int defaultValue) {
        if (widget instanceof MTabItem) {
            MTabItem item = (MTabItem)widget;
            if ("fill".equals(key)) {
                if (item.isSelected()) {
                    return 38;
                }
                if (item.isPreselected()) {
                    return 19;
                }
            }
        }
        return super.getAlpha(widget, key, defaultValue);
    }

    public Font getFont(Object widget, String key) {
        if (widget instanceof MTabItem && "text".equals(key)) {
            return (Font)this.resourceManager.get((DeviceResourceDescriptor)JFaceResources.getDefaultFontDescriptor().setHeight(12));
        }
        return super.getFont(widget, key);
    }

    public int getWidth(Object widget, String key, int defaultValue) {
        if (widget instanceof MTabItem) {
            if ("image".equals(key)) {
                return 56;
            }
            if ("margin".equals(key)) {
                return 3;
            }
            if ("separator".equals(key)) {
                return 2;
            }
            if (key == null) {
                return 72;
            }
        }
        return super.getWidth(widget, key, defaultValue);
    }

    public int getHeight(Object widget, String key, int defaultValue) {
        if (widget instanceof MTabItem) {
            if ("image".equals(key)) {
                return 45;
            }
            if ("margin".equals(key)) {
                return 6;
            }
            if ("separator".equals(key)) {
                return 2;
            }
            if (key == null) {
                return 74;
            }
        }
        return super.getHeight(widget, key, defaultValue);
    }

    public int getPosition(Object widget, String key, int defaultValue) {
        if (widget instanceof MTabItem) {
            if ("text".equals(key)) {
                return 1024;
            }
        } else if (widget instanceof MTabFolder && "tabBar".equals(key)) {
            return 16384;
        }
        return super.getPosition(widget, key, defaultValue);
    }

    public void setColor(String key, RGB value) {
        this.keyToRGB.put(key, value);
    }
}

