/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.config;

import com.db4o.config.Alias;
import com.db4o.foundation.ArgumentNullException;

public class WildcardAlias
implements Alias {
    private final WildcardPattern _storedPattern;
    private final WildcardPattern _runtimePattern;

    public WildcardAlias(String storedPattern, String runtimePattern) {
        if (null == storedPattern) {
            throw new ArgumentNullException("storedPattern");
        }
        if (null == runtimePattern) {
            throw new ArgumentNullException("runtimePattern");
        }
        this._storedPattern = new WildcardPattern(storedPattern);
        this._runtimePattern = new WildcardPattern(runtimePattern);
    }

    @Override
    public String resolveRuntimeName(String runtimeTypeName) {
        return this.resolve(this._runtimePattern, this._storedPattern, runtimeTypeName);
    }

    @Override
    public String resolveStoredName(String storedTypeName) {
        return this.resolve(this._storedPattern, this._runtimePattern, storedTypeName);
    }

    private String resolve(WildcardPattern from, WildcardPattern to, String typeName) {
        String match = from.matches(typeName);
        return match != null ? to.inject(match) : null;
    }

    static class WildcardPattern {
        private String _head;
        private String _tail;

        public WildcardPattern(String pattern) {
            String[] parts = this.split(pattern);
            this._head = parts[0];
            this._tail = parts[1];
        }

        public String inject(String s) {
            return this._head + s + this._tail;
        }

        public String matches(String s) {
            if (!s.startsWith(this._head) || !s.endsWith(this._tail)) {
                return null;
            }
            return s.substring(this._head.length(), s.length() - this._tail.length());
        }

        private void invalidPattern() {
            throw new IllegalArgumentException("only one '*' character");
        }

        String[] split(String pattern) {
            int index = pattern.indexOf(42);
            if (-1 == index || index != pattern.lastIndexOf(42)) {
                this.invalidPattern();
            }
            return new String[]{pattern.substring(0, index), pattern.substring(index + 1)};
        }
    }
}

