/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.internal.Transaction;
import com.db4o.internal.cs.ClientTransactionPool;

public class ClientTransactionHandle {
    private final ClientTransactionPool _transactionPool;
    private Transaction _mainTransaction;
    private Transaction _transaction;
    private boolean _rollbackOnClose;

    public ClientTransactionHandle(ClientTransactionPool transactionPool) {
        this._transactionPool = transactionPool;
        this._mainTransaction = this._transactionPool.acquireMain();
        this._rollbackOnClose = true;
    }

    public void acquireTransactionForFile(String fileName) {
        this._transaction = this._transactionPool.acquire(fileName);
    }

    public void releaseTransaction() {
        if (this._transaction != null) {
            this._transactionPool.release(this._transaction, this._rollbackOnClose);
            this._transaction = null;
        }
    }

    public boolean isClosed() {
        return this._transactionPool.isClosed();
    }

    public void close() {
        if (!this._transactionPool.isClosed() && this._mainTransaction != null) {
            this._mainTransaction.close(this._rollbackOnClose);
        }
    }

    public Transaction transaction() {
        if (this._transaction != null) {
            return this._transaction;
        }
        return this._mainTransaction;
    }

    public void transaction(Transaction transaction) {
        if (this._transaction != null) {
            this._transaction = transaction;
        } else {
            this._mainTransaction = transaction;
        }
        this._rollbackOnClose = false;
    }
}

