/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.reflect.generic;

import com.db4o.foundation.Collection4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.VirtualFieldMetadata;
import com.db4o.internal.marshall.ClassMarshaller;
import com.db4o.internal.marshall.FieldMarshaller;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.RawClassSpec;
import com.db4o.internal.marshall.RawFieldSpec;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.ReflectField;
import com.db4o.reflect.Reflector;
import com.db4o.reflect.generic.ReflectClassBuilder;

public class KnownClassesRepository {
    private static final Hashtable4 PRIMITIVES = new Hashtable4();
    private ObjectContainerBase _stream;
    private Transaction _trans;
    private ReflectClassBuilder _builder;
    private final Hashtable4 _classByName = new Hashtable4();
    private final Hashtable4 _classByID = new Hashtable4();
    private Collection4 _pendingClasses = new Collection4();
    private final Collection4 _classes = new Collection4();

    private static void registerPrimitive(Class wrapper, Class primitive) {
        PRIMITIVES.put(wrapper.getName(), (Object)primitive);
    }

    public KnownClassesRepository(ReflectClassBuilder builder) {
        this._builder = builder;
    }

    public void setTransaction(Transaction trans) {
        if (trans != null) {
            this._trans = trans;
            this._stream = trans.container();
        }
    }

    public void register(ReflectClass clazz) {
        this._classByName.put(clazz.getName(), (Object)clazz);
        this._classes.add(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReflectClass forID(int id) {
        Object object = this._stream.lock();
        synchronized (object) {
            if (this._stream.handlers().isSystemHandler(id)) {
                return this._stream.handlers().classForID(id);
            }
            this.ensureClassAvailability(id);
            return this.lookupByID(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReflectClass forName(String className) {
        ReflectClass clazz = (ReflectClass)this._classByName.get(className);
        if (clazz != null) {
            return clazz;
        }
        if (this._stream == null) {
            return null;
        }
        Object object = this._stream.lock();
        synchronized (object) {
            if (this._stream.classCollection() == null) {
                return null;
            }
            int classID = this._stream.classMetadataIdForName(className);
            if (classID <= 0) {
                return null;
            }
            return this.initializeClass(classID, className);
        }
    }

    private ReflectClass initializeClass(int classID, String className) {
        ReflectClass newClazz = this.ensureClassInitialised(classID);
        this._classByName.put(className, (Object)newClazz);
        return newClazz;
    }

    private void readAll() {
        Iterator4 idIter = this._stream.classCollection().ids();
        while (idIter.moveNext()) {
            this.ensureClassAvailability((Integer)idIter.current());
        }
        idIter = this._stream.classCollection().ids();
        while (idIter.moveNext()) {
            this.ensureClassRead((Integer)idIter.current());
        }
    }

    private ReflectClass ensureClassAvailability(int id) {
        if (id == 0) {
            return null;
        }
        ReflectClass ret = (ReflectClass)this._classByID.get(id);
        if (ret != null) {
            return ret;
        }
        ClassMarshaller marshaller = this.marshallerFamily()._class;
        StatefulBuffer classreader = this._stream.readWriterByID(this._trans, id);
        RawClassSpec spec = marshaller.readSpec(this._trans, classreader);
        String className = spec.name();
        ret = (ReflectClass)this._classByName.get(className);
        if (ret != null) {
            this._classByID.put(id, (Object)ret);
            this._pendingClasses.add(new Integer(id));
            return ret;
        }
        ret = this._builder.createClass(className, this.ensureClassAvailability(spec.superClassID()), spec.numFields());
        this._classByID.put(id, (Object)ret);
        this._pendingClasses.add(new Integer(id));
        return ret;
    }

    private void ensureClassRead(int id) {
        ReflectClass clazz = this.lookupByID(id);
        ClassMarshaller classMarshaller = this.marshallerFamily()._class;
        StatefulBuffer classreader = this._stream.readWriterByID(this._trans, id);
        RawClassSpec classInfo = classMarshaller.readSpec(this._trans, classreader);
        String className = classInfo.name();
        if (this._classByName.get(className) != null) {
            return;
        }
        this._classByName.put(className, (Object)clazz);
        this._classes.add(clazz);
        int numFields = classInfo.numFields();
        ReflectField[] fields = this._builder.fieldArray(numFields);
        FieldMarshaller fieldMarshaller = this.marshallerFamily()._field;
        for (int i = 0; i < numFields; ++i) {
            RawFieldSpec fieldInfo = fieldMarshaller.readSpec(this._stream, classreader);
            String fieldName = fieldInfo.name();
            ReflectClass fieldClass = this.reflectClassForFieldSpec(fieldInfo, this._stream.reflector());
            fields[i] = this._builder.createField(clazz, fieldName, fieldClass, fieldInfo.isVirtual(), fieldInfo.isPrimitive(), fieldInfo.isArray(), fieldInfo.isNArray());
        }
        this._builder.initFields(clazz, fields);
    }

    private ReflectClass reflectClassForFieldSpec(RawFieldSpec fieldInfo, Reflector reflector) {
        if (fieldInfo.isVirtual()) {
            return this.virtualFieldByName(fieldInfo.name()).classReflector(reflector);
        }
        int handlerID = fieldInfo.handlerID();
        switch (handlerID) {
            case 11: {
                return this.objectClass();
            }
            case 12: {
                return this.arrayClass(this.objectClass());
            }
        }
        ReflectClass fieldClass = this.forID(handlerID);
        if (null != fieldClass) {
            return this.normalizeFieldClass(fieldInfo, fieldClass);
        }
        return null;
    }

    private ReflectClass normalizeFieldClass(RawFieldSpec fieldInfo, ReflectClass fieldClass) {
        ReflectClass theClass = this._stream.reflector().forName(fieldClass.getName());
        if (fieldInfo.isPrimitive()) {
            theClass = this.primitiveClass(theClass);
        }
        if (fieldInfo.isArray()) {
            theClass = this.arrayClass(theClass);
        }
        return theClass;
    }

    private ReflectClass objectClass() {
        return this._stream.reflector().forClass(Object.class);
    }

    private VirtualFieldMetadata virtualFieldByName(String fieldName) {
        return this._stream.handlers().virtualFieldByName(fieldName);
    }

    private MarshallerFamily marshallerFamily() {
        return MarshallerFamily.forConverterVersion(this._stream.converterVersion());
    }

    private ReflectClass ensureClassInitialised(int id) {
        ReflectClass ret = this.ensureClassAvailability(id);
        while (this._pendingClasses.size() > 0) {
            Collection4 pending = this._pendingClasses;
            this._pendingClasses = new Collection4();
            Iterator4 i = pending.iterator();
            while (i.moveNext()) {
                this.ensureClassRead((Integer)i.current());
            }
        }
        return ret;
    }

    public Iterator4 classes() {
        this.readAll();
        return this._classes.iterator();
    }

    public void register(int id, ReflectClass clazz) {
        this._classByID.put(id, (Object)clazz);
    }

    public ReflectClass lookupByID(int id) {
        return (ReflectClass)this._classByID.get(id);
    }

    public ReflectClass lookupByName(String name) {
        return (ReflectClass)this._classByName.get(name);
    }

    private ReflectClass arrayClass(ReflectClass clazz) {
        Object proto = clazz.reflector().array().newInstance(clazz, 0);
        return clazz.reflector().forObject(proto);
    }

    private ReflectClass primitiveClass(ReflectClass baseClass) {
        Class primitive = (Class)PRIMITIVES.get(baseClass.getName());
        if (primitive != null) {
            return baseClass.reflector().forClass(primitive);
        }
        return baseClass;
    }

    static {
        KnownClassesRepository.registerPrimitive(Boolean.class, Boolean.TYPE);
        KnownClassesRepository.registerPrimitive(Byte.class, Byte.TYPE);
        KnownClassesRepository.registerPrimitive(Short.class, Short.TYPE);
        KnownClassesRepository.registerPrimitive(Character.class, Character.TYPE);
        KnownClassesRepository.registerPrimitive(Integer.class, Integer.TYPE);
        KnownClassesRepository.registerPrimitive(Long.class, Long.TYPE);
        KnownClassesRepository.registerPrimitive(Float.class, Float.TYPE);
        KnownClassesRepository.registerPrimitive(Double.class, Double.TYPE);
    }
}

