/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.client.async.BlockSet;
import freenet.client.events.ClientEventProducer;
import freenet.client.events.SimpleEventProducer;
import freenet.client.filter.FoundURICallback;
import freenet.client.filter.TagReplacerCallback;
import freenet.node.RequestScheduler;
import freenet.support.api.BucketFactory;
import freenet.support.io.StorageFormatException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class FetchContext
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int IDENTICAL_MASK = 0;
    public static final int SPLITFILE_DEFAULT_BLOCK_MASK = 1;
    public static final int SPLITFILE_DEFAULT_MASK = 2;
    public static final int SET_RETURN_ARCHIVES = 4;
    public long maxOutputLength;
    public long maxTempLength;
    public int maxRecursionLevel;
    public int maxArchiveRestarts;
    public int maxArchiveLevels;
    public boolean dontEnterImplicitArchives;
    public int maxSplitfileBlockRetries;
    public int maxNonSplitfileRetries;
    public final int maxUSKRetries;
    public boolean allowSplitfiles;
    public boolean followRedirects;
    public boolean localRequestOnly;
    public boolean ignoreStore;
    public final ClientEventProducer eventProducer;
    public int maxMetadataSize;
    public int maxDataBlocksPerSegment;
    public int maxCheckBlocksPerSegment;
    public boolean returnZIPManifests;
    public boolean filterData;
    public final boolean ignoreTooManyPathComponents;
    public final BlockSet blocks;
    public Set<String> allowedMIMETypes;
    public String charset;
    private final boolean hasOwnEventProducer;
    public boolean canWriteClientCache;
    public FoundURICallback prefetchHook;
    public TagReplacerCallback tagReplacer;
    public String overrideMIME;
    private int cooldownRetries;
    private long cooldownTime;
    public boolean ignoreUSKDatehints;
    private static final long CLIENT_DETAIL_MAGIC = 6549706159590070305L;
    private static final int CLIENT_DETAIL_VERSION = 1;

    public FetchContext(long curMaxLength, long curMaxTempLength, int maxMetadataSize, int maxRecursionLevel, int maxArchiveRestarts, int maxArchiveLevels, boolean dontEnterImplicitArchives, int maxSplitfileBlockRetries, int maxNonSplitfileRetries, int maxUSKRetries, boolean allowSplitfiles, boolean followRedirects, boolean localRequestOnly, boolean filterData, int maxDataBlocksPerSegment, int maxCheckBlocksPerSegment, BucketFactory bucketFactory, ClientEventProducer producer, boolean ignoreTooManyPathComponents, boolean canWriteClientCache, String charset, String overrideMIME) {
        this.blocks = null;
        this.maxOutputLength = curMaxLength;
        if (this.maxOutputLength < 0L) {
            throw new IllegalArgumentException("Bad max output length");
        }
        this.maxTempLength = curMaxTempLength;
        if (this.maxTempLength < 0L) {
            throw new IllegalArgumentException("Bad max temp length");
        }
        this.maxMetadataSize = maxMetadataSize;
        if (maxMetadataSize < 0) {
            throw new IllegalArgumentException("Bad max metadata size");
        }
        this.maxRecursionLevel = maxRecursionLevel;
        if (maxRecursionLevel < 0) {
            throw new IllegalArgumentException("Bad max recursion level");
        }
        this.maxArchiveRestarts = maxArchiveRestarts;
        if (maxArchiveRestarts < 0) {
            throw new IllegalArgumentException("Bad max archive restarts");
        }
        this.maxArchiveLevels = maxArchiveLevels;
        if (maxArchiveLevels < 0) {
            throw new IllegalArgumentException("Bad max archive levels");
        }
        this.dontEnterImplicitArchives = dontEnterImplicitArchives;
        this.maxSplitfileBlockRetries = maxSplitfileBlockRetries;
        if (maxSplitfileBlockRetries < -1) {
            throw new IllegalArgumentException("Bad max splitfile block retries");
        }
        this.maxNonSplitfileRetries = maxNonSplitfileRetries;
        if (maxNonSplitfileRetries < -1) {
            throw new IllegalArgumentException("Bad non-splitfile retries");
        }
        this.maxUSKRetries = maxUSKRetries;
        if (maxUSKRetries < -1) {
            throw new IllegalArgumentException("Bad max USK retries");
        }
        this.allowSplitfiles = allowSplitfiles;
        this.followRedirects = followRedirects;
        this.localRequestOnly = localRequestOnly;
        this.eventProducer = producer;
        this.maxDataBlocksPerSegment = maxDataBlocksPerSegment;
        if (maxDataBlocksPerSegment < 0 || maxDataBlocksPerSegment > 256) {
            throw new IllegalArgumentException("Bad max blocks per segment");
        }
        this.maxCheckBlocksPerSegment = maxCheckBlocksPerSegment;
        if (maxCheckBlocksPerSegment < 0 || maxCheckBlocksPerSegment > 256) {
            throw new IllegalArgumentException("Bad max blocks per segment");
        }
        this.filterData = filterData;
        this.ignoreTooManyPathComponents = ignoreTooManyPathComponents;
        this.canWriteClientCache = canWriteClientCache;
        this.charset = charset;
        this.overrideMIME = overrideMIME;
        this.cooldownRetries = 3;
        this.cooldownTime = RequestScheduler.COOLDOWN_PERIOD;
        this.ignoreUSKDatehints = false;
        this.hasOwnEventProducer = true;
    }

    public FetchContext(FetchContext ctx, int maskID) {
        this(ctx, maskID, false, null);
    }

    public FetchContext(FetchContext ctx, int maskID, boolean keepProducer, BlockSet blocks) {
        this.eventProducer = keepProducer ? ctx.eventProducer : new SimpleEventProducer();
        this.hasOwnEventProducer = !keepProducer;
        this.ignoreTooManyPathComponents = ctx.ignoreTooManyPathComponents;
        this.blocks = blocks != null ? blocks : ctx.blocks;
        this.allowedMIMETypes = ctx.allowedMIMETypes;
        this.maxUSKRetries = ctx.maxUSKRetries;
        this.localRequestOnly = ctx.localRequestOnly;
        this.maxArchiveLevels = ctx.maxArchiveLevels;
        this.maxMetadataSize = ctx.maxMetadataSize;
        this.maxNonSplitfileRetries = ctx.maxNonSplitfileRetries;
        this.maxOutputLength = ctx.maxOutputLength;
        this.maxSplitfileBlockRetries = ctx.maxSplitfileBlockRetries;
        this.maxTempLength = ctx.maxTempLength;
        this.allowSplitfiles = ctx.allowSplitfiles;
        this.dontEnterImplicitArchives = ctx.dontEnterImplicitArchives;
        this.followRedirects = ctx.followRedirects;
        this.maxArchiveRestarts = ctx.maxArchiveRestarts;
        this.maxCheckBlocksPerSegment = ctx.maxCheckBlocksPerSegment;
        this.maxDataBlocksPerSegment = ctx.maxDataBlocksPerSegment;
        this.filterData = ctx.filterData;
        this.maxRecursionLevel = ctx.maxRecursionLevel;
        this.returnZIPManifests = ctx.returnZIPManifests;
        this.canWriteClientCache = ctx.canWriteClientCache;
        this.prefetchHook = ctx.prefetchHook;
        this.tagReplacer = ctx.tagReplacer;
        this.overrideMIME = ctx.overrideMIME;
        this.cooldownRetries = ctx.cooldownRetries;
        this.cooldownTime = ctx.cooldownTime;
        this.ignoreUSKDatehints = ctx.ignoreUSKDatehints;
        if (maskID != 0 && maskID != 2) {
            if (maskID == 1) {
                this.maxRecursionLevel = 1;
                this.maxArchiveRestarts = 0;
                this.dontEnterImplicitArchives = true;
                this.allowSplitfiles = false;
                this.followRedirects = false;
                this.maxDataBlocksPerSegment = 0;
                this.maxCheckBlocksPerSegment = 0;
                this.returnZIPManifests = false;
            } else if (maskID == 4) {
                this.returnZIPManifests = true;
            } else {
                throw new IllegalArgumentException();
            }
        }
    }

    public FetchContext clone() {
        try {
            return (FetchContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public void setCooldownRetries(int cooldownRetries) {
        if (cooldownRetries < 0) {
            throw new IllegalArgumentException("Bogus negative retries");
        }
        if (cooldownRetries > 3) {
            throw new IllegalArgumentException("Invalid COOLDOWN_RETRIES: Must be <= 3 since the network will not tolerate more than that");
        }
        this.cooldownRetries = cooldownRetries;
    }

    public void setCooldownTime(long cooldownTime) {
        this.setCooldownTime(cooldownTime, false);
    }

    public void setCooldownTime(long cooldownTime, boolean force) {
        if (cooldownTime < 0L) {
            throw new IllegalArgumentException("Bogus negative cooldown time");
        }
        if (cooldownTime < RequestScheduler.COOLDOWN_PERIOD && !force) {
            throw new IllegalArgumentException("Invalid COOLDOWN_PERIOD: Must be >= " + RequestScheduler.COOLDOWN_PERIOD + " since ULPRs will ensure fast response at that level");
        }
        this.cooldownTime = cooldownTime;
    }

    public int getCooldownRetries() {
        return this.cooldownRetries;
    }

    public long getCooldownTime() {
        return this.cooldownTime;
    }

    public void writeTo(DataOutputStream dos) throws IOException {
        dos.writeLong(6549706159590070305L);
        dos.writeInt(1);
        dos.writeLong(this.maxOutputLength);
        dos.writeLong(this.maxTempLength);
        dos.writeInt(this.maxRecursionLevel);
        dos.writeInt(this.maxArchiveRestarts);
        dos.writeInt(this.maxArchiveLevels);
        dos.writeBoolean(this.dontEnterImplicitArchives);
        dos.writeInt(this.maxSplitfileBlockRetries);
        dos.writeInt(this.maxNonSplitfileRetries);
        dos.writeInt(this.maxUSKRetries);
        dos.writeBoolean(this.allowSplitfiles);
        dos.writeBoolean(this.followRedirects);
        dos.writeBoolean(this.localRequestOnly);
        dos.writeBoolean(this.ignoreStore);
        dos.writeInt(this.maxMetadataSize);
        dos.writeInt(this.maxDataBlocksPerSegment);
        dos.writeInt(this.maxCheckBlocksPerSegment);
        dos.writeBoolean(this.returnZIPManifests);
        dos.writeBoolean(this.filterData);
        dos.writeBoolean(this.ignoreTooManyPathComponents);
        if (this.blocks != null) {
            throw new UnsupportedOperationException("Binary blob not supported");
        }
        if (this.allowedMIMETypes != null) {
            dos.writeInt(this.allowedMIMETypes.size());
            for (String s : this.allowedMIMETypes) {
                dos.writeUTF(s);
            }
        } else {
            dos.writeInt(0);
        }
        if (this.charset == null) {
            dos.writeUTF("");
        } else {
            dos.writeUTF(this.charset);
        }
        dos.writeBoolean(this.canWriteClientCache);
        if (this.prefetchHook != null) {
            throw new UnsupportedOperationException("Prefetch hook not supported");
        }
        if (this.tagReplacer != null) {
            throw new UnsupportedOperationException("Tag replacer not supported");
        }
        if (this.overrideMIME != null) {
            dos.writeUTF(this.overrideMIME);
        } else {
            dos.writeUTF("");
        }
        dos.writeInt(this.cooldownRetries);
        dos.writeLong(this.cooldownTime);
        dos.writeBoolean(this.ignoreUSKDatehints);
    }

    public FetchContext(DataInputStream dis) throws StorageFormatException, IOException {
        long magic = dis.readLong();
        if (magic != 6549706159590070305L) {
            throw new StorageFormatException("Bad magic for fetch settings (FetchContext)");
        }
        int version = dis.readInt();
        if (version != 1) {
            throw new StorageFormatException("Bad version for fetch settings (FetchContext)");
        }
        this.maxOutputLength = dis.readLong();
        if (this.maxOutputLength < 0L) {
            throw new StorageFormatException("Bad max output length");
        }
        this.maxTempLength = dis.readLong();
        if (this.maxTempLength < 0L) {
            throw new StorageFormatException("Bad max temp length");
        }
        this.maxRecursionLevel = dis.readInt();
        if (this.maxRecursionLevel < 0) {
            throw new StorageFormatException("Bad max recursion level");
        }
        this.maxArchiveRestarts = dis.readInt();
        if (this.maxArchiveRestarts < 0) {
            throw new StorageFormatException("Bad max archive restarts");
        }
        this.maxArchiveLevels = dis.readInt();
        if (this.maxArchiveLevels < 0) {
            throw new StorageFormatException("Bad max archive levels");
        }
        this.dontEnterImplicitArchives = dis.readBoolean();
        this.maxSplitfileBlockRetries = dis.readInt();
        if (this.maxSplitfileBlockRetries < -1) {
            throw new StorageFormatException("Bad max splitfile block retries");
        }
        this.maxNonSplitfileRetries = dis.readInt();
        if (this.maxNonSplitfileRetries < -1) {
            throw new StorageFormatException("Bad non-splitfile retries");
        }
        this.maxUSKRetries = dis.readInt();
        if (this.maxUSKRetries < -1) {
            throw new StorageFormatException("Bad max USK retries");
        }
        this.allowSplitfiles = dis.readBoolean();
        this.followRedirects = dis.readBoolean();
        this.localRequestOnly = dis.readBoolean();
        this.ignoreStore = dis.readBoolean();
        this.maxMetadataSize = dis.readInt();
        if (this.maxMetadataSize < 0) {
            throw new StorageFormatException("Bad max metadata size");
        }
        this.maxDataBlocksPerSegment = dis.readInt();
        if (this.maxDataBlocksPerSegment < 0 || this.maxDataBlocksPerSegment > 256) {
            throw new StorageFormatException("Bad max blocks per segment");
        }
        this.maxCheckBlocksPerSegment = dis.readInt();
        if (this.maxCheckBlocksPerSegment < 0 || this.maxCheckBlocksPerSegment > 256) {
            throw new StorageFormatException("Bad max blocks per segment");
        }
        this.returnZIPManifests = dis.readBoolean();
        this.filterData = dis.readBoolean();
        this.ignoreTooManyPathComponents = dis.readBoolean();
        int x = dis.readInt();
        if (x < 0) {
            throw new StorageFormatException("Bad allowed MIME types length " + x);
        }
        if (x == 0) {
            this.allowedMIMETypes = null;
        } else {
            this.allowedMIMETypes = new HashSet<String>();
            for (int i = 0; i < x; ++i) {
                this.allowedMIMETypes.add(dis.readUTF());
            }
        }
        String s = dis.readUTF();
        this.charset = s.equals("") ? null : s;
        this.canWriteClientCache = dis.readBoolean();
        s = dis.readUTF();
        this.overrideMIME = s.equals("") ? null : s;
        this.cooldownRetries = dis.readInt();
        this.cooldownTime = dis.readLong();
        this.ignoreUSKDatehints = dis.readBoolean();
        this.hasOwnEventProducer = true;
        this.eventProducer = new SimpleEventProducer();
        this.blocks = null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allowSplitfiles ? 1231 : 1237);
        result = 31 * result + (this.allowedMIMETypes == null ? 0 : this.allowedMIMETypes.hashCode());
        result = 31 * result + (this.canWriteClientCache ? 1231 : 1237);
        result = 31 * result + (this.charset == null ? 0 : this.charset.hashCode());
        result = 31 * result + this.cooldownRetries;
        result = 31 * result + (int)(this.cooldownTime ^ this.cooldownTime >>> 32);
        result = 31 * result + (this.dontEnterImplicitArchives ? 1231 : 1237);
        result = 31 * result + (this.filterData ? 1231 : 1237);
        result = 31 * result + (this.followRedirects ? 1231 : 1237);
        result = 31 * result + (this.hasOwnEventProducer ? 1231 : 1237);
        result = 31 * result + (this.ignoreStore ? 1231 : 1237);
        result = 31 * result + (this.ignoreTooManyPathComponents ? 1231 : 1237);
        result = 31 * result + (this.ignoreUSKDatehints ? 1231 : 1237);
        result = 31 * result + (this.localRequestOnly ? 1231 : 1237);
        result = 31 * result + this.maxArchiveLevels;
        result = 31 * result + this.maxArchiveRestarts;
        result = 31 * result + this.maxCheckBlocksPerSegment;
        result = 31 * result + this.maxDataBlocksPerSegment;
        result = 31 * result + this.maxMetadataSize;
        result = 31 * result + this.maxNonSplitfileRetries;
        result = 31 * result + (int)(this.maxOutputLength ^ this.maxOutputLength >>> 32);
        result = 31 * result + this.maxRecursionLevel;
        result = 31 * result + this.maxSplitfileBlockRetries;
        result = 31 * result + (int)(this.maxTempLength ^ this.maxTempLength >>> 32);
        result = 31 * result + this.maxUSKRetries;
        result = 31 * result + (this.overrideMIME == null ? 0 : this.overrideMIME.hashCode());
        result = 31 * result + (this.prefetchHook == null ? 0 : this.prefetchHook.hashCode());
        result = 31 * result + (this.returnZIPManifests ? 1231 : 1237);
        result = 31 * result + (this.tagReplacer == null ? 0 : this.tagReplacer.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FetchContext other = (FetchContext)obj;
        if (this.allowSplitfiles != other.allowSplitfiles) {
            return false;
        }
        if (this.allowedMIMETypes == null ? other.allowedMIMETypes != null : !this.allowedMIMETypes.equals(other.allowedMIMETypes)) {
            return false;
        }
        if (this.blocks == null ? other.blocks != null : !this.blocks.equals(other.blocks)) {
            return false;
        }
        if (this.canWriteClientCache != other.canWriteClientCache) {
            return false;
        }
        if (this.charset == null ? other.charset != null : !this.charset.equals(other.charset)) {
            return false;
        }
        if (this.cooldownRetries != other.cooldownRetries) {
            return false;
        }
        if (this.cooldownTime != other.cooldownTime) {
            return false;
        }
        if (this.dontEnterImplicitArchives != other.dontEnterImplicitArchives) {
            return false;
        }
        if (this.filterData != other.filterData) {
            return false;
        }
        if (this.followRedirects != other.followRedirects) {
            return false;
        }
        if (this.hasOwnEventProducer != other.hasOwnEventProducer) {
            return false;
        }
        if (this.ignoreStore != other.ignoreStore) {
            return false;
        }
        if (this.ignoreTooManyPathComponents != other.ignoreTooManyPathComponents) {
            return false;
        }
        if (this.ignoreUSKDatehints != other.ignoreUSKDatehints) {
            return false;
        }
        if (this.localRequestOnly != other.localRequestOnly) {
            return false;
        }
        if (this.maxArchiveLevels != other.maxArchiveLevels) {
            return false;
        }
        if (this.maxArchiveRestarts != other.maxArchiveRestarts) {
            return false;
        }
        if (this.maxCheckBlocksPerSegment != other.maxCheckBlocksPerSegment) {
            return false;
        }
        if (this.maxDataBlocksPerSegment != other.maxDataBlocksPerSegment) {
            return false;
        }
        if (this.maxMetadataSize != other.maxMetadataSize) {
            return false;
        }
        if (this.maxNonSplitfileRetries != other.maxNonSplitfileRetries) {
            return false;
        }
        if (this.maxOutputLength != other.maxOutputLength) {
            return false;
        }
        if (this.maxRecursionLevel != other.maxRecursionLevel) {
            return false;
        }
        if (this.maxSplitfileBlockRetries != other.maxSplitfileBlockRetries) {
            return false;
        }
        if (this.maxTempLength != other.maxTempLength) {
            return false;
        }
        if (this.maxUSKRetries != other.maxUSKRetries) {
            return false;
        }
        if (this.overrideMIME == null ? other.overrideMIME != null : !this.overrideMIME.equals(other.overrideMIME)) {
            return false;
        }
        if (this.prefetchHook == null ? other.prefetchHook != null : !this.prefetchHook.equals(other.prefetchHook)) {
            return false;
        }
        if (this.returnZIPManifests != other.returnZIPManifests) {
            return false;
        }
        return !(this.tagReplacer == null ? other.tagReplacer != null : !this.tagReplacer.equals(other.tagReplacer));
    }
}

