/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.FetchContext;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ChosenBlockImpl;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequestSchedulerGroup;
import freenet.client.async.ClientRequester;
import freenet.client.async.OfferedKeysList;
import freenet.crypt.RandomSource;
import freenet.keys.ClientKey;
import freenet.keys.Key;
import freenet.node.BaseSendableGet;
import freenet.node.KeysFetchingLocally;
import freenet.node.Node;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.RequestStarter;
import freenet.node.SendableGet;
import freenet.node.SendableInsert;
import freenet.node.SendableRequest;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestItemKey;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.RandomGrabArray;
import freenet.support.RandomGrabArrayWithObject;
import freenet.support.RemoveRandom;
import freenet.support.RemoveRandomParent;
import freenet.support.SectoredRandomGrabArray;
import freenet.support.SectoredRandomGrabArraySimple;
import freenet.support.TimeUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;

public class ClientRequestSelector
implements KeysFetchingLocally {
    final boolean isInsertScheduler;
    final boolean isSSKScheduler;
    final boolean isRTScheduler;
    final ClientRequestScheduler sched;
    protected RequestClientRGANode[] priorities;
    protected final Deque<BaseSendableGet> recentSuccesses;
    private static volatile boolean logMINOR;
    private transient HashSet<Key> keysFetching;
    private transient HashMap<Key, WeakReference<BaseSendableGet>[]> transientRequestsWaitingForKeysFetching;
    private final transient HashSet<SendableRequestItemKey> runningInserts;
    private static final short[] tweakedPrioritySelector;
    private static final short[] prioritySelector;

    ClientRequestSelector(boolean isInsertScheduler, boolean isSSKScheduler, boolean isRTScheduler, ClientRequestScheduler sched) {
        this.sched = sched;
        this.isInsertScheduler = isInsertScheduler;
        this.isSSKScheduler = isSSKScheduler;
        this.isRTScheduler = isRTScheduler;
        if (!isInsertScheduler) {
            this.keysFetching = new HashSet();
            this.transientRequestsWaitingForKeysFetching = new HashMap();
            this.runningInserts = null;
            this.recentSuccesses = new ArrayDeque<BaseSendableGet>();
        } else {
            this.keysFetching = null;
            this.runningInserts = new HashSet();
            this.recentSuccesses = null;
        }
        this.priorities = new RequestClientRGANode[7];
    }

    private synchronized long choosePriority(int fuzz, RandomSource random, ClientContext context, long now) {
        RequestClientRGANode result = null;
        long wakeupTime = Long.MAX_VALUE;
        int iteration = 0;
        while (true) {
            long cooldownTime;
            int n = iteration;
            iteration = (short)(iteration + 1);
            if (n >= 8) break;
            short priority = fuzz < 0 ? tweakedPrioritySelector[random.nextInt(tweakedPrioritySelector.length)] : prioritySelector[Math.abs(fuzz % prioritySelector.length)];
            result = this.priorities[priority];
            if (result != null && (cooldownTime = result.getWakeupTime(context, now)) > 0L) {
                if (cooldownTime < wakeupTime) {
                    wakeupTime = cooldownTime;
                }
                if (logMINOR) {
                    if (cooldownTime == Long.MAX_VALUE) {
                        Logger.minor(this, "Priority " + priority + " is waiting until a request finishes or is empty");
                    } else {
                        Logger.minor(this, "Priority " + priority + " is in cooldown for another " + (cooldownTime - now) + " " + TimeUtil.formatTime(cooldownTime - now));
                    }
                }
                result = null;
            }
            if (priority > 5) {
                ++fuzz;
                continue;
            }
            if (result != null && !result.isEmpty()) {
                if (logMINOR) {
                    Logger.minor(this, "using priority : " + priority);
                }
                return priority;
            }
            if (logMINOR) {
                Logger.minor(this, "Priority " + priority + " is null (fuzz = " + fuzz + ')');
            }
            ++fuzz;
        }
        return wakeupTime;
    }

    ChosenBlock chooseRequest(int fuzz, RandomSource random, OfferedKeysList offeredKeys, RequestStarter starter, boolean realTime, ClientContext context) {
        long now = System.currentTimeMillis();
        for (int i = 0; i < 5; ++i) {
            SelectorReturn r = this.chooseRequestInner(fuzz, random, offeredKeys, starter, realTime, context, now);
            SendableRequest req = r.req;
            if (req == null) {
                if (r.wakeupTime == Long.MAX_VALUE || r.wakeupTime <= now) continue;
                this.sched.clientContext.ticker.queueTimedJob(new Runnable(){

                    @Override
                    public void run() {
                        ClientRequestSelector.this.sched.wakeStarter();
                    }
                }, r.wakeupTime - now);
                continue;
            }
            if (this.isInsertScheduler && req instanceof SendableGet) {
                IllegalStateException e = new IllegalStateException("removeFirstInner returned a SendableGet on an insert scheduler!!");
                req.internalError(e, this.sched, context, req.persistent());
                throw e;
            }
            ChosenBlock block = this.maybeMakeChosenRequest(req, context, now);
            if (block == null) continue;
            return block;
        }
        return null;
    }

    public ChosenBlock maybeMakeChosenRequest(SendableRequest req, ClientContext context, long now) {
        boolean forkOnCacheable;
        boolean realTimeFlag;
        boolean canWriteClientCache;
        boolean ignoreStore;
        boolean localRequestOnly;
        ClientKey ckey;
        Key key;
        if (req == null) {
            return null;
        }
        if (req.isCancelled()) {
            if (logMINOR) {
                Logger.minor(this, "Request is cancelled: " + req);
            }
            return null;
        }
        if (req.getWakeupTime(context, now) != 0L) {
            if (logMINOR) {
                Logger.minor(this, "Request is in cooldown: " + req);
            }
            return null;
        }
        SendableRequestItem token = req.chooseKey(this, context);
        if (token == null) {
            if (logMINOR) {
                Logger.minor(this, "Choose key returned null: " + req);
            }
            return null;
        }
        if (this.isInsertScheduler) {
            key = null;
            ckey = null;
        } else {
            key = ((BaseSendableGet)req).getNodeKey(token);
            ckey = req instanceof SendableGet ? ((SendableGet)req).getKey(token) : null;
        }
        if (key != null && key.getRoutingKey() == null) {
            throw new NullPointerException();
        }
        if (req instanceof SendableGet) {
            SendableGet sg = (SendableGet)req;
            FetchContext ctx = sg.getContext();
            localRequestOnly = ctx.localRequestOnly;
            ignoreStore = ctx.ignoreStore;
            canWriteClientCache = ctx.canWriteClientCache;
            realTimeFlag = sg.realTimeFlag();
            forkOnCacheable = false;
        } else {
            localRequestOnly = false;
            if (req instanceof SendableInsert) {
                canWriteClientCache = ((SendableInsert)req).canWriteClientCache();
                forkOnCacheable = ((SendableInsert)req).forkOnCacheable();
                localRequestOnly = ((SendableInsert)req).localRequestOnly();
                realTimeFlag = ((SendableInsert)req).realTimeFlag();
            } else {
                canWriteClientCache = false;
                forkOnCacheable = true;
                localRequestOnly = false;
                realTimeFlag = false;
            }
            ignoreStore = false;
        }
        ChosenBlockImpl ret = new ChosenBlockImpl(req, token, key, ckey, localRequestOnly, ignoreStore, canWriteClientCache, forkOnCacheable, realTimeFlag, this.sched, req.persistent());
        if (logMINOR) {
            Logger.minor(this, "Created " + ret + " for " + req);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SelectorReturn chooseRequestInner(int fuzz, RandomSource random, OfferedKeysList offeredKeys, RequestStarter starter, boolean realTime, ClientContext context, long now) {
        boolean tryOfferedKeys;
        if (logMINOR) {
            Logger.minor(this, "removeFirst()");
        }
        boolean bl = tryOfferedKeys = offeredKeys != null && random.nextBoolean();
        if (tryOfferedKeys && offeredKeys.getWakeupTime(context, now) == 0L) {
            return new SelectorReturn(offeredKeys);
        }
        long l = this.choosePriority(fuzz, random, context, now);
        if (l > Integer.MAX_VALUE) {
            if (logMINOR) {
                Logger.minor(this, "No priority available for the next " + TimeUtil.formatTime(l - now));
            }
            return new SelectorReturn(l);
        }
        int choosenPriorityClass = (int)l;
        if (choosenPriorityClass == -1) {
            if (!tryOfferedKeys && offeredKeys != null && offeredKeys.getWakeupTime(context, now) == 0L) {
                return new SelectorReturn(offeredKeys);
            }
            if (logMINOR) {
                Logger.minor(this, "Nothing to do");
            }
            return new SelectorReturn(Long.MAX_VALUE);
        }
        long wakeupTime = Long.MAX_VALUE;
        while (choosenPriorityClass <= 5) {
            block50: {
                RequestClientRGANode chosenTracker;
                if (logMINOR) {
                    Logger.minor(this, "Using priority " + choosenPriorityClass);
                }
                if ((chosenTracker = this.priorities[choosenPriorityClass]) == null) {
                    if (logMINOR) {
                        Logger.minor(this, "No requests to run: chosen priority empty");
                    }
                } else {
                    Object object;
                    Object baseRGA;
                    SendableRequest req;
                    while (true) {
                        RemoveRandom.RemoveRandomReturn val;
                        long cooldownTime;
                        if ((cooldownTime = chosenTracker.getWakeupTime(context, now)) > 0L) {
                            if (cooldownTime < wakeupTime) {
                                wakeupTime = cooldownTime;
                            }
                            Logger.normal(this, "Priority " + choosenPriorityClass + " is in cooldown for another " + (cooldownTime - now) + " " + TimeUtil.formatTime(cooldownTime - now));
                            break block50;
                        }
                        if (logMINOR) {
                            Logger.minor(this, "Got priority tracker " + chosenTracker);
                        }
                        ClientRequestSelector clientRequestSelector = this;
                        synchronized (clientRequestSelector) {
                            val = chosenTracker.removeRandom(starter, context, now);
                        }
                        if (val == null) {
                            Logger.normal(this, "Priority " + choosenPriorityClass + " returned null - nothing to schedule, should remove priority");
                            break block50;
                        }
                        if (val.item == null) {
                            if (val.wakeupTime == -1L) {
                                Logger.normal(this, "Priority " + choosenPriorityClass + " returned cooldown time of -1 - nothing to schedule, should remove priority");
                            } else {
                                Logger.normal(this, "Priority " + choosenPriorityClass + " returned cooldown time of " + (val.wakeupTime - now) + " = " + TimeUtil.formatTime(val.wakeupTime - now));
                                if (val.wakeupTime > 0L && val.wakeupTime < wakeupTime) {
                                    wakeupTime = val.wakeupTime;
                                }
                            }
                            break block50;
                        }
                        req = (SendableRequest)val.item;
                        if (req.getPriorityClass() == choosenPriorityClass) break;
                        Logger.normal(this, "In wrong priority class: " + req + " (req.prio=" + req.getPriorityClass() + " but chosen=" + choosenPriorityClass + ')');
                        ClientRequestRGANode clientGrabber = (ClientRequestRGANode)chosenTracker.getGrabber(req.getClient());
                        if (clientGrabber != null) {
                            baseRGA = (RandomGrabArray)clientGrabber.getGrabber(req.getSchedulerGroup());
                            if (baseRGA != null) {
                                object = this;
                                synchronized (object) {
                                    ((RandomGrabArray)baseRGA).remove(req, context);
                                }
                            }
                        } else {
                            Logger.error(this, "Could not find client grabber for client " + req.getClient() + " from " + chosenTracker);
                        }
                        this.innerRegister(req, context, null);
                    }
                    if (!this.isInsertScheduler) {
                        SendableRequest altReq = null;
                        baseRGA = this.recentSuccesses;
                        synchronized (baseRGA) {
                            if (!this.recentSuccesses.isEmpty() && random.nextBoolean()) {
                                altReq = this.recentSuccesses.poll();
                            }
                        }
                        if (altReq != null && altReq.isCancelled()) {
                            if (logMINOR) {
                                Logger.minor(this, "Ignoring cancelled recently succeeded item " + altReq);
                            }
                            altReq = null;
                        }
                        if (altReq != null && (l = altReq.getWakeupTime(context, now)) != 0L && logMINOR) {
                            Logger.minor(this, "Ignoring recently succeeded item, cooldown time = " + l + (l > 0L ? " (" + TimeUtil.formatTime(l - now) + ")" : ""));
                            altReq = null;
                        }
                        if (altReq != null && altReq != req) {
                            short prio = altReq.getPriorityClass();
                            if (prio <= choosenPriorityClass) {
                                if (logMINOR) {
                                    Logger.minor(this, "Recently succeeded (transient) req " + altReq + " (prio=" + altReq.getPriorityClass() + ") is better than " + req + " (prio=" + req.getPriorityClass() + "), using that");
                                }
                                req = altReq;
                            } else {
                                if (logMINOR) {
                                    Logger.minor(this, "Chosen req " + req + " is better, reregistering recently succeeded " + altReq);
                                }
                                object = this.recentSuccesses;
                                synchronized (object) {
                                    this.recentSuccesses.add((BaseSendableGet)altReq);
                                }
                            }
                        }
                    }
                    if (logMINOR) {
                        Logger.minor(this, "removeFirst() returning " + req + " (prio " + req.getPriorityClass() + ", client " + req.getClient() + ", client-req " + req.getClientRequest() + ')');
                    }
                    if (logMINOR) {
                        Logger.minor(this, "removeFirst() returning " + req + " of " + req.getClientRequest());
                    }
                    assert (req.realTimeFlag() == realTime);
                    return new SelectorReturn(req);
                }
            }
            ++choosenPriorityClass;
        }
        if (logMINOR) {
            Logger.minor(this, "No requests to run");
        }
        return new SelectorReturn(wakeupTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToFetching(Key key) {
        HashSet<Key> hashSet = this.keysFetching;
        synchronized (hashSet) {
            boolean retval = this.keysFetching.add(key);
            if (!retval) {
                Logger.normal(this, "Already in keysFetching: " + key);
            } else if (logMINOR) {
                Logger.minor(this, "Added to keysFetching: " + key);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasKey(Key key, BaseSendableGet getterWaiting) {
        if (this.keysFetching == null) {
            throw new NullPointerException();
        }
        HashSet<Key> hashSet = this.keysFetching;
        synchronized (hashSet) {
            boolean ret = this.keysFetching.contains(key);
            if (!ret) {
                return ret;
            }
            if (getterWaiting != null) {
                WeakReference<BaseSendableGet>[] waiting = this.transientRequestsWaitingForKeysFetching.get(key);
                if (waiting == null) {
                    this.transientRequestsWaitingForKeysFetching.put(key, new WeakReference[]{new WeakReference<BaseSendableGet>(getterWaiting)});
                } else {
                    for (WeakReference<BaseSendableGet> ref : waiting) {
                        if (ref.get() != getterWaiting) continue;
                        return true;
                    }
                    WeakReference<BaseSendableGet>[] newWaiting = Arrays.copyOf(waiting, waiting.length + 1);
                    newWaiting[waiting.length] = new WeakReference<BaseSendableGet>(getterWaiting);
                    this.transientRequestsWaitingForKeysFetching.put(key, newWaiting);
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeFetchingKey(Key key) {
        if (logMINOR) {
            Logger.minor(this, "Removing from keysFetching: " + key);
        }
        if (key == null) return;
        WeakReference<BaseSendableGet>[] weakReferenceArray = this.keysFetching;
        synchronized (this.keysFetching) {
            this.keysFetching.remove(key);
            WeakReference<BaseSendableGet>[] transientWaiting = this.transientRequestsWaitingForKeysFetching.remove(key);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (transientWaiting == null || transientWaiting == null) return;
            for (WeakReference<BaseSendableGet> ref : transientWaiting) {
                BaseSendableGet get = (BaseSendableGet)ref.get();
                if (get == null) continue;
                get.clearWakeupTime(this.sched.getContext());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasInsert(SendableRequestItemKey token) {
        HashSet<SendableRequestItemKey> hashSet = this.runningInserts;
        synchronized (hashSet) {
            return this.runningInserts.contains(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addRunningInsert(SendableRequestItemKey token) {
        HashSet<SendableRequestItemKey> hashSet = this.runningInserts;
        synchronized (hashSet) {
            boolean retval = this.runningInserts.add(token);
            if (!retval) {
                Logger.error(this, "Already in runningInserts: " + token);
            } else if (logMINOR) {
                Logger.minor(this, "Added to runningInserts: " + token);
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRunningInsert(SendableRequestItemKey token) {
        if (logMINOR) {
            Logger.minor(this, "Removing from runningInserts: " + token);
        }
        HashSet<SendableRequestItemKey> hashSet = this.runningInserts;
        synchronized (hashSet) {
            this.runningInserts.remove(token);
        }
    }

    @Override
    public long checkRecentlyFailed(Key key, boolean realTime) {
        Node node = this.sched.getNode();
        return node.clientCore.checkRecentlyFailed(key, realTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToGrabArray(short priorityClass, RequestClient client, ClientRequestSchedulerGroup cr, SendableRequest req, ClientContext context) {
        if (priorityClass > 6 || priorityClass < 0) {
            throw new IllegalStateException("Invalid priority: " + priorityClass + " - range is " + 0 + " (most important) to " + 6 + " (least important)");
        }
        ClientRequestSelector clientRequestSelector = this;
        synchronized (clientRequestSelector) {
            ClientRequestRGANode requestGrabber = this.makeSRGAForClient(priorityClass, client, context);
            requestGrabber.add(cr, req, context);
        }
        this.sched.wakeStarter();
    }

    private ClientRequestRGANode makeSRGAForClient(short priorityClass, RequestClient client, ClientContext context) {
        ClientRequestRGANode requestGrabber;
        RequestClientRGANode clientGrabber = this.priorities[priorityClass];
        if (clientGrabber == null) {
            this.priorities[priorityClass] = clientGrabber = new RequestClientRGANode(null, this);
            if (logMINOR) {
                Logger.minor(this, "Registering client tracker for priority " + priorityClass + " : " + clientGrabber);
            }
        }
        if ((requestGrabber = (ClientRequestRGANode)clientGrabber.getGrabber(client)) == null) {
            requestGrabber = new ClientRequestRGANode(client, (RemoveRandomParent)clientGrabber, this);
            if (logMINOR) {
                Logger.minor(this, "Creating new grabber: " + requestGrabber + " for " + client + " from " + clientGrabber + " : prio=" + priorityClass);
            }
            clientGrabber.addGrabber(client, requestGrabber, context);
            clientGrabber.clearWakeupTime(context);
        }
        return requestGrabber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reregisterAll(ClientRequester request, RequestScheduler lock, ClientContext context, short oldPrio) {
        RequestClient client = request.getClient();
        short newPrio = request.getPriorityClass();
        if (newPrio == oldPrio) {
            Logger.error(this, "Changing priority from " + oldPrio + " to " + newPrio + " for " + request);
            return;
        }
        ClientRequestSchedulerGroup group = request.getSchedulerGroup();
        ClientRequestSelector clientRequestSelector = this;
        synchronized (clientRequestSelector) {
            RequestClientRGANode clientGrabber = this.priorities[oldPrio];
            if (clientGrabber == null) {
                if (logMINOR) {
                    Logger.minor(this, "Changing priority but request not running " + request, (Throwable)new Exception("debug"));
                }
                return;
            }
            ClientRequestRGANode requestGrabber = (ClientRequestRGANode)clientGrabber.getGrabber(client);
            if (requestGrabber == null) {
                if (logMINOR) {
                    Logger.minor(this, "Changing priority but request not running " + request, (Throwable)new Exception("debug"));
                }
                return;
            }
            RandomGrabArrayWithObject rga = (RandomGrabArrayWithObject)requestGrabber.getGrabber(group);
            if (rga == null) {
                if (logMINOR) {
                    Logger.minor(this, "Changing priority but request not running " + request, (Throwable)new Exception("debug"));
                }
                return;
            }
            requestGrabber.maybeRemove(rga, context);
            requestGrabber = this.makeSRGAForClient(newPrio, client, context);
            if (requestGrabber.getGrabber(group) != null) {
                Logger.error(this, "RGA already exists for " + request + " : " + requestGrabber.getGrabber(group) + " but want to insert " + rga, (Throwable)new Exception("error"));
                requestGrabber.maybeRemove(rga, context);
            }
            requestGrabber.addGrabber(group, rga, context);
        }
    }

    public synchronized long countQueuedRequests(ClientContext context) {
        long total = 0L;
        for (int i = 0; i < this.priorities.length; ++i) {
            RequestClientRGANode prio = this.priorities[i];
            if (prio == null || prio.isEmpty()) {
                System.out.println("Priority " + i + " : empty");
                continue;
            }
            System.out.println("Priority " + i + " : " + prio.size());
            System.out.println("Clients: " + prio.size() + " for " + prio);
            for (int k = 0; k < prio.size(); ++k) {
                RequestClient client = (RequestClient)prio.getClient(k);
                System.out.println("Client " + k + " : " + client);
                ClientRequestRGANode requestGrabber = (ClientRequestRGANode)prio.getGrabber(client);
                System.out.println("SRGA for client: " + requestGrabber);
                for (int l = 0; l < requestGrabber.size(); ++l) {
                    ClientRequestSchedulerGroup cr = (ClientRequestSchedulerGroup)requestGrabber.getClient(l);
                    System.out.println("Request " + l + " : " + cr);
                    RandomGrabArray rga = (RandomGrabArray)requestGrabber.getGrabber(cr);
                    System.out.println("Queued SendableRequests: " + rga.size() + " on " + rga);
                    long sendable = 0L;
                    long all = 0L;
                    for (int m = 0; m < rga.size(); ++m) {
                        SendableRequest req = (SendableRequest)rga.get(m);
                        if (req == null) continue;
                        sendable += req.countSendableKeys(context);
                        all += req.countAllKeys(context);
                    }
                    System.out.println("Sendable keys: " + sendable + " all keys " + all + " diff " + (all - sendable));
                    total += all;
                }
            }
        }
        return total;
    }

    void innerRegister(SendableRequest req, ClientContext context, SendableRequest[] maybeActive) {
        if (this.isInsertScheduler && req instanceof BaseSendableGet) {
            throw new IllegalArgumentException("Adding a SendableGet to an insert scheduler!!");
        }
        if (!this.isInsertScheduler && req instanceof SendableInsert) {
            throw new IllegalArgumentException("Adding a SendableInsert to a request scheduler!!");
        }
        if (this.isInsertScheduler != req.isInsert()) {
            throw new IllegalArgumentException("Request isInsert=" + req.isInsert() + " but my isInsertScheduler=" + this.isInsertScheduler + "!!");
        }
        short prio = req.getPriorityClass();
        if (logMINOR) {
            Logger.minor(this, "Still registering " + req + " at prio " + prio + " for " + req.getClientRequest() + " ssk=" + this.isSSKScheduler + " insert=" + this.isInsertScheduler);
        }
        this.addToGrabArray(prio, req.getClient(), req.getSchedulerGroup(), req, context);
        if (logMINOR) {
            Logger.minor(this, "Registered " + req + " on prioclass=" + prio);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void succeeded(BaseSendableGet succeeded) {
        if (this.isInsertScheduler) {
            return;
        }
        if (succeeded.isCancelled()) {
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Recording successful fetch from " + succeeded);
        }
        Deque<BaseSendableGet> deque = this.recentSuccesses;
        synchronized (deque) {
            while (this.recentSuccesses.size() >= 8) {
                this.recentSuccesses.pollFirst();
            }
            this.recentSuccesses.add(succeeded);
        }
    }

    public void wakeUp(ClientContext context) {
        context.mainExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ClientRequestSelector.this.sched.wakeStarter();
            }
        });
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        tweakedPrioritySelector = new short[]{0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5};
        prioritySelector = new short[]{0, 1, 2, 3, 4, 5};
    }

    public class SelectorReturn {
        public final SendableRequest req;
        public final long wakeupTime;

        SelectorReturn(SendableRequest req) {
            this.req = req;
            this.wakeupTime = -1L;
        }

        SelectorReturn(long wakeupTime) {
            this.wakeupTime = wakeupTime;
            this.req = null;
        }
    }

    static class RequestClientRGANode
    extends SectoredRandomGrabArray<RequestClient, ClientRequestRGANode> {
        public RequestClientRGANode(RemoveRandomParent parent, ClientRequestSelector root) {
            super(parent, root);
        }
    }

    static class ClientRequestRGANode
    extends SectoredRandomGrabArraySimple<RequestClient, ClientRequestSchedulerGroup> {
        public ClientRequestRGANode(RequestClient object, RemoveRandomParent parent, ClientRequestSelector root) {
            super(object, parent, root);
        }
    }
}

