/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.ClientRequester;
import freenet.crypt.RandomSource;
import freenet.keys.Key;
import freenet.node.BaseSendableGet;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelGetException;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.RequestCompletionListener;
import freenet.node.RequestScheduler;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestItemKey;
import freenet.node.SendableRequestSender;
import freenet.support.ListUtils;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.ArrayList;
import java.util.HashSet;

public class OfferedKeysList
extends BaseSendableGet
implements RequestClient {
    private final HashSet<Key> keys = new HashSet();
    private final ArrayList<Key> keysList = new ArrayList();
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private final RandomSource random;
    private final short priorityClass;
    private final boolean isSSK;

    OfferedKeysList(NodeClientCore core, RandomSource random, short priorityClass, boolean isSSK, boolean realTimeFlag) {
        super(false, realTimeFlag);
        this.random = random;
        this.priorityClass = priorityClass;
        this.isSSK = isSSK;
    }

    public synchronized void remove(Key key) {
        assert (this.keysList.size() == this.keys.size());
        if (this.keys.remove(key)) {
            ListUtils.removeBySwapLast(this.keysList, key);
            if (logMINOR) {
                Logger.minor(this, "Found " + key + " , removing it  for " + this + " size now " + this.keysList.size());
            }
        }
        assert (this.keysList.size() == this.keys.size());
    }

    public synchronized boolean isEmpty() {
        return this.keys.isEmpty();
    }

    @Override
    public long countAllKeys(ClientContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long countSendableKeys(ClientContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized SendableRequestItem chooseKey(KeysFetchingLocally fetching, ClientContext context) {
        assert (this.keysList.size() == this.keys.size());
        if (this.keys.size() == 1) {
            Key k = this.keysList.get(0);
            if (fetching.hasKey(k, null)) {
                return null;
            }
            this.keys.remove(k);
            this.keysList.remove(0);
            this.keysList.trimToSize();
            return new MySendableRequestItem(k);
        }
        for (int i = 0; i < 10; ++i) {
            if (this.keysList.isEmpty()) {
                return null;
            }
            int ptr = this.random.nextInt(this.keysList.size());
            Key k = this.keysList.get(ptr);
            if (fetching.hasKey(k, null)) continue;
            ListUtils.removeBySwapLast(this.keysList, ptr);
            this.keys.remove(k);
            assert (this.keysList.size() == this.keys.size());
            return new MySendableRequestItem(k);
        }
        return null;
    }

    @Override
    public RequestClient getClient() {
        return this;
    }

    @Override
    public ClientRequester getClientRequest() {
        return null;
    }

    @Override
    public short getPriorityClass() {
        return this.priorityClass;
    }

    @Override
    public void internalError(Throwable t, RequestScheduler sched, ClientContext context, boolean persistent) {
        Logger.error(this, "Internal error: " + t, t);
    }

    @Override
    public SendableRequestSender getSender(ClientContext context) {
        return new SendableRequestSender(){

            @Override
            public boolean send(NodeClientCore core, final RequestScheduler sched, ClientContext context, ChosenBlock req) {
                final Key key = ((MySendableRequestItem)req.token).key;
                core.asyncGet(key, true, new RequestCompletionListener(){

                    @Override
                    public void onSucceeded() {
                        sched.removeFetchingKey(key);
                        sched.wakeStarter();
                    }

                    @Override
                    public void onFailed(LowLevelGetException e) {
                        sched.removeFetchingKey(key);
                        sched.wakeStarter();
                    }
                }, true, false, OfferedKeysList.this.realTimeFlag, false, false);
                return true;
            }

            @Override
            public boolean sendIsBlocking() {
                return false;
            }
        };
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    public synchronized void queueKey(Key key) {
        assert (this.keysList.size() == this.keys.size());
        if (this.keys.add(key)) {
            this.keysList.add(key);
            if (logMINOR) {
                Logger.minor(this, "Queued key " + key + " on " + this);
            }
        }
        assert (this.keysList.size() == this.keys.size());
    }

    @Override
    public Key getNodeKey(SendableRequestItem token) {
        return ((MySendableRequestItem)token).key;
    }

    @Override
    public boolean isSSK() {
        return this.isSSK;
    }

    @Override
    public boolean isInsert() {
        return false;
    }

    @Override
    public ClientRequestScheduler getScheduler(ClientContext context) {
        if (this.isSSK) {
            return context.getSskFetchScheduler(this.realTimeFlag);
        }
        return context.getChkFetchScheduler(this.realTimeFlag);
    }

    @Override
    public boolean preRegister(ClientContext context, boolean toNetwork) {
        return false;
    }

    @Override
    public long getWakeupTime(ClientContext context, long now) {
        if (this.isEmpty()) {
            return Long.MAX_VALUE;
        }
        return 0L;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }

    private static class MySendableRequestItem
    implements SendableRequestItem,
    SendableRequestItemKey {
        final Key key;

        MySendableRequestItem(Key key) {
            this.key = key;
        }

        @Override
        public void dump() {
        }

        @Override
        public SendableRequestItemKey getKey() {
            return this;
        }
    }
}

