/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.CodecPacket;
import freenet.client.filter.CodecPacketFilter;
import freenet.support.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class VorbisPacketFilter
implements CodecPacketFilter {
    static final byte[] magicNumber = new byte[]{118, 111, 114, 98, 105, 115};
    State currentState = State.UNINITIALIZED;

    @Override
    public CodecPacket parse(CodecPacket packet) throws IOException {
        boolean logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
        DataInputStream input = new DataInputStream(new ByteArrayInputStream(packet.payload));
        byte[] magicHeader = null;
        switch (this.currentState) {
            case UNINITIALIZED: {
                magicHeader = new byte[1 + magicNumber.length];
                input.readFully(magicHeader);
                if (magicHeader[0] != 1) {
                    return null;
                }
                for (int i = 0; i < magicNumber.length; ++i) {
                    if (magicHeader[i + 1] == magicNumber[i]) continue;
                    return null;
                }
                long vorbis_version = Integer.reverse(input.readInt());
                int audio_channels = input.readUnsignedByte();
                long audio_sample_rate = Integer.reverseBytes(input.readInt());
                int bitrate_maximum = Integer.reverseBytes(input.readInt());
                int bitrate_nominal = Integer.reverseBytes(input.readInt());
                int bitrate_minimum = Integer.reverseBytes(input.readInt());
                int blocksize = input.readUnsignedByte();
                boolean framing_flag = input.readBoolean();
                if (vorbis_version != 0L) {
                    return null;
                }
                if (audio_channels == 0) {
                    return null;
                }
                if (audio_sample_rate == 0L) {
                    return null;
                }
                if ((blocksize & 0xF) > (blocksize & 0xF)) {
                    return null;
                }
                if (!framing_flag) {
                    return null;
                }
                this.currentState = State.IDENTIFICATION_FOUND;
                break;
            }
            case IDENTIFICATION_FOUND: {
                magicHeader = new byte[1 + magicNumber.length];
                input.readFully(magicHeader);
                if (magicHeader[0] != 3) {
                    return null;
                }
                for (int i = 0; i < magicNumber.length; ++i) {
                    if (magicHeader[i + 1] == magicNumber[i]) continue;
                    return null;
                }
                long vendor_length = Integer.reverseBytes(input.readInt());
                if (logMINOR) {
                    Logger.minor(this, "Read a vendor length of " + vendor_length);
                }
                byte[] vendor_string = new byte[(int)vendor_length];
                input.readFully(vendor_string);
                long user_comment_list_length = Integer.reverseBytes(input.readInt());
                for (long i = 0L; i < user_comment_list_length; ++i) {
                    for (long j = (long)Integer.reverseBytes(input.readInt()); j > 0L; --j) {
                        input.skipBytes(1);
                    }
                }
                if (!input.readBoolean()) {
                    return null;
                }
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                DataOutputStream output = new DataOutputStream(data);
                output.write(magicHeader);
                output.writeInt(0);
                output.writeInt(0);
                output.writeBoolean(true);
                output.close();
                packet = new CodecPacket(data.toByteArray());
                Logger.minor(this, "Packet size: " + packet.payload.length);
                this.currentState = State.COMMENT_FOUND;
                break;
            }
            case COMMENT_FOUND: {
                this.currentState = State.SETUP_FOUND;
                break;
            }
        }
        input.close();
        return packet;
    }

    static enum State {
        UNINITIALIZED,
        IDENTIFICATION_FOUND,
        COMMENT_FOUND,
        SETUP_FOUND;

    }
}

