/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.EndListPeerNotesMessage;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.PeerNote;
import freenet.clients.fcp.UnknownNodeIdentifierMessage;
import freenet.node.DarknetPeerNode;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.support.SimpleFieldSet;

public class ListPeerNotesMessage
extends FCPMessage {
    static final String NAME = "ListPeerNotes";
    final SimpleFieldSet fs;
    final String identifier;

    public ListPeerNotesMessage(SimpleFieldSet fs) {
        this.fs = fs;
        this.identifier = fs.get("Identifier");
        fs.removeValue("Identifier");
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        return new SimpleFieldSet(true);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        if (!handler.hasFullAccess()) {
            throw new MessageInvalidException(24, "ListPeerNotes requires full access", this.identifier, false);
        }
        String nodeIdentifier = this.fs.get("NodeIdentifier");
        if (nodeIdentifier == null) {
            throw new MessageInvalidException(5, "Error: NodeIdentifier field missing", this.identifier, false);
        }
        PeerNode pn = node.getPeerNode(nodeIdentifier);
        if (pn == null) {
            UnknownNodeIdentifierMessage msg = new UnknownNodeIdentifierMessage(nodeIdentifier, this.identifier);
            handler.send(msg);
            return;
        }
        if (!(pn instanceof DarknetPeerNode)) {
            throw new MessageInvalidException(31, "ModifyPeer only available for darknet peers", this.identifier, false);
        }
        DarknetPeerNode dpn = (DarknetPeerNode)pn;
        String noteText = dpn.getPrivateDarknetCommentNote();
        handler.send(new PeerNote(nodeIdentifier, noteText, 1, this.identifier));
        handler.send(new EndListPeerNotesMessage(nodeIdentifier, this.identifier));
    }
}

