/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.SendPeerMessage;
import freenet.keys.FreenetURI;
import freenet.node.DarknetPeerNode;
import freenet.support.SimpleFieldSet;
import freenet.support.io.BucketTools;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;

public class SendURIMessage
extends SendPeerMessage {
    public static final String NAME = "SendURI";
    private final FreenetURI uri;

    public SendURIMessage(SimpleFieldSet fs) throws MessageInvalidException {
        super(fs);
        try {
            this.uri = new FreenetURI(fs.get("URI"));
        }
        catch (MalformedURLException e) {
            throw new MessageInvalidException(4, e.getMessage(), this.identifier, false);
        }
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = super.getFieldSet();
        fs.putSingle("URI", this.uri.toString());
        return fs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    protected int handleFeed(DarknetPeerNode pn) throws MessageInvalidException {
        try {
            if (this.dataLength() > 0L) {
                byte[] description = BucketTools.toByteArray(this.bucket);
                return pn.sendDownloadFeed(this.uri, new String(description, "UTF-8"));
            }
            return pn.sendDownloadFeed(this.uri, null);
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("Impossible: JVM doesn't support UTF-8: " + e, e);
        }
        catch (IOException e) {
            throw new MessageInvalidException(7, "", null, false);
        }
    }
}

