/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.client.async.ReadBucketAndFreeInputStream;
import freenet.crypt.CRCChecksumChecker;
import freenet.crypt.ChecksumFailedException;
import freenet.support.api.BucketFactory;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.PrependLengthOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;

public abstract class ChecksumChecker {
    public static final int CHECKSUM_CRC = 1;

    public abstract int checksumLength();

    public abstract OutputStream checksumWriter(OutputStream var1, int var2);

    public OutputStream checksumWriter(OutputStream os) {
        return this.checksumWriter(os, 0);
    }

    public PrependLengthOutputStream checksumWriterWithLength(OutputStream dos, BucketFactory bf) throws IOException {
        return PrependLengthOutputStream.create(this.checksumWriter(dos, 8), bf, 0, true);
    }

    public abstract byte[] appendChecksum(byte[] var1);

    public void verifyChecksum(byte[] data, int offset, int length, byte[] checksum) throws ChecksumFailedException {
        if (!this.checkChecksum(data, offset, length, checksum)) {
            throw new ChecksumFailedException();
        }
    }

    public abstract boolean checkChecksum(byte[] var1, int var2, int var3, byte[] var4);

    public abstract byte[] generateChecksum(byte[] var1, int var2, int var3);

    public byte[] generateChecksum(byte[] bufToChecksum) {
        return this.generateChecksum(bufToChecksum, 0, bufToChecksum.length);
    }

    public abstract int getChecksumTypeID();

    public abstract void copyAndStripChecksum(InputStream var1, OutputStream var2, long var3) throws IOException, ChecksumFailedException;

    public abstract void readAndChecksum(DataInput var1, byte[] var2, int var3, int var4) throws IOException, ChecksumFailedException;

    public InputStream checksumReaderWithLength(InputStream dis, BucketFactory bf, long maxLength) throws IOException, ChecksumFailedException {
        long length = new DataInputStream(dis).readLong();
        if (length < 0L || length > maxLength) {
            throw new IOException("Bad length: " + length + "; maxLength: " + maxLength);
        }
        RandomAccessBucket bucket = bf.makeBucket(-1L);
        OutputStream os = bucket.getOutputStream();
        this.copyAndStripChecksum(dis, os, length);
        os.close();
        return ReadBucketAndFreeInputStream.create(bucket);
    }

    public void writeAndChecksum(OutputStream os, byte[] buf, int offset, int length) throws IOException {
        os.write(buf, offset, length);
        os.write(this.generateChecksum(buf, offset, length));
    }

    public void writeAndChecksum(ObjectOutputStream oos, byte[] buf) throws IOException {
        this.writeAndChecksum(oos, buf, 0, buf.length);
    }

    public int lengthAndChecksumOverhead() {
        return 8 + this.checksumLength();
    }

    public static ChecksumChecker create(int checksumID) {
        if (checksumID == 1) {
            return new CRCChecksumChecker();
        }
        throw new IllegalArgumentException("Bad checksum ID");
    }
}

