/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.transport.ip;

import java.net.Inet6Address;
import java.net.InetAddress;

public class IPUtil {
    static final boolean strict = true;

    public static boolean isSiteLocalAddress(InetAddress i) {
        if (i instanceof Inet6Address) {
            byte[] addr = i.getAddress();
            assert (addr.length == 16);
            return (addr[0] & 0xFFFFFFFE) == -4 || addr[0] == -2 && (addr[1] & 0xFFFFFFC0) == -64;
        }
        return i.isSiteLocalAddress();
    }

    public static boolean isValidAddress(InetAddress i, boolean includeLocalAddressesInNoderefs) {
        if (i.isAnyLocalAddress()) {
            return false;
        }
        if (i.isLinkLocalAddress() || i.isLoopbackAddress() || IPUtil.isSiteLocalAddress(i)) {
            return includeLocalAddressesInNoderefs;
        }
        if (i.isMulticastAddress()) {
            return false;
        }
        byte[] ipAddressBytes = i.getAddress();
        return ipAddressBytes.length != 4 || ipAddressBytes[0] != 0;
    }
}

