/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.client.InsertException;
import freenet.client.async.BaseClientPutter;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientPutCallback;
import freenet.keys.FreenetURI;
import freenet.node.RequestClient;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.Bucket;

public class PutWaiter
implements ClientPutCallback {
    private boolean finished;
    private boolean succeeded;
    private FreenetURI uri;
    private InsertException error;
    final RequestClient client;
    private static volatile boolean logMINOR;

    public PutWaiter(RequestClient client) {
        this.client = client;
    }

    @Override
    public synchronized void onSuccess(BaseClientPutter state) {
        this.succeeded = true;
        this.finished = true;
        this.notifyAll();
    }

    @Override
    public synchronized void onFailure(InsertException e, BaseClientPutter state) {
        this.error = e;
        this.finished = true;
        this.notifyAll();
    }

    @Override
    public synchronized void onGeneratedURI(FreenetURI uri, BaseClientPutter state) {
        if (logMINOR) {
            Logger.minor(this, "URI: " + uri);
        }
        if (this.uri == null) {
            this.uri = uri;
        }
        if (uri.equals(this.uri)) {
            return;
        }
        Logger.error(this, "URI already set: " + this.uri + " but new URI: " + uri, (Throwable)new Exception("error"));
    }

    public synchronized FreenetURI waitForCompletion() throws InsertException {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.error != null) {
            this.error.uri = this.uri;
            throw this.error;
        }
        if (this.succeeded) {
            return this.uri;
        }
        Logger.error(this, "Did not succeed but no error");
        throw new InsertException(InsertException.InsertExceptionMode.INTERNAL_ERROR, "Did not succeed but no error", this.uri);
    }

    @Override
    public void onFetchable(BaseClientPutter state) {
    }

    @Override
    public void onGeneratedMetadata(Bucket metadata, BaseClientPutter state) {
        Logger.error(this, "onGeneratedMetadata() on PutWaiter from " + state, (Throwable)new Exception("error"));
        metadata.free();
    }

    @Override
    public void onResume(ClientContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RequestClient getRequestClient() {
        return this.client;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

