/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.ClientMetadata;
import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.InsertContext;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetState;
import freenet.client.async.ClientGetWorkerThread;
import freenet.client.async.ClientRequester;
import freenet.client.async.GetCompletionCallback;
import freenet.client.async.HasKeyListener;
import freenet.client.async.KeyListener;
import freenet.client.async.SimpleSingleFileFetcher;
import freenet.client.async.StreamGenerator;
import freenet.client.async.USKCallback;
import freenet.client.async.USKChecker;
import freenet.client.async.USKCheckerCallback;
import freenet.client.async.USKDateHint;
import freenet.client.async.USKFetcherCallback;
import freenet.client.async.USKManager;
import freenet.client.async.USKProgressCallback;
import freenet.crypt.HashResult;
import freenet.keys.ClientKey;
import freenet.keys.ClientSSK;
import freenet.keys.ClientSSKBlock;
import freenet.keys.FreenetURI;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.KeyDecodeException;
import freenet.keys.NodeSSK;
import freenet.keys.SSKBlock;
import freenet.keys.SSKVerifyException;
import freenet.keys.USK;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelGetException;
import freenet.node.RequestClient;
import freenet.node.SendableGet;
import freenet.node.SendableRequest;
import freenet.node.SendableRequestItem;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.RemoveRangeArrayList;
import freenet.support.api.Bucket;
import freenet.support.api.RandomAccessBucket;
import freenet.support.compress.Compressor;
import freenet.support.compress.DecompressorThreadManager;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;

public class USKFetcher
implements ClientGetState,
USKCallback,
HasKeyListener,
KeyListener {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private final USKManager uskManager;
    private final USK origUSK;
    private final List<USKFetcherCallback> callbacks;
    final FetchContext ctx;
    final FetchContext ctxNoStore;
    final FetchContext ctxDBR;
    private boolean completed;
    private boolean cancelled;
    private final boolean checkStoreOnly;
    final ClientRequester parent;
    private Bucket lastRequestData;
    private short lastCompressionCodec;
    private boolean lastWasMetadata;
    private final USKWatchingKeys watchingKeys;
    private final ArrayList<USKAttempt> attemptsToStart;
    private static final int WATCH_KEYS = 50;
    private final HashSet<DBRAttempt> dbrAttempts = new HashSet();
    private final TreeMap<Long, USKAttempt> runningAttempts = new TreeMap();
    private final TreeMap<Long, USKAttempt> pollingAttempts = new TreeMap();
    private long lastFetchedEdition;
    final long origMinFailures;
    boolean firstLoop;
    static final long origSleepTime;
    static final long maxSleepTime;
    long sleepTime = origSleepTime;
    private long valueAtSchedule;
    private final boolean backgroundPoll;
    final boolean keepLastData;
    private boolean started;
    private final boolean realTimeFlag;
    private static short DEFAULT_NORMAL_POLL_PRIORITY;
    private short normalPollPriority = DEFAULT_NORMAL_POLL_PRIORITY;
    private static short DEFAULT_PROGRESS_POLL_PRIORITY;
    private short progressPollPriority = DEFAULT_PROGRESS_POLL_PRIORITY;
    private boolean scheduledDBRs;
    private boolean scheduleAfterDBRsDone;
    private int dbrHintsFound = 0;
    private int dbrHintsStarted = 0;
    final HashSet<USKCallback> subscribers;
    final HashMap<USKCallback, Long> subscriberHints = new HashMap();
    private StoreCheckerGetter runningStoreChecker = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCallback(USKFetcherCallback cb) {
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            if (this.completed) {
                return false;
            }
            this.callbacks.add(cb);
        }
        this.updatePriorities();
        return true;
    }

    USKFetcher(USK origUSK, USKManager manager, FetchContext ctx, ClientRequester requester, int minFailures, boolean pollForever, boolean keepLastData, boolean checkStoreOnly) {
        this.parent = requester;
        this.origUSK = origUSK;
        this.uskManager = manager;
        this.origMinFailures = minFailures;
        if (this.origMinFailures > 50L) {
            throw new IllegalArgumentException();
        }
        this.firstLoop = true;
        this.callbacks = new ArrayList<USKFetcherCallback>();
        this.subscribers = new HashSet();
        this.lastFetchedEdition = -1L;
        this.realTimeFlag = this.parent.realTimeFlag();
        this.ctxDBR = ctx.clone();
        if (ctx.followRedirects) {
            this.ctx = ctx.clone();
            this.ctx.followRedirects = false;
        } else {
            this.ctx = ctx;
        }
        this.ctxDBR.maxOutputLength = 1024L;
        this.ctxDBR.maxTempLength = 32768L;
        this.ctxDBR.filterData = false;
        this.ctxDBR.maxArchiveLevels = 0;
        this.ctxDBR.maxArchiveRestarts = 0;
        if (checkStoreOnly) {
            this.ctxDBR.localRequestOnly = true;
        }
        if (ctx.ignoreStore) {
            this.ctxNoStore = this.ctx;
        } else {
            this.ctxNoStore = this.ctx.clone();
            this.ctxNoStore.ignoreStore = true;
        }
        this.backgroundPoll = pollForever;
        this.keepLastData = keepLastData;
        this.checkStoreOnly = checkStoreOnly;
        if (checkStoreOnly && logMINOR) {
            Logger.minor(this, "Just checking store on " + this);
        }
        this.watchingKeys = new USKWatchingKeys(origUSK, Math.max(0L, this.uskManager.lookupLatestSlot(origUSK) + 1L));
        this.attemptsToStart = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDBRsFinished(ClientContext context) {
        boolean needSchedule = false;
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            if (this.scheduleAfterDBRsDone) {
                needSchedule = true;
            }
        }
        if (needSchedule) {
            this.schedule(context);
        }
        this.checkFinishedForNow(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDBRHint(long hint, ClientContext context, DBRAttempt dbrAttempt) {
        try {
            short prio;
            this.updatePriorities();
            ArrayList<DBRAttempt> toCancel = null;
            USKFetcher uSKFetcher = this;
            synchronized (uSKFetcher) {
                if (this.cancelled || this.completed) {
                    return;
                }
                ++this.dbrHintsFound;
                prio = this.progressPollPriority;
                Iterator<DBRAttempt> i = this.dbrAttempts.iterator();
                while (i.hasNext()) {
                    DBRAttempt a = i.next();
                    if (!dbrAttempt.type.alwaysMorePreciseThan(a.type)) continue;
                    if (toCancel == null) {
                        toCancel = new ArrayList<DBRAttempt>();
                    }
                    toCancel.add(a);
                    i.remove();
                }
            }
            this.uskManager.hintUpdate(this.origUSK.copy(hint).getURI(), context, prio);
            if (toCancel != null) {
                for (DBRAttempt a : toCancel) {
                    a.cancel(context);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void onCheckEnteredFiniteCooldown(ClientContext context) {
        this.checkFinishedForNow(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFinishedForNow(ClientContext context) {
        USKAttempt[] uSKAttemptArray = this;
        synchronized (this) {
            if (this.cancelled || this.completed) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            if (this.runningStoreChecker != null) {
                if (logMINOR) {
                    Logger.minor(this, "Not finished because still running store checker on " + this);
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            if (!this.runningAttempts.isEmpty()) {
                if (logMINOR) {
                    Logger.minor(this, "Not finished because running attempts (random probes) on " + this);
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            if (this.pollingAttempts.isEmpty()) {
                if (logMINOR) {
                    Logger.minor(this, "Not finished because no polling attempts (not started???) on " + this);
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            if (!this.dbrAttempts.isEmpty()) {
                if (logMINOR) {
                    Logger.minor(this, "Not finished because still waiting for DBR attempts on " + this + " : " + this.dbrAttempts);
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            USKAttempt[] attempts = this.pollingAttempts.values().toArray(new USKAttempt[this.pollingAttempts.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (USKAttempt a : attempts) {
                if (a.everInCooldown()) continue;
                if (logMINOR) {
                    Logger.minor(this, "Not finished because polling attempt " + a + " never entered cooldown on " + this);
                }
                return;
            }
            super.notifyFinishedForNow(context);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFinishedForNow(ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Notifying finished for now on " + this + " for " + this.origUSK + (this.realTimeFlag ? " (realtime)" : " (bulk)"));
        }
        USKCallback[] uSKCallbackArray = this;
        synchronized (this) {
            if (this.cancelled || this.completed) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            USKCallback[] toCheck = this.subscribers.toArray(new USKCallback[this.subscribers.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (USKCallback cb : toCheck) {
                if (!(cb instanceof USKProgressCallback)) continue;
                ((USKProgressCallback)cb).onRoundFinished(context);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySendingToNetwork(ClientContext context) {
        USKCallback[] uSKCallbackArray = this;
        synchronized (this) {
            if (this.cancelled || this.completed) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            USKCallback[] toCheck = this.subscribers.toArray(new USKCallback[this.subscribers.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (USKCallback cb : toCheck) {
                if (!(cb instanceof USKProgressCallback)) continue;
                ((USKProgressCallback)cb).onSendingToNetwork(context);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onDNF(USKAttempt att, ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "DNF: " + att);
        }
        boolean finished = false;
        long curLatest = this.uskManager.lookupLatestSlot(this.origUSK);
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            if (this.completed || this.cancelled) {
                return;
            }
            this.lastFetchedEdition = Math.max(this.lastFetchedEdition, att.number);
            this.runningAttempts.remove(att.number);
            if (this.runningAttempts.isEmpty()) {
                if (logMINOR) {
                    Logger.minor(this, "latest: " + curLatest + ", last fetched: " + this.lastFetchedEdition + ", curLatest+MIN_FAILURES: " + (curLatest + this.origMinFailures));
                }
                if (this.started) {
                    finished = true;
                }
            } else if (logMINOR) {
                Logger.minor(this, "Remaining: " + this.runningAttempts());
            }
        }
        if (finished) {
            this.finishSuccess(context);
        }
    }

    private synchronized String runningAttempts() {
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (USKAttempt a : this.runningAttempts.values()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(a.number);
            if (a.cancelled) {
                sb.append("(cancelled)");
            }
            if (!a.succeeded) continue;
            sb.append("(succeeded)");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void finishSuccess(ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "finishSuccess() on " + this);
        }
        if (this.backgroundPoll) {
            long valAtEnd = this.uskManager.lookupLatestSlot(this.origUSK);
            long now = System.currentTimeMillis();
            USKFetcherCallback[] uSKFetcherCallbackArray = this;
            synchronized (this) {
                this.started = false;
                long newSleepTime = this.sleepTime * 2L;
                if (newSleepTime > maxSleepTime) {
                    newSleepTime = maxSleepTime;
                }
                this.sleepTime = newSleepTime;
                long end = now + (long)context.random.nextInt((int)this.sleepTime);
                if (valAtEnd > this.valueAtSchedule && valAtEnd > this.origUSK.suggestedEdition) {
                    this.sleepTime = origSleepTime;
                    this.firstLoop = false;
                    end = now;
                    if (logMINOR) {
                        Logger.minor(this, "We have advanced: at start, " + this.valueAtSchedule + " at end, " + valAtEnd);
                    }
                }
                if (logMINOR) {
                    Logger.minor(this, "Sleep time is " + this.sleepTime + " this sleep is " + (end - now) + " for " + this);
                }
                // ** MonitorExit[var8_6] (shouldn't be in output)
                this.schedule(end - now, context);
                this.checkFinishedForNow(context);
                return;
            }
        }
        USKFetcherCallback[] uSKFetcherCallbackArray = this;
        synchronized (this) {
            this.completed = true;
            USKFetcherCallback[] cb = this.callbacks.toArray(new USKFetcherCallback[this.callbacks.size()]);
            // ** MonitorExit[var3_12] (shouldn't be in output)
            this.uskManager.unsubscribe(this.origUSK, (USKCallback)this);
            this.uskManager.onFinished((USKFetcher)this);
            context.getSskFetchScheduler((boolean)this.realTimeFlag).schedTransient.removePendingKeys((KeyListener)this);
            long ed = this.uskManager.lookupLatestSlot(this.origUSK);
            USKFetcherCallback[] uSKFetcherCallbackArray2 = this;
            synchronized (this) {
                byte[] data;
                if (this.lastRequestData == null) {
                    data = null;
                } else {
                    try {
                        data = BucketTools.toByteArray(this.lastRequestData);
                    }
                    catch (IOException e) {
                        Logger.error(this, "Unable to turn lastRequestData into byte[]: caught I/O exception: " + e, (Throwable)e);
                        data = null;
                    }
                    this.lastRequestData.free();
                }
                // ** MonitorExit[var6_5] (shouldn't be in output)
                for (USKFetcherCallback c : cb) {
                    try {
                        if (ed == -1L) {
                            c.onFailure(context);
                            continue;
                        }
                        c.onFoundEdition(ed, this.origUSK.copy(ed), context, this.lastWasMetadata, this.lastCompressionCodec, data, false, false);
                    }
                    catch (Exception e) {
                        Logger.error(this, "An exception occured while dealing with a callback:" + c.toString() + "\n" + e.getMessage(), (Throwable)e);
                    }
                }
                return;
            }
        }
    }

    void onSuccess(USKAttempt att, boolean dontUpdate, ClientSSKBlock block, ClientContext context) {
        this.onSuccess(att, att.number, dontUpdate, block, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onSuccess(USKAttempt att, long curLatest, boolean dontUpdate, ClientSSKBlock block, ClientContext context) {
        boolean registerNow;
        long lastEd = this.uskManager.lookupLatestSlot(this.origUSK);
        if (logMINOR) {
            Logger.minor(this, "Found edition " + curLatest + " for " + this.origUSK + " official is " + lastEd + " on " + this);
        }
        boolean decode = false;
        List<USKAttempt> killAttempts = null;
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            if (att != null) {
                this.runningAttempts.remove(att.number);
            }
            if (this.completed || this.cancelled) {
                if (logMINOR) {
                    Logger.minor(this, "Finished already: completed=" + this.completed + " cancelled=" + this.cancelled);
                }
                return;
            }
            decode = curLatest >= lastEd && (!dontUpdate || block != null);
            curLatest = Math.max(lastEd, curLatest);
            if (logMINOR) {
                Logger.minor(this, "Latest: " + curLatest + " in onSuccess");
            }
            if (!this.checkStoreOnly) {
                killAttempts = this.cancelBefore(curLatest, context);
                USKWatchingKeys.ToFetch list = this.watchingKeys.getEditionsToFetch(curLatest, context.random, this.getRunningFetchEditions(), this.shouldAddRandomEditions(context.random));
                Lookup[] toPoll = list.toPoll;
                Lookup[] toFetch = list.toFetch;
                for (Lookup i : toPoll) {
                    if (logDEBUG) {
                        Logger.debug(this, "Polling " + i + " for " + this);
                    }
                    this.attemptsToStart.add(this.add(i, true));
                }
                for (Lookup i : toFetch) {
                    if (logMINOR) {
                        Logger.minor(this, "Adding checker for edition " + i + " for " + this.origUSK);
                    }
                    this.attemptsToStart.add(this.add(i, false));
                }
            }
            registerNow = !this.scheduleAfterDBRsDone || this.dbrAttempts.isEmpty() ? !this.fillKeysWatching(curLatest, context) : false;
        }
        this.finishCancelBefore(killAttempts, context);
        Bucket data = null;
        if (decode && block != null) {
            try {
                data = block.decode(context.getBucketFactory(this.parent.persistent()), 1025, true);
            }
            catch (KeyDecodeException e) {
                data = null;
            }
            catch (IOException e) {
                data = null;
                Logger.error(this, "An IOE occured while decoding: " + e.getMessage(), (Throwable)e);
            }
        }
        USKFetcher uSKFetcher2 = this;
        synchronized (uSKFetcher2) {
            if (decode) {
                if (block != null) {
                    this.lastCompressionCodec = block.getCompressionCodec();
                    this.lastWasMetadata = block.isMetadata();
                    if (this.keepLastData) {
                        if (this.lastRequestData != null) {
                            this.lastRequestData.free();
                        }
                        this.lastRequestData = data;
                    } else {
                        data.free();
                    }
                } else {
                    this.lastCompressionCodec = (short)-1;
                    this.lastWasMetadata = false;
                    this.lastRequestData = null;
                }
            }
        }
        if (!dontUpdate) {
            this.uskManager.updateSlot(this.origUSK, curLatest, context);
        }
        if (registerNow) {
            this.registerAttempts(context);
        }
    }

    private boolean shouldAddRandomEditions(Random random) {
        if (this.firstLoop) {
            return false;
        }
        return random.nextInt(this.dbrHintsStarted + 1) >= this.dbrHintsFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onCancelled(USKAttempt att, ClientContext context) {
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            this.runningAttempts.remove(att.number);
            if (!this.runningAttempts.isEmpty()) {
                return;
            }
            if (this.cancelled) {
                this.finishCancelled(context);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishCancelled(ClientContext context) {
        USKFetcherCallback[] uSKFetcherCallbackArray = this;
        synchronized (this) {
            this.completed = true;
            USKFetcherCallback[] cb = this.callbacks.toArray(new USKFetcherCallback[this.callbacks.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (USKFetcherCallback c : cb) {
                c.onCancelled(context);
            }
            return;
        }
    }

    public void onFail(USKAttempt attempt, ClientContext context) {
        this.onDNF(attempt, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<USKAttempt> cancelBefore(long curLatest, ClientContext context) {
        ArrayList v = null;
        int count = 0;
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            Map.Entry entry;
            Iterator<Object> i = this.runningAttempts.values().iterator();
            while (i.hasNext()) {
                USKAttempt att = i.next();
                if (att.number < curLatest) {
                    if (v == null) {
                        v = new ArrayList(this.runningAttempts.size() - count);
                    }
                    v.add(att);
                    i.remove();
                }
                ++count;
            }
            i = this.pollingAttempts.entrySet().iterator();
            while (i.hasNext() && (Long)(entry = (Map.Entry)i.next()).getKey() < curLatest) {
                if (v == null) {
                    v = new ArrayList(Math.max(1, this.pollingAttempts.size() - count));
                }
                v.add(entry.getValue());
                i.remove();
            }
        }
        return v;
    }

    private void finishCancelBefore(List<USKAttempt> v, ClientContext context) {
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                USKAttempt att = v.get(i);
                att.cancel(context);
            }
        }
    }

    private synchronized USKAttempt add(Lookup l, boolean forever) {
        long i = l.val;
        if (l.val < 0L) {
            throw new IllegalArgumentException("Can't check <0 for " + l.val + " on " + this + " for " + this.origUSK);
        }
        if (this.cancelled) {
            return null;
        }
        if (this.checkStoreOnly) {
            return null;
        }
        if (logMINOR) {
            Logger.minor(this, "Adding USKAttempt for " + i + " for " + this.origUSK.getURI());
        }
        if (forever) {
            if (this.pollingAttempts.containsKey(i)) {
                if (logMINOR) {
                    Logger.minor(this, "Already polling edition: " + i + " for " + this);
                }
                return null;
            }
        } else if (this.runningAttempts.containsKey(i)) {
            if (logMINOR) {
                Logger.minor(this, "Returning because already running for " + this.origUSK.getURI());
            }
            return null;
        }
        USKAttempt a = new USKAttempt(l, forever);
        if (forever) {
            this.pollingAttempts.put(i, a);
        } else {
            this.runningAttempts.put(i, a);
        }
        if (logMINOR) {
            Logger.minor(this, "Added " + a + " for " + this.origUSK);
        }
        return a;
    }

    public FreenetURI getURI() {
        return this.origUSK.getURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            return this.completed || this.cancelled;
        }
    }

    public USK getOriginalUSK() {
        return this.origUSK;
    }

    public void schedule(long delay, final ClientContext context) {
        if (delay <= 0L) {
            this.schedule(context);
        } else {
            context.ticker.queueTimedJob(new Runnable(){

                @Override
                public void run() {
                    USKFetcher.this.schedule(context);
                }
            }, delay);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void schedule(ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Scheduling " + this);
        }
        DBRAttempt[] atts = null;
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            if (this.cancelled) {
                return;
            }
            if (this.completed) {
                return;
            }
            if (!this.scheduledDBRs && !this.ctx.ignoreUSKDatehints) {
                atts = this.addDBRs(context);
            }
            this.scheduledDBRs = true;
        }
        context.getSskFetchScheduler((boolean)this.realTimeFlag).schedTransient.addPendingKeys(this);
        this.updatePriorities();
        this.uskManager.subscribe(this.origUSK, this, false, this.parent.getClient());
        if (atts != null) {
            this.startDBRs(atts, context);
        }
        long lookedUp = this.uskManager.lookupLatestSlot(this.origUSK);
        boolean registerNow = false;
        boolean bye = false;
        boolean completeCheckingStore = false;
        USKFetcher uSKFetcher2 = this;
        synchronized (uSKFetcher2) {
            this.valueAtSchedule = Math.max(lookedUp + 1L, this.valueAtSchedule);
            boolean bl = bye = this.cancelled || this.completed;
            if (!bye) {
                if (!this.checkStoreOnly && this.attemptsToStart.isEmpty() && this.runningAttempts.isEmpty() && this.pollingAttempts.isEmpty()) {
                    USKWatchingKeys.ToFetch list = this.watchingKeys.getEditionsToFetch(lookedUp, context.random, this.getRunningFetchEditions(), this.shouldAddRandomEditions(context.random));
                    Lookup[] toPoll = list.toPoll;
                    Lookup[] toFetch = list.toFetch;
                    for (Lookup i : toPoll) {
                        if (logDEBUG) {
                            Logger.debug(this, "Polling " + i + " for " + this);
                        }
                        this.attemptsToStart.add(this.add(i, true));
                    }
                    for (Lookup i : toFetch) {
                        if (logMINOR) {
                            Logger.minor(this, "Adding checker for edition " + i + " for " + this.origUSK);
                        }
                        this.attemptsToStart.add(this.add(i, false));
                    }
                }
                this.started = true;
                if (lookedUp <= 0L && atts != null) {
                    this.scheduleAfterDBRsDone = true;
                    registerNow = false;
                } else {
                    registerNow = !this.scheduleAfterDBRsDone || this.dbrAttempts.isEmpty() ? !this.fillKeysWatching(lookedUp, context) : false;
                }
                completeCheckingStore = this.checkStoreOnly && this.scheduleAfterDBRsDone && this.runningStoreChecker == null;
            }
        }
        if (registerNow) {
            this.registerAttempts(context);
        } else if (completeCheckingStore) {
            this.finishSuccess(context);
            return;
        }
        if (!bye) {
            return;
        }
        this.uskManager.unsubscribe(this.origUSK, this);
        context.getSskFetchScheduler((boolean)this.realTimeFlag).schedTransient.removePendingKeys(this);
        this.uskManager.onFinished(this, true);
    }

    private DBRAttempt[] addDBRs(ClientContext context) {
        USKDateHint date = USKDateHint.now();
        ClientSSK[] ssks = date.getRequestURIs(this.origUSK);
        DBRAttempt[] atts = new DBRAttempt[ssks.length];
        int x = 0;
        for (int i = 0; i < ssks.length; ++i) {
            ClientSSK key = ssks[i];
            DBRAttempt att = new DBRAttempt(key, context, USKDateHint.Type.values()[i]);
            this.dbrAttempts.add(att);
            atts[x++] = att;
        }
        this.dbrHintsStarted = atts.length;
        return atts;
    }

    private void startDBRs(DBRAttempt[] toStart, ClientContext context) {
        for (DBRAttempt att : toStart) {
            att.start(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(ClientContext context) {
        if (logMINOR) {
            Logger.minor(this, "Cancelling " + this);
        }
        this.uskManager.unsubscribe(this.origUSK, (USKCallback)this);
        context.getSskFetchScheduler((boolean)this.realTimeFlag).schedTransient.removePendingKeys((KeyListener)this);
        this.uskManager.onFinished((USKFetcher)this);
        Object[] objectArray = this;
        synchronized (this) {
            if (this.cancelled) {
                Logger.error(this, "Already cancelled " + this);
            }
            if (this.completed) {
                Logger.error(this, "Already completed " + this);
            }
            this.cancelled = true;
            USKAttempt[] attempts = this.runningAttempts.values().toArray(new USKAttempt[this.runningAttempts.size()]);
            USKAttempt[] polling = this.pollingAttempts.values().toArray(new USKAttempt[this.pollingAttempts.size()]);
            DBRAttempt[] atts = this.dbrAttempts.toArray(new DBRAttempt[this.dbrAttempts.size()]);
            this.attemptsToStart.clear();
            this.runningAttempts.clear();
            this.pollingAttempts.clear();
            this.dbrAttempts.clear();
            StoreCheckerGetter storeChecker = this.runningStoreChecker;
            this.runningStoreChecker = null;
            Bucket data = this.lastRequestData;
            this.lastRequestData = null;
            // ** MonitorExit[var7_2] (shouldn't be in output)
            for (USKAttempt attempt : attempts) {
                attempt.cancel(context);
            }
            for (USKAttempt p : polling) {
                p.cancel(context);
            }
            for (DBRAttempt a : atts) {
                a.cancel(context);
            }
            if (storeChecker != null) {
                storeChecker.unregister(context, ((SendableRequest)storeChecker).getPriorityClass());
            }
            if (data != null) {
                data.free();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubscriber(USKCallback cb, long hint) {
        Long[] hints;
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            this.subscribers.add(cb);
            this.subscriberHints.put(cb, hint);
            hints = this.subscriberHints.values().toArray(new Long[this.subscriberHints.size()]);
        }
        this.updatePriorities();
        this.watchingKeys.updateSubscriberHints(hints, this.uskManager.lookupLatestSlot(this.origUSK));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePriorities() {
        short normalPrio = 6;
        short progressPrio = 6;
        USKCallback[] uSKCallbackArray = this;
        synchronized (this) {
            short prio;
            USKCallback[] localCallbacks = this.subscribers.toArray(new USKCallback[this.subscribers.size()]);
            USKFetcherCallback[] fetcherCallbacks = this.callbacks.toArray(new USKFetcherCallback[this.callbacks.size()]);
            // ** MonitorExit[uSKCallbackArray] (shouldn't be in output)
            if (localCallbacks.length == 0 && fetcherCallbacks.length == 0) {
                this.normalPollPriority = DEFAULT_NORMAL_POLL_PRIORITY;
                this.progressPollPriority = DEFAULT_PROGRESS_POLL_PRIORITY;
                if (logMINOR) {
                    Logger.minor(this, "Updating priorities: normal = " + this.normalPollPriority + " progress = " + this.progressPollPriority + " for " + this + " for " + this.origUSK);
                }
                return;
            }
            for (USKCallback uSKCallback : localCallbacks) {
                prio = uSKCallback.getPollingPriorityNormal();
                if (logDEBUG) {
                    Logger.debug(this, "Normal priority for " + uSKCallback + " : " + prio);
                }
                if (prio < normalPrio) {
                    normalPrio = prio;
                }
                if (logDEBUG) {
                    Logger.debug(this, "Progress priority for " + uSKCallback + " : " + prio);
                }
                if ((prio = uSKCallback.getPollingPriorityProgress()) >= progressPrio) continue;
                progressPrio = prio;
            }
            for (USKCallback uSKCallback : fetcherCallbacks) {
                prio = uSKCallback.getPollingPriorityNormal();
                if (logDEBUG) {
                    Logger.debug(this, "Normal priority for " + uSKCallback + " : " + prio);
                }
                if (prio < normalPrio) {
                    normalPrio = prio;
                }
                if (logDEBUG) {
                    Logger.debug(this, "Progress priority for " + uSKCallback + " : " + prio);
                }
                if ((prio = uSKCallback.getPollingPriorityProgress()) >= progressPrio) continue;
                progressPrio = prio;
            }
            if (logMINOR) {
                Logger.minor(this, "Updating priorities: normal=" + normalPrio + " progress=" + progressPrio + " for " + this + " for " + this.origUSK);
            }
            uSKCallbackArray = this;
            synchronized (this) {
                this.normalPollPriority = normalPrio;
                this.progressPollPriority = progressPrio;
                // ** MonitorExit[uSKCallbackArray] (shouldn't be in output)
                return;
            }
        }
    }

    public synchronized boolean hasSubscribers() {
        return !this.subscribers.isEmpty();
    }

    public synchronized boolean hasCallbacks() {
        return !this.callbacks.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubscriber(USKCallback cb, ClientContext context) {
        Long[] hints;
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            this.subscribers.remove(cb);
            this.subscriberHints.remove(cb);
            hints = this.subscriberHints.values().toArray(new Long[this.subscriberHints.size()]);
        }
        this.updatePriorities();
        this.watchingKeys.updateSubscriberHints(hints, this.uskManager.lookupLatestSlot(this.origUSK));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallback(USKCallback cb) {
        Long[] hints;
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            this.subscribers.remove(cb);
            this.subscriberHints.remove(cb);
            hints = this.subscriberHints.values().toArray(new Long[this.subscriberHints.size()]);
        }
        this.watchingKeys.updateSubscriberHints(hints, this.uskManager.lookupLatestSlot(this.origUSK));
    }

    @Override
    public long getToken() {
        return -1L;
    }

    @Override
    public short getPollingPriorityNormal() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getPollingPriorityProgress() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFoundEdition(long ed, USK key, ClientContext context, boolean metadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
        if (newKnownGood && !newSlotToo) {
            return;
        }
        long lastEd = this.uskManager.lookupLatestSlot(this.origUSK);
        boolean decode = false;
        List<USKAttempt> killAttempts = null;
        boolean registerNow = false;
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            if (this.completed || this.cancelled) {
                return;
            }
            decode = lastEd == ed && data != null;
            ed = Math.max(lastEd, ed);
            if (logMINOR) {
                Logger.minor(this, "Latest: " + ed + " in onFoundEdition");
            }
            if (!this.checkStoreOnly) {
                killAttempts = this.cancelBefore(ed, context);
                USKWatchingKeys.ToFetch list = this.watchingKeys.getEditionsToFetch(ed, context.random, this.getRunningFetchEditions(), this.shouldAddRandomEditions(context.random));
                Lookup[] toPoll = list.toPoll;
                Lookup[] toFetch = list.toFetch;
                for (Lookup i : toPoll) {
                    if (logMINOR) {
                        Logger.minor(this, "Polling " + i + " for " + this + " in onFoundEdition");
                    }
                    this.attemptsToStart.add(this.add(i, true));
                }
                for (Lookup i : toFetch) {
                    if (logMINOR) {
                        Logger.minor(this, "Adding checker for edition " + i + " for " + this.origUSK + " in onFoundEdition");
                    }
                    this.attemptsToStart.add(this.add(i, false));
                }
            }
            registerNow = !this.scheduleAfterDBRsDone || this.dbrAttempts.isEmpty() ? !this.fillKeysWatching(ed, context) : false;
        }
        this.finishCancelBefore(killAttempts, context);
        if (registerNow) {
            this.registerAttempts(context);
        }
        uSKFetcher = this;
        synchronized (uSKFetcher) {
            if (decode) {
                this.lastCompressionCodec = codec;
                this.lastWasMetadata = metadata;
                if (this.keepLastData) {
                    if (this.lastRequestData != null) {
                        this.lastRequestData.free();
                    }
                    try {
                        this.lastRequestData = BucketTools.makeImmutableBucket(context.tempBucketFactory, data);
                    }
                    catch (IOException e) {
                        Logger.error(this, "Caught " + e, (Throwable)e);
                    }
                }
            }
        }
    }

    private synchronized List<Lookup> getRunningFetchEditions() {
        ArrayList<Lookup> ret = new ArrayList<Lookup>();
        for (USKAttempt a : this.runningAttempts.values()) {
            if (ret.contains(a.lookup)) continue;
            ret.add(a.lookup);
        }
        for (USKAttempt a : this.pollingAttempts.values()) {
            if (ret.contains(a.lookup)) continue;
            ret.add(a.lookup);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void registerAttempts(ClientContext context) {
        USKAttempt[] uSKAttemptArray = this;
        // MONITORENTER : this
        if (this.cancelled || this.completed) {
            // MONITOREXIT : uSKAttemptArray
            return;
        }
        USKAttempt[] attempts = this.attemptsToStart.toArray(new USKAttempt[this.attemptsToStart.size()]);
        this.attemptsToStart.clear();
        // MONITOREXIT : uSKAttemptArray
        if (attempts.length > 0) {
            this.parent.toNetwork(context);
        }
        if (logMINOR) {
            Logger.minor(this, "Registering " + attempts.length + " USKChecker's for " + this + " running=" + this.runningAttempts.size() + " polling=" + this.pollingAttempts.size());
        }
        uSKAttemptArray = attempts;
        int n = uSKAttemptArray.length;
        int n2 = 0;
        while (n2 < n) {
            USKAttempt attempt = uSKAttemptArray[n2];
            long lastEd = this.uskManager.lookupLatestSlot(this.origUSK);
            USKAttempt[] uSKAttemptArray2 = this;
            // MONITORENTER : this
            if (this.keepLastData && this.lastRequestData == null && lastEd == this.origUSK.suggestedEdition) {
                --lastEd;
            }
            // MONITOREXIT : uSKAttemptArray2
            if (attempt != null) {
                if (attempt.number > lastEd) {
                    attempt.schedule(context);
                } else {
                    uSKAttemptArray2 = this;
                    // MONITORENTER : this
                    this.runningAttempts.remove(attempt.number);
                    // MONITOREXIT : uSKAttemptArray2
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fillKeysWatching(long ed, ClientContext context) {
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            if (this.runningStoreChecker != null) {
                return true;
            }
            USKStoreChecker checker = this.watchingKeys.getDatastoreChecker(ed);
            if (checker == null) {
                if (logMINOR) {
                    Logger.minor(this, "No datastore checker");
                }
                return false;
            }
            this.runningStoreChecker = new StoreCheckerGetter(this.parent, checker);
        }
        try {
            context.getSskFetchScheduler(this.realTimeFlag).register(null, new SendableGet[]{this.runningStoreChecker}, false, null, false);
        }
        catch (Throwable t) {
            USKFetcher uSKFetcher2 = this;
            synchronized (uSKFetcher2) {
                this.runningStoreChecker = null;
            }
            Logger.error(this, "Unable to start: " + t, t);
            try {
                this.runningStoreChecker.unregister(context, this.progressPollPriority);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Registered " + this.runningStoreChecker + " for " + this);
        }
        return true;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.completed || this.cancelled;
    }

    @Override
    public KeyListener makeKeyListener(ClientContext context, boolean onStartup) {
        return this;
    }

    @Override
    public synchronized long countKeys() {
        return this.watchingKeys.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short definitelyWantKey(Key key, byte[] saltedKey, ClientContext context) {
        if (!(key instanceof NodeSSK)) {
            return -1;
        }
        NodeSSK k = (NodeSSK)key;
        if (!this.origUSK.samePubKeyHash(k)) {
            return -1;
        }
        long lastSlot = this.uskManager.lookupLatestSlot(this.origUSK) + 1L;
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            if (this.watchingKeys.match(k, lastSlot) != -1L) {
                return this.progressPollPriority;
            }
        }
        return -1;
    }

    @Override
    public HasKeyListener getHasKeyListener() {
        return this;
    }

    @Override
    public short getPriorityClass() {
        return this.progressPollPriority;
    }

    @Override
    public SendableGet[] getRequestsForKey(Key key, byte[] saltedKey, ClientContext context) {
        return new SendableGet[0];
    }

    @Override
    public boolean handleBlock(Key key, byte[] saltedKey, KeyBlock found, ClientContext context) {
        ClientSSKBlock data;
        if (!(found instanceof SSKBlock)) {
            return false;
        }
        long lastSlot = this.uskManager.lookupLatestSlot(this.origUSK) + 1L;
        long edition = this.watchingKeys.match((NodeSSK)key, lastSlot);
        if (edition == -1L) {
            return false;
        }
        if (logMINOR) {
            Logger.minor(this, "Matched edition " + edition + " for " + this.origUSK);
        }
        try {
            data = this.watchingKeys.decode((SSKBlock)found, edition);
        }
        catch (SSKVerifyException e) {
            data = null;
        }
        this.onSuccess(null, edition, false, data, context);
        return true;
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.cancelled || this.completed;
    }

    @Override
    public boolean isSSK() {
        return true;
    }

    @Override
    public void onRemove() {
    }

    @Override
    public boolean persistent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean probablyWantKey(Key key, byte[] saltedKey) {
        if (!(key instanceof NodeSSK)) {
            return false;
        }
        NodeSSK k = (NodeSSK)key;
        if (!this.origUSK.samePubKeyHash(k)) {
            return false;
        }
        long lastSlot = this.uskManager.lookupLatestSlot(this.origUSK) + 1L;
        USKFetcher uSKFetcher = this;
        synchronized (uSKFetcher) {
            return this.watchingKeys.match(k, lastSlot) != -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeUSKPollParameters(long time, int tries, ClientContext context) {
        this.ctx.setCooldownRetries(tries);
        this.ctxNoStore.setCooldownRetries(tries);
        this.ctx.setCooldownTime(time);
        this.ctxNoStore.setCooldownTime(time);
        USKAttempt[] uSKAttemptArray = this;
        synchronized (this) {
            USKAttempt[] pollers = this.pollingAttempts.values().toArray(new USKAttempt[this.pollingAttempts.size()]);
            // ** MonitorExit[var6_4] (shouldn't be in output)
            for (USKAttempt a : pollers) {
                a.reloadPollParameters(context);
            }
            return;
        }
    }

    public void addHintEdition(long suggestedEdition) {
        this.watchingKeys.addHintEdition(suggestedEdition, this.uskManager.lookupLatestSlot(this.origUSK));
    }

    @Override
    public void onResume(ClientContext context) {
        throw new UnsupportedOperationException("Not persistent");
    }

    @Override
    public void onShutdown(ClientContext context) {
        throw new UnsupportedOperationException("Not persistent");
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
        origSleepTime = TimeUnit.MINUTES.toMillis(30L);
        maxSleepTime = TimeUnit.HOURS.toMillis(24L);
        DEFAULT_NORMAL_POLL_PRIORITY = (short)5;
        DEFAULT_PROGRESS_POLL_PRIORITY = (short)3;
    }

    private class Lookup {
        long val;
        ClientSSK key;
        boolean ignoreStore;

        private Lookup() {
        }

        public boolean equals(Object o) {
            if (o instanceof Lookup) {
                return ((Lookup)o).val == this.val;
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.val ^ this.val >>> 32);
        }

        public String toString() {
            return USKFetcher.this.origUSK + ":" + this.val;
        }
    }

    private class USKWatchingKeys {
        final byte[] pubKeyHash;
        final byte cryptoAlgorithm;
        private final KeyList fromLastKnownSlot;
        private TreeMap<Long, KeyList> fromSubscribers;
        private TreeSet<Long> persistentHints = new TreeSet();

        public USKWatchingKeys(USK origUSK, long lookedUp) {
            this.pubKeyHash = origUSK.getPubKeyHash();
            this.cryptoAlgorithm = origUSK.cryptoAlgorithm;
            if (logMINOR) {
                Logger.minor(this, "Creating KeyList from last known good: " + lookedUp);
            }
            this.fromLastKnownSlot = new KeyList(lookedUp);
            this.fromSubscribers = new TreeMap();
            if (origUSK.suggestedEdition > lookedUp) {
                this.fromSubscribers.put(origUSK.suggestedEdition, new KeyList(origUSK.suggestedEdition));
            }
        }

        public synchronized ToFetch getEditionsToFetch(long lookedUp, Random random, List<Lookup> alreadyRunning, boolean doRandom) {
            boolean probeFromLastKnownGood;
            if (logMINOR) {
                Logger.minor(this, "Get editions to fetch, latest slot is " + lookedUp + " running is " + alreadyRunning);
            }
            ArrayList<Lookup> toFetch = new ArrayList<Lookup>();
            ArrayList<Lookup> toPoll = new ArrayList<Lookup>();
            boolean bl = probeFromLastKnownGood = lookedUp > -1L || USKFetcher.this.backgroundPoll && !USKFetcher.this.firstLoop || this.fromSubscribers.isEmpty();
            if (probeFromLastKnownGood) {
                this.fromLastKnownSlot.getNextEditions(toFetch, toPoll, lookedUp, alreadyRunning, random);
            }
            Iterator<Map.Entry<Long, KeyList>> it = this.fromSubscribers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, KeyList> entry = it.next();
                long l = entry.getKey() - 1L;
                if (l <= lookedUp) {
                    it.remove();
                }
                ((KeyList)entry.getValue()).getNextEditions(toFetch, toPoll, l - 1L, alreadyRunning, random);
            }
            if (doRandom) {
                int runningRandom = 0;
                for (Lookup l : alreadyRunning) {
                    if (toFetch.contains(l) || toPoll.contains(l)) continue;
                    ++runningRandom;
                }
                int allowedRandom = 1 + this.fromSubscribers.size();
                if (logMINOR) {
                    Logger.minor(this, "Running random requests: " + runningRandom + " total allowed: " + allowedRandom + " looked up is " + lookedUp + " for " + USKFetcher.this);
                }
                if ((allowedRandom -= runningRandom) > 0 && probeFromLastKnownGood) {
                    this.fromLastKnownSlot.getRandomEditions(toFetch, lookedUp, alreadyRunning, random, Math.min(1, allowedRandom));
                    --allowedRandom;
                }
                Iterator<KeyList> it2 = this.fromSubscribers.values().iterator();
                while (allowedRandom >= 2 && it2.hasNext()) {
                    KeyList k = it2.next();
                    k.getRandomEditions(toFetch, lookedUp, alreadyRunning, random, Math.min(1, allowedRandom));
                    --allowedRandom;
                }
            }
            return new ToFetch(toFetch, toPoll);
        }

        public synchronized void updateSubscriberHints(Long[] hints, long lookedUp) {
            ArrayList<Long> surviving = new ArrayList<Long>();
            Arrays.sort((Object[])hints);
            long prev = -1L;
            for (Long hint : hints) {
                if (hint == prev) continue;
                prev = hint;
                if (hint <= lookedUp) continue;
                surviving.add(hint);
            }
            Iterator<Long> i = this.persistentHints.iterator();
            while (i.hasNext()) {
                Long hint = i.next();
                if (hint <= lookedUp) {
                    i.remove();
                }
                if (surviving.contains(hint)) continue;
                surviving.add(hint);
            }
            if (((USKFetcher)USKFetcher.this).origUSK.suggestedEdition > lookedUp && !surviving.contains(((USKFetcher)USKFetcher.this).origUSK.suggestedEdition)) {
                surviving.add(((USKFetcher)USKFetcher.this).origUSK.suggestedEdition);
            }
            Iterator<Long> it = this.fromSubscribers.keySet().iterator();
            while (it.hasNext()) {
                Long l = it.next();
                if (surviving.contains(l)) continue;
                it.remove();
            }
            for (Long l : surviving) {
                if (this.fromSubscribers.containsKey(l)) continue;
                this.fromSubscribers.put(l, new KeyList(l));
            }
        }

        public synchronized void addHintEdition(long suggestedEdition, long lookedUp) {
            if (suggestedEdition <= lookedUp) {
                return;
            }
            if (!this.persistentHints.add(suggestedEdition)) {
                return;
            }
            if (this.fromSubscribers.containsKey(suggestedEdition)) {
                return;
            }
            this.fromSubscribers.put(suggestedEdition, new KeyList(suggestedEdition));
        }

        public synchronized long size() {
            return 50 + this.fromSubscribers.size() * 50;
        }

        public synchronized USKStoreChecker getDatastoreChecker(long lastSlot) {
            if (logMINOR) {
                Logger.minor(this, "Getting datastore checker from " + lastSlot + " for " + USKFetcher.this.origUSK + " on " + USKFetcher.this, (Throwable)new Exception("debug"));
            }
            ArrayList<KeyList.StoreSubChecker> checkers = new ArrayList<KeyList.StoreSubChecker>();
            KeyList.StoreSubChecker c = this.fromLastKnownSlot.checkStore(lastSlot + 1L);
            if (c != null) {
                checkers.add(c);
            }
            Iterator<Map.Entry<Long, KeyList>> it = this.fromSubscribers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, KeyList> entry = it.next();
                long l = entry.getKey();
                if (l <= lastSlot) {
                    it.remove();
                }
                if ((c = entry.getValue().checkStore(l)) == null) continue;
                checkers.add(c);
            }
            if (checkers.size() > 0) {
                return new USKStoreChecker(checkers);
            }
            return null;
        }

        public ClientSSKBlock decode(SSKBlock block, long edition) throws SSKVerifyException {
            ClientSSK csk = USKFetcher.this.origUSK.getSSK(edition);
            assert (Arrays.equals(csk.ehDocname, block.getKey().getKeyBytes()));
            return ClientSSKBlock.construct(block, csk);
        }

        public synchronized long match(NodeSSK key, long lastSlot) {
            long ret;
            if (logMINOR) {
                Logger.minor(this, "Trying to match " + key + " from slot " + lastSlot + " for " + USKFetcher.this.origUSK);
            }
            if ((ret = this.fromLastKnownSlot.match(key, lastSlot)) != -1L) {
                return ret;
            }
            Iterator<Map.Entry<Long, KeyList>> it = this.fromSubscribers.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, KeyList> entry = it.next();
                long l = entry.getKey();
                if (l <= lastSlot) {
                    it.remove();
                }
                if ((ret = entry.getValue().match(key, l)) == -1L) continue;
                return ret;
            }
            return -1L;
        }

        class KeyList {
            long firstSlot;
            private WeakReference<RemoveRangeArrayList<byte[]>> cache;
            private long checkedDatastoreFrom = -1L;
            private long checkedDatastoreTo = -1L;

            public KeyList(long slot) {
                if (logMINOR) {
                    Logger.minor(this, "Creating KeyList from " + slot + " on " + USKFetcher.this + " " + this, (Throwable)new Exception("debug"));
                }
                this.firstSlot = slot;
                RemoveRangeArrayList<byte[]> ehDocnames = new RemoveRangeArrayList<byte[]>(50);
                this.cache = new WeakReference(ehDocnames);
                this.generate(this.firstSlot, 50, ehDocnames);
            }

            public synchronized void getNextEditions(List<Lookup> toFetch, List<Lookup> toPoll, long lookedUp, List<Lookup> alreadyRunning, Random random) {
                if (logMINOR) {
                    Logger.minor(this, "Getting next editions from " + lookedUp);
                }
                if (lookedUp < 0L) {
                    lookedUp = 0L;
                }
                int i = 1;
                while ((long)i <= USKFetcher.this.origMinFailures) {
                    long ed = (long)i + lookedUp;
                    Lookup l = new Lookup();
                    l.val = ed;
                    boolean poll = USKFetcher.this.backgroundPoll;
                    if (!poll && toFetch.contains(l) || poll && toPoll.contains(l)) {
                        if (logDEBUG) {
                            Logger.debug(this, "Ignoring " + l);
                        }
                    } else if (alreadyRunning.remove(l)) {
                        if (logDEBUG) {
                            Logger.debug(this, "Ignoring (2): " + l);
                        }
                    } else {
                        ClientSSK key;
                        l.key = key = USKFetcher.this.origUSK.getSSK(ed);
                        l.ignoreStore = true;
                        if (poll) {
                            if (!toPoll.contains(l)) {
                                toPoll.add(l);
                            } else if (logDEBUG) {
                                Logger.debug(this, "Ignoring poll (3): " + l);
                            }
                        } else if (!toFetch.contains(l)) {
                            toFetch.add(l);
                        } else if (logDEBUG) {
                            Logger.debug(this, "Ignoring fetch (3): " + l);
                        }
                    }
                    ++i;
                }
            }

            public synchronized void getRandomEditions(List<Lookup> toFetch, long lookedUp, List<Lookup> alreadyRunning, Random random, int allowed) {
                long baseEdition = lookedUp + USKFetcher.this.origMinFailures;
                for (int i = 0; i < allowed; ++i) {
                    Lookup l;
                    long fetch;
                    while (true) {
                        int mean = random.nextInt(5) == 0 ? 100 : 10;
                        fetch = baseEdition + (long)Math.floor(Math.log(random.nextFloat()) / Math.log(1.0 - 1.0 / (double)mean));
                        if (fetch < baseEdition) continue;
                        l = new Lookup();
                        l.val = fetch;
                        if (!toFetch.contains(l) && !alreadyRunning.contains(l)) break;
                    }
                    l.key = USKFetcher.this.origUSK.getSSK(fetch);
                    l.ignoreStore = fetch - lookedUp < 50L;
                    toFetch.add(l);
                    if (!logMINOR) continue;
                    Logger.minor(this, "Trying random future edition " + fetch + " for " + USKFetcher.this.origUSK + " current edition " + lookedUp);
                }
            }

            public synchronized StoreSubChecker checkStore(long lastSlot) {
                if (logDEBUG) {
                    Logger.minor(this, "check store from " + lastSlot + " current first slot " + this.firstSlot);
                }
                long checkFrom = lastSlot;
                long checkTo = lastSlot + 50L;
                if (this.checkedDatastoreTo >= checkFrom) {
                    checkFrom = this.checkedDatastoreTo;
                }
                if (checkFrom >= checkTo) {
                    return null;
                }
                RemoveRangeArrayList<byte[]> ehDocnames = this.updateCache(lastSlot);
                int offset = (int)(checkFrom - this.firstSlot);
                NodeSSK[] keysToCheck = new NodeSSK[50 - offset];
                int x = 0;
                int i = offset;
                while (i < 50) {
                    keysToCheck[x] = new NodeSSK(USKWatchingKeys.this.pubKeyHash, (byte[])ehDocnames.get(i), USKWatchingKeys.this.cryptoAlgorithm);
                    ++i;
                    ++x;
                }
                return new StoreSubChecker(keysToCheck, checkFrom, checkTo);
            }

            synchronized RemoveRangeArrayList<byte[]> updateCache(long curBaseEdition) {
                if (logMINOR) {
                    Logger.minor(this, "update cache from " + curBaseEdition + " current first slot " + this.firstSlot);
                }
                RemoveRangeArrayList ehDocnames = null;
                if (this.cache == null || (ehDocnames = (RemoveRangeArrayList)this.cache.get()) == null) {
                    ehDocnames = new RemoveRangeArrayList(50);
                    this.cache = new WeakReference<RemoveRangeArrayList>(ehDocnames);
                    this.firstSlot = curBaseEdition;
                    if (logMINOR) {
                        Logger.minor(this, "Regenerating because lost cached keys");
                    }
                    this.generate(this.firstSlot, 50, ehDocnames);
                    return ehDocnames;
                }
                this.match(null, curBaseEdition, ehDocnames);
                return ehDocnames;
            }

            public synchronized long match(NodeSSK key, long curBaseEdition) {
                if (logDEBUG) {
                    Logger.minor(this, "match from " + curBaseEdition + " current first slot " + this.firstSlot);
                }
                RemoveRangeArrayList ehDocnames = null;
                if (this.cache == null || (ehDocnames = (RemoveRangeArrayList)this.cache.get()) == null) {
                    ehDocnames = new RemoveRangeArrayList(50);
                    this.cache = new WeakReference<RemoveRangeArrayList>(ehDocnames);
                    this.firstSlot = curBaseEdition;
                    this.generate(this.firstSlot, 50, ehDocnames);
                    return key == null ? -1L : this.innerMatch(key, ehDocnames, 0, ehDocnames.size(), this.firstSlot);
                }
                long x = this.innerMatch(key, ehDocnames, 0, ehDocnames.size(), this.firstSlot);
                if (x != -1L) {
                    return x;
                }
                return this.match(key, curBaseEdition, ehDocnames);
            }

            private long match(NodeSSK key, long curBaseEdition, RemoveRangeArrayList<byte[]> ehDocnames) {
                if (logMINOR) {
                    Logger.minor(this, "Matching " + key + " cur base edition " + curBaseEdition + " first slot was " + this.firstSlot + " for " + USKFetcher.this.origUSK + " on " + this);
                }
                if (this.firstSlot < curBaseEdition) {
                    if (this.firstSlot + (long)ehDocnames.size() <= curBaseEdition) {
                        ehDocnames.clear();
                        this.firstSlot = curBaseEdition;
                        this.generate(curBaseEdition, 50, ehDocnames);
                        return key == null ? -1L : this.innerMatch(key, ehDocnames, 0, ehDocnames.size(), this.firstSlot);
                    }
                    ehDocnames.removeRange(0, (int)(curBaseEdition - this.firstSlot));
                    int size = ehDocnames.size();
                    this.firstSlot = curBaseEdition;
                    this.generate(curBaseEdition + (long)size, 50 - size, ehDocnames);
                    return key == null ? -1L : this.innerMatch(key, ehDocnames, 50 - size, size, this.firstSlot);
                }
                if (this.firstSlot > curBaseEdition) {
                    if (logMINOR) {
                        Logger.minor(this, "Ignoring regression in match() from " + curBaseEdition + " to " + this.firstSlot);
                    }
                    return key == null ? -1L : this.innerMatch(key, ehDocnames, 0, ehDocnames.size(), this.firstSlot);
                }
                return -1L;
            }

            private long innerMatch(NodeSSK key, RemoveRangeArrayList<byte[]> ehDocnames, int offset, int size, long firstSlot) {
                byte[] data = key.getKeyBytes();
                for (int i = offset; i < offset + size; ++i) {
                    if (!Arrays.equals(data, (byte[])ehDocnames.get(i))) continue;
                    if (logMINOR) {
                        Logger.minor(this, "Found edition " + (firstSlot + (long)i) + " for " + USKFetcher.this.origUSK);
                    }
                    return firstSlot + (long)i;
                }
                return -1L;
            }

            private void generate(long baseEdition, int keys, RemoveRangeArrayList<byte[]> ehDocnames) {
                if (logMINOR) {
                    Logger.minor(this, "generate() from " + baseEdition + " for " + USKFetcher.this.origUSK);
                }
                assert (baseEdition >= 0L);
                for (int i = 0; i < keys; ++i) {
                    long ed = baseEdition + (long)i;
                    ehDocnames.add(((USKFetcher)USKFetcher.this).origUSK.getSSK((long)ed).ehDocname);
                }
            }

            public class StoreSubChecker {
                final NodeSSK[] keysToCheck;
                private final long checkedFrom;
                private final long checkedTo;

                private StoreSubChecker(NodeSSK[] keysToCheck, long checkFrom, long checkTo) {
                    this.keysToCheck = keysToCheck;
                    this.checkedFrom = checkFrom;
                    this.checkedTo = checkTo;
                    if (logMINOR) {
                        Logger.minor(this, "Checking datastore from " + checkFrom + " to " + checkTo + " for " + USKFetcher.this + " on " + this);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                void checked() {
                    KeyList keyList = KeyList.this;
                    synchronized (keyList) {
                        if (KeyList.this.checkedDatastoreTo >= this.checkedFrom && KeyList.this.checkedDatastoreFrom <= this.checkedFrom) {
                            KeyList.this.checkedDatastoreTo = this.checkedTo;
                        } else {
                            KeyList.this.checkedDatastoreFrom = this.checkedFrom;
                            KeyList.this.checkedDatastoreTo = this.checkedTo;
                        }
                        if (logMINOR) {
                            Logger.minor(this, "Checked from " + this.checkedFrom + " to " + this.checkedTo + " (now overall is " + KeyList.this.checkedDatastoreFrom + " to " + KeyList.this.checkedDatastoreTo + ") for " + USKFetcher.this + " for " + USKFetcher.this.origUSK);
                        }
                    }
                }
            }
        }

        class ToFetch {
            public final Lookup[] toFetch;
            public final Lookup[] toPoll;

            public ToFetch(List<Lookup> toFetch2, List<Lookup> toPoll2) {
                this.toFetch = toFetch2.toArray(new Lookup[toFetch2.size()]);
                this.toPoll = toPoll2.toArray(new Lookup[toPoll2.size()]);
            }
        }
    }

    class StoreCheckerGetter
    extends SendableGet {
        public final USKStoreChecker checker;
        boolean done;

        public StoreCheckerGetter(ClientRequester parent, USKStoreChecker c) {
            super(parent, USKFetcher.this.realTimeFlag);
            this.done = false;
            this.checker = c;
        }

        @Override
        public FetchContext getContext() {
            return USKFetcher.this.ctx;
        }

        @Override
        public long getCooldownWakeup(SendableRequestItem token, ClientContext context) {
            return -1L;
        }

        @Override
        public ClientKey getKey(SendableRequestItem token) {
            return null;
        }

        @Override
        public Key[] listKeys() {
            return this.checker.getKeys();
        }

        @Override
        public void onFailure(LowLevelGetException e, SendableRequestItem token, ClientContext context) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean preRegister(ClientContext context, boolean toNetwork) {
            this.unregister(context, this.getPriorityClass());
            USKAttempt[] uSKAttemptArray = USKFetcher.this;
            synchronized (USKFetcher.this) {
                USKFetcher.this.runningStoreChecker = null;
                USKAttempt[] attempts = USKFetcher.this.attemptsToStart.toArray(new USKAttempt[USKFetcher.this.attemptsToStart.size()]);
                USKFetcher.this.attemptsToStart.clear();
                this.done = true;
                if (USKFetcher.this.cancelled) {
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return true;
                }
                // ** MonitorExit[var4_3] (shouldn't be in output)
                this.checker.checked();
                if (logMINOR) {
                    Logger.minor(this, "Checked datastore, finishing registration for " + attempts.length + " checkers for " + USKFetcher.this + " for " + USKFetcher.this.origUSK);
                }
                if (attempts.length > 0) {
                    this.parent.toNetwork(context);
                    USKFetcher.this.notifySendingToNetwork(context);
                }
                for (USKAttempt attempt : attempts) {
                    long lastEd = USKFetcher.this.uskManager.lookupLatestSlot(USKFetcher.this.origUSK);
                    USKFetcher uSKFetcher = USKFetcher.this;
                    synchronized (uSKFetcher) {
                        if (USKFetcher.this.keepLastData && USKFetcher.this.lastRequestData == null && lastEd == ((USKFetcher)USKFetcher.this).origUSK.suggestedEdition) {
                            --lastEd;
                        }
                    }
                    if (attempt == null) continue;
                    if (attempt.number > lastEd) {
                        attempt.schedule(context);
                        continue;
                    }
                    uSKFetcher = USKFetcher.this;
                    synchronized (uSKFetcher) {
                        USKFetcher.this.runningAttempts.remove(attempt.number);
                        USKFetcher.this.pollingAttempts.remove(attempt.number);
                    }
                }
                long lastEd = USKFetcher.this.uskManager.lookupLatestSlot(USKFetcher.this.origUSK);
                if (!USKFetcher.this.fillKeysWatching(lastEd, context) && USKFetcher.this.checkStoreOnly) {
                    if (logMINOR) {
                        Logger.minor(this, "Just checking store, terminating " + USKFetcher.this + " ...");
                    }
                    StoreCheckerGetter storeCheckerGetter = this;
                    synchronized (storeCheckerGetter) {
                        if (!USKFetcher.this.dbrAttempts.isEmpty()) {
                            USKFetcher.this.scheduleAfterDBRsDone = true;
                            return true;
                        }
                    }
                    USKFetcher.this.finishSuccess(context);
                }
                return true;
            }
        }

        @Override
        public SendableRequestItem chooseKey(KeysFetchingLocally keys, ClientContext context) {
            return null;
        }

        @Override
        public long countAllKeys(ClientContext context) {
            return USKFetcher.this.watchingKeys.size();
        }

        @Override
        public long countSendableKeys(ClientContext context) {
            return 0L;
        }

        @Override
        public RequestClient getClient() {
            return this.realTimeFlag ? USKManager.rcRT : USKManager.rcBulk;
        }

        @Override
        public ClientRequester getClientRequest() {
            return this.parent;
        }

        @Override
        public short getPriorityClass() {
            return USKFetcher.this.progressPollPriority;
        }

        @Override
        public boolean isCancelled() {
            return this.done || USKFetcher.this.cancelled || USKFetcher.this.completed;
        }

        @Override
        public boolean isSSK() {
            return true;
        }

        @Override
        public long getWakeupTime(ClientContext context, long now) {
            return 0L;
        }

        @Override
        protected ClientGetState getClientGetState() {
            return USKFetcher.this;
        }
    }

    class USKStoreChecker {
        final USKWatchingKeys.KeyList.StoreSubChecker[] checkers;

        public USKStoreChecker(List<USKWatchingKeys.KeyList.StoreSubChecker> c) {
            this.checkers = c.toArray(new USKWatchingKeys.KeyList.StoreSubChecker[c.size()]);
        }

        public USKStoreChecker(USKWatchingKeys.KeyList.StoreSubChecker[] checkers2) {
            this.checkers = checkers2;
        }

        public Key[] getKeys() {
            if (this.checkers.length == 0) {
                return new Key[0];
            }
            if (this.checkers.length == 1) {
                return this.checkers[0].keysToCheck;
            }
            int x = 0;
            for (USKWatchingKeys.KeyList.StoreSubChecker checker : this.checkers) {
                x += checker.keysToCheck.length;
            }
            Key[] keys = new Key[x];
            int ptr = 0;
            HashSet<NodeSSK> check = new HashSet<NodeSSK>();
            for (USKWatchingKeys.KeyList.StoreSubChecker checker : this.checkers) {
                for (NodeSSK k : checker.keysToCheck) {
                    if (!check.add(k)) continue;
                    keys[ptr++] = k;
                }
            }
            if (keys.length != ptr) {
                keys = Arrays.copyOf(keys, ptr);
            }
            return keys;
        }

        public void checked() {
            for (USKWatchingKeys.KeyList.StoreSubChecker checker : this.checkers) {
                checker.checked();
            }
        }
    }

    class USKAttempt
    implements USKCheckerCallback {
        long number;
        USKChecker checker;
        boolean succeeded;
        boolean dnf;
        boolean cancelled;
        final Lookup lookup;
        final boolean forever;
        private boolean everInCooldown;

        public USKAttempt(Lookup l, boolean forever) {
            this.lookup = l;
            this.number = l.val;
            this.succeeded = false;
            this.dnf = false;
            this.forever = forever;
            this.checker = new USKChecker(this, l.key, forever ? -1 : USKFetcher.this.ctx.maxUSKRetries, l.ignoreStore ? USKFetcher.this.ctxNoStore : USKFetcher.this.ctx, USKFetcher.this.parent, USKFetcher.this.realTimeFlag);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDNF(ClientContext context) {
            USKAttempt uSKAttempt = this;
            synchronized (uSKAttempt) {
                this.checker = null;
                this.dnf = true;
            }
            USKFetcher.this.onDNF(this, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(ClientSSKBlock block, ClientContext context) {
            USKAttempt uSKAttempt = this;
            synchronized (uSKAttempt) {
                this.checker = null;
                this.succeeded = true;
            }
            USKFetcher.this.onSuccess(this, false, block, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFatalAuthorError(ClientContext context) {
            USKAttempt uSKAttempt = this;
            synchronized (uSKAttempt) {
                this.checker = null;
            }
            USKFetcher.this.onSuccess(this, true, null, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNetworkError(ClientContext context) {
            USKAttempt uSKAttempt = this;
            synchronized (uSKAttempt) {
                this.checker = null;
            }
            USKFetcher.this.onFail(this, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCancelled(ClientContext context) {
            USKAttempt uSKAttempt = this;
            synchronized (uSKAttempt) {
                this.checker = null;
            }
            USKFetcher.this.onCancelled(this, context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel(ClientContext context) {
            USKChecker c;
            this.cancelled = true;
            USKAttempt uSKAttempt = this;
            synchronized (uSKAttempt) {
                c = this.checker;
            }
            if (c != null) {
                c.cancel(context);
            }
            this.onCancelled(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void schedule(ClientContext context) {
            USKChecker c;
            USKAttempt uSKAttempt = this;
            synchronized (uSKAttempt) {
                c = this.checker;
            }
            if (c == null) {
                if (logMINOR) {
                    Logger.minor(this, "Checker == null in schedule() for " + this, (Throwable)new Exception("debug"));
                }
            } else {
                assert (!c.persistent());
                c.schedule(context);
            }
        }

        public String toString() {
            return "USKAttempt for " + this.number + " for " + USKFetcher.this.origUSK.getURI() + " for " + USKFetcher.this + (this.forever ? " (forever)" : "");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public short getPriority() {
            if (USKFetcher.this.backgroundPoll) {
                USKAttempt uSKAttempt = this;
                synchronized (uSKAttempt) {
                    if (this.forever) {
                        if (!this.everInCooldown) {
                            return USKFetcher.this.progressPollPriority;
                        }
                        return USKFetcher.this.normalPollPriority;
                    }
                    return USKFetcher.this.normalPollPriority;
                }
            }
            return USKFetcher.this.parent.getPriorityClass();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEnterFiniteCooldown(ClientContext context) {
            USKAttempt uSKAttempt = this;
            synchronized (uSKAttempt) {
                this.everInCooldown = true;
            }
            USKFetcher.this.onCheckEnteredFiniteCooldown(context);
        }

        public synchronized boolean everInCooldown() {
            return this.everInCooldown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reloadPollParameters(ClientContext context) {
            USKChecker c;
            USKAttempt uSKAttempt = this;
            synchronized (uSKAttempt) {
                c = this.checker;
            }
            if (c == null) {
                return;
            }
            c.onChangedFetchContext(context);
        }
    }

    class DBRAttempt
    implements GetCompletionCallback {
        final SimpleSingleFileFetcher fetcher;
        final USKDateHint.Type type;

        DBRAttempt(ClientKey key, ClientContext context, USKDateHint.Type type) {
            this.fetcher = new DBRFetcher(key, USKFetcher.this.ctxDBR.maxUSKRetries, USKFetcher.this.ctxDBR, USKFetcher.this.parent, this, false, true, 0L, context, false, USKFetcher.this.realTimeFlag);
            this.type = type;
            if (logMINOR) {
                Logger.minor(this, "Created " + this + " with " + this.fetcher);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(StreamGenerator streamGenerator, ClientMetadata clientMetadata, List<? extends Compressor> decompressors, ClientGetState state, ClientContext context) {
            Object worker;
            OutputStream output = null;
            PipedInputStream pipeIn = new PipedInputStream();
            PipedOutputStream pipeOut = new PipedOutputStream();
            RandomAccessBucket data = null;
            long maxLen = Math.max(USKFetcher.this.ctx.maxTempLength, USKFetcher.this.ctx.maxOutputLength);
            try {
                data = context.getBucketFactory(false).makeBucket(maxLen);
                output = data.getOutputStream();
                if (decompressors != null) {
                    if (logMINOR) {
                        Logger.minor(this, "decompressing...");
                    }
                    pipeOut.connect(pipeIn);
                    DecompressorThreadManager decompressorManager = new DecompressorThreadManager(pipeIn, decompressors, maxLen);
                    pipeIn = decompressorManager.execute();
                    worker = new ClientGetWorkerThread(new BufferedInputStream(pipeIn), output, null, null, null, false, null, null, null, context.linkFilterExceptionProvider);
                    ((Thread)worker).start();
                    streamGenerator.writeTo(pipeOut, context);
                    decompressorManager.waitFinished();
                    ((ClientGetWorkerThread)worker).waitFinished();
                } else {
                    streamGenerator.writeTo(output, context);
                }
                output.close();
                pipeOut.close();
                pipeIn.close();
                output = null;
                pipeOut = null;
                pipeIn = null;
                this.innerSuccess(data, context);
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t, t);
                this.onFailure(new FetchException(FetchException.FetchExceptionMode.INTERNAL_ERROR, t), state, context);
                return;
            }
            finally {
                boolean dbrsFinished;
                worker = USKFetcher.this;
                synchronized (worker) {
                    USKFetcher.this.dbrAttempts.remove(this);
                    if (logMINOR) {
                        Logger.minor(this, "Remaining DBR attempts: " + USKFetcher.this.dbrAttempts);
                    }
                    dbrsFinished = USKFetcher.this.dbrAttempts.isEmpty();
                }
                Closer.close(pipeOut);
                Closer.close(pipeIn);
                Closer.close(output);
                if (dbrsFinished) {
                    USKFetcher.this.onDBRsFinished(context);
                }
                Closer.close(data);
            }
        }

        private void innerSuccess(Bucket bucket, ClientContext context) {
            long hint;
            String line;
            byte[] data;
            try {
                data = BucketTools.toByteArray(bucket);
            }
            catch (IOException e) {
                Logger.error(this, "Unable to read hint data because of I/O error, maybe bad decompression?: " + e, (Throwable)e);
                return;
            }
            try {
                line = new String(data, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Logger.error(this, "Impossible: " + e, (Throwable)e);
                return;
            }
            catch (Throwable t) {
                Logger.error(this, "Impossible throwable - maybe bogus encoding?: " + t, t);
                return;
            }
            String[] split = line.split("\n");
            if (split.length < 3) {
                Logger.error(this, "Unable to parse hint (not enough lines): \"" + line + "\"");
                return;
            }
            if (!split[0].startsWith("HINT")) {
                Logger.error(this, "Unable to parse hint (first line doesn't start with HINT): \"" + line + "\"");
                return;
            }
            String value = split[1];
            try {
                hint = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                Logger.error(this, "Unable to parse hint \"" + value + "\"", (Throwable)e);
                return;
            }
            if (logMINOR) {
                Logger.minor(this, "Found DBR hint edition " + hint + " for " + this.fetcher.getKey(null).getURI() + " for " + USKFetcher.this);
            }
            USKFetcher.this.processDBRHint(hint, context, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(FetchException e, ClientGetState state, ClientContext context) {
            boolean dbrsFinished;
            if (logMINOR) {
                Logger.minor(this, "Failed to fetch hint " + this.fetcher.getKey(null) + " for " + this + " for " + USKFetcher.this);
            }
            USKFetcher uSKFetcher = USKFetcher.this;
            synchronized (uSKFetcher) {
                USKFetcher.this.dbrAttempts.remove(this);
                if (logMINOR) {
                    Logger.minor(this, "Remaining DBR attempts: " + USKFetcher.this.dbrAttempts);
                }
                dbrsFinished = USKFetcher.this.dbrAttempts.isEmpty();
            }
            if (dbrsFinished) {
                USKFetcher.this.onDBRsFinished(context);
            }
        }

        @Override
        public void onBlockSetFinished(ClientGetState state, ClientContext context) {
        }

        @Override
        public void onTransition(ClientGetState oldState, ClientGetState newState, ClientContext context) {
        }

        @Override
        public void onExpectedSize(long size, ClientContext context) {
        }

        @Override
        public void onExpectedMIME(ClientMetadata meta, ClientContext context) throws FetchException {
        }

        @Override
        public void onFinalizedMetadata() {
        }

        @Override
        public void onExpectedTopSize(long size, long compressed, int blocksReq, int blocksTotal, ClientContext context) {
        }

        @Override
        public void onSplitfileCompatibilityMode(InsertContext.CompatibilityMode min, InsertContext.CompatibilityMode max, byte[] customSplitfileKey, boolean compressed, boolean bottomLayer, boolean definitiveAnyway, ClientContext context) {
        }

        @Override
        public void onHashes(HashResult[] hashes, ClientContext context) {
        }

        public void start(ClientContext context) {
            this.fetcher.schedule(context);
        }

        public void cancel(ClientContext context) {
            this.fetcher.cancel(context);
        }
    }

    class DBRFetcher
    extends SimpleSingleFileFetcher {
        DBRFetcher(ClientKey key, int maxRetries, FetchContext ctx, ClientRequester parent, GetCompletionCallback rcb, boolean isEssential, boolean dontAdd, long l, ClientContext context, boolean deleteFetchContext, boolean realTimeFlag) {
            super(key, maxRetries, ctx, parent, rcb, isEssential, dontAdd, l, context, deleteFetchContext, realTimeFlag);
        }

        @Override
        public short getPriorityClass() {
            return USKFetcher.this.progressPollPriority;
        }

        public String toString() {
            return super.objectToString() + " for " + USKFetcher.this + " for " + USKFetcher.this.origUSK;
        }
    }
}

