/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.l10n.NodeL10n;
import freenet.node.Node;
import freenet.node.NodeStarter;
import freenet.node.Version;
import freenet.support.SimpleFieldSet;
import freenet.support.compress.Compressor;

public class NodeHelloMessage
extends FCPMessage {
    public static final String NAME = "NodeHello";
    private final String id;

    public NodeHelloMessage(String id) {
        this.id = id;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.putSingle("FCPVersion", "2.0");
        sfs.putSingle("Node", "Fred");
        sfs.putSingle("Version", Version.getVersionString());
        sfs.put("Build", Version.buildNumber());
        sfs.putSingle("Revision", Version.cvsRevision());
        sfs.put("ExtBuild", NodeStarter.extBuildNumber);
        sfs.putSingle("ExtRevision", NodeStarter.extRevisionNumber);
        sfs.put("Testnet", Node.isTestnetEnabled());
        sfs.putSingle("CompressionCodecs", Compressor.COMPRESSOR_TYPE.getHelloCompressorDescriptor());
        sfs.putSingle("ConnectionIdentifier", this.id);
        sfs.putSingle("NodeLanguage", NodeL10n.getBase().getSelectedLanguage().toString());
        return sfs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        throw new MessageInvalidException(7, "NodeHello goes from server to client not the other way around", null, false);
    }
}

