/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http.wizardsteps;

import freenet.clients.http.FirstTimeWizardToadlet;
import freenet.support.Fields;
import freenet.support.api.HTTPRequest;

public class PersistFields {
    public final FirstTimeWizardToadlet.WIZARD_PRESET preset;
    public final boolean opennet;

    public PersistFields(HTTPRequest request) {
        this.preset = this.parsePreset(request);
        this.opennet = this.parseOpennet(request);
    }

    public PersistFields(boolean opennet, HTTPRequest request) {
        this.preset = this.parsePreset(request);
        this.opennet = opennet;
    }

    public PersistFields(FirstTimeWizardToadlet.WIZARD_PRESET preset, HTTPRequest request) {
        this.preset = preset;
        this.opennet = this.parseOpennet(request);
    }

    private FirstTimeWizardToadlet.WIZARD_PRESET parsePreset(HTTPRequest request) {
        FirstTimeWizardToadlet.WIZARD_PRESET preset;
        String presetRaw = request.hasParameters() ? request.getParam("preset") : request.getPartAsStringFailsafe("preset", 4);
        try {
            preset = FirstTimeWizardToadlet.WIZARD_PRESET.valueOf(presetRaw);
        }
        catch (IllegalArgumentException e) {
            preset = null;
        }
        return preset;
    }

    private boolean parseOpennet(HTTPRequest request) {
        String opennetRaw = request.hasParameters() ? request.getParam("opennet", "false") : request.getPartAsStringFailsafe("opennet", 5);
        return Fields.stringToBool(opennetRaw, false);
    }

    public boolean isUsingPreset() {
        return this.preset != null;
    }

    public String appendTo(String baseURL) {
        StringBuilder url = new StringBuilder(baseURL).append("&opennet=").append(this.opennet);
        if (this.isUsingPreset()) {
            url.append("&preset=").append((Object)this.preset);
        }
        return url.toString();
    }
}

