/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.Util;
import freenet.node.Node;
import freenet.support.Logger;
import freenet.support.io.Closer;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.tanukisoftware.wrapper.WrapperManager;

public class SHA256 {
    private static final int HASH_SIZE = 32;
    private static final Queue<SoftReference<MessageDigest>> digests = new ConcurrentLinkedQueue<SoftReference<MessageDigest>>();
    private static final Provider mdProvider = Util.mdProviders.get("SHA-256");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hash(InputStream is, MessageDigest md) throws IOException {
        try {
            byte[] buf = new byte[4096];
            int readBytes = is.read(buf);
            while (readBytes > -1) {
                md.update(buf, 0, readBytes);
                readBytes = is.read(buf);
            }
            is.close();
        }
        finally {
            Closer.close(is);
        }
    }

    public static MessageDigest getMessageDigest() {
        try {
            SoftReference<MessageDigest> item = null;
            while ((item = digests.poll()) != null) {
                MessageDigest md = item.get();
                if (md == null) continue;
                return md;
            }
            return MessageDigest.getInstance("SHA-256", mdProvider);
        }
        catch (NoSuchAlgorithmException e2) {
            Logger.error(Node.class, "Check your JVM settings especially the JCE!" + e2);
            System.err.println("Check your JVM settings especially the JCE!" + e2);
            e2.printStackTrace();
            WrapperManager.stop((int)255);
            throw new RuntimeException();
        }
    }

    public static void returnMessageDigest(MessageDigest md256) {
        if (md256 == null) {
            return;
        }
        String algo = md256.getAlgorithm();
        if (!algo.equals("SHA-256") && !algo.equals("SHA256")) {
            throw new IllegalArgumentException("Should be SHA-256 but is " + algo);
        }
        md256.reset();
        digests.add(new SoftReference<MessageDigest>(md256));
    }

    public static byte[] digest(byte[] data) {
        MessageDigest md = null;
        try {
            md = SHA256.getMessageDigest();
            byte[] byArray = md.digest(data);
            return byArray;
        }
        finally {
            SHA256.returnMessageDigest(md);
        }
    }

    public static int getDigestLength() {
        return 32;
    }
}

