/*
 * Decompiled with CFR 0.152.
 */
package freenet.l10n;

import freenet.l10n.L10nParseException;
import freenet.support.HTMLEncoder;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.io.Closer;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.NoSuchElementException;

public class BaseL10n {
    private LANGUAGE lang;
    private String l10nFilesBasePath;
    private String l10nFilesMask;
    private String l10nOverrideFilesMask;
    private SimpleFieldSet currentTranslation = null;
    private SimpleFieldSet fallbackTranslation = null;
    private SimpleFieldSet translationOverride;
    private ClassLoader cl;

    private static ClassLoader getClassLoaderFallback() {
        ClassLoader _cl = BaseL10n.class.getClassLoader();
        if (_cl == null) {
            _cl = ClassLoader.getSystemClassLoader();
        }
        return _cl;
    }

    public BaseL10n(String l10nFilesBasePath, String l10nFilesMask, String l10nOverrideFilesMask) {
        this(l10nFilesBasePath, l10nFilesMask, l10nOverrideFilesMask, LANGUAGE.getDefault());
    }

    public BaseL10n(String l10nFilesBasePath, String l10nFilesMask, String l10nOverrideFilesMask, LANGUAGE lang) {
        this(l10nFilesBasePath, l10nFilesMask, l10nOverrideFilesMask, lang, BaseL10n.getClassLoaderFallback());
    }

    public BaseL10n(String l10nFilesBasePath, String l10nFilesMask, String l10nOverrideFilesMask, LANGUAGE lang, ClassLoader cl) {
        if (!l10nFilesBasePath.endsWith("/")) {
            l10nFilesBasePath = l10nFilesBasePath + "/";
        }
        this.l10nFilesBasePath = l10nFilesBasePath;
        this.l10nFilesMask = l10nFilesMask;
        this.l10nOverrideFilesMask = l10nOverrideFilesMask;
        this.cl = cl;
        this.setLanguage(lang);
    }

    public String getL10nFileName(LANGUAGE lang) {
        return this.l10nFilesBasePath + this.l10nFilesMask.replace("${lang}", lang.shortCode);
    }

    public String getL10nOverrideFileName(LANGUAGE lang) {
        return this.l10nOverrideFilesMask.replace("${lang}", lang.shortCode);
    }

    public void setLanguage(LANGUAGE selectedLanguage) throws MissingResourceException {
        if (selectedLanguage == null) {
            throw new MissingResourceException("LANGUAGE given is null !", this.getClass().getName(), "");
        }
        this.lang = selectedLanguage;
        Logger.normal(this.getClass(), "Changing the current language to : " + (Object)((Object)this.lang));
        try {
            this.loadOverrideFileOrBackup();
        }
        catch (IOException e) {
            this.translationOverride = null;
            Logger.error(this, "IOError while accessing the file!" + e.getMessage(), (Throwable)e);
        }
        this.currentTranslation = this.loadTranslation(this.lang);
        if (this.currentTranslation == null) {
            Logger.error(this, "The translation file for " + (Object)((Object)this.lang) + " is invalid. The node will load an empty template.");
            this.currentTranslation = null;
        }
    }

    private void loadOverrideFileOrBackup() throws IOException {
        File tmpFile = new File(this.getL10nOverrideFileName(this.lang));
        if (tmpFile.exists() && tmpFile.canRead() && tmpFile.length() > 0L) {
            Logger.normal(this, "Override file detected : let's try to load it");
            this.translationOverride = SimpleFieldSet.readFrom(tmpFile, false, false);
        } else {
            File backup = new File(tmpFile.getParentFile(), tmpFile.getName() + ".bak");
            if (backup.exists() && backup.length() > 0L) {
                Logger.normal(this, "Override-backup file detected : let's try to load it");
                this.translationOverride = SimpleFieldSet.readFrom(backup, false, false);
            } else {
                this.translationOverride = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleFieldSet loadTranslation(LANGUAGE lang) {
        InputStream in;
        SimpleFieldSet result;
        block5: {
            result = null;
            in = null;
            try {
                in = this.cl.getResourceAsStream(this.getL10nFileName(lang));
                if (in != null) {
                    result = SimpleFieldSet.readFrom(in, false, false);
                    break block5;
                }
                System.err.println("Could not get resource : " + this.getL10nFileName(lang));
            }
            catch (Exception e) {
                try {
                    System.err.println("Error while loading the l10n file from " + this.getL10nFileName(lang) + " :" + e.getMessage());
                    e.printStackTrace();
                    result = null;
                }
                catch (Throwable throwable) {
                    Closer.close(in);
                    throw throwable;
                }
                Closer.close(in);
            }
        }
        Closer.close(in);
        return result;
    }

    private synchronized void loadFallback() {
        if (this.fallbackTranslation == null) {
            this.fallbackTranslation = this.loadTranslation(LANGUAGE.getDefault());
            if (this.fallbackTranslation == null) {
                this.fallbackTranslation = new SimpleFieldSet(true);
            }
        }
    }

    public LANGUAGE getSelectedLanguage() {
        return this.lang;
    }

    public boolean isOverridden(String key) {
        if (this.translationOverride == null) {
            return false;
        }
        return this.translationOverride.get(key) != null;
    }

    public void setOverride(String key, String value) {
        key = key.trim();
        value = value.trim();
        if (this.translationOverride == null) {
            this.translationOverride = new SimpleFieldSet(false);
        }
        if ("".equals(value) || this.currentTranslation != null && value.equals(this.currentTranslation.get(key))) {
            this.translationOverride.removeValue(key);
        } else {
            value = value.replaceAll("(\r|\n|\t)+", "");
            this.translationOverride.putOverwrite(key, value);
            Logger.normal(this.getClass(), "Got a new translation key: set the Override!");
        }
        this.saveTranslationFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTranslationFile() {
        FileOutputStream fos = null;
        File finalFile = new File(this.getL10nOverrideFileName(this.lang));
        try {
            File tempFile = File.createTempFile(finalFile.getName(), ".bak", finalFile.getParentFile());
            Logger.minor(this.getClass(), "The temporary filename is : " + tempFile);
            fos = new FileOutputStream(tempFile);
            this.translationOverride.writeToBigBuffer(fos);
            fos.close();
            fos = null;
            FileUtil.renameTo(tempFile, finalFile);
            Logger.normal(this.getClass(), "Override file saved successfully!");
            Closer.close(fos);
        }
        catch (IOException e) {
            Logger.error(this.getClass(), "Error while saving the translation override: " + e.getMessage(), (Throwable)e);
        }
        finally {
            Closer.close(fos);
        }
    }

    public SimpleFieldSet getCurrentLanguageTranslation() {
        return this.currentTranslation == null ? null : new SimpleFieldSet(this.currentTranslation);
    }

    public SimpleFieldSet getOverrideForCurrentLanguageTranslation() {
        return this.translationOverride == null ? null : new SimpleFieldSet(this.translationOverride);
    }

    public SimpleFieldSet getDefaultLanguageTranslation() {
        this.loadFallback();
        return new SimpleFieldSet(this.fallbackTranslation);
    }

    public String getString(String key) {
        return this.getStrings(key).iterator().next();
    }

    public String getString(String key, boolean returnNullIfNotFound) {
        if (!returnNullIfNotFound) {
            return this.getString(key);
        }
        String result = null;
        if (this.translationOverride != null) {
            result = this.translationOverride.get(key);
        }
        if (result != null) {
            return result;
        }
        if (this.currentTranslation != null) {
            result = this.currentTranslation.get(key);
        }
        if (result == null) {
            Logger.normal(this.getClass(), "The translation for " + key + " hasn't been found (" + (Object)((Object)this.getSelectedLanguage()) + ")! please tell the maintainer.");
        }
        return result;
    }

    private Iterable<String> getStrings(String key) {
        return this.getStrings(key, FallbackState.CURRENT_LANG);
    }

    private Iterable<String> getStrings(final String key, final FallbackState initialState) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new L10nStringIterator(key, initialState);
            }
        };
    }

    public HTMLNode getHTMLNode(String key) {
        return this.getHTMLNode(key, null, null);
    }

    public HTMLNode getHTMLNode(String key, String[] patterns, String[] values) {
        String value = this.getString(key, true);
        if (value != null) {
            if (patterns != null) {
                return new HTMLNode("#", this.getString(key, patterns, values));
            }
            return new HTMLNode("#", value);
        }
        HTMLNode translationField = new HTMLNode("span", "class", "translate_it");
        if (patterns != null) {
            translationField.addChild("#", this.getDefaultString(key, patterns, values));
        } else {
            translationField.addChild("#", this.getDefaultString(key));
        }
        translationField.addChild("a", "href", "/translation/?translate=" + key).addChild("small", " (translate it in your native language!)");
        return translationField;
    }

    private String getFallbackString(String key) {
        this.loadFallback();
        String result = this.fallbackTranslation.get(key);
        if (result == null) {
            Logger.error(this.getClass(), "The default translation for " + key + " hasn't been found!");
            System.err.println("The default translation for " + key + " hasn't been found!");
            new Exception().printStackTrace();
        }
        return result;
    }

    public String getDefaultString(String key) {
        return this.getStrings(key, FallbackState.FALLBACK_LANG).iterator().next();
    }

    public String getDefaultString(String key, String[] patterns, String[] values) {
        assert (patterns.length == values.length);
        String result = this.getDefaultString(key);
        for (int i = 0; i < patterns.length; ++i) {
            result = result.replaceAll("\\$\\{" + patterns[i] + "\\}", this.quoteReplacement(values[i]));
        }
        return result;
    }

    public String getString(String key, String[] patterns, String[] values) {
        assert (patterns.length == values.length);
        String result = this.getString(key);
        for (int i = 0; i < patterns.length; ++i) {
            result = result.replaceAll("\\$\\{" + patterns[i] + "\\}", this.quoteReplacement(values[i]));
        }
        return result;
    }

    public String getString(String key, String pattern, String value) {
        return this.getString(key, new String[]{pattern}, new String[]{value});
    }

    private String quoteReplacement(String s) {
        if (s == null) {
            return "(null)";
        }
        if (s.indexOf(92) == -1 && s.indexOf(36) == -1) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                sb.append('\\');
                sb.append('\\');
                continue;
            }
            if (c == '$') {
                sb.append('\\');
                sb.append('$');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Deprecated
    public void addL10nSubstitution(HTMLNode node, String key, String[] patterns, String[] values) {
        String result = HTMLEncoder.encode(this.getString(key));
        assert (patterns.length == values.length);
        for (int i = 0; i < patterns.length; ++i) {
            result = result.replaceAll("\\$\\{" + patterns[i] + "\\}", this.quoteReplacement(values[i]));
        }
        node.addChild("%", result);
    }

    public void addL10nSubstitution(HTMLNode node, String key, String[] patterns, HTMLNode[] values) {
        List<HTMLNode> newContent = this.getHTMLWithSubstitutions(key, patterns, values);
        node.addChildren(newContent);
    }

    void attemptParse(String value) throws L10nParseException {
        String[] patterns = new String[]{};
        HTMLNode[] values = new HTMLNode[]{};
        this.performHTMLSubstitutions(value, patterns, values);
    }

    private List<HTMLNode> getHTMLWithSubstitutions(String key, String[] patterns, HTMLNode[] values) {
        for (String value : this.getStrings(key)) {
            try {
                return this.performHTMLSubstitutions(value, patterns, values);
            }
            catch (L10nParseException e) {
                Logger.error(this, "Error in l10n value \"" + value + "\" for " + key, (Throwable)e);
            }
        }
        return Collections.singletonList(new HTMLNode("#"));
    }

    private List<HTMLNode> performHTMLSubstitutions(String value, String[] patterns, HTMLNode[] values) throws L10nParseException {
        HTMLNode tempNode = new HTMLNode("#");
        this.addHTMLSubstitutions(tempNode, value, patterns, values);
        return tempNode.getChildren();
    }

    private void addHTMLSubstitutions(HTMLNode node, String value, String[] patterns, HTMLNode[] values) throws L10nParseException {
        int x;
        while (!value.equals("") && (x = value.indexOf("${")) != -1) {
            String searchFor;
            int y;
            String before = value.substring(0, x);
            if (before.length() > 0) {
                node.addChild("#", before);
            }
            if ((y = (value = value.substring(x)).indexOf(125)) == -1) {
                throw new L10nParseException("Unclosed braces");
            }
            String lookup = value.substring(2, y);
            value = value.substring(y + 1);
            if (lookup.startsWith("/")) {
                throw new L10nParseException("Starts with /");
            }
            HTMLNode subnode = null;
            for (int i = 0; i < patterns.length; ++i) {
                if (!patterns[i].equals(lookup)) continue;
                subnode = values[i];
                break;
            }
            if ((x = value.indexOf(searchFor = "${/" + lookup + "}")) == -1) {
                if (subnode == null) continue;
                node.addChild(subnode.clone());
                continue;
            }
            String inner = value.substring(0, x);
            String rest = value.substring(x + searchFor.length());
            if (subnode != null) {
                subnode = subnode.clone();
                node.addChild(subnode);
            } else {
                subnode = node;
            }
            this.addHTMLSubstitutions(subnode, inner, patterns, values);
            value = rest;
        }
        if (!value.equals("")) {
            node.addChild("#", value);
        }
    }

    public String[] getAllNamesWithPrefix(String prefix) {
        if (this.fallbackTranslation == null) {
            return new String[0];
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        Iterator<String> it = this.fallbackTranslation.keyIterator();
        while (it.hasNext()) {
            String key = it.next();
            if (!key.startsWith(prefix)) continue;
            toReturn.add(key);
        }
        return toReturn.toArray(new String[toReturn.size()]);
    }

    private class L10nStringIterator
    implements Iterator<String> {
        private final String key;
        private FallbackState state;

        public L10nStringIterator(String key, FallbackState state) {
            this.key = key;
            this.state = state;
        }

        @Override
        public boolean hasNext() {
            return this.state != FallbackState.END;
        }

        @Override
        public String next() {
            String value;
            if (this.state == FallbackState.CURRENT_LANG) {
                this.state = FallbackState.FALLBACK_LANG;
                value = BaseL10n.this.getString(this.key, true);
                if (value != null) {
                    return value;
                }
            }
            if (this.state == FallbackState.FALLBACK_LANG) {
                this.state = FallbackState.KEY;
                if (BaseL10n.this.getSelectedLanguage() != LANGUAGE.getDefault() && (value = BaseL10n.this.getFallbackString(this.key)) != null) {
                    return value;
                }
            }
            if (this.state == FallbackState.KEY) {
                this.state = FallbackState.END;
                return this.key;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static enum FallbackState {
        CURRENT_LANG,
        FALLBACK_LANG,
        KEY,
        END;

    }

    public static enum LANGUAGE {
        CROATIAN("hr", "Hrvatski", "hrv", new String[]{"WINDOWS041A"}),
        ENGLISH("en", "English", "eng", new String[]{"WINDOWS0409", "WINDOWS0809", "WINDOWS0C09", "WINDOWS1009", "WINDOWS1409", "WINDOWS1809", "WINDOWS1C09", "WINDOWS2009", "WINDOWS2409", "WINDOWS2809", "WINDOWS2C09", "WINDOWS3009", "WINDOWS3409"}),
        HUNGARIAN("hu", "magyar", "hun", new String[]{"WINDOWS040E"}),
        SPANISH("es", "Espa\u00f1ol", "spa", new String[]{"WINDOWS040A", "WINDOWS080A", "WINDOWS0C0A", "WINDOWS100A", "WINDOWS140A", "WINDOWS180A", "WINDOWS1C0A", "WINDOWS200A", "WINDOWS240A", "WINDOWS280A", "WINDOWS2C0A", "WINDOWS300A", "WINDOWS340A", "WINDOWS380A", "WINDOWS3C0A", "WINDOWS400A", "WINDOWS440A", "WINDOWS480A", "WINDOWS4C0A", "WINDOWS500A"}),
        DANISH("da", "Dansk", "dan", new String[]{"WINDOWS0406"}),
        DUTCH("nl", "Nederlands", "nld", new String[]{"WINDOWS0413", "WINDOWS0813"}),
        GERMAN("de", "Deutsch", "deu", new String[]{"WINDOWS0407", "WINDOWS0807", "WINDOWS0C07", "WINDOWS1007", "WINDOWS1407"}),
        FINNISH("fi", "Suomi", "fin", new String[]{"WINDOWS040B"}),
        FRENCH("fr", "Fran\u00e7ais", "fra", new String[]{"WINDOWS040C", "WINDOWS080C", "WINDOWS0C0C", "WINDOWS100C", "WINDOWS140C", "WINDOWS180C"}),
        ITALIAN("it", "Italiano", "ita", new String[]{"WINDOWS0410", "WINDOWS0810"}),
        NORWEGIAN("nb-no", "Bokm\u00e5l", "nob", new String[]{"WINDOWS0414", "WINDOWS0814"}),
        POLISH("pl", "Polski", "pol", new String[]{"WINDOWS0415"}),
        SWEDISH("sv", "Svenska", "swe", new String[]{"WINDOWS041D", "WINDOWS081D"}),
        CHINESE("zh-cn", "\u4e2d\u6587(\u7b80\u4f53)", "chn", new String[]{"WINDOWS0804", "WINDOWS1004"}),
        CHINESE_TAIWAN("zh-tw", "\u4e2d\u6587(\u7e41\u9ad4)", "zh-tw", new String[]{"WINDOWS0404", "WINDOWS0C04", "WINDOWS1404"}),
        RUSSIAN("ru", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439", "rus", new String[]{"WINDOWS0419"}),
        JAPANESE("ja", "\u65e5\u672c\u8a9e", "jpn", new String[]{"WINDOWS0411"}),
        PORTUGUESE("pt-PT", "Portugu\u00eas do Portugal", "pt", new String[]{"WINDOWS0816"}),
        BRAZILIAN_PORTUGUESE("pt-br", "Portugu\u00eas do Brasil", "pt-br", new String[]{"WINDOWS0416"}),
        GREEK("el", "\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac", "ell", new String[]{"WINDOWS0408"}),
        UNLISTED("unlisted", "unlisted", "unlisted", new String[0]);

        public final String shortCode;
        public final String fullName;
        public final String isoCode;
        public final String[] aliases;

        private LANGUAGE(String shortCode, String fullName, String isoCode, String[] aliases) {
            this.shortCode = shortCode;
            this.fullName = fullName;
            this.isoCode = isoCode;
            this.aliases = aliases;
        }

        private LANGUAGE(LANGUAGE l) {
            this(l.shortCode, l.fullName, l.isoCode, l.aliases);
        }

        public static LANGUAGE mapToLanguage(String whatever) {
            for (LANGUAGE currentLanguage : LANGUAGE.values()) {
                if (currentLanguage.shortCode.equalsIgnoreCase(whatever) || currentLanguage.fullName.equalsIgnoreCase(whatever) || currentLanguage.isoCode.equalsIgnoreCase(whatever) || currentLanguage.toString().equalsIgnoreCase(whatever)) {
                    return currentLanguage;
                }
                if (currentLanguage.aliases == null) continue;
                for (String s : currentLanguage.aliases) {
                    if (!whatever.equalsIgnoreCase(s)) continue;
                    return currentLanguage;
                }
            }
            return null;
        }

        public static String[] valuesWithFullNames() {
            LANGUAGE[] allValues = LANGUAGE.values();
            ArrayList<String> result = new ArrayList<String>(allValues.length);
            for (int i = 0; i < allValues.length; ++i) {
                if (allValues[i] == UNLISTED) continue;
                result.add(allValues[i].fullName);
            }
            Collections.sort(result);
            result.add(LANGUAGE.UNLISTED.fullName);
            return result.toArray(new String[result.size()]);
        }

        public static LANGUAGE getDefault() {
            return ENGLISH;
        }
    }
}

