/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.config.InvalidConfigValueException;
import freenet.config.SubConfig;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.Peer;
import freenet.l10n.NodeL10n;
import freenet.node.IPDetectorPluginManager;
import freenet.node.Node;
import freenet.node.NodeIPPortDetector;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.node.SeedServerPeerNode;
import freenet.node.useralerts.IPUndetectedUserAlert;
import freenet.node.useralerts.InvalidAddressOverrideUserAlert;
import freenet.node.useralerts.SimpleUserAlert;
import freenet.pluginmanager.DetectedIP;
import freenet.pluginmanager.FredPluginBandwidthIndicator;
import freenet.pluginmanager.FredPluginIPDetector;
import freenet.pluginmanager.FredPluginPortForward;
import freenet.support.HTMLNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.api.StringCallback;
import freenet.support.io.NativeThread;
import freenet.support.transport.ip.HostnameSyntaxException;
import freenet.support.transport.ip.IPAddressDetector;
import freenet.support.transport.ip.IPUtil;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class NodeIPDetector {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    final Node node;
    FreenetInetAddress overrideIPAddress;
    String overrideIPAddressString;
    FreenetInetAddress oldIPAddress;
    DetectedIP[] pluginDetectedIPs;
    FreenetInetAddress[] lastIPAddress;
    private final MinimumMTU minimumMTUIPv4 = new MinimumMTU();
    private final MinimumMTU minimumMTUIPv6 = new MinimumMTU();
    private final IPAddressDetector ipDetector;
    final IPDetectorPluginManager ipDetectorManager;
    private InvalidAddressOverrideUserAlert invalidAddressOverrideAlert;
    private boolean hasValidAddressOverride;
    private IPUndetectedUserAlert primaryIPUndetectedAlert;
    FreenetInetAddress[] lastIP;
    boolean maybeSymmetric;
    private boolean hasDetectedPM;
    private boolean hasDetectedIAD;
    private NodeIPPortDetector[] portDetectors;
    private boolean hasValidIP;
    private boolean firstDetection = true;
    SimpleUserAlert maybeSymmetricAlert;
    private FredPluginBandwidthIndicator bandwidthIndicator;

    public NodeIPDetector(Node node) {
        this.node = node;
        this.ipDetectorManager = new IPDetectorPluginManager(node, this);
        this.ipDetector = new IPAddressDetector(TimeUnit.SECONDS.toMillis(10L), this);
        this.invalidAddressOverrideAlert = new InvalidAddressOverrideUserAlert(node);
        this.primaryIPUndetectedAlert = new IPUndetectedUserAlert(node);
        this.portDetectors = new NodeIPPortDetector[0];
    }

    public synchronized void addPortDetector(NodeIPPortDetector detector) {
        this.portDetectors = Arrays.copyOf(this.portDetectors, this.portDetectors.length + 1);
        this.portDetectors[this.portDetectors.length - 1] = detector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FreenetInetAddress[] detectPrimaryIPAddress(boolean dumpLocalAddresses) {
        boolean addedValidIP = false;
        Logger.minor(this, "Redetecting IPs...");
        ArrayList<FreenetInetAddress> addresses = new ArrayList<FreenetInetAddress>();
        if (this.overrideIPAddress != null) {
            addresses.add(this.overrideIPAddress);
            if (this.overrideIPAddress.isRealInternetAddress(false, true, false)) {
                addedValidIP = true;
            }
        }
        if (!this.node.dontDetect()) {
            addedValidIP |= this.innerDetect(addresses);
        }
        if (this.node.clientCore != null) {
            FreenetInetAddress[] freenetInetAddressArray = this;
            synchronized (this) {
                boolean hadValidIP = this.hasValidIP;
                this.hasValidIP = addedValidIP;
                if (this.firstDetection) {
                    hadValidIP = !addedValidIP;
                    this.firstDetection = false;
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
                if (hadValidIP != addedValidIP) {
                    if (addedValidIP) {
                        if (logMINOR) {
                            Logger.minor(this, "Got valid IP");
                        }
                        this.onAddedValidIP();
                    } else {
                        if (logMINOR) {
                            Logger.minor(this, "No valid IP");
                        }
                        this.onNotAddedValidIP();
                    }
                }
            }
        } else if (logMINOR) {
            Logger.minor(this, "Client core not loaded");
        }
        {
            FreenetInetAddress[] hadValidIP = this;
            synchronized (this) {
                this.hasValidIP = addedValidIP;
                // ** MonitorExit[hadValidIP] (shouldn't be in output)
                this.lastIPAddress = addresses.toArray(new FreenetInetAddress[addresses.size()]);
                if (dumpLocalAddresses) {
                    ArrayList<FreenetInetAddress> filtered = new ArrayList<FreenetInetAddress>(this.lastIPAddress.length);
                    for (FreenetInetAddress addr : this.lastIPAddress) {
                        if (addr == null) continue;
                        if (addr == this.overrideIPAddress && addr.hasHostnameNoIP()) {
                            filtered.add(addr);
                            continue;
                        }
                        if (addr.hasHostnameNoIP() || !IPUtil.isValidAddress(addr.getAddress(), false)) continue;
                        filtered.add(addr);
                    }
                    return filtered.toArray(new FreenetInetAddress[filtered.size()]);
                }
                return this.lastIPAddress;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasValidIP() {
        NodeIPDetector nodeIPDetector = this;
        synchronized (nodeIPDetector) {
            return this.hasValidIP;
        }
    }

    private void onAddedValidIP() {
        this.node.clientCore.alerts.unregister(this.primaryIPUndetectedAlert);
        this.node.onAddedValidIP();
    }

    private void onNotAddedValidIP() {
        this.node.clientCore.alerts.register(this.primaryIPUndetectedAlert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean innerDetect(List<FreenetInetAddress> addresses) {
        boolean addedValidIP = false;
        InetAddress[] detectedAddrs = this.ipDetector.getAddressNoCallback();
        assert (detectedAddrs != null);
        Object[] objectArray = this;
        synchronized (this) {
            Object addr;
            this.hasDetectedIAD = true;
            // ** MonitorExit[objectArray] (shouldn't be in output)
            for (InetAddress detectedAddr : detectedAddrs) {
                addr = new FreenetInetAddress(detectedAddr);
                if (addresses.contains(addr)) continue;
                Logger.normal(this, "Detected IP address: " + addr);
                addresses.add((FreenetInetAddress)addr);
                if (!((FreenetInetAddress)addr).isRealInternetAddress(false, false, false)) continue;
                addedValidIP = true;
            }
            if (this.pluginDetectedIPs != null && this.pluginDetectedIPs.length > 0) {
                for (DetectedIP pluginDetectedIP : this.pluginDetectedIPs) {
                    FreenetInetAddress a;
                    addr = pluginDetectedIP.publicAddress;
                    if (addr == null || addresses.contains(a = new FreenetInetAddress((InetAddress)addr))) continue;
                    Logger.normal(this, "Plugin detected IP address: " + a);
                    addresses.add(a);
                    if (!a.isRealInternetAddress(false, false, false)) continue;
                    addedValidIP = true;
                }
            }
            boolean hadAddedValidIP = addedValidIP;
            int confidence = 0;
            if (this.node.peers != null) {
                PeerNode[] peerList = this.node.peers.myPeers();
                HashMap<FreenetInetAddress, Integer> countsByPeer = new HashMap<FreenetInetAddress, Integer>();
                for (PeerNode pn : peerList) {
                    if (!pn.isConnected()) {
                        if (!logDEBUG) continue;
                        Logger.minor(this, "Not connected");
                        continue;
                    }
                    if (!pn.isRealConnection()) {
                        if (!(pn instanceof SeedServerPeerNode)) continue;
                        if (logMINOR) {
                            Logger.minor(this, "Not a real connection and not a seed node: " + pn);
                        }
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Maybe a usable connection for IP: " + pn);
                    }
                    Peer p = pn.getRemoteDetectedPeer();
                    if (logMINOR) {
                        Logger.minor(this, "Remote detected peer: " + p);
                    }
                    if (p == null || p.isNull()) continue;
                    FreenetInetAddress freenetInetAddress = p.getFreenetAddress();
                    if (logMINOR) {
                        Logger.minor(this, "Address: " + freenetInetAddress);
                    }
                    if (freenetInetAddress == null) continue;
                    if (!IPUtil.isValidAddress(freenetInetAddress.getAddress(false), false)) {
                        if (!logMINOR) continue;
                        Logger.minor(this, "Address not valid");
                        continue;
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Peer " + pn.getPeer() + " thinks we are " + freenetInetAddress);
                    }
                    if (countsByPeer.containsKey(freenetInetAddress)) {
                        countsByPeer.put(freenetInetAddress, (Integer)countsByPeer.get(freenetInetAddress) + 1);
                        continue;
                    }
                    countsByPeer.put(freenetInetAddress, 1);
                }
                if (countsByPeer.size() == 1) {
                    Map.Entry countByPeer = countsByPeer.entrySet().iterator().next();
                    FreenetInetAddress addr3 = (FreenetInetAddress)countByPeer.getKey();
                    confidence = (Integer)countByPeer.getValue();
                    Logger.minor(this, "Everyone agrees we are " + addr3);
                    if (!addresses.contains(addr3)) {
                        if (addr3.isRealInternetAddress(false, false, false)) {
                            addedValidIP = true;
                        }
                        addresses.add(addr3);
                    }
                } else if (countsByPeer.size() > 1) {
                    FreenetInetAddress best = null;
                    FreenetInetAddress secondBest = null;
                    int bestPopularity = 0;
                    int secondBestPopularity = 0;
                    for (Map.Entry entry : countsByPeer.entrySet()) {
                        FreenetInetAddress cur = (FreenetInetAddress)entry.getKey();
                        int curPop = (Integer)entry.getValue();
                        Logger.minor(this, "Detected peer: " + cur + " popularity " + curPop);
                        if (curPop < bestPopularity) continue;
                        secondBestPopularity = bestPopularity;
                        bestPopularity = curPop;
                        secondBest = best;
                        best = cur;
                    }
                    if (best != null) {
                        boolean hasRealDetectedAddress = false;
                        for (InetAddress detectedAddr : detectedAddrs) {
                            if (!IPUtil.isValidAddress(detectedAddr, false)) continue;
                            hasRealDetectedAddress = true;
                        }
                        if (bestPopularity > 1 || !hasRealDetectedAddress) {
                            if (!addresses.contains(best)) {
                                Logger.minor(this, "Adding best peer " + best + " (" + bestPopularity + ')');
                                addresses.add(best);
                                if (best.isRealInternetAddress(false, false, false)) {
                                    addedValidIP = true;
                                }
                            }
                            confidence = bestPopularity;
                            if (secondBest != null && secondBestPopularity > 1 && !addresses.contains(secondBest)) {
                                Logger.minor(this, "Adding second best peer " + secondBest + " (" + secondBest + ')');
                                addresses.add(secondBest);
                                if (secondBest.isRealInternetAddress(false, false, false)) {
                                    addedValidIP = true;
                                }
                            }
                        }
                    }
                }
            }
            if (!hadAddedValidIP && confidence <= 2 && this.oldIPAddress != null && !this.oldIPAddress.equals(this.overrideIPAddress)) {
                addresses.add(this.oldIPAddress);
            }
            return addedValidIP;
        }
    }

    private String l10n(String key) {
        return NodeL10n.getBase().getString("NodeIPDetector." + key);
    }

    private String l10n(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("NodeIPDetector." + key, pattern, value);
    }

    FreenetInetAddress[] getPrimaryIPAddress(boolean dumpLocal) {
        if (this.lastIPAddress == null) {
            return this.detectPrimaryIPAddress(dumpLocal);
        }
        return this.lastIPAddress;
    }

    public boolean hasDirectlyDetectedIP() {
        InetAddress[] addrs = this.ipDetector.getAddress(this.node.executor);
        if (addrs == null || addrs.length == 0) {
            return false;
        }
        for (InetAddress addr : addrs) {
            if (!IPUtil.isValidAddress(addr, false)) continue;
            if (logMINOR) {
                Logger.minor(this, "Has a directly detected IP: " + addr);
            }
            return true;
        }
        return false;
    }

    public void processDetectedIPs(DetectedIP[] list) {
        this.pluginDetectedIPs = list;
        boolean mtuChanged = false;
        for (DetectedIP pluginDetectedIP : this.pluginDetectedIPs) {
            this.reportMTU(pluginDetectedIP.mtu, pluginDetectedIP.publicAddress instanceof Inet6Address);
        }
        this.redetectAddress();
    }

    public void reportMTU(int mtu, boolean forIPv6) {
        boolean mtuChanged = false;
        mtuChanged = forIPv6 ? (mtuChanged |= this.minimumMTUIPv6.report(mtu)) : (mtuChanged |= this.minimumMTUIPv4.report(mtu));
        if (mtuChanged) {
            this.node.updateMTU();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redetectAddress() {
        Object[] newIP = this.detectPrimaryIPAddress(false);
        NodeIPPortDetector[] nodeIPPortDetectorArray = this;
        synchronized (this) {
            if (Arrays.equals(newIP, this.lastIP)) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            this.lastIP = newIP;
            NodeIPPortDetector[] detectors = this.portDetectors;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (NodeIPPortDetector detector : detectors) {
                detector.update();
            }
            this.node.writeNodeFile();
            return;
        }
    }

    public void setOldIPAddress(FreenetInetAddress freenetAddress) {
        this.oldIPAddress = freenetAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerConfigs(SubConfig nodeConfig, int sortOrder) {
        nodeConfig.register("ipAddressOverride", "", sortOrder++, true, false, "NodeIPDectector.ipOverride", "NodeIPDectector.ipOverrideLong", new StringCallback(){

            @Override
            public String get() {
                if (NodeIPDetector.this.overrideIPAddressString == null) {
                    return "";
                }
                return NodeIPDetector.this.overrideIPAddressString;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void set(String val) throws InvalidConfigValueException {
                FreenetInetAddress addr;
                boolean hadValidAddressOverride = NodeIPDetector.this.hasValidAddressOverride();
                if (val.length() == 0) {
                    NodeIPDetector.this.overrideIPAddressString = val;
                    NodeIPDetector.this.overrideIPAddress = null;
                    NodeIPDetector.this.lastIPAddress = null;
                    NodeIPDetector.this.redetectAddress();
                    return;
                }
                try {
                    addr = new FreenetInetAddress(val, false, true);
                }
                catch (HostnameSyntaxException e) {
                    throw new InvalidConfigValueException(NodeIPDetector.this.l10n("unknownHostErrorInIPOverride", "error", "hostname or IP address syntax error"));
                }
                catch (UnknownHostException e) {
                    throw new InvalidConfigValueException(NodeIPDetector.this.l10n("unknownHostErrorInIPOverride", "error", e.getMessage()));
                }
                if (addr.equals(NodeIPDetector.this.overrideIPAddress)) {
                    return;
                }
                NodeIPDetector.this.overrideIPAddressString = val;
                NodeIPDetector.this.overrideIPAddress = addr;
                NodeIPDetector.this.lastIPAddress = null;
                2 var4_6 = this;
                synchronized (var4_6) {
                    NodeIPDetector.this.hasValidAddressOverride = true;
                }
                if (!hadValidAddressOverride) {
                    NodeIPDetector.this.onGetValidAddressOverride();
                }
                NodeIPDetector.this.redetectAddress();
            }
        });
        this.hasValidAddressOverride = true;
        this.overrideIPAddressString = nodeConfig.getString("ipAddressOverride");
        if (this.overrideIPAddressString.length() == 0) {
            this.overrideIPAddress = null;
        } else {
            String msg;
            try {
                this.overrideIPAddress = new FreenetInetAddress(this.overrideIPAddressString, false, true);
            }
            catch (HostnameSyntaxException e) {
                NodeIPDetector nodeIPDetector = this;
                synchronized (nodeIPDetector) {
                    this.hasValidAddressOverride = false;
                }
                msg = "Invalid IP override syntax: " + this.overrideIPAddressString + " in config: " + e.getMessage();
                Logger.error(this, msg);
                System.err.println(msg + " but starting up anyway, ignoring the configured IP override");
                this.overrideIPAddress = null;
            }
            catch (UnknownHostException e) {
                msg = "Unknown host: " + this.overrideIPAddressString + " in config: " + e.getMessage();
                Logger.error(this, msg);
                System.err.println(msg + " but starting up anyway with no IP override");
                this.overrideIPAddress = null;
            }
        }
        nodeConfig.register("tempIPAddressHint", "", sortOrder++, true, false, "NodeIPDectector.tempAddressHint", "NodeIPDectector.tempAddressHintLong", new StringCallback(){

            @Override
            public String get() {
                return "";
            }

            @Override
            public void set(String val) throws InvalidConfigValueException {
                if (val.length() == 0) {
                    return;
                }
                if (NodeIPDetector.this.overrideIPAddress != null) {
                    return;
                }
                try {
                    NodeIPDetector.this.oldIPAddress = new FreenetInetAddress(val, false);
                }
                catch (UnknownHostException e) {
                    throw new InvalidConfigValueException("Unknown host: " + e.getMessage());
                }
                NodeIPDetector.this.redetectAddress();
            }
        });
        String ipHintString = nodeConfig.getString("tempIPAddressHint");
        if (ipHintString.length() > 0) {
            try {
                this.oldIPAddress = new FreenetInetAddress(ipHintString, false);
            }
            catch (UnknownHostException e) {
                String msg = "Unknown host: " + ipHintString + " in config: " + e.getMessage();
                Logger.error(this, msg);
                System.err.println(msg);
                this.oldIPAddress = null;
            }
        }
        return sortOrder;
    }

    public void start() {
        boolean haveValidAddressOverride = this.hasValidAddressOverride();
        if (!haveValidAddressOverride) {
            this.onNotGetValidAddressOverride();
        }
        this.node.executor.execute(this.ipDetector, "IP address re-detector");
        this.redetectAddress();
        this.node.getTicker().queueTimedJob(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NodeIPPortDetector[] nodeIPPortDetectorArray = this;
                synchronized (this) {
                    NodeIPPortDetector[] detectors = NodeIPDetector.this.portDetectors;
                    // ** MonitorExit[var2_1] (shouldn't be in output)
                    for (NodeIPPortDetector detector : detectors) {
                        detector.startARK();
                    }
                    return;
                }
            }
        }, TimeUnit.SECONDS.toMillis(60L));
    }

    public void onConnectedPeer() {
        this.node.executor.execute(new PrioRunnable(){

            @Override
            public void run() {
                NodeIPDetector.this.ipDetectorManager.maybeRun();
            }

            @Override
            public int getPriority() {
                return NativeThread.HIGH_PRIORITY;
            }
        });
    }

    public void registerIPDetectorPlugin(FredPluginIPDetector detector) {
        this.ipDetectorManager.registerDetectorPlugin(detector);
    }

    public void unregisterIPDetectorPlugin(FredPluginIPDetector detector) {
        this.ipDetectorManager.unregisterDetectorPlugin(detector);
    }

    public synchronized boolean isDetecting() {
        return !this.hasDetectedPM || !this.hasDetectedIAD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void hasDetectedPM() {
        if (logMINOR) {
            Logger.minor(this, "hasDetectedPM() called", (Throwable)new Exception("debug"));
        }
        NodeIPDetector nodeIPDetector = this;
        synchronized (nodeIPDetector) {
            this.hasDetectedPM = true;
        }
    }

    public int getMinimumDetectedMTU(boolean ipv6) {
        return ipv6 ? this.minimumMTUIPv6.get() : this.minimumMTUIPv4.get();
    }

    public int getMinimumDetectedMTU() {
        return Math.min(this.minimumMTUIPv4.get(), this.minimumMTUIPv6.get());
    }

    public void setMaybeSymmetric() {
        if (this.ipDetectorManager != null && this.ipDetectorManager.isEmpty()) {
            if (this.maybeSymmetricAlert == null) {
                this.maybeSymmetricAlert = new SimpleUserAlert(true, this.l10n("maybeSymmetricTitle"), this.l10n("maybeSymmetric"), this.l10n("maybeSymmetricShort"), 1);
            }
            if (this.node.clientCore != null && this.node.clientCore.alerts != null) {
                this.node.clientCore.alerts.register(this.maybeSymmetricAlert);
            }
        } else if (this.maybeSymmetricAlert != null) {
            this.node.clientCore.alerts.unregister(this.maybeSymmetricAlert);
        }
    }

    public void registerPortForwardPlugin(FredPluginPortForward forward) {
        this.ipDetectorManager.registerPortForwardPlugin(forward);
    }

    public void unregisterPortForwardPlugin(FredPluginPortForward forward) {
        this.ipDetectorManager.unregisterPortForwardPlugin(forward);
    }

    public synchronized void registerBandwidthIndicatorPlugin(FredPluginBandwidthIndicator indicator) {
        this.bandwidthIndicator = indicator;
    }

    public synchronized void unregisterBandwidthIndicatorPlugin(FredPluginBandwidthIndicator indicator) {
        this.bandwidthIndicator = null;
    }

    public synchronized FredPluginBandwidthIndicator getBandwidthIndicator() {
        return this.bandwidthIndicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasValidAddressOverride() {
        NodeIPDetector nodeIPDetector = this;
        synchronized (nodeIPDetector) {
            return this.hasValidAddressOverride;
        }
    }

    private void onGetValidAddressOverride() {
        this.node.clientCore.alerts.unregister(this.invalidAddressOverrideAlert);
    }

    private void onNotGetValidAddressOverride() {
        this.node.clientCore.alerts.register(this.invalidAddressOverrideAlert);
    }

    public void addConnectionTypeBox(HTMLNode contentNode) {
        this.ipDetectorManager.addConnectionTypeBox(contentNode);
    }

    public boolean noDetectPlugins() {
        return !this.ipDetectorManager.hasDetectors();
    }

    public boolean hasJSTUN() {
        return this.ipDetectorManager.hasJSTUN();
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }

    private class MinimumMTU {
        private int minimumMTU = Integer.MAX_VALUE;

        private MinimumMTU() {
        }

        boolean report(int mtu) {
            if (mtu <= 0) {
                return false;
            }
            if (mtu < this.minimumMTU) {
                Logger.normal(this, "Reducing the MTU to " + this.minimumMTU);
                this.minimumMTU = mtu;
                return true;
            }
            return false;
        }

        public int get() {
            return this.minimumMTU > 0 ? this.minimumMTU : 1500;
        }
    }
}

