/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.compress;

import freenet.support.compress.CompressionRatioException;
import freenet.support.compress.Compressor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

abstract class AbstractCompressor
implements Compressor {
    AbstractCompressor() {
    }

    @Override
    public long compress(InputStream input, OutputStream output, long maxReadLength, long maxWriteLength) throws IOException {
        try {
            return this.compress(input, output, maxReadLength, maxWriteLength, Long.MAX_VALUE, 0);
        }
        catch (CompressionRatioException e) {
            throw new IllegalStateException(e);
        }
    }

    void checkCompressionEffect(long rawDataVolume, long compressedDataVolume, int minimumCompressionPercentage) throws CompressionRatioException {
        assert (rawDataVolume != 0L);
        assert (minimumCompressionPercentage != 0);
        long compressionPercentage = 100L - compressedDataVolume * 100L / rawDataVolume;
        if (compressionPercentage < (long)minimumCompressionPercentage) {
            throw new CompressionRatioException("Compression has no effect. Compression percentage: " + compressionPercentage);
        }
    }
}

