/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import freenet.support.Logger;
import freenet.support.math.MersenneTwister;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public final class Fallocate {
    private static final boolean IS_LINUX = Platform.isLinux();
    private static final boolean IS_POSIX = !Platform.isWindows() && !Platform.isMac();
    private static final int FALLOC_FL_KEEP_SIZE = 1;
    private final int fd;
    private int mode;
    private long offset;
    private final long final_filesize;
    private final FileChannel channel;

    private Fallocate(FileChannel channel, int fd, long final_filesize) {
        this.fd = fd;
        this.final_filesize = final_filesize;
        this.channel = channel;
    }

    public static Fallocate forChannel(FileChannel channel, long final_filesize) {
        return new Fallocate(channel, Fallocate.getDescriptor(channel), final_filesize);
    }

    public Fallocate fromOffset(long offset) {
        if (offset < 0L || offset > this.final_filesize) {
            throw new IllegalArgumentException();
        }
        this.offset = offset;
        return this;
    }

    public Fallocate keepSize() {
        this.requireLinux("fallocate keep size");
        this.mode |= 1;
        return this;
    }

    private void requireLinux(String feature) {
        if (!IS_LINUX) {
            this.throwUnsupported(feature);
        }
    }

    private void throwUnsupported(String feature) {
        throw new UnsupportedOperationException(feature + " is not supported on this file system");
    }

    public void execute() throws IOException {
        int errno = 0;
        boolean isUnsupported = false;
        if (IS_LINUX) {
            int result = FallocateHolder.fallocate(this.fd, this.mode, this.offset, this.final_filesize - this.offset);
            errno = result == 0 ? 0 : Native.getLastError();
        } else if (IS_POSIX) {
            errno = FallocateHolderPOSIX.posix_fallocate(this.fd, this.offset, this.final_filesize - this.offset);
        } else {
            isUnsupported = true;
        }
        if (isUnsupported || errno != 0) {
            Logger.normal(this, "fallocate() failed; using legacy method; errno=" + errno);
            Fallocate.legacyFill(this.channel, this.final_filesize, this.offset);
        }
    }

    private static int getDescriptor(FileChannel channel) {
        try {
            Field field = channel.getClass().getDeclaredField("fd");
            field.setAccessible(true);
            return Fallocate.getDescriptor((FileDescriptor)field.get(channel));
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("unsupported FileChannel implementation", e);
        }
    }

    private static int getDescriptor(FileDescriptor descriptor) {
        try {
            Field field = descriptor.getClass().getDeclaredField("fd");
            field.setAccessible(true);
            return (Integer)field.get(descriptor);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("unsupported FileDescriptor implementation", e);
        }
    }

    private static void legacyFill(FileChannel fc, long newLength, long offset) throws IOException {
        MersenneTwister mt = new MersenneTwister();
        byte[] b = new byte[4096];
        ByteBuffer bb = ByteBuffer.wrap(b);
        while (offset < newLength) {
            bb.rewind();
            mt.nextBytes(b);
            if ((offset += (long)fc.write(bb, offset)) % 0x40000000L != 0L) continue;
            mt = new MersenneTwister();
        }
    }

    private static class FallocateHolderPOSIX {
        private FallocateHolderPOSIX() {
        }

        private static native int posix_fallocate(int var0, long var1, long var3);

        static {
            Native.register((String)Platform.C_LIBRARY_NAME);
        }
    }

    private static class FallocateHolder {
        private FallocateHolder() {
        }

        private static native int fallocate(int var0, int var1, long var2, long var4);

        static {
            Native.register((String)Platform.C_LIBRARY_NAME);
        }
    }
}

