/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.async.BlockSet;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentJob;
import freenet.keys.Key;
import freenet.keys.KeyBlock;
import freenet.keys.NodeSSK;
import freenet.node.LowLevelGetException;
import freenet.node.Node;
import freenet.node.PrioRunnable;
import freenet.node.SendableGet;
import freenet.support.Executor;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.io.NativeThread;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public class DatastoreChecker
implements PrioRunnable {
    private final boolean lazy;
    private boolean running;
    private final Executor executor;
    private final String threadName;
    static final int KILL_BLOCKS = 0;
    static final int RESET_COUNTER = 100;
    private static volatile boolean logMINOR;
    private final ArrayDeque<QueueItem>[] queue;
    private ClientContext context;
    private final Node node;

    public synchronized void setContext(ClientContext context) {
        this.context = context;
    }

    public DatastoreChecker(Node node, boolean lazyStart, Executor executor, String threadName) {
        this.node = node;
        this.lazy = lazyStart;
        this.executor = executor;
        this.threadName = threadName;
        int priorities = 7;
        this.queue = new ArrayDeque[priorities];
        for (int i = 0; i < priorities; ++i) {
            this.queue[i] = new ArrayDeque();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueRequest(SendableGet getter, BlockSet blocks) {
        Key[] checkKeys = getter.listKeys();
        short prio = getter.getPriorityClass();
        if (logMINOR) {
            Logger.minor(this, "Queueing transient request " + getter + " priority " + prio + " keys " + checkKeys.length);
        }
        ArrayList<Key> finalKeysToCheck = new ArrayList<Key>(checkKeys.length);
        DatastoreChecker datastoreChecker = this;
        synchronized (datastoreChecker) {
            for (Key key : checkKeys) {
                finalKeysToCheck.add(key);
            }
            QueueItem queueItem = new QueueItem(finalKeysToCheck.toArray(new Key[finalKeysToCheck.size()]), getter, blocks);
            if (logMINOR && this.queue[prio].contains(queueItem)) {
                Logger.error(this, "Transient request " + getter + " is already queued!");
                return;
            }
            this.queue[prio].add(queueItem);
            this.wakeUp();
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (!this.realRun()) {
                }
                return;
            }
            catch (Throwable t) {
                Logger.error(this, "Caught " + t + " in datastore checker thread", t);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean realRun() {
        Random random = null;
        Key[] keys = null;
        SendableGet getter = null;
        ClientRequestScheduler sched = null;
        BlockSet blocks = null;
        boolean waited = false;
        DatastoreChecker datastoreChecker = this;
        synchronized (datastoreChecker) {
            while (true) {
                for (int prio = 0; prio < this.queue.length; prio = (int)((short)(prio + 1))) {
                    QueueItem trans = this.queue[prio].pollFirst();
                    if (trans == null) continue;
                    keys = trans.keys;
                    getter = trans.getter;
                    blocks = trans.blockSet;
                    if (!logMINOR) break;
                    Logger.minor(this, "Checking transient request " + getter + " prio " + prio + " of " + this.queue[prio].size());
                    break;
                }
                if (keys != null) break;
                if (logMINOR) {
                    Logger.minor(this, "Waiting for more transient requests");
                }
                if (this.lazy) {
                    this.running = false;
                    return true;
                }
                waited = true;
                try {
                    this.wait(TimeUnit.SECONDS.toMillis(100L));
                }
                catch (InterruptedException prio) {}
            }
        }
        sched = getter.getScheduler(this.context);
        boolean anyValid = false;
        for (Key key : keys) {
            if (random != null && random.nextInt(100) < 0) {
                anyValid = true;
                continue;
            }
            KeyBlock block = blocks != null ? blocks.get(key) : this.node.fetch(key, true, true, false, false, null);
            if (block != null) {
                if (logMINOR) {
                    Logger.minor(this, "Found key");
                }
                if (key instanceof NodeSSK) {
                    sched.tripPendingKey(block);
                    continue;
                }
                sched.tripPendingKey(block);
                continue;
            }
            anyValid = true;
        }
        if (logMINOR) {
            Logger.minor(this, "Checked " + keys.length + " keys");
        }
        if (getter.persistent()) {
            final SendableGet get = getter;
            final ClientRequestScheduler scheduler = sched;
            final boolean valid = anyValid;
            try {
                this.context.jobRunner.queue(new PersistentJob(){

                    @Override
                    public boolean run(ClientContext context) {
                        try {
                            scheduler.finishRegister(new SendableGet[]{get}, true, valid);
                        }
                        catch (Throwable t) {
                            Logger.error(this, "Failed to register " + get + ": " + t, t);
                            try {
                                get.onFailure(new LowLevelGetException(3, "Internal error: " + t, t), null, context);
                            }
                            catch (Throwable t1) {
                                Logger.error(this, "Failed to fail: " + t, t);
                            }
                        }
                        return false;
                    }

                    public String toString() {
                        return "DatastoreCheckerFinishRegister";
                    }
                }, NativeThread.NORM_PRIORITY);
            }
            catch (PersistenceDisabledException persistenceDisabledException) {}
        } else {
            sched.finishRegister(new SendableGet[]{getter}, false, anyValid);
        }
        return false;
    }

    synchronized void wakeUp() {
        if (this.lazy && !this.running) {
            this.start();
            return;
        }
        this.notifyAll();
    }

    public synchronized void start() {
        if (this.lazy) {
            if (this.isEmpty()) {
                return;
            }
            if (this.running) {
                return;
            }
        }
        this.running = true;
        this.executor.execute(this, this.threadName);
    }

    private synchronized boolean isEmpty() {
        for (ArrayDeque<QueueItem> q : this.queue) {
            if (q.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getPriority() {
        return NativeThread.NORM_PRIORITY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequest(SendableGet request, boolean persistent, ClientContext context, short prio) {
        if (logMINOR) {
            Logger.minor(this, "Removing request prio=" + prio + " persistent=" + persistent);
        }
        QueueItem requestMatcher = new QueueItem(null, request, null);
        DatastoreChecker datastoreChecker = this;
        synchronized (datastoreChecker) {
            if (!this.queue[prio].remove(requestMatcher)) {
                return;
            }
        }
        if (logMINOR) {
            Logger.minor(this, "Removed transient request");
        }
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }

    private static class QueueItem {
        final SendableGet getter;
        Key[] keys;
        final BlockSet blockSet;

        QueueItem(Key[] keys, SendableGet getter, BlockSet blockSet) {
            this.getter = getter;
            this.keys = keys;
            this.blockSet = blockSet;
        }

        public boolean equals(Object o) {
            if (!(o instanceof QueueItem)) {
                return false;
            }
            return this.getter == ((QueueItem)o).getter;
        }

        public int hashCode() {
            if (this.getter == null) {
                return 0;
            }
            return this.getter.hashCode();
        }
    }
}

