/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.client.InsertException;
import freenet.client.async.ChosenBlock;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequester;
import freenet.client.async.PersistentJob;
import freenet.client.async.SplitFileInserter;
import freenet.client.async.SplitFileInserterSegmentStorage;
import freenet.client.async.SplitFileInserterStorage;
import freenet.keys.CHKBlock;
import freenet.keys.ClientCHK;
import freenet.keys.ClientCHKBlock;
import freenet.keys.ClientKey;
import freenet.keys.KeyBlock;
import freenet.node.KeysFetchingLocally;
import freenet.node.LowLevelPutException;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.node.RequestScheduler;
import freenet.node.SendableInsert;
import freenet.node.SendableRequestItem;
import freenet.node.SendableRequestSender;
import freenet.store.KeyCollisionException;
import freenet.support.Logger;
import freenet.support.io.ResumeFailedException;
import java.io.IOException;

public class SplitFileInserterSender
extends SendableInsert {
    final SplitFileInserter parent;
    final SplitFileInserterStorage storage;
    final MySendableRequestSender sender = new MySendableRequestSender();

    public SplitFileInserterSender(SplitFileInserter parent, SplitFileInserterStorage storage) {
        super(parent.persistent, parent.realTime);
        this.parent = parent;
        this.storage = storage;
    }

    @Override
    public void onSuccess(SendableRequestItem keyNum, ClientKey key, ClientContext context) {
        SplitFileInserterSegmentStorage.BlockInsert block = (SplitFileInserterSegmentStorage.BlockInsert)keyNum;
        block.segment.onInsertedBlock(block.blockNumber, (ClientCHK)key);
    }

    @Override
    public void onFailure(LowLevelPutException e, SendableRequestItem keyNum, ClientContext context) {
        InsertException e1 = InsertException.constructFrom(e);
        if (keyNum == null) {
            this.storage.fail(e1);
        } else {
            SplitFileInserterSegmentStorage.BlockInsert block = (SplitFileInserterSegmentStorage.BlockInsert)keyNum;
            block.segment.onFailure(block.blockNumber, e1);
        }
    }

    @Override
    public boolean canWriteClientCache() {
        return this.parent.ctx.canWriteClientCache;
    }

    @Override
    public boolean localRequestOnly() {
        return this.parent.ctx.localRequestOnly;
    }

    @Override
    public boolean forkOnCacheable() {
        return this.parent.ctx.forkOnCacheable;
    }

    @Override
    public void onEncode(SendableRequestItem token, ClientKey key, ClientContext context) {
        SplitFileInserterSegmentStorage.BlockInsert block = (SplitFileInserterSegmentStorage.BlockInsert)token;
        try {
            if (this.storage.hasFinished()) {
                return;
            }
            block.segment.setKey(block.blockNumber, (ClientCHK)key);
        }
        catch (IOException e) {
            if (this.storage.hasFinished()) {
                return;
            }
            this.storage.failOnDiskError(e);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.isCancelled();
    }

    @Override
    protected void innerOnResume(ClientContext context) throws InsertException, ResumeFailedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getPriorityClass() {
        return this.parent.parent.getPriorityClass();
    }

    @Override
    public SendableRequestItem chooseKey(KeysFetchingLocally keys, ClientContext context) {
        return this.storage.chooseBlock();
    }

    @Override
    public long countAllKeys(ClientContext context) {
        return this.storage.countAllKeys();
    }

    @Override
    public long countSendableKeys(ClientContext context) {
        return this.storage.countSendableKeys();
    }

    @Override
    public SendableRequestSender getSender(ClientContext context) {
        return this.sender;
    }

    @Override
    public boolean isCancelled() {
        return this.storage.hasFinished();
    }

    @Override
    public RequestClient getClient() {
        return this.parent.parent.getClient();
    }

    @Override
    public ClientRequester getClientRequest() {
        return this.parent.parent;
    }

    @Override
    public boolean isSSK() {
        return false;
    }

    public void schedule(ClientContext context) {
        if (this.getParentGrabArray() != null) {
            return;
        }
        context.getChkInsertScheduler(this.parent.realTime).registerInsert(this, this.persistent);
    }

    @Override
    public long getWakeupTime(ClientContext context, long now) {
        return this.storage.getWakeupTime(context, now);
    }

    class MySendableRequestSender
    implements SendableRequestSender {
        MySendableRequestSender() {
        }

        @Override
        public boolean send(NodeClientCore node, RequestScheduler sched, ClientContext context, final ChosenBlock request) {
            final SplitFileInserterSegmentStorage.BlockInsert token = (SplitFileInserterSegmentStorage.BlockInsert)request.token;
            try {
                ClientCHKBlock clientBlock = token.segment.encodeBlock(token.blockNumber);
                CHKBlock block = clientBlock.getBlock();
                final ClientCHK key = clientBlock.getClientKey();
                context.getJobRunner(request.isPersistent()).queueNormalOrDrop(new PersistentJob(){

                    @Override
                    public boolean run(ClientContext context) {
                        SplitFileInserterSender.this.onEncode(token, key, context);
                        return false;
                    }
                });
                if (request.localRequestOnly) {
                    try {
                        node.node.store((KeyBlock)block, false, request.canWriteClientCache, true, false);
                    }
                    catch (KeyCollisionException e) {
                        throw new LowLevelPutException(5);
                    }
                } else {
                    node.realPut(block, request.canWriteClientCache, request.forkOnCacheable, false, false, request.realTimeFlag);
                }
                request.onInsertSuccess(key, context);
                return true;
            }
            catch (LowLevelPutException e) {
                request.onFailure(e, context);
                return true;
            }
            catch (IOException e) {
                context.getJobRunner(request.isPersistent()).queueNormalOrDrop(new PersistentJob(){

                    @Override
                    public boolean run(ClientContext context) {
                        try {
                            SplitFileInserterSender.this.storage.failOnDiskError(e);
                        }
                        finally {
                            request.onFailure(new LowLevelPutException(1, "Disk error", e), context);
                        }
                        return true;
                    }
                });
                return true;
            }
            catch (Throwable t) {
                Logger.error(this, "Failed to send insert: " + t, t);
                request.onFailure(new LowLevelPutException(1, "Failed: " + t, t), context);
                return true;
            }
        }

        @Override
        public boolean sendIsBlocking() {
            return true;
        }
    }
}

