/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.NodeHelloMessage;
import freenet.node.Node;
import freenet.support.SimpleFieldSet;

public class ClientHelloMessage
extends FCPMessage {
    public static final String NAME = "ClientHello";
    String clientName;
    String clientExpectedVersion;

    public ClientHelloMessage(SimpleFieldSet fs) throws MessageInvalidException {
        this.clientName = fs.get("Name");
        this.clientExpectedVersion = fs.get("ExpectedVersion");
        if (this.clientName == null) {
            throw new MessageInvalidException(5, "ClientHello must contain a Name field", null, false);
        }
        if (this.clientExpectedVersion == null) {
            throw new MessageInvalidException(5, "ClientHello must contain a ExpectedVersion field", null, false);
        }
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.putSingle("Name", this.clientName);
        sfs.putSingle("ExpectedVersion", this.clientExpectedVersion);
        return sfs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(FCPConnectionHandler handler, Node node) {
        NodeHelloMessage msg = new NodeHelloMessage(handler.connectionIdentifier);
        handler.send(msg);
        handler.setClientName(this.clientName);
    }
}

