/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.async.ClientContext;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.PersistentJob;
import freenet.clients.fcp.ClientRequest;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FCPMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.clients.fcp.ProtocolErrorMessage;
import freenet.node.Node;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.io.NativeThread;

public class RemovePersistentRequest
extends FCPMessage {
    static final String NAME = "RemoveRequest";
    static final String ALT_NAME = "RemovePersistentRequest";
    final String identifier;
    final boolean global;

    public RemovePersistentRequest(SimpleFieldSet fs) throws MessageInvalidException {
        this.global = fs.getBoolean("Global", false);
        this.identifier = fs.get("Identifier");
        if (this.identifier == null) {
            throw new MessageInvalidException(5, "Must have Identifier", null, this.global);
        }
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        return fs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void run(final FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        ClientRequest req = handler.removePersistentRebootRequest(this.global, this.identifier);
        if (req == null && !this.global) {
            req = handler.removeRequestByIdentifier(this.identifier, true);
        }
        if (req == null) {
            try {
                handler.server.core.clientContext.jobRunner.queue(new PersistentJob(){

                    @Override
                    public boolean run(ClientContext context) {
                        try {
                            ClientRequest req = handler.removePersistentForeverRequest(RemovePersistentRequest.this.global, RemovePersistentRequest.this.identifier);
                            if (req == null) {
                                Logger.error(this, "Huh ? the request is null!");
                                return false;
                            }
                            return true;
                        }
                        catch (MessageInvalidException e) {
                            ProtocolErrorMessage err = new ProtocolErrorMessage(e.protocolCode, false, e.getMessage(), e.ident, e.global);
                            handler.send(err);
                            return false;
                        }
                    }
                }, NativeThread.HIGH_PRIORITY);
            }
            catch (PersistenceDisabledException e) {
                ProtocolErrorMessage err = new ProtocolErrorMessage(33, false, "Persistence disabled and non-persistent request not found", this.identifier, this.global);
                handler.send(err);
            }
        }
    }
}

