/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.Peer;
import freenet.node.Node;
import freenet.node.NodeARKInserter;
import freenet.node.NodeCrypto;
import freenet.node.NodeIPDetector;
import freenet.node.PeerNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.transport.ip.IPUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NodeIPPortDetector {
    final Node node;
    final NodeIPDetector ipDetector;
    final NodeCrypto crypto;
    private final NodeARKInserter arkPutter;
    Peer[] lastPeers;
    private static volatile boolean logMINOR;

    NodeIPPortDetector(Node node, NodeIPDetector ipDetector, NodeCrypto crypto, boolean enableARKs) {
        this.node = node;
        this.ipDetector = ipDetector;
        this.crypto = crypto;
        this.arkPutter = new NodeARKInserter(node, crypto, this, enableARKs);
        ipDetector.addPortDetector(this);
    }

    FreenetInetAddress[] detectPrimaryIPAddress() {
        FreenetInetAddress addr = this.crypto.getBindTo();
        if (addr.isRealInternetAddress(false, true, false)) {
            return new FreenetInetAddress[]{addr};
        }
        return this.ipDetector.detectPrimaryIPAddress(!this.crypto.config.includeLocalAddressesInNoderefs);
    }

    Peer[] detectPrimaryPeers() {
        FreenetInetAddress[] addrs;
        boolean logMINOR = NodeIPPortDetector.logMINOR;
        ArrayList<Object> addresses = new ArrayList<Object>();
        for (FreenetInetAddress addr : addrs = this.detectPrimaryIPAddress()) {
            addresses.add(new Peer(addr, this.crypto.portNumber));
            if (!logMINOR) continue;
            Logger.minor(this, "Adding " + addr);
        }
        PeerNode[] peerList = this.crypto.getPeerNodes();
        if (peerList != null) {
            Object p;
            HashMap<Object, Integer> countsByPeer = new HashMap<Object, Integer>();
            for (PeerNode pn : peerList) {
                p = pn.getRemoteDetectedPeer();
                if (p == null || ((Peer)p).isNull() || !IPUtil.isValidAddress(((Peer)p).getAddress(true), false)) continue;
                if (logMINOR) {
                    Logger.minor(this, "Peer " + pn.getPeer() + " thinks we are " + p);
                }
                if (countsByPeer.containsKey(p)) {
                    countsByPeer.put(p, (Integer)countsByPeer.get(p) + 1);
                    continue;
                }
                countsByPeer.put(p, 1);
            }
            if (countsByPeer.size() == 1) {
                Iterator it = countsByPeer.keySet().iterator();
                Peer p2 = (Peer)it.next();
                Logger.minor(this, "Everyone agrees we are " + p2);
                if (!addresses.contains(p2)) {
                    addresses.add(p2);
                }
            } else if (countsByPeer.size() > 1) {
                Peer best = null;
                Peer secondBest = null;
                int bestPopularity = 0;
                int secondBestPopularity = 0;
                for (Map.Entry entry : countsByPeer.entrySet()) {
                    Peer cur = (Peer)entry.getKey();
                    int curPop = (Integer)entry.getValue();
                    Logger.normal(this, "Detected peer: " + cur + " popularity " + curPop);
                    if (curPop < bestPopularity) continue;
                    secondBestPopularity = bestPopularity;
                    bestPopularity = curPop;
                    secondBest = best;
                    best = cur;
                }
                if (best != null && (bestPopularity > 1 || addrs.length == 0)) {
                    if (!addresses.contains(best)) {
                        Logger.normal(this, "Adding best peer " + best + " (" + bestPopularity + ')');
                        addresses.add(best);
                    }
                    if (secondBest != null && secondBestPopularity > 1) {
                        if (!addresses.contains(secondBest)) {
                            Logger.normal(this, "Adding second best peer " + secondBest + " (" + secondBest + ')');
                            addresses.add(secondBest);
                        }
                        if (best.getAddress().equals(secondBest.getAddress()) && bestPopularity == 1) {
                            Logger.error(this, "Hrrrm, maybe this is a symmetric NAT? Expect trouble connecting!");
                            System.err.println("Hrrrm, maybe this is a symmetric NAT? Expect trouble connecting!");
                            this.ipDetector.setMaybeSymmetric();
                            p = new Peer(best.getFreenetAddress(), this.crypto.portNumber);
                            if (!addresses.contains(p)) {
                                addresses.add(p);
                            }
                        }
                    }
                }
            }
        }
        this.lastPeers = addresses.toArray(new Peer[addresses.size()]);
        if (logMINOR) {
            Logger.minor(this, "Returning for port " + this.crypto.portNumber + " : " + Arrays.toString(this.lastPeers));
        }
        return this.lastPeers;
    }

    void update() {
        this.arkPutter.update();
    }

    void startARK() {
        this.arkPutter.start();
    }

    public Peer[] getPrimaryPeers() {
        if (this.lastPeers == null) {
            return this.detectPrimaryPeers();
        }
        return this.lastPeers;
    }

    public boolean includes(FreenetInetAddress addr) {
        FreenetInetAddress[] a;
        for (FreenetInetAddress ai : a = this.detectPrimaryIPAddress()) {
            if (!ai.equals(addr)) continue;
            return true;
        }
        return false;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

