/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.fcp;

import freenet.client.DefaultMIMETypes;
import freenet.client.async.ClientContext;
import freenet.client.filter.ContentFilter;
import freenet.client.filter.FilterOperation;
import freenet.client.filter.UnsafeContentTypeException;
import freenet.clients.fcp.DataCarryingMessage;
import freenet.clients.fcp.DataSource;
import freenet.clients.fcp.FCPConnectionHandler;
import freenet.clients.fcp.FilterResultMessage;
import freenet.clients.fcp.MessageInvalidException;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.api.BucketFactory;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.Closer;
import freenet.support.io.FileBucket;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;

public class FilterMessage
extends DataCarryingMessage {
    public static final String NAME = "Filter";
    private final String identifier;
    private final FilterOperation operation;
    private final DataSource dataSource;
    private final String mimeType;
    private final long dataLength;
    private final String filename;
    private final BucketFactory bf;

    public FilterMessage(SimpleFieldSet fs, BucketFactory bf) throws MessageInvalidException {
        String ds;
        String op;
        try {
            this.identifier = fs.getString("Identifier");
        }
        catch (FSParseException e) {
            throw new MessageInvalidException(5, "Must contain an Identifier field", null, false);
        }
        try {
            op = fs.getString("Operation");
        }
        catch (FSParseException e) {
            throw new MessageInvalidException(5, "Must contain an Operation field", this.identifier, false);
        }
        try {
            this.operation = FilterOperation.valueOf(op);
        }
        catch (IllegalArgumentException e) {
            throw new MessageInvalidException(8, "Illegal Operation value", this.identifier, false);
        }
        try {
            ds = fs.getString("DataSource");
        }
        catch (FSParseException e) {
            throw new MessageInvalidException(5, "Must contain a DataSource field", this.identifier, false);
        }
        try {
            this.dataSource = DataSource.valueOf(ds);
        }
        catch (IllegalArgumentException e) {
            throw new MessageInvalidException(8, "Illegal DataSource value", this.identifier, false);
        }
        String inputMimeType = fs.get("MimeType");
        this.filename = fs.get("Filename");
        if (this.dataSource == DataSource.DIRECT) {
            this.mimeType = inputMimeType;
            if (this.mimeType == null) {
                throw new MessageInvalidException(5, "Must contain a MimeType field", this.identifier, false);
            }
            String dl = fs.get("DataLength");
            if (dl == null) {
                throw new MessageInvalidException(5, "Must contain a DataLength field", this.identifier, false);
            }
            try {
                this.dataLength = fs.getLong("DataLength");
            }
            catch (FSParseException e) {
                throw new MessageInvalidException(6, "DataLength field must be a long", this.identifier, false);
            }
        } else if (this.dataSource == DataSource.DISK) {
            if (this.filename == null) {
                throw new MessageInvalidException(5, "Must contain a Filename field", this.identifier, false);
            }
            File file = new File(this.filename);
            if (!file.exists()) {
                throw new MessageInvalidException(9, null, this.identifier, false);
            }
            if (!file.isFile()) {
                throw new MessageInvalidException(23, null, this.identifier, false);
            }
            if (!file.canRead()) {
                throw new MessageInvalidException(26, null, this.identifier, false);
            }
            if (inputMimeType != null) {
                this.mimeType = inputMimeType;
            } else {
                this.mimeType = this.bestGuessMimeType(this.filename);
                if (this.mimeType == null) {
                    throw new MessageInvalidException(35, "Could not determine MIME type from filename", this.identifier, false);
                }
            }
            this.dataLength = -1L;
            this.bucket = new FileBucket(file, true, false, false, false);
        } else {
            throw new MessageInvalidException(8, "Illegal DataSource value", this.identifier, false);
        }
        this.bf = bf;
    }

    @Override
    String getIdentifier() {
        return this.identifier;
    }

    @Override
    boolean isGlobal() {
        return false;
    }

    @Override
    long dataLength() {
        return this.dataLength;
    }

    @Override
    public SimpleFieldSet getFieldSet() {
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("Identifier", this.identifier);
        fs.putOverwrite("Operation", this.operation.name());
        fs.putOverwrite("DataSource", this.dataSource.name());
        fs.putOverwrite("MimeType", this.mimeType);
        fs.putOverwrite("Filename", this.filename);
        fs.put("DataLength", this.dataLength);
        return fs;
    }

    @Override
    public String getName() {
        return NAME;
    }

    /*
     * Loose catch block
     */
    @Override
    public void run(FCPConnectionHandler handler, Node node) throws MessageInvalidException {
        RandomAccessBucket resultBucket;
        if (this.bucket == null) {
            throw new MessageInvalidException(5, "Must contain data", this.identifier, false);
        }
        try {
            resultBucket = this.bf.makeBucket(-1L);
        }
        catch (IOException e) {
            Logger.error(this, "Failed to create temporary bucket", (Throwable)e);
            throw new MessageInvalidException(17, e.toString(), this.identifier, false);
        }
        String resultCharset = null;
        String resultMimeType = null;
        boolean unsafe = false;
        InputStream input = null;
        OutputStream output = null;
        try {
            input = this.bucket.getInputStream();
            output = resultBucket.getOutputStream();
            ContentFilter.FilterStatus status = this.applyFilter(input, output, handler.server.core.clientContext);
            resultCharset = status.charset;
            resultMimeType = status.mimeType;
        }
        catch (UnsafeContentTypeException e) {
            unsafe = true;
            Closer.close(input);
            Closer.close(output);
        }
        catch (IOException e2) {
            Logger.error(this, "IO error running content filter", (Throwable)e2);
            throw new MessageInvalidException(17, e2.toString(), this.identifier, false);
            {
                catch (Throwable throwable) {
                    Closer.close(input);
                    Closer.close(output);
                    throw throwable;
                }
            }
        }
        Closer.close(input);
        Closer.close(output);
        FilterResultMessage response = new FilterResultMessage(this.identifier, resultCharset, resultMimeType, unsafe, resultBucket);
        handler.send(response);
    }

    private ContentFilter.FilterStatus applyFilter(InputStream input, OutputStream output, ClientContext clientContext) throws MessageInvalidException, UnsafeContentTypeException, IOException {
        URI fakeUri;
        try {
            fakeUri = new URI("http://127.0.0.1:8888/");
        }
        catch (URISyntaxException e) {
            Logger.error(this, "Inexplicable URI error", (Throwable)e);
            throw new MessageInvalidException(17, e.toString(), this.identifier, false);
        }
        return ContentFilter.filter(input, output, this.mimeType, fakeUri, null, null, null, null, clientContext.linkFilterExceptionProvider);
    }

    private String bestGuessMimeType(String filename) {
        String guessedMimeType = null;
        if (filename != null) {
            guessedMimeType = DefaultMIMETypes.guessMIMEType(filename, true);
        }
        return guessedMimeType;
    }
}

