/*
 * Decompiled with CFR 0.152.
 */
package freenet.clients.http;

import freenet.client.HighLevelSimpleClient;
import freenet.clients.http.ExternalLinkToadlet;
import freenet.clients.http.PageNode;
import freenet.clients.http.RedirectException;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContainer;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.clients.http.wizardsteps.PageHelper;
import freenet.clients.http.wizardsteps.WizardL10n;
import freenet.l10n.NodeL10n;
import freenet.node.MasterKeysFileSizeException;
import freenet.node.MasterKeysWrongPasswordException;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.SecurityLevels;
import freenet.support.HTMLNode;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.api.HTTPRequest;
import freenet.support.io.FileUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;

public class SecurityLevelsToadlet
extends Toadlet {
    public static final int MAX_PASSWORD_LENGTH = 1024;
    private final NodeClientCore core;
    private final Node node;
    private static volatile boolean logMINOR;
    static final String PATH = "/seclevels/";

    SecurityLevelsToadlet(HighLevelSimpleClient client, Node node, NodeClientCore core) {
        super(client);
        this.core = core;
        this.node = node;
    }

    public void handleMethodPOST(URI uri, HTTPRequest request, ToadletContext ctx) throws ToadletContextClosedException, IOException, RedirectException {
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        if (request.isPartSet("seclevels")) {
            HTMLNode pageNode = null;
            HTMLNode content = null;
            HTMLNode ul = null;
            HTMLNode formNode = null;
            boolean changedAnything = false;
            String configName = "security-levels.networkThreatLevel";
            String confirm = "security-levels.networkThreatLevel.confirm";
            String tryConfirm = "security-levels.networkThreatLevel.tryConfirm";
            String networkThreatLevel = request.getPartAsStringFailsafe(configName, 128);
            SecurityLevels.NETWORK_THREAT_LEVEL newThreatLevel = SecurityLevels.parseNetworkThreatLevel(networkThreatLevel);
            if (newThreatLevel != null && newThreatLevel != this.node.securityLevels.getNetworkThreatLevel()) {
                if (!request.isPartSet(confirm) && !request.isPartSet(tryConfirm)) {
                    HTMLNode warning = this.node.securityLevels.getConfirmWarning(newThreatLevel, confirm);
                    if (warning != null) {
                        PageNode page = ctx.getPageMaker().getPageNode(NodeL10n.getBase().getString("ConfigToadlet.fullTitle"), ctx);
                        pageNode = page.outer;
                        content = page.content;
                        formNode = ctx.addFormChild(content, ".", "configFormSecLevels");
                        ul = formNode.addChild("ul", "class", "config");
                        HTMLNode seclevelGroup = ul.addChild("li");
                        seclevelGroup.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", configName, networkThreatLevel});
                        HTMLNode infobox = seclevelGroup.addChild("div", "class", "infobox infobox-information");
                        infobox.addChild("div", "class", "infobox-header", SecurityLevelsToadlet.l10nSec("networkThreatLevelConfirmTitle", "mode", SecurityLevels.localisedName(newThreatLevel)));
                        HTMLNode infoboxContent = infobox.addChild("div", "class", "infobox-content");
                        infoboxContent.addChild(warning);
                        infoboxContent.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", tryConfirm, "on"});
                    } else {
                        this.node.securityLevels.setThreatLevel(newThreatLevel);
                        changedAnything = true;
                    }
                } else if (request.isPartSet(confirm)) {
                    this.node.securityLevels.setThreatLevel(newThreatLevel);
                    changedAnything = true;
                }
            }
            configName = "security-levels.physicalThreatLevel";
            confirm = "security-levels.physicalThreatLevel.confirm";
            tryConfirm = "security-levels.physicalThreatLevel.tryConfirm";
            String physicalThreatLevel = request.getPartAsStringFailsafe(configName, 128);
            SecurityLevels.PHYSICAL_THREAT_LEVEL newPhysicalLevel = SecurityLevels.parsePhysicalThreatLevel(physicalThreatLevel);
            SecurityLevels.PHYSICAL_THREAT_LEVEL oldPhysicalLevel = this.core.node.securityLevels.getPhysicalThreatLevel();
            if (logMINOR) {
                Logger.minor(this, "New physical threat level: " + (Object)((Object)newPhysicalLevel) + " old = " + (Object)((Object)this.node.securityLevels.getPhysicalThreatLevel()));
            }
            if (newPhysicalLevel != null) {
                String password;
                if (newPhysicalLevel == oldPhysicalLevel && newPhysicalLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.HIGH) {
                    password = request.getPartAsStringFailsafe("masterPassword", 1024);
                    String oldPassword = request.getPartAsStringFailsafe("oldPassword", 1024);
                    String confirmPassword = request.getPartAsStringFailsafe("confirmMasterPassword", 1024);
                    if (!oldPassword.isEmpty() && !confirmPassword.isEmpty() && !password.isEmpty() && password.equals(confirmPassword)) {
                        try {
                            this.core.node.changeMasterPassword(oldPassword, password, false);
                        }
                        catch (MasterKeysWrongPasswordException e) {
                            this.sendChangePasswordForm(ctx, true, false, newPhysicalLevel.name());
                            return;
                        }
                        catch (MasterKeysFileSizeException e) {
                            this.sendPasswordFileCorruptedPage(e.isTooBig(), ctx, false, true);
                            if (changedAnything) {
                                this.core.storeConfig();
                            }
                            return;
                        }
                        catch (Node.AlreadySetPasswordException e) {
                            this.sendChangePasswordForm(ctx, false, true, newPhysicalLevel.name());
                            if (changedAnything) {
                                this.core.storeConfig();
                            }
                            return;
                        }
                    } else if (!(password.isEmpty() && oldPassword.isEmpty() && confirmPassword.isEmpty())) {
                        this.sendChangePasswordForm(ctx, false, true, newPhysicalLevel.name());
                        if (changedAnything) {
                            this.core.storeConfig();
                        }
                        return;
                    }
                }
                if (newPhysicalLevel != oldPhysicalLevel) {
                    if (newPhysicalLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.HIGH && this.node.securityLevels.getPhysicalThreatLevel() != newPhysicalLevel) {
                        password = request.getPartAsStringFailsafe("masterPassword", 1024);
                        String confirmPassword = request.getPartAsStringFailsafe("confirmMasterPassword", 1024);
                        if (!password.isEmpty() && !confirmPassword.isEmpty() && password.equals(confirmPassword)) {
                            try {
                                if (oldPhysicalLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.NORMAL || oldPhysicalLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.LOW) {
                                    this.core.node.changeMasterPassword("", password, false);
                                }
                                this.core.node.setMasterPassword(password, false);
                            }
                            catch (Node.AlreadySetPasswordException e) {
                                this.sendChangePasswordForm(ctx, false, false, newPhysicalLevel.name());
                                return;
                            }
                            catch (MasterKeysWrongPasswordException e) {
                                System.err.println("Wrong password!");
                                PageNode page = ctx.getPageMaker().getPageNode(SecurityLevelsToadlet.l10nSec("passwordPageTitle"), ctx);
                                pageNode = page.outer;
                                HTMLNode contentNode = page.content;
                                content = ctx.getPageMaker().getInfobox("infobox-error", SecurityLevelsToadlet.l10nSec("passwordWrongTitle"), contentNode, "wrong-password", true).addChild("div", "class", "infobox-content");
                                SecurityLevelsToadlet.generatePasswordFormPage(true, ctx.getContainer(), content, false, false, true, newPhysicalLevel.name(), null);
                                SecurityLevelsToadlet.addBackToSeclevelsLink(content);
                                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                                if (changedAnything) {
                                    this.core.storeConfig();
                                }
                                return;
                            }
                            catch (MasterKeysFileSizeException e) {
                                this.sendPasswordFileCorruptedPage(e.isTooBig(), ctx, false, true);
                                if (changedAnything) {
                                    this.core.storeConfig();
                                }
                                return;
                            }
                        } else {
                            if (password.isEmpty() || confirmPassword.isEmpty()) {
                                this.sendPasswordPage(ctx, true, newPhysicalLevel.name());
                            } else {
                                this.sendPasswordPageMismatch(ctx, newPhysicalLevel.name());
                            }
                            if (changedAnything) {
                                this.core.storeConfig();
                            }
                            return;
                        }
                    }
                    if ((newPhysicalLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.LOW || newPhysicalLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.NORMAL) && oldPhysicalLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.HIGH) {
                        password = request.getPartAsStringFailsafe("masterPassword", 1024);
                        if (!password.isEmpty()) {
                            try {
                                this.core.node.changeMasterPassword(password, "", false);
                            }
                            catch (IOException e) {
                                if (!this.core.node.getMasterPasswordFile().exists()) {
                                    System.out.println("Master password file no longer exists, assuming this is deliberate");
                                }
                                System.err.println("Cannot change password as cannot write new passwords file: " + e);
                                e.printStackTrace();
                                String msg = "<html><head><title>" + SecurityLevelsToadlet.l10nSec("cantWriteNewMasterKeysFileTitle") + "</title></head><body><h1>" + SecurityLevelsToadlet.l10nSec("cantWriteNewMasterKeysFileTitle") + "</h1><p>" + SecurityLevelsToadlet.l10nSec("cantWriteNewMasterKeysFile") + "<pre>";
                                StringWriter sw = new StringWriter();
                                PrintWriter pw = new PrintWriter(sw);
                                e.printStackTrace(pw);
                                pw.flush();
                                msg = msg + sw.toString() + "</pre></body></html>";
                                this.writeHTMLReply(ctx, 500, "Internal Error", msg);
                                if (changedAnything) {
                                    this.core.storeConfig();
                                }
                                return;
                            }
                            catch (MasterKeysWrongPasswordException e) {
                                System.err.println("Wrong password!");
                                PageNode page = ctx.getPageMaker().getPageNode(SecurityLevelsToadlet.l10nSec("passwordForDecryptTitle"), ctx);
                                pageNode = page.outer;
                                HTMLNode contentNode = page.content;
                                content = ctx.getPageMaker().getInfobox("infobox-error", SecurityLevelsToadlet.l10nSec("passwordWrongTitle"), contentNode, "wrong-password", true).addChild("div", "class", "infobox-content");
                                SecurityLevelsToadlet.generatePasswordFormPage(true, ctx.getContainer(), content, false, true, false, newPhysicalLevel.name(), null);
                                SecurityLevelsToadlet.addBackToSeclevelsLink(content);
                                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                                if (changedAnything) {
                                    this.core.storeConfig();
                                }
                                return;
                            }
                            catch (MasterKeysFileSizeException e) {
                                this.sendPasswordFileCorruptedPage(e.isTooBig(), ctx, false, true);
                                if (changedAnything) {
                                    this.core.storeConfig();
                                }
                                return;
                            }
                            catch (Node.AlreadySetPasswordException e) {
                                this.sendChangePasswordForm(ctx, false, true, newPhysicalLevel.name());
                                if (changedAnything) {
                                    this.core.storeConfig();
                                }
                                return;
                            }
                        } else if (this.core.node.getMasterPasswordFile().exists()) {
                            PageNode page = ctx.getPageMaker().getPageNode(SecurityLevelsToadlet.l10nSec("passwordForDecryptTitle"), ctx);
                            pageNode = page.outer;
                            HTMLNode contentNode = page.content;
                            content = ctx.getPageMaker().getInfobox("infobox-error", SecurityLevelsToadlet.l10nSec("passwordForDecryptTitle"), contentNode, "password-prompt", false).addChild("div", "class", "infobox-content");
                            if (password.isEmpty()) {
                                content.addChild("p", SecurityLevelsToadlet.l10nSec("passwordNotZeroLength"));
                            }
                            SecurityLevelsToadlet.generatePasswordFormPage(false, ctx.getContainer(), content, false, true, false, newPhysicalLevel.name(), null);
                            SecurityLevelsToadlet.addBackToSeclevelsLink(content);
                            this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                            if (changedAnything) {
                                this.core.storeConfig();
                            }
                            return;
                        }
                    }
                    if (newPhysicalLevel == SecurityLevels.PHYSICAL_THREAT_LEVEL.MAXIMUM) {
                        try {
                            this.core.node.killMasterKeysFile();
                        }
                        catch (IOException e) {
                            this.sendCantDeleteMasterKeysFile(ctx, newPhysicalLevel.name());
                            return;
                        }
                    }
                    this.node.securityLevels.setThreatLevel(newPhysicalLevel);
                    changedAnything = true;
                }
            }
            if (changedAnything) {
                this.core.storeConfig();
            }
            if (pageNode != null) {
                formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "seclevels", "on"});
                formNode.addChild("input", new String[]{"type", "value"}, new String[]{"submit", SecurityLevelsToadlet.l10n("apply")});
                formNode.addChild("input", new String[]{"type", "value"}, new String[]{"reset", SecurityLevelsToadlet.l10n("undo")});
                this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
                return;
            }
            MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
            headers.put("Location", PATH);
            ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
            return;
        }
        if (request.isPartSet("masterPassword")) {
            String to;
            String masterPassword = request.getPartAsStringFailsafe("masterPassword", 1024);
            if (masterPassword.isEmpty()) {
                this.sendPasswordPage(ctx, true, null);
                return;
            }
            System.err.println("Setting master password");
            try {
                this.node.setMasterPassword(masterPassword, false);
            }
            catch (Node.AlreadySetPasswordException e) {
                System.err.println("Already set master password");
                Logger.error(this, "Already set master password");
                MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
                headers.put("Location", "/");
                ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                return;
            }
            catch (MasterKeysWrongPasswordException e) {
                this.sendPasswordFormPage(true, ctx);
                return;
            }
            catch (MasterKeysFileSizeException e) {
                this.sendPasswordFileCorruptedPage(e.isTooBig(), ctx, false, false);
                return;
            }
            MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
            if (request.isPartSet("redirect") && (to = request.getPartAsStringFailsafe("redirect", 100)).startsWith("/")) {
                headers.put("Location", to);
                ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
                return;
            }
            headers.put("Location", "/");
            ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
            return;
        }
        try {
            throw new RedirectException(PATH);
        }
        catch (URISyntaxException masterPassword) {
            MultiValueTable<String, String> headers = new MultiValueTable<String, String>();
            headers.put("Location", "/");
            ctx.sendReplyHeaders(302, "Found", headers, null, 0L);
            return;
        }
    }

    private void sendCantDeleteMasterKeysFile(ToadletContext ctx, String physicalSecurityLevel) throws ToadletContextClosedException, IOException {
        HTMLNode pageNode = SecurityLevelsToadlet.sendCantDeleteMasterKeysFileInner(ctx, this.node.getMasterPasswordFile().getPath(), false, physicalSecurityLevel, this.node);
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    public static void sendCantDeleteMasterKeysFileInner(PageHelper helper, String filename, String physicalSecurityLevel) {
        HTMLNode contentNode = helper.getPageContent(SecurityLevelsToadlet.l10nSec("cantDeletePasswordFileTitle"));
        HTMLNode content = helper.getInfobox("infobox-error", SecurityLevelsToadlet.l10nSec("cantDeletePasswordFileTitle"), contentNode, "password-error", true).addChild("div", "class", "infobox-content");
        HTMLNode form = helper.addFormChild(content, "/wizard/", "masterPasswordForm");
        SecurityLevelsToadlet.sendCantDeleteMasterKeysFileInner(content, form, filename, physicalSecurityLevel);
    }

    public static HTMLNode sendCantDeleteMasterKeysFileInner(ToadletContext ctx, String filename, boolean forFirstTimeWizard, String physicalSecurityLevel, Node node) {
        PageNode page = ctx.getPageMaker().getPageNode(SecurityLevelsToadlet.l10nSec("cantDeletePasswordFileTitle"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode content = ctx.getPageMaker().getInfobox("infobox-error", SecurityLevelsToadlet.l10nSec("cantDeletePasswordFileTitle"), contentNode, "password-error", true).addChild("div", "class", "infobox-content");
        HTMLNode form = forFirstTimeWizard ? ctx.addFormChild(content, "/wizard/", "masterPasswordForm") : ctx.addFormChild(content, PATH, "masterPasswordForm");
        SecurityLevelsToadlet.sendCantDeleteMasterKeysFileInner(content, form, filename, physicalSecurityLevel);
        return pageNode;
    }

    private static void sendCantDeleteMasterKeysFileInner(HTMLNode content, HTMLNode form, String filename, String physicalSecurityLevel) {
        form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "security-levels.physicalThreatLevel", physicalSecurityLevel});
        form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "seclevels", "true"});
        form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "tryAgain", SecurityLevelsToadlet.l10nSec("cantDeletePasswordFileButton")});
        content.addChild("p", SecurityLevelsToadlet.l10nSec("cantDeletePasswordFile", "filename", filename));
    }

    private void sendChangePasswordForm(ToadletContext ctx, boolean wrongPassword, boolean emptyPassword, String physicalSecurityLevel) throws ToadletContextClosedException, IOException {
        PageNode page = ctx.getPageMaker().getPageNode(SecurityLevelsToadlet.l10nSec("changePasswordTitle"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode content = ctx.getPageMaker().getInfobox("infobox-error", SecurityLevelsToadlet.l10nSec("changePasswordTitle"), contentNode, "password-change", true).addChild("div", "class", "infobox-content");
        if (emptyPassword) {
            content.addChild("p", SecurityLevelsToadlet.l10nSec("passwordNotZeroLength"));
        }
        if (wrongPassword) {
            content.addChild("p", SecurityLevelsToadlet.l10nSec("wrongOldPassword"));
        }
        HTMLNode form = ctx.addFormChild(content, this.path(), "changePasswordForm");
        this.addPasswordChangeForm(form);
        if (physicalSecurityLevel != null) {
            form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "security-levels.physicalThreatLevel", physicalSecurityLevel});
            form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "seclevels", "true"});
        }
        SecurityLevelsToadlet.addBackToSeclevelsLink(content);
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    private void sendPasswordPage(ToadletContext ctx, boolean emptyPassword, String threatlevel) throws ToadletContextClosedException, IOException {
        PageNode page = ctx.getPageMaker().getPageNode(SecurityLevelsToadlet.l10nSec("setPasswordTitle"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode content = ctx.getPageMaker().getInfobox("infobox-error", SecurityLevelsToadlet.l10nSec("setPasswordTitle"), contentNode, "password-prompt", false).addChild("div", "class", "infobox-content");
        if (emptyPassword) {
            content.addChild("p", SecurityLevelsToadlet.l10nSec("passwordNotZeroLength"));
        }
        SecurityLevelsToadlet.generatePasswordFormPage(false, ctx.getContainer(), content, false, false, true, threatlevel, null);
        SecurityLevelsToadlet.addBackToSeclevelsLink(content);
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    private static void addBackToSeclevelsLink(HTMLNode content) {
        content.addChild("p").addChild("a", "href", PATH, SecurityLevelsToadlet.l10nSec("backToSecurityLevels"));
    }

    @Override
    public void handleMethodGET(URI uri, HTTPRequest req, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        if (!ctx.checkFullAccess(this)) {
            return;
        }
        PageNode page = ctx.getPageMaker().getPageNode(NodeL10n.getBase().getString("SecurityLevelsToadlet.fullTitle"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        contentNode.addChild(ctx.getAlertManager().createSummary());
        this.drawSecurityLevelsPage(contentNode, ctx);
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    private void drawSecurityLevelsPage(HTMLNode contentNode, ToadletContext ctx) {
        HTMLNode inner;
        HTMLNode input;
        HTMLNode infobox = contentNode.addChild("div", "class", "infobox infobox-normal");
        infobox.addChild("div", "class", "infobox-header", SecurityLevelsToadlet.l10nSec("title"));
        HTMLNode configNode = infobox.addChild("div", "class", "infobox-content");
        HTMLNode formNode = ctx.addFormChild(configNode, ".", "configFormSecLevels");
        formNode.addChild("div", "class", "configprefix", SecurityLevelsToadlet.l10nSec("networkThreatLevelShort"));
        HTMLNode ul = formNode.addChild("ul", "class", "config");
        HTMLNode seclevelGroup = ul.addChild("li");
        seclevelGroup.addChild("#", SecurityLevelsToadlet.l10nSec("networkThreatLevel.opennetIntro"));
        SecurityLevels.NETWORK_THREAT_LEVEL networkLevel = this.node.securityLevels.getNetworkThreatLevel();
        HTMLNode p = seclevelGroup.addChild("p");
        p.addChild("b", SecurityLevelsToadlet.l10nSec("networkThreatLevel.opennetLabel"));
        p.addChild("#", ": " + SecurityLevelsToadlet.l10nSec("networkThreatLevel.opennetExplain"));
        HTMLNode div = seclevelGroup.addChild("div", "class", "opennetDiv");
        String controlName = "security-levels.networkThreatLevel";
        for (SecurityLevels.NETWORK_THREAT_LEVEL level : SecurityLevels.NETWORK_THREAT_LEVEL.getOpennetValues()) {
            input = level == networkLevel ? div.addChild("p").addChild("input", new String[]{"type", "checked", "name", "value"}, new String[]{"radio", "on", controlName, level.name()}) : div.addChild("p").addChild("input", new String[]{"type", "name", "value"}, new String[]{"radio", controlName, level.name()});
            input.addChild("b", SecurityLevelsToadlet.l10nSec("networkThreatLevel.name." + (Object)((Object)level)));
            input.addChild("#", ": ");
            NodeL10n.getBase().addL10nSubstitution(input, "SecurityLevels.networkThreatLevel.choice." + (Object)((Object)level), new String[]{"bold"}, new HTMLNode[]{HTMLNode.STRONG});
            inner = input.addChild("p").addChild("i");
            NodeL10n.getBase().addL10nSubstitution(inner, "SecurityLevels.networkThreatLevel.desc." + (Object)((Object)level), new String[]{"bold"}, new HTMLNode[]{HTMLNode.STRONG});
        }
        p = seclevelGroup.addChild("p");
        p.addChild("b", SecurityLevelsToadlet.l10nSec("networkThreatLevel.darknetLabel"));
        p.addChild("#", ": " + SecurityLevelsToadlet.l10nSec("networkThreatLevel.darknetExplain"));
        div = seclevelGroup.addChild("div", "class", "darknetDiv");
        for (SecurityLevels.NETWORK_THREAT_LEVEL level : SecurityLevels.NETWORK_THREAT_LEVEL.getDarknetValues()) {
            input = level == networkLevel ? div.addChild("p").addChild("input", new String[]{"type", "checked", "name", "value"}, new String[]{"radio", "on", controlName, level.name()}) : div.addChild("p").addChild("input", new String[]{"type", "name", "value"}, new String[]{"radio", controlName, level.name()});
            input.addChild("b", SecurityLevelsToadlet.l10nSec("networkThreatLevel.name." + (Object)((Object)level)));
            input.addChild("#", ": ");
            NodeL10n.getBase().addL10nSubstitution(input, "SecurityLevels.networkThreatLevel.choice." + (Object)((Object)level), new String[]{"bold"}, new HTMLNode[]{HTMLNode.STRONG});
            inner = input.addChild("p").addChild("i");
            NodeL10n.getBase().addL10nSubstitution(inner, "SecurityLevels.networkThreatLevel.desc." + (Object)((Object)level), new String[]{"bold", "link"}, new HTMLNode[]{HTMLNode.STRONG, HTMLNode.link("/wizard/?step=OPENNET")});
        }
        seclevelGroup.addChild("p").addChild("b", SecurityLevelsToadlet.l10nSec("networkThreatLevel.opennetFriendsWarning"));
        formNode.addChild("div", "class", "configprefix", SecurityLevelsToadlet.l10nSec("physicalThreatLevelShort"));
        ul = formNode.addChild("ul", "class", "config");
        seclevelGroup = ul.addChild("li");
        seclevelGroup.addChild("#", SecurityLevelsToadlet.l10nSec("physicalThreatLevel"));
        NodeL10n.getBase().addL10nSubstitution(seclevelGroup.addChild("p").addChild("i"), "SecurityLevels.physicalThreatLevelFDE", new String[]{"bold", "link"}, new HTMLNode[]{HTMLNode.STRONG, HTMLNode.linkInNewWindow(ExternalLinkToadlet.escape(SecurityLevelsToadlet.l10nSec("physicalThreatLevelFDELink")))});
        HTMLNode swapWarning = seclevelGroup.addChild("p").addChild("i");
        FileUtil.OperatingSystem os = FileUtil.detectedOS;
        swapWarning.addChild("#", NodeL10n.getBase().getString("SecurityLevels.physicalThreatLevelSwapfile", "operatingSystem", NodeL10n.getBase().getString("OperatingSystemName." + os.name())));
        if (os == FileUtil.OperatingSystem.Windows) {
            swapWarning.addChild("#", " " + WizardL10n.l10nSec("physicalThreatLevelSwapfileWindows"));
        }
        SecurityLevels.PHYSICAL_THREAT_LEVEL physicalLevel = this.node.securityLevels.getPhysicalThreatLevel();
        controlName = "security-levels.physicalThreatLevel";
        for (SecurityLevels.PHYSICAL_THREAT_LEVEL level : SecurityLevels.PHYSICAL_THREAT_LEVEL.values()) {
            HTMLNode input2 = level == physicalLevel ? seclevelGroup.addChild("p").addChild("input", new String[]{"type", "checked", "name", "value"}, new String[]{"radio", "on", controlName, level.name()}) : seclevelGroup.addChild("p").addChild("input", new String[]{"type", "name", "value"}, new String[]{"radio", controlName, level.name()});
            input2.addChild("b", SecurityLevelsToadlet.l10nSec("physicalThreatLevel.name." + (Object)((Object)level)));
            input2.addChild("#", ": ");
            NodeL10n.getBase().addL10nSubstitution(input2, "SecurityLevels.physicalThreatLevel.choice." + (Object)((Object)level), new String[]{"bold"}, new HTMLNode[]{HTMLNode.STRONG});
            HTMLNode inner2 = input2.addChild("p").addChild("i");
            NodeL10n.getBase().addL10nSubstitution(inner2, "SecurityLevels.physicalThreatLevel.desc." + (Object)((Object)level), new String[]{"bold"}, new HTMLNode[]{HTMLNode.STRONG});
            if (level == SecurityLevels.PHYSICAL_THREAT_LEVEL.MAXIMUM && this.node.hasDatabase()) {
                inner2.addChild("b", " " + SecurityLevelsToadlet.l10nSec("warningMaximumWillDeleteQueue"));
            }
            if (level != SecurityLevels.PHYSICAL_THREAT_LEVEL.HIGH) continue;
            if (physicalLevel == level) {
                this.addPasswordChangeForm(inner2);
                continue;
            }
            p = inner2.addChild("p", SecurityLevelsToadlet.l10nSec("setPassword"));
            SecurityLevelsToadlet.generatePasswordConfirmationForm(inner2);
        }
        formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "seclevels", "on"});
        formNode.addChild("input", new String[]{"type", "value"}, new String[]{"submit", SecurityLevelsToadlet.l10n("apply")});
        formNode.addChild("input", new String[]{"type", "value"}, new String[]{"reset", SecurityLevelsToadlet.l10n("undo")});
    }

    private void addPasswordChangeForm(HTMLNode inner) {
        HTMLNode table = inner.addChild("table", "border", "0");
        HTMLNode row = table.addChild("tr");
        HTMLNode cell = row.addChild("td");
        cell.addChild("label", "for", "oldPasswordBox", SecurityLevelsToadlet.l10nSec("oldPasswordLabel"));
        cell = row.addChild("td");
        cell.addChild("input", new String[]{"id", "type", "name", "size"}, new String[]{"oldPasswordBox", "password", "oldPassword", "100"});
        row = table.addChild("tr");
        row = table.addChild("tr");
        cell = row.addChild("td");
        cell.addChild("label", "for", "newPasswordBox", SecurityLevelsToadlet.l10nSec("newPasswordLabel"));
        cell = row.addChild("td");
        cell.addChild("input", new String[]{"id", "type", "name", "size"}, new String[]{"newPasswordBox", "password", "masterPassword", "100"});
        row = table.addChild("tr");
        cell = row.addChild("td");
        cell.addChild("label", "for", "confirmPasswordBox", SecurityLevelsToadlet.l10nSec("confirmNewPasswordLabel"));
        cell = row.addChild("td");
        cell.addChild("input", new String[]{"id", "type", "name", "size"}, new String[]{"confirmPasswordBox", "password", "confirmMasterPassword", "100"});
        HTMLNode p = inner.addChild("p");
        p.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "changePassword", SecurityLevelsToadlet.l10nSec("changePasswordButton")});
    }

    @Override
    public String path() {
        return PATH;
    }

    private static String l10n(String string) {
        return NodeL10n.getBase().getString("ConfigToadlet." + string);
    }

    private static String l10nSec(String key) {
        return NodeL10n.getBase().getString("SecurityLevels." + key);
    }

    private static String l10nSec(String key, String pattern, String value) {
        return NodeL10n.getBase().getString("SecurityLevels." + key, pattern, value);
    }

    void sendPasswordFileCorruptedPage(boolean tooBig, ToadletContext ctx, boolean forSecLevels, boolean forFirstTimeWizard) throws ToadletContextClosedException, IOException {
        HTMLNode page = SecurityLevelsToadlet.sendPasswordFileCorruptedPageInner(tooBig, ctx, forSecLevels, forFirstTimeWizard, this.node.getMasterPasswordFile().getPath(), this.node);
        this.writeHTMLReply(ctx, 500, "Internal Server Error", page.generate());
    }

    public static void sendPasswordFileCorruptedPageInner(PageHelper helper, String masterPasswordFile) {
        HTMLNode contentNode = helper.getPageContent(SecurityLevelsToadlet.l10nSec("passwordFileCorruptedTitle"));
        HTMLNode infoBox = helper.getInfobox("infobox-error", SecurityLevelsToadlet.l10nSec("passwordFileCorruptedTitle"), contentNode, "password-error", false).addChild("div", "class", "infobox-content");
        SecurityLevelsToadlet.sendPasswordFileCorruptedPageInner(infoBox, masterPasswordFile);
    }

    public static HTMLNode sendPasswordFileCorruptedPageInner(boolean tooBig, ToadletContext ctx, boolean forSecLevels, boolean forFirstTimeWizard, String masterPasswordFile, Node node) {
        PageNode page = ctx.getPageMaker().getPageNode(SecurityLevelsToadlet.l10nSec("passwordFileCorruptedTitle"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode infoBox = ctx.getPageMaker().getInfobox("infobox-error", SecurityLevelsToadlet.l10nSec("passwordFileCorruptedTitle"), contentNode, "password-error", false).addChild("div", "class", "infobox-content");
        SecurityLevelsToadlet.sendPasswordFileCorruptedPageInner(infoBox, masterPasswordFile);
        return pageNode;
    }

    private static void sendPasswordFileCorruptedPageInner(HTMLNode infoBox, String masterPasswordFile) {
        infoBox.addChild("p", SecurityLevelsToadlet.l10nSec("passwordFileCorrupted", "file", masterPasswordFile));
        SecurityLevelsToadlet.addHomepageLink(infoBox);
        SecurityLevelsToadlet.addBackToSeclevelsLink(infoBox);
    }

    private void sendPasswordFormPage(boolean wasWrong, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        PageNode page = ctx.getPageMaker().getPageNode(SecurityLevelsToadlet.l10nSec("passwordPageTitle"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode content = ctx.getPageMaker().getInfobox("infobox-error", wasWrong ? SecurityLevelsToadlet.l10nSec("passwordWrongTitle") : SecurityLevelsToadlet.l10nSec("enterPasswordTitle"), contentNode, "password-error", false).addChild("div", "class", "infobox-content");
        SecurityLevelsToadlet.generatePasswordFormPage(wasWrong, ctx.getContainer(), content, false, false, false, null, null);
        SecurityLevelsToadlet.addHomepageLink(content);
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    private void sendPasswordPageMismatch(ToadletContext ctx, String threatLevel) throws ToadletContextClosedException, IOException {
        PageNode page = ctx.getPageMaker().getPageNode(SecurityLevelsToadlet.l10nSec("passwordPageTitle"), ctx);
        HTMLNode pageNode = page.outer;
        HTMLNode contentNode = page.content;
        HTMLNode content = ctx.getPageMaker().getInfobox("infobox-error", SecurityLevelsToadlet.l10nSec("setPasswordTitle"), contentNode, "password-error", false).addChild("div", "class", "infobox-content");
        content.addChild("p", SecurityLevelsToadlet.l10nSec("passwordsDoNotMatch"));
        SecurityLevelsToadlet.generatePasswordFormPage(false, ctx.getContainer(), content, false, false, true, threatLevel, null);
        SecurityLevelsToadlet.addBackToSeclevelsLink(content);
        this.writeHTMLReply(ctx, 200, "OK", pageNode.generate());
    }

    public static void generatePasswordFormPage(boolean wasWrong, ToadletContainer ctx, HTMLNode content, boolean forFirstTimeWizard, boolean forDowngrade, boolean forUpgrade, String physicalSecurityLevel, String redirect) {
        String postTo = forFirstTimeWizard ? "/wizard/" : PATH;
        HTMLNode form = ctx.addFormChild(content, postTo, "masterPasswordForm");
        SecurityLevelsToadlet.generatePasswordFormPage(wasWrong, form, content, forDowngrade, forUpgrade, physicalSecurityLevel, redirect);
    }

    private static void generatePasswordConfirmationForm(HTMLNode formNode) {
        HTMLNode table = formNode.addChild("table", "border", "0");
        HTMLNode row = table.addChild("tr");
        HTMLNode cell = row.addChild("td");
        cell.addChild("label", "for", "passwordBox", SecurityLevelsToadlet.l10nSec("passwordLabel"));
        cell = row.addChild("td");
        cell.addChild("input", new String[]{"id", "type", "name", "size"}, new String[]{"passwordBox", "password", "masterPassword", "100"});
        row = table.addChild("tr");
        row = table.addChild("tr");
        cell = row.addChild("td");
        cell.addChild("label", "for", "confirmPasswordBox", SecurityLevelsToadlet.l10nSec("confirmPasswordLabel"));
        cell = row.addChild("td");
        cell.addChild("input", new String[]{"id", "type", "name", "size"}, new String[]{"confirmPasswordBox", "password", "confirmMasterPassword", "100"});
    }

    public static void generatePasswordFormPage(boolean wasWrong, HTMLNode formNode, HTMLNode content, boolean forDowngrade, boolean forUpgrade, String physicalSecurityLevel, String redirect) {
        if (forDowngrade && !wasWrong) {
            content.addChild("#", SecurityLevelsToadlet.l10nSec("passwordForDecrypt"));
        } else if (wasWrong) {
            content.addChild("#", SecurityLevelsToadlet.l10nSec("passwordWrong"));
        } else if (forUpgrade) {
            content.addChild("#", SecurityLevelsToadlet.l10nSec("setPassword"));
        } else {
            content.addChild("#", SecurityLevelsToadlet.l10nSec("enterPassword"));
        }
        if (forUpgrade) {
            SecurityLevelsToadlet.generatePasswordConfirmationForm(formNode);
        } else {
            formNode.addChild("label", "for", "passwordBox", SecurityLevelsToadlet.l10nSec("passwordLabel"));
            formNode.addChild("input", new String[]{"id", "type", "name", "size"}, new String[]{"passwordBox", "password", "masterPassword", "100"});
        }
        if (physicalSecurityLevel != null) {
            formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "security-levels.physicalThreatLevel", physicalSecurityLevel});
            formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "seclevels", "true"});
        }
        if (redirect != null) {
            formNode.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "redirect", redirect});
        }
        formNode.addChild("input", new String[]{"type", "value"}, new String[]{"submit", SecurityLevelsToadlet.l10nSec("passwordSubmit")});
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
    }
}

