/*
 * Decompiled with CFR 0.152.
 */
package freenet.config;

import freenet.config.Option;
import freenet.config.SubConfig;
import freenet.support.Logger;
import java.util.LinkedHashMap;

public class Config {
    protected final LinkedHashMap<String, SubConfig> configsByPrefix = new LinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(SubConfig sc) {
        Config config = this;
        synchronized (config) {
            if (this.configsByPrefix.containsKey(sc.prefix)) {
                throw new IllegalArgumentException("Already registered " + sc.prefix + ": " + sc);
            }
            this.configsByPrefix.put(sc.prefix, sc);
        }
    }

    public void store() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishedInit() {
        SubConfig[] subConfigArray = this;
        synchronized (this) {
            SubConfig[] configs = this.configsByPrefix.values().toArray(new SubConfig[this.configsByPrefix.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (SubConfig config : configs) {
                if (config.hasFinishedInitialization()) continue;
                Logger.error(this, "Not finished initialization: " + config.prefix);
            }
            return;
        }
    }

    public void onRegister(SubConfig config, Option<?> o) {
    }

    public synchronized SubConfig[] getConfigs() {
        return this.configsByPrefix.values().toArray(new SubConfig[this.configsByPrefix.size()]);
    }

    public synchronized SubConfig get(String subConfig) {
        return this.configsByPrefix.get(subConfig);
    }

    public SubConfig createSubConfig(String subConfig) {
        return new SubConfig(subConfig, this);
    }

    public static enum RequestType {
        CURRENT_SETTINGS,
        DEFAULT_SETTINGS,
        SORT_ORDER,
        EXPERT_FLAG,
        FORCE_WRITE_FLAG,
        SHORT_DESCRIPTION,
        LONG_DESCRIPTION,
        DATA_TYPE;

    }
}

