/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.io;

import freenet.support.api.Bucket;
import freenet.support.api.BucketFactory;
import freenet.support.api.RandomAccessBucket;
import freenet.support.io.BucketTools;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PrependLengthOutputStream
extends FilterOutputStream {
    private final Bucket temp;
    private final OutputStream origOS;
    private final int offset;
    private final boolean closeUnderlying;
    private boolean aborted;
    private boolean closed;

    public static PrependLengthOutputStream create(OutputStream out, BucketFactory bf, int offset, boolean closeUnderlying) throws IOException {
        RandomAccessBucket temp = bf.makeBucket(-1L);
        OutputStream os = temp.getOutputStream();
        return new PrependLengthOutputStream(os, temp, out, offset, closeUnderlying);
    }

    private PrependLengthOutputStream(OutputStream os, Bucket temp, OutputStream origOS, int offset, boolean closeUnderlying) {
        super(os);
        this.temp = temp;
        this.origOS = origOS;
        this.offset = offset;
        this.closeUnderlying = closeUnderlying;
    }

    @Override
    public void write(byte[] buf, int offset, int length) throws IOException {
        this.out.write(buf, offset, length);
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public boolean abort() throws IOException {
        if (this.closed) {
            return false;
        }
        this.aborted = true;
        return true;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.out.close();
        DataOutputStream dos = new DataOutputStream(this.origOS);
        if (this.aborted) {
            dos.writeLong(0L);
        } else {
            dos.writeLong(this.temp.size() - (long)this.offset);
            BucketTools.copyTo(this.temp, dos, Long.MAX_VALUE);
        }
        this.temp.free();
        this.closed = true;
        if (this.closeUnderlying) {
            dos.close();
        }
    }
}

