/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.cs;

import com.db4o.foundation.IntIterator4;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.Transaction;
import com.db4o.internal.cs.ClientObjectContainer;
import com.db4o.internal.cs.PrefetchingStrategy;
import com.db4o.internal.cs.messages.Msg;
import com.db4o.internal.cs.messages.MsgD;
import com.db4o.internal.cs.messages.MsgObject;

public class SingleMessagePrefetchingStrategy
implements PrefetchingStrategy {
    public static final PrefetchingStrategy INSTANCE = new SingleMessagePrefetchingStrategy();

    private SingleMessagePrefetchingStrategy() {
    }

    @Override
    public int prefetchObjects(ClientObjectContainer container, IntIterator4 ids, Object[] prefetched, int prefetchCount) {
        int count = 0;
        int toGet = 0;
        int[] idsToGet = new int[prefetchCount];
        int[] position = new int[prefetchCount];
        while (count < prefetchCount && ids.moveNext()) {
            int id = ids.currentInt();
            if (id <= 0) continue;
            Object obj = container.transaction().objectForIdFromCache(id);
            if (obj != null) {
                prefetched[count] = obj;
            } else {
                idsToGet[toGet] = id;
                position[toGet] = count;
                ++toGet;
            }
            ++count;
        }
        if (toGet > 0) {
            Transaction trans = container.transaction();
            MsgD msg = Msg.READ_MULTIPLE_OBJECTS.getWriterForIntArray(trans, idsToGet, toGet);
            container.write(msg);
            MsgD response = (MsgD)container.expectedResponse(Msg.READ_MULTIPLE_OBJECTS);
            int embeddedMessageCount = response.readInt();
            for (int i = 0; i < embeddedMessageCount; ++i) {
                MsgObject mso = (MsgObject)Msg.OBJECT_TO_CLIENT.publicClone();
                mso.setTransaction(trans);
                mso.payLoad(response.payLoad().readYapBytes());
                if (mso.payLoad() == null) continue;
                mso.payLoad().incrementOffset(9);
                StatefulBuffer reader = mso.unmarshall(9);
                Object obj = trans.objectForIdFromCache(idsToGet[i]);
                prefetched[position[i]] = obj != null ? obj : new ObjectReference(idsToGet[i]).readPrefetch(trans, reader);
            }
        }
        return count;
    }
}

