/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.ext.Db4oIOException;
import com.db4o.foundation.BooleanByRef;
import com.db4o.foundation.PreparedComparison;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassAspect;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.Db4oTypeImpl;
import com.db4o.internal.DefragmentContext;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.IllegalComparisonException;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.Reflection4;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionContext;
import com.db4o.internal.TypeHandlerCloneContext;
import com.db4o.internal.VirtualFieldMetadata;
import com.db4o.internal.activation.ActivationContext4;
import com.db4o.internal.activation.ActivationMode;
import com.db4o.internal.delete.DeleteContext;
import com.db4o.internal.delete.DeleteContextImpl;
import com.db4o.internal.handlers.FieldAwareTypeHandler;
import com.db4o.internal.marshall.CollectIdContext;
import com.db4o.internal.marshall.ContextState;
import com.db4o.internal.marshall.FieldListInfo;
import com.db4o.internal.marshall.MarshallingContext;
import com.db4o.internal.marshall.MarshallingInfo;
import com.db4o.internal.marshall.ObjectHeaderContext;
import com.db4o.internal.marshall.ObjectIdContextImpl;
import com.db4o.internal.marshall.ObjectReferenceContext;
import com.db4o.internal.marshall.QueryingReadContext;
import com.db4o.internal.marshall.UnmarshallingContext;
import com.db4o.internal.slots.Slot;
import com.db4o.marshall.Context;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteContext;
import com.db4o.reflect.ReflectClass;
import com.db4o.typehandlers.TypeHandler4;

public class FirstClassObjectHandler
implements FieldAwareTypeHandler {
    private static final int HASHCODE_FOR_NULL = 72483944;
    private ClassMetadata _classMetadata;

    public FirstClassObjectHandler(ClassMetadata classMetadata) {
        this._classMetadata = classMetadata;
    }

    public FirstClassObjectHandler() {
    }

    @Override
    public void defragment(final DefragmentContext context) {
        TraverseAspectCommand command = new TraverseAspectCommand(){

            @Override
            public int aspectCount(ClassMetadata classMetadata, ByteArrayBuffer reader) {
                return context.readInt();
            }

            @Override
            public void processAspect(ClassAspect aspect, int currentSlot, boolean isNull, ClassMetadata containingClass) {
                if (!isNull) {
                    aspect.defragAspect(context);
                }
            }
        };
        this.traverseAllAspects(context, command);
    }

    @Override
    public void delete(DeleteContext context) throws Db4oIOException {
        context.deleteObject();
    }

    public final void instantiateAspects(final UnmarshallingContext context) {
        final BooleanByRef updateFieldFound = new BooleanByRef();
        ContextState savedState = context.saveState();
        TraverseAspectCommand command = new TraverseAspectCommand(){

            @Override
            public void processAspect(ClassAspect aspect, int currentSlot, boolean isNull, ClassMetadata containingClass) {
                if (!aspect.enabled(context)) {
                    return;
                }
                if (aspect instanceof FieldMetadata) {
                    FieldMetadata field = (FieldMetadata)aspect;
                    if (field.updating()) {
                        updateFieldFound.value = true;
                    }
                    if (isNull) {
                        field.set(context.persistentObject(), null);
                        return;
                    }
                }
                aspect.instantiate(context);
            }
        };
        this.traverseAllAspects(context, command);
        if (updateFieldFound.value) {
            context.restoreState(savedState);
            command = new TraverseFieldCommand(){

                @Override
                public void processAspect(ClassAspect aspect, int currentSlot, boolean isNull, ClassMetadata containingClass) {
                    if (!isNull) {
                        ((FieldMetadata)aspect).attemptUpdate(context);
                    }
                }
            };
            this.traverseAllAspects(context, command);
        }
    }

    @Override
    public Object read(ReadContext context) {
        UnmarshallingContext unmarshallingContext = (UnmarshallingContext)context;
        this.instantiateAspects(unmarshallingContext);
        return unmarshallingContext.persistentObject();
    }

    @Override
    public void write(WriteContext context, Object obj) {
        this.marshallAspects(obj, (MarshallingContext)context);
    }

    public void marshallAspects(final Object obj, final MarshallingContext context) {
        final Transaction trans = context.transaction();
        TraverseAspectCommand command = new TraverseAspectCommand(){

            @Override
            public int aspectCount(ClassMetadata classMetadata, ByteArrayBuffer buffer) {
                int fieldCount = classMetadata._aspects.length;
                context.fieldCount(fieldCount);
                return fieldCount;
            }

            @Override
            public void processAspect(ClassAspect aspect, int currentSlot, boolean isNull, ClassMetadata containingClass) {
                if (!aspect.enabled(context)) {
                    return;
                }
                Object marshalledObject = obj;
                if (aspect instanceof FieldMetadata) {
                    FieldMetadata field = (FieldMetadata)aspect;
                    marshalledObject = field.getOrCreate(trans, obj);
                    if (marshalledObject == null) {
                        context.isNull(currentSlot, true);
                        field.addIndexEntry(trans, context.objectID(), null);
                        return;
                    }
                    if (marshalledObject instanceof Db4oTypeImpl) {
                        marshalledObject = ((Db4oTypeImpl)marshalledObject).storedTo(trans);
                    }
                }
                aspect.marshall(context, marshalledObject);
            }
        };
        this.traverseAllAspects(context, command);
    }

    @Override
    public PreparedComparison prepareComparison(Context context, Object source) {
        if (source == null) {
            return new PreparedComparison(){

                @Override
                public int compareTo(Object obj) {
                    if (obj == null) {
                        return 0;
                    }
                    return -1;
                }
            };
        }
        int id = 0;
        ReflectClass claxx = null;
        if (source instanceof Integer) {
            id = (Integer)source;
        } else if (source instanceof TransactionContext) {
            TransactionContext tc = (TransactionContext)source;
            Object obj = tc._object;
            id = this._classMetadata.stream().getID(tc._transaction, obj);
            claxx = this._classMetadata.reflector().forObject(obj);
        } else {
            throw new IllegalComparisonException();
        }
        return new ClassMetadata.PreparedComparisonImpl(id, claxx);
    }

    protected final void traverseAllAspects(MarshallingInfo context, TraverseAspectCommand command) {
        int currentSlot = 0;
        ClassMetadata classMetadata = this.classMetadata();
        while (classMetadata != null) {
            int fieldCount = command.aspectCount(classMetadata, (ByteArrayBuffer)context.buffer());
            context.aspectCount(fieldCount);
            for (int i = 0; i < fieldCount && !command.cancelled(); ++i) {
                if (command.accept(classMetadata._aspects[i])) {
                    command.processAspect(classMetadata._aspects[i], currentSlot, this.isNull(context, currentSlot), classMetadata);
                }
                context.beginSlot();
                ++currentSlot;
            }
            if (command.cancelled()) {
                return;
            }
            classMetadata = classMetadata.i_ancestor;
        }
    }

    protected boolean isNull(FieldListInfo fieldList, int fieldIndex) {
        return fieldList.isNull(fieldIndex);
    }

    public ClassMetadata classMetadata() {
        return this._classMetadata;
    }

    @Override
    public void classMetadata(ClassMetadata classMetadata) {
        this._classMetadata = classMetadata;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FirstClassObjectHandler)) {
            return false;
        }
        FirstClassObjectHandler other = (FirstClassObjectHandler)obj;
        if (this._classMetadata == null) {
            return other._classMetadata == null;
        }
        return this._classMetadata.equals(other._classMetadata);
    }

    public int hashCode() {
        if (this._classMetadata != null) {
            return this._classMetadata.hashCode();
        }
        return 72483944;
    }

    @Override
    public TypeHandler4 unversionedTemplate() {
        return new FirstClassObjectHandler(null);
    }

    @Override
    public Object deepClone(Object context) {
        TypeHandlerCloneContext typeHandlerCloneContext = (TypeHandlerCloneContext)context;
        FirstClassObjectHandler cloned = (FirstClassObjectHandler)Reflection4.newInstance(this);
        if (typeHandlerCloneContext.original instanceof FirstClassObjectHandler) {
            FirstClassObjectHandler original = (FirstClassObjectHandler)typeHandlerCloneContext.original;
            cloned._classMetadata = original._classMetadata;
        } else {
            if (this._classMetadata == null) {
                throw new IllegalStateException();
            }
            cloned._classMetadata = this._classMetadata;
        }
        return cloned;
    }

    @Override
    public void collectIDs(final CollectIdContext context, final String fieldName) {
        TraverseAspectCommand command = new TraverseAspectCommand(){

            @Override
            public void processAspect(ClassAspect aspect, int currentSlot, boolean isNull, ClassMetadata containingClass) {
                if (isNull) {
                    return;
                }
                if (fieldName.equals(aspect.getName())) {
                    aspect.collectIDs(context);
                } else {
                    aspect.incrementOffset(context);
                }
            }
        };
        this.traverseAllAspects(context, command);
    }

    @Override
    public void cascadeActivation(ActivationContext4 context) {
        context.cascadeActivationToTarget(this.classMetadata(), this.classMetadata().descendOnCascadingActivation());
    }

    @Override
    public TypeHandler4 readCandidateHandler(QueryingReadContext context) {
        if (this.classMetadata().isArray()) {
            return this.classMetadata();
        }
        return null;
    }

    @Override
    public void collectIDs(final QueryingReadContext context) throws Db4oIOException {
        int id = context.collectionID();
        if (id == 0) {
            return;
        }
        Transaction transaction = context.transaction();
        ObjectContainerBase container = context.container();
        Object obj = container.getByID(transaction, id);
        if (obj == null) {
            return;
        }
        int depth = this.classMetadata().adjustDepthToBorders(2);
        container.activate(transaction, obj, container.activationDepthProvider().activationDepth(depth, ActivationMode.ACTIVATE));
        Platform4.forEachCollectionElement(obj, new Visitor4(){

            @Override
            public void visit(Object elem) {
                context.add(elem);
            }
        });
    }

    @Override
    public void readVirtualAttributes(final ObjectReferenceContext context) {
        TraverseAspectCommand command = new TraverseAspectCommand(){

            @Override
            public void processAspect(ClassAspect aspect, int currentSlot, boolean isNull, ClassMetadata containingClass) {
                if (!isNull) {
                    if (aspect instanceof VirtualFieldMetadata) {
                        ((VirtualFieldMetadata)aspect).readVirtualAttribute(context);
                    } else {
                        aspect.incrementOffset(context);
                    }
                }
            }
        };
        this.traverseAllAspects(context, command);
    }

    @Override
    public void addFieldIndices(final ObjectIdContextImpl context, final Slot oldSlot) {
        TraverseAspectCommand command = new TraverseAspectCommand(){

            @Override
            public void processAspect(ClassAspect aspect, int currentSlot, boolean isNull, ClassMetadata containingClass) {
                if (aspect instanceof FieldMetadata) {
                    FieldMetadata field = (FieldMetadata)aspect;
                    if (isNull) {
                        field.addIndexEntry(context.transaction(), context.id(), null);
                    } else {
                        field.addFieldIndex(context, oldSlot);
                    }
                } else {
                    aspect.incrementOffset(context.buffer());
                }
            }
        };
        this.traverseAllAspects(context, command);
    }

    @Override
    public void deleteMembers(final DeleteContextImpl context, final boolean isUpdate) {
        TraverseAspectCommand command = new TraverseAspectCommand(){

            @Override
            public void processAspect(ClassAspect aspect, int currentSlot, boolean isNull, ClassMetadata containingClass) {
                if (isNull) {
                    if (aspect instanceof FieldMetadata) {
                        FieldMetadata field = (FieldMetadata)aspect;
                        field.removeIndexEntry(context.transaction(), context.id(), null);
                    }
                    return;
                }
                aspect.delete(context, isUpdate);
            }
        };
        this.traverseAllAspects(context, command);
    }

    @Override
    public boolean seekToField(final ObjectHeaderContext context, final FieldMetadata field) {
        final BooleanByRef found = new BooleanByRef(false);
        TraverseAspectCommand command = new TraverseAspectCommand(){

            @Override
            public void processAspect(ClassAspect curField, int currentSlot, boolean isNull, ClassMetadata containingClass) {
                if (curField == field) {
                    found.value = !isNull;
                    this.cancel();
                    return;
                }
                if (!isNull) {
                    curField.incrementOffset(context);
                }
            }
        };
        this.traverseAllAspects(context, command);
        return found.value;
    }

    public static abstract class TraverseFieldCommand
    extends TraverseAspectCommand {
        @Override
        public boolean accept(ClassAspect aspect) {
            return aspect instanceof FieldMetadata;
        }
    }

    public static abstract class TraverseAspectCommand {
        private boolean _cancelled = false;

        public int aspectCount(ClassMetadata classMetadata, ByteArrayBuffer reader) {
            return classMetadata.readAspectCount(reader);
        }

        public boolean cancelled() {
            return this._cancelled;
        }

        protected void cancel() {
            this._cancelled = true;
        }

        public boolean accept(ClassAspect aspect) {
            return true;
        }

        public abstract void processAspect(ClassAspect var1, int var2, boolean var3, ClassMetadata var4);
    }
}

