/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.marshall;

import com.db4o.foundation.IntByRef;
import com.db4o.foundation.Procedure4;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.ClassAspect;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DefragmentContextImpl;
import com.db4o.internal.FieldMetadata;
import com.db4o.internal.LatinStringIO;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.Platform4;
import com.db4o.internal.Transaction;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.internal.marshall.RawClassSpec;

public abstract class ClassMarshaller {
    public MarshallerFamily _family;

    public RawClassSpec readSpec(Transaction trans, ByteArrayBuffer reader) {
        byte[] nameBytes = this.readName(trans, reader);
        String className = trans.container().stringIO().read(nameBytes);
        this.readMetaClassID(reader);
        int ancestorID = reader.readInt();
        reader.incrementOffset(4);
        int numFields = reader.readInt();
        return new RawClassSpec(className, ancestorID, numFields);
    }

    public void write(final Transaction trans, final ClassMetadata clazz, final ByteArrayBuffer writer) {
        writer.writeShortString(trans, clazz.nameToWrite());
        int intFormerlyKnownAsMetaClassID = 0;
        writer.writeInt(intFormerlyKnownAsMetaClassID);
        writer.writeIDOf(trans, clazz.i_ancestor);
        this.writeIndex(trans, clazz, writer);
        writer.writeInt(clazz.declaredAspectCount());
        clazz.forEachDeclaredAspect(new Procedure4(){

            @Override
            public void apply(Object arg) {
                ClassMarshaller.this._family._field.write(trans, clazz, (ClassAspect)arg, writer);
            }
        });
    }

    protected void writeIndex(Transaction trans, ClassMetadata clazz, ByteArrayBuffer writer) {
        int indexID = clazz.index().write(trans);
        writer.writeInt(this.indexIDForWriting(indexID));
    }

    protected abstract int indexIDForWriting(int var1);

    public byte[] readName(Transaction trans, ByteArrayBuffer reader) {
        byte[] name = this.readName(trans.container().stringIO(), reader);
        return name;
    }

    public final int readMetaClassID(ByteArrayBuffer reader) {
        return reader.readInt();
    }

    private byte[] readName(LatinStringIO sio, ByteArrayBuffer reader) {
        int len = reader.readInt();
        byte[] nameBytes = new byte[len *= sio.bytesPerChar()];
        System.arraycopy(reader._buffer, reader._offset, nameBytes, 0, len);
        nameBytes = Platform4.updateClassName(nameBytes);
        reader.incrementOffset(len);
        return nameBytes;
    }

    public final void read(ObjectContainerBase stream, ClassMetadata clazz, ByteArrayBuffer reader) {
        clazz.setAncestor(stream.classMetadataForId(reader.readInt()));
        if (clazz.callConstructor()) {
            clazz.createConstructor(stream, clazz.classReflector(), clazz.getName(), true);
        }
        clazz.checkType();
        this.readIndex(stream, clazz, reader);
        clazz._aspects = this.createFields(clazz, reader.readInt());
        this.readFields(stream, reader, clazz._aspects);
    }

    protected abstract void readIndex(ObjectContainerBase var1, ClassMetadata var2, ByteArrayBuffer var3);

    private ClassAspect[] createFields(ClassMetadata clazz, int fieldCount) {
        ClassAspect[] aspects = new ClassAspect[fieldCount];
        for (int i = 0; i < aspects.length; ++i) {
            aspects[i] = new FieldMetadata(clazz);
            aspects[i].setHandle(i);
        }
        return aspects;
    }

    private void readFields(ObjectContainerBase stream, ByteArrayBuffer reader, ClassAspect[] fields) {
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = this._family._field.read(stream, (FieldMetadata)fields[i], reader);
        }
    }

    public int marshalledLength(final ObjectContainerBase stream, ClassMetadata clazz) {
        final IntByRef len = new IntByRef(stream.stringIO().shortLength(clazz.nameToWrite()) + 0 + 8 + 4);
        len.value += clazz.index().ownLength();
        clazz.forEachDeclaredAspect(new Procedure4(){

            @Override
            public void apply(Object arg) {
                len.value += ClassMarshaller.this._family._field.marshalledLength(stream, (ClassAspect)arg);
            }
        });
        return len.value;
    }

    public void defrag(final ClassMetadata classMetadata, final LatinStringIO sio, final DefragmentContextImpl context, int classIndexID) {
        this.readName(sio, context.sourceBuffer());
        this.readName(sio, context.targetBuffer());
        int metaClassID = 0;
        context.writeInt(metaClassID);
        context.copyID();
        context.writeInt(this.indexIDForWriting(classIndexID));
        final int aspectCount = context.readInt();
        if (aspectCount > classMetadata.declaredAspectCount()) {
            throw new IllegalStateException();
        }
        final IntByRef processedAspectCount = new IntByRef(0);
        classMetadata.forEachDeclaredAspect(new Procedure4(){

            @Override
            public void apply(Object arg) {
                if (processedAspectCount.value >= aspectCount) {
                    return;
                }
                ClassAspect aspect = (ClassAspect)arg;
                ClassMarshaller.this._family._field.defrag(classMetadata, aspect, sio, context);
                ++processedAspectCount.value;
            }
        });
    }
}

