/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.async;

import freenet.node.Node;
import freenet.support.BandwidthStatsContainer;
import freenet.support.UptimeContainer;
import java.io.Serializable;

public class PersistentStatsPutter
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int OFFSET = 60000;
    private long latestNodeBytesOut = 0L;
    private long latestNodeBytesIn = 0L;
    private long latestUptimeVal = 0L;
    private BandwidthStatsContainer latestBW = new BandwidthStatsContainer();
    private UptimeContainer latestUptime = new UptimeContainer();

    public BandwidthStatsContainer getLatestBWData() {
        return this.latestBW;
    }

    public UptimeContainer getLatestUptimeData() {
        return this.latestUptime;
    }

    public void updateData(Node n) {
        long[] nodeBW = n.getCollector().getTotalIO();
        this.latestBW.totalBytesOut += nodeBW[0] - this.latestNodeBytesOut;
        this.latestBW.totalBytesIn += nodeBW[1] - this.latestNodeBytesIn;
        this.latestBW.creationTime = System.currentTimeMillis();
        this.latestNodeBytesOut = nodeBW[0];
        this.latestNodeBytesIn = nodeBW[1];
        long uptime = n.getUptime();
        this.latestUptime.totalUptime += uptime - this.latestUptimeVal;
        this.latestUptime.creationTime = System.currentTimeMillis();
        this.latestUptimeVal = uptime;
    }

    public void addFrom(PersistentStatsPutter stored) {
        this.latestBW.addFrom(stored.latestBW);
        this.latestUptime.addFrom(stored.latestUptime);
    }
}

