/*
 * Decompiled with CFR 0.152.
 */
package freenet.client.filter;

import freenet.client.filter.BMPFilter;
import freenet.client.filter.CSSReadFilter;
import freenet.client.filter.CharsetExtractor;
import freenet.client.filter.DataFilterException;
import freenet.client.filter.FilterCallback;
import freenet.client.filter.FilterMIMEType;
import freenet.client.filter.FlacFilter;
import freenet.client.filter.FoundURICallback;
import freenet.client.filter.GIFFilter;
import freenet.client.filter.GenericReadFilterCallback;
import freenet.client.filter.HTMLFilter;
import freenet.client.filter.JPEGFilter;
import freenet.client.filter.KnownUnsafeContentTypeException;
import freenet.client.filter.LinkFilterExceptionProvider;
import freenet.client.filter.M3UFilter;
import freenet.client.filter.MP3Filter;
import freenet.client.filter.OggFilter;
import freenet.client.filter.PNGFilter;
import freenet.client.filter.TagReplacerCallback;
import freenet.client.filter.UndetectableCharsetException;
import freenet.client.filter.UnknownContentTypeException;
import freenet.client.filter.UnsafeContentTypeException;
import freenet.client.filter.UnsupportedCharsetInFilterException;
import freenet.l10n.NodeL10n;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedHashMap;

public class ContentFilter {
    static final Hashtable<String, FilterMIMEType> mimeTypesByName = new Hashtable();
    public static final String[] HTML_MIME_TYPES = new String[]{"text/html", "application/xhtml+xml", "text/xml+xhtml", "text/xhtml", "application/xhtml"};
    private static volatile boolean logMINOR;
    static byte[] bom_utf8;
    static byte[] bom_utf16_be;
    static byte[] bom_utf16_le;
    static byte[] bom_utf32_be;
    static byte[] bom_utf32_le;
    static byte[] bom_scsu;
    static byte[] bom_utf7_1;
    static byte[] bom_utf7_2;
    static byte[] bom_utf7_3;
    static byte[] bom_utf7_4;
    static byte[] bom_utf7_5;
    static byte[] bom_utf_ebcdic;
    static byte[] bom_bocu_1;
    static byte[] bom_utf32_2143;
    static byte[] bom_utf32_3412;

    public static void init() {
        ContentFilter.register(new FilterMIMEType("text/plain", "txt", new String[0], new String[]{"text", "pot"}, true, true, null, false, false, false, false, false, false, ContentFilter.l10n("textPlainReadAdvice"), true, "US-ASCII", null, false));
        ContentFilter.register(new FilterMIMEType("image/gif", "gif", new String[0], new String[0], true, false, new GIFFilter(), false, false, false, false, false, false, ContentFilter.l10n("imageGifReadAdvice"), false, null, null, false));
        ContentFilter.register(new FilterMIMEType("image/jpeg", "jpeg", new String[0], new String[]{"jpg"}, true, false, new JPEGFilter(true, true), false, false, false, false, false, false, ContentFilter.l10n("imageJpegReadAdvice"), false, null, null, false));
        ContentFilter.register(new FilterMIMEType("image/png", "png", new String[]{"image/x-png"}, new String[0], true, false, new PNGFilter(true, true, true), false, false, false, false, true, false, ContentFilter.l10n("imagePngReadAdvice"), false, null, null, false));
        ContentFilter.register(new FilterMIMEType("image/bmp", "bmp", new String[]{"image/x-bmp", "image/x-bitmap", "image/x-xbitmap", "image/x-win-bitmap", "image/x-windows-bmp", "image/ms-bmp", "image/x-ms-bmp", "application/bmp", "application/x-bmp", "application/x-win-bitmap"}, new String[0], true, false, new BMPFilter(), false, false, false, false, true, false, ContentFilter.l10n("imageBMPReadAdvice"), false, null, null, false));
        ContentFilter.register(new FilterMIMEType("application/ogg", "ogx", new String[]{"video/ogg", "audio/ogg"}, new String[]{"ogg", "oga", "ogv"}, true, false, new OggFilter(), true, true, false, true, false, false, ContentFilter.l10n("containerOggReadAdvice"), false, null, null, false));
        ContentFilter.register(new FilterMIMEType("audio/flac", "flac", new String[]{"application/x-flac"}, new String[0], true, true, new FlacFilter(), true, true, false, true, false, false, ContentFilter.l10n("audioFLACReadAdvice"), false, null, null, false));
        ContentFilter.register(new FilterMIMEType("audio/mpegurl", "m3u", new String[]{"application/vnd.apple.mpegurl", "application/mpegurl", "application/x-mpegurl", "audio/x-mpegurl"}, new String[]{"m3u8"}, false, false, new M3UFilter(), false, false, false, false, false, false, ContentFilter.l10n("audioM3UReadAdvice"), false, "utf-8", null, false));
        ContentFilter.register(new FilterMIMEType("audio/mpeg", "mp3", new String[]{"audio/mp3", "audio/x-mp3", "audio/x-mpeg", "audio/mpeg3", "audio/x-mpeg3", "audio/mpg", "audio/x-mpg", "audio/mpegaudio"}, new String[0], true, false, new MP3Filter(), true, true, false, true, false, false, ContentFilter.l10n("audioMP3ReadAdvice"), false, null, null, false));
        ContentFilter.register(new FilterMIMEType("application/pdf", "pdf", new String[]{"application/x-pdf"}, new String[0], false, false, null, true, true, true, false, true, true, ContentFilter.l10n("applicationPdfReadAdvice"), false, null, null, false));
        ContentFilter.register(new FilterMIMEType(HTML_MIME_TYPES[0], "html", Arrays.asList(HTML_MIME_TYPES).subList(1, HTML_MIME_TYPES.length).toArray(new String[HTML_MIME_TYPES.length - 1]), new String[]{"htm"}, false, false, new HTMLFilter(), true, true, true, true, true, true, ContentFilter.l10n("textHtmlReadAdvice"), true, "iso-8859-1", new HTMLFilter(), false));
        ContentFilter.register(new FilterMIMEType("text/css", "css", new String[0], new String[0], false, false, new CSSReadFilter(), true, true, true, true, true, false, ContentFilter.l10n("textCssReadAdvice"), true, "utf-8", new CSSReadFilter(), true));
    }

    private static String l10n(String key) {
        return NodeL10n.getBase().getString("ContentFilter." + key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(FilterMIMEType mimeType) {
        Hashtable<String, FilterMIMEType> hashtable = mimeTypesByName;
        synchronized (hashtable) {
            mimeTypesByName.put(mimeType.primaryMimeType, mimeType);
            String[] alt = mimeType.alternateMimeTypes;
            if (alt != null) {
                for (String a : alt) {
                    mimeTypesByName.put(a, mimeType);
                }
            }
        }
    }

    public static String stripMIMEType(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        int x = mimeType.indexOf(59);
        if (x != -1) {
            mimeType = mimeType.substring(0, x).trim();
        }
        return mimeType;
    }

    public static FilterMIMEType getMIMEType(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        return mimeTypesByName.get(ContentFilter.stripMIMEType(mimeType));
    }

    @Deprecated
    public static FilterStatus filter(InputStream input, OutputStream output, String typeName, URI baseURI, FoundURICallback cb, TagReplacerCallback trc, String maybeCharset) throws UnsafeContentTypeException, IOException {
        return ContentFilter.filter(input, output, typeName, baseURI, null, cb, trc, maybeCharset, null);
    }

    public static FilterStatus filter(InputStream input, OutputStream output, String typeName, URI baseURI, String schemeHostAndPort, FoundURICallback cb, TagReplacerCallback trc, String maybeCharset) throws UnsafeContentTypeException, IOException {
        return ContentFilter.filter(input, output, typeName, baseURI, schemeHostAndPort, cb, trc, maybeCharset, null);
    }

    public static FilterStatus filter(InputStream input, OutputStream output, String typeName, URI baseURI, String schemeHostAndPort, FoundURICallback cb, TagReplacerCallback trc, String maybeCharset, LinkFilterExceptionProvider linkFilterExceptionProvider) throws UnsafeContentTypeException, IOException {
        return ContentFilter.filter(input, output, typeName, maybeCharset, schemeHostAndPort, new GenericReadFilterCallback(baseURI, cb, trc, linkFilterExceptionProvider));
    }

    @Deprecated
    public static FilterStatus filter(InputStream input, OutputStream output, String typeName, String maybeCharset, FilterCallback filterCallback) throws UnsafeContentTypeException, IOException {
        return ContentFilter.filter(input, output, typeName, maybeCharset, null, filterCallback);
    }

    public static FilterStatus filter(InputStream input, OutputStream output, String typeName, String maybeCharset, String schemeHostAndPort, FilterCallback filterCallback) throws UnsafeContentTypeException, IOException {
        FilterMIMEType handler;
        if (logMINOR) {
            Logger.minor(ContentFilter.class, "Filtering data of type" + typeName);
        }
        String type = typeName;
        String options = "";
        String charset = null;
        LinkedHashMap<String, String> otherMimeTypeParams = new LinkedHashMap<String, String>();
        input = new BufferedInputStream(input);
        int idx = type.indexOf(59);
        if (idx != -1) {
            String[] rawOpts;
            options = type.substring(idx + 1);
            type = type.substring(0, idx);
            for (String raw : rawOpts = options.split(";")) {
                idx = raw.indexOf(61);
                if (idx == -1) {
                    Logger.error(ContentFilter.class, "idx = -1 for '=' on option: " + raw + " from " + typeName);
                    continue;
                }
                String before = raw.substring(0, idx).trim();
                String after = raw.substring(idx + 1).trim();
                if (before.equals("charset")) {
                    charset = after;
                    continue;
                }
                otherMimeTypeParams.put(before, after);
            }
        }
        if ((handler = ContentFilter.getMIMEType(type)) == null) {
            throw new UnknownContentTypeException(typeName);
        }
        if (handler.readFilter != null) {
            if (handler.takesACharset && (charset == null || charset.length() == 0)) {
                int bufferSize = handler.charsetExtractor.getCharsetBufferSize();
                input.mark(bufferSize);
                byte[] charsetBuffer = new byte[bufferSize];
                int bytesRead = 0;
                int offset = 0;
                int toread = 0;
                while ((bytesRead = input.read(charsetBuffer, offset, toread = bufferSize - offset)) != -1 && toread != 0) {
                    offset += bytesRead;
                }
                input.reset();
                charset = ContentFilter.detectCharset(charsetBuffer, offset, handler, maybeCharset);
            }
            try {
                handler.readFilter.readFilter(input, output, charset, otherMimeTypeParams, schemeHostAndPort, filterCallback);
            }
            catch (EOFException e) {
                Logger.error(ContentFilter.class, "EOFException caught: " + e, (Throwable)e);
                throw new DataFilterException(ContentFilter.l10n("EOFMessage"), ContentFilter.l10n("EOFMessage"), ContentFilter.l10n("EOFDescription"));
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                if (filterCallback != null) {
                    filterCallback.onFinished();
                }
            }
            if (charset != null) {
                type = type + "; charset=" + charset;
            }
            output.flush();
            return new FilterStatus(charset, typeName);
        }
        if (handler.safeToRead) {
            FileUtil.copy(input, output, -1L);
            output.flush();
            return new FilterStatus(charset, typeName);
        }
        handler.throwUnsafeContentTypeException();
        return null;
    }

    public static String detectCharset(byte[] input, int length, FilterMIMEType handler, String maybeCharset) throws IOException {
        String charset = ContentFilter.detectBOM(input, length);
        if (charset == null && handler.charsetExtractor != null) {
            CharsetExtractor.BOMDetection bom = handler.charsetExtractor.getCharsetByBOM(input, length);
            if (bom != null && (charset = bom.charset) != null) {
                try {
                    charset = handler.charsetExtractor.getCharset(input, length, charset);
                    if (charset != null) {
                        if (logMINOR) {
                            Logger.minor(ContentFilter.class, "Returning charset: " + charset);
                        }
                        return charset;
                    }
                    if (bom.mustHaveCharset) {
                        throw new UndetectableCharsetException(bom.charset);
                    }
                }
                catch (DataFilterException dataFilterException) {
                    // empty catch block
                }
            }
            if (handler.defaultCharset != null) {
                try {
                    charset = handler.charsetExtractor.getCharset(input, length, handler.defaultCharset);
                    if (charset != null) {
                        if (logMINOR) {
                            Logger.minor(ContentFilter.class, "Returning charset: " + charset);
                        }
                        return charset;
                    }
                }
                catch (DataFilterException dataFilterException) {
                    // empty catch block
                }
            }
            try {
                charset = handler.charsetExtractor.getCharset(input, length, "ISO-8859-1");
                if (charset != null) {
                    return charset;
                }
            }
            catch (DataFilterException dataFilterException) {
                // empty catch block
            }
            try {
                charset = handler.charsetExtractor.getCharset(input, length, "UTF-8");
                if (charset != null) {
                    return charset;
                }
            }
            catch (DataFilterException dataFilterException) {
                // empty catch block
            }
            try {
                charset = handler.charsetExtractor.getCharset(input, length, "UTF-16");
                if (charset != null) {
                    return charset;
                }
            }
            catch (DataFilterException dataFilterException) {
                // empty catch block
            }
            try {
                charset = handler.charsetExtractor.getCharset(input, length, "UTF-32");
                if (charset != null) {
                    return charset;
                }
            }
            catch (UnsupportedEncodingException e) {
                if (logMINOR) {
                    Logger.minor(ContentFilter.class, "UTF-32 not supported");
                }
            }
            catch (DataFilterException dataFilterException) {
                // empty catch block
            }
        }
        if (handler.useMaybeCharset && maybeCharset != null && maybeCharset.length() != 0) {
            return maybeCharset;
        }
        if (charset != null) {
            return charset;
        }
        return handler.defaultCharset;
    }

    private static String detectBOM(byte[] input, int length) throws IOException {
        if (ContentFilter.startsWith(input, bom_utf8, length)) {
            return "UTF-8";
        }
        if (ContentFilter.startsWith(input, bom_utf16_be, length)) {
            return "UTF-16BE";
        }
        if (ContentFilter.startsWith(input, bom_utf16_le, length)) {
            return "UTF-16LE";
        }
        if (ContentFilter.startsWith(input, bom_utf32_be, length)) {
            return "UTF-32BE";
        }
        if (ContentFilter.startsWith(input, bom_utf32_le, length)) {
            return "UTF-32LE";
        }
        if (ContentFilter.startsWith(input, bom_utf32_2143, length)) {
            throw new UnsupportedCharsetInFilterException("UTF-32-2143");
        }
        if (ContentFilter.startsWith(input, bom_utf32_3412, length)) {
            throw new UnsupportedCharsetInFilterException("UTF-32-3412");
        }
        if (ContentFilter.startsWith(input, bom_scsu, length)) {
            return "SCSU";
        }
        if (ContentFilter.startsWith(input, bom_utf7_1, length) || ContentFilter.startsWith(input, bom_utf7_2, length) || ContentFilter.startsWith(input, bom_utf7_3, length) || ContentFilter.startsWith(input, bom_utf7_4, length) || ContentFilter.startsWith(input, bom_utf7_5, length)) {
            return "UTF-7";
        }
        if (ContentFilter.startsWith(input, bom_utf_ebcdic, length)) {
            return "UTF-EBCDIC";
        }
        if (ContentFilter.startsWith(input, bom_bocu_1, length)) {
            return "BOCU-1";
        }
        return null;
    }

    public static boolean startsWith(byte[] data, byte[] cmp, int length) {
        if (cmp.length > length) {
            return false;
        }
        for (int i = 0; i < cmp.length; ++i) {
            if (data[i] == cmp[i]) continue;
            return false;
        }
        return true;
    }

    public static String mimeTypeForSrc(String uriold) {
        String uriPath;
        String string = uriPath = uriold.contains("?") ? uriold.split("\\?")[0] : uriold;
        String subMimetype = uriPath.endsWith(".m3u") || uriPath.endsWith(".m3u8") ? "audio/mpegurl" : (uriPath.endsWith(".flac") ? "audio/flac" : (uriPath.endsWith(".oga") ? "audio/ogg" : (uriPath.endsWith(".ogv") ? "video/ogg" : (uriPath.endsWith(".ogg") ? "application/ogg" : "audio/mpeg"))));
        return subMimetype;
    }

    public static UnsafeContentTypeException checkMIMEType(String expectedMIME) {
        FilterMIMEType handler = ContentFilter.getMIMEType(expectedMIME);
        if (handler == null || handler.readFilter == null && !handler.safeToRead) {
            if (handler == null) {
                if (logMINOR) {
                    Logger.minor(ContentFilter.class, "Unable to get filter handler for MIME type " + expectedMIME);
                }
                return new UnknownContentTypeException(expectedMIME);
            }
            if (logMINOR) {
                Logger.minor(ContentFilter.class, "Unable to filter unsafe MIME type " + expectedMIME);
            }
            return new KnownUnsafeContentTypeException(handler);
        }
        return null;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        ContentFilter.init();
        bom_utf8 = new byte[]{-17, -69, -65};
        bom_utf16_be = new byte[]{-2, -1};
        bom_utf16_le = new byte[]{-1, -2};
        bom_utf32_be = new byte[]{0, 0, -2, -1};
        bom_utf32_le = new byte[]{-1, -2, 0, 0};
        bom_scsu = new byte[]{14, -2, -1};
        bom_utf7_1 = new byte[]{43, 47, 118, 56};
        bom_utf7_2 = new byte[]{43, 47, 118, 57};
        bom_utf7_3 = new byte[]{43, 47, 118, 43};
        bom_utf7_4 = new byte[]{43, 47, 118, 47};
        bom_utf7_5 = new byte[]{43, 47, 118, 56, 45};
        bom_utf_ebcdic = new byte[]{-35, 115, 102, 115};
        bom_bocu_1 = new byte[]{-5, -18, 40};
        bom_utf32_2143 = new byte[]{0, 0, -1, -2};
        bom_utf32_3412 = new byte[]{-2, -1, 0, 0};
    }

    public static class FilterStatus {
        public final String charset;
        public final String mimeType;

        FilterStatus(String charset, String mimeType) {
            this.charset = charset;
            this.mimeType = mimeType;
        }
    }
}

