/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.KeyPairType;
import freenet.crypt.KeyType;
import freenet.crypt.MACType;
import freenet.crypt.MessageAuthCode;
import freenet.crypt.UnsupportedTypeException;
import freenet.node.NodeStarter;
import freenet.support.Fields;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class KeyGenUtils {
    private static BouncyCastleProvider bcProvider = new BouncyCastleProvider();

    private static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2);
        }
        int dotPos = version.indexOf(46);
        int dashPos = version.indexOf(45);
        return Integer.parseInt(version.substring(0, dotPos > -1 ? dotPos : (dashPos > -1 ? dashPos : 1)));
    }

    private static boolean isJava7() {
        return KeyGenUtils.getJavaVersion() <= 7;
    }

    public static KeyPair genKeyPair(KeyPairType type) {
        if (type.equals((Object)KeyPairType.DSA)) {
            throw new UnsupportedTypeException(type);
        }
        try {
            KeyPairGenerator kg = KeyGenUtils.isJava7() ? KeyPairGenerator.getInstance(type.alg, (Provider)bcProvider) : KeyPairGenerator.getInstance(type.alg);
            kg.initialize(type.spec);
            return kg.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new Error(e);
        }
    }

    public static PublicKey getPublicKey(KeyPairType type, byte[] pub) {
        if (type.equals((Object)KeyPairType.DSA)) {
            throw new UnsupportedTypeException(type);
        }
        try {
            KeyFactory kf = KeyGenUtils.isJava7() ? KeyFactory.getInstance(type.alg, (Provider)bcProvider) : KeyFactory.getInstance(type.alg);
            X509EncodedKeySpec xks = new X509EncodedKeySpec(pub);
            return kf.generatePublic(xks);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static PublicKey getPublicKey(KeyPairType type, ByteBuffer pub) {
        return KeyGenUtils.getPublicKey(type, Fields.copyToArray(pub));
    }

    public static KeyPair getPublicKeyPair(KeyPairType type, byte[] pub) {
        return KeyGenUtils.getKeyPair(KeyGenUtils.getPublicKey(type, pub), null);
    }

    public static KeyPair getPublicKeyPair(KeyPairType type, ByteBuffer pub) {
        return KeyGenUtils.getPublicKeyPair(type, Fields.copyToArray(pub));
    }

    public static KeyPair getKeyPair(KeyPairType type, byte[] pub, byte[] pri) {
        if (type.equals((Object)KeyPairType.DSA)) {
            throw new UnsupportedTypeException(type);
        }
        try {
            KeyFactory kf = KeyGenUtils.isJava7() ? KeyFactory.getInstance(type.alg, (Provider)bcProvider) : KeyFactory.getInstance(type.alg);
            PublicKey pubK = KeyGenUtils.getPublicKey(type, pub);
            PKCS8EncodedKeySpec pks = new PKCS8EncodedKeySpec(pri);
            PrivateKey privK = kf.generatePrivate(pks);
            return KeyGenUtils.getKeyPair(pubK, privK);
        }
        catch (UnsupportedTypeException e) {
            throw new Error(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static KeyPair getKeyPair(KeyPairType type, ByteBuffer pub, ByteBuffer pri) {
        return KeyGenUtils.getKeyPair(type, Fields.copyToArray(pub), Fields.copyToArray(pri));
    }

    public static KeyPair getKeyPair(PublicKey pubK, PrivateKey privK) {
        return new KeyPair(pubK, privK);
    }

    public static SecretKey genSecretKey(KeyType type) {
        try {
            KeyGenerator kg = KeyGenUtils.isJava7() ? KeyGenerator.getInstance(type.alg, (Provider)bcProvider) : KeyGenerator.getInstance(type.alg);
            kg.init(type.keySize);
            return kg.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
    }

    public static SecretKey getSecretKey(KeyType type, byte[] key) {
        if (!type.name().startsWith("HMAC") && key.length != type.keySize >> 3) {
            throw new IllegalArgumentException("Key size does not match KeyType");
        }
        return new SecretKeySpec(key, type.alg);
    }

    public static SecretKey getSecretKey(KeyType type, ByteBuffer key) {
        return KeyGenUtils.getSecretKey(type, Fields.copyToArray(key));
    }

    private static byte[] genRandomBytes(int length) {
        byte[] randBytes = new byte[length];
        NodeStarter.getGlobalSecureRandom().nextBytes(randBytes);
        return randBytes;
    }

    public static ByteBuffer genNonce(int length) {
        return ByteBuffer.wrap(KeyGenUtils.genRandomBytes(length));
    }

    public static IvParameterSpec genIV(int length) {
        return new IvParameterSpec(KeyGenUtils.genRandomBytes(length));
    }

    public static IvParameterSpec getIvParameterSpec(byte[] iv, int offset, int length) {
        return new IvParameterSpec(iv, offset, length);
    }

    public static IvParameterSpec getIvParameterSpec(ByteBuffer iv) {
        return new IvParameterSpec(Fields.copyToArray(iv));
    }

    private static ByteBuffer deriveBytes(SecretKey kdfKey, Class<?> c, String kdfString) throws InvalidKeyException {
        if (kdfString == null) {
            throw new NullPointerException();
        }
        MessageAuthCode kdf = new MessageAuthCode(MACType.HMACSHA512, kdfKey);
        return kdf.genMac(new byte[][]{(c.getName() + kdfString).getBytes(StandardCharsets.UTF_8)});
    }

    private static ByteBuffer deriveBytesTruncated(SecretKey kdfKey, Class<?> c, String kdfString, int len) throws InvalidKeyException {
        byte[] key = new byte[len];
        KeyGenUtils.deriveBytes(kdfKey, c, kdfString).get(key);
        return ByteBuffer.wrap(key);
    }

    public static SecretKey deriveSecretKey(SecretKey kdfKey, Class<?> c, String kdfString, KeyType type) throws InvalidKeyException {
        return KeyGenUtils.getSecretKey(type, KeyGenUtils.deriveBytesTruncated(kdfKey, c, kdfString, type.keySize >> 3));
    }

    public static IvParameterSpec deriveIvParameterSpec(SecretKey kdfKey, Class<?> c, String kdfString, KeyType ivType) throws InvalidKeyException {
        return KeyGenUtils.getIvParameterSpec(KeyGenUtils.deriveBytesTruncated(kdfKey, c, kdfString, ivType.ivSize >> 3));
    }
}

