/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.BlockCipher;
import freenet.crypt.JceLoader;
import freenet.crypt.ciphers.Rijndael;
import freenet.support.Fields;
import freenet.support.HexUtil;
import freenet.support.Loader;
import freenet.support.Logger;
import freenet.support.math.MersenneTwister;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class Util {
    protected static final int BUFFER_SIZE = 32768;
    public static final BigInteger TWO;
    private static final MessageDigest ctx;
    private static final int ctx_length;
    public static final Map<String, Provider> mdProviders;

    public static void fillByteArrayFromInts(int[] ints, byte[] bytes) {
        int ic = 0;
        for (int i : ints) {
            bytes[ic++] = (byte)(i >> 24);
            bytes[ic++] = (byte)(i >> 16);
            bytes[ic++] = (byte)(i >> 8);
            bytes[ic++] = (byte)i;
        }
    }

    public static void fillByteArrayFromLongs(long[] ints, byte[] bytes) {
        int ic = 0;
        for (long l : ints) {
            bytes[ic++] = (byte)(l >> 56);
            bytes[ic++] = (byte)(l >> 48);
            bytes[ic++] = (byte)(l >> 40);
            bytes[ic++] = (byte)(l >> 32);
            bytes[ic++] = (byte)(l >> 24);
            bytes[ic++] = (byte)(l >> 16);
            bytes[ic++] = (byte)(l >> 8);
            bytes[ic++] = (byte)l;
        }
    }

    public static byte[] MPIbytes(BigInteger num) {
        int len = num.bitLength();
        byte[] bytes = new byte[2 + (len + 8 >> 3)];
        System.arraycopy(num.toByteArray(), 0, bytes, 2, bytes.length - 2);
        bytes[0] = (byte)(len >> 8);
        bytes[1] = (byte)len;
        return bytes;
    }

    public static void writeMPI(BigInteger num, OutputStream out) throws IOException {
        out.write(Util.MPIbytes(num));
    }

    public static BigInteger readMPI(InputStream in) throws IOException {
        int b1 = in.read();
        int b2 = in.read();
        if (b1 == -1 || b2 == -1) {
            throw new EOFException();
        }
        byte[] data = new byte[(b1 << 8) + b2 + 8 >> 3];
        Util.readFully(in, data, 0, data.length);
        return new BigInteger(1, data);
    }

    public static byte[] hashBytes(MessageDigest d, byte[] b) {
        return Util.hashBytes(d, b, 0, b.length);
    }

    public static byte[] hashBytes(MessageDigest d, byte[] b, int offset, int length) {
        d.update(b, offset, length);
        return d.digest();
    }

    public static byte[] hashString(MessageDigest d, String s) {
        byte[] sbytes = s.getBytes(StandardCharsets.UTF_8);
        d.update(sbytes, 0, sbytes.length);
        return d.digest();
    }

    public static byte[] xor(byte[] b1, byte[] b2) {
        int maxl = Math.max(b1.length, b2.length);
        byte[] rv = new byte[maxl];
        int minl = Math.min(b1.length, b2.length);
        for (int i = 0; i < minl; ++i) {
            rv[i] = (byte)(b1[i] ^ b2[i]);
        }
        return rv;
    }

    public static void randomBytes(SecureRandom r, byte[] buf) {
        r.nextBytes(buf);
    }

    public static void randomBytes(SecureRandom r, byte[] buf, int from, int len) {
        Util.randomBytesSlowNextInt(r, buf, from, len);
    }

    private static void randomBytesSlowNextInt(Random r, byte[] buf, int from, int len) {
        if (from == 0 && len == buf.length) {
            r.nextBytes(buf);
            return;
        }
        byte[] tmp = new byte[len];
        r.nextBytes(tmp);
        System.arraycopy(tmp, 0, buf, from, len);
    }

    public static void randomBytes(Random r, byte[] buf) {
        Util.randomBytes(r, buf, 0, buf.length);
    }

    public static void randomBytes(Random r, byte[] buf, int from, int len) {
        int rnd;
        if (!(r instanceof MersenneTwister)) {
            Util.randomBytesSlowNextInt(r, buf, from, len);
            return;
        }
        int to = from + len;
        while (from + 4 <= to) {
            rnd = r.nextInt();
            buf[from++] = (byte)rnd;
            buf[from++] = (byte)(rnd >>= 8);
            buf[from++] = (byte)(rnd >>= 8);
            buf[from++] = (byte)(rnd >>= 8);
            rnd >>= 8;
        }
        if (to > from) {
            assert (to - from < 4);
            rnd = r.nextInt();
            while (from < to) {
                buf[from++] = (byte)rnd;
                rnd >>= 8;
            }
        }
    }

    @Deprecated
    public static boolean byteArrayEqual(byte[] a, byte[] b, int offset, int length) {
        return Fields.byteArrayEqual(a, b, offset, offset, length);
    }

    private static long benchmark(MessageDigest md) throws GeneralSecurityException {
        int i;
        long times = Long.MAX_VALUE;
        byte[] input = new byte[1024];
        byte[] output = new byte[md.getDigestLength()];
        for (i = 0; i < 32; ++i) {
            md.update(input, 0, input.length);
            md.digest(output, 0, output.length);
            System.arraycopy(output, 0, input, i * output.length % (input.length - output.length), output.length);
        }
        for (i = 0; i < 128; ++i) {
            long startTime = System.nanoTime();
            for (int j = 0; j < 4; ++j) {
                for (int k = 0; k < 32; ++k) {
                    md.update(input, 0, input.length);
                }
                md.digest(output, 0, output.length);
            }
            long endTime = System.nanoTime();
            times = Math.min(endTime - startTime, times);
            System.arraycopy(output, 0, input, 0, output.length);
        }
        return times;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeKey(byte[] entropy, byte[] key, int offset, int len) {
        try {
            MessageDigest messageDigest = ctx;
            synchronized (messageDigest) {
                ctx.digest();
                int ic = 0;
                while (len > 0) {
                    int bc;
                    ++ic;
                    for (int i = 0; i < ic; ++i) {
                        ctx.update((byte)0);
                    }
                    ctx.update(entropy, 0, entropy.length);
                    if (len > ctx_length) {
                        ctx.digest(key, offset, ctx_length);
                        bc = ctx_length;
                    } else {
                        byte[] hash = ctx.digest();
                        bc = Math.min(len, hash.length);
                        System.arraycopy(hash, 0, key, offset, bc);
                    }
                    offset += bc;
                    len -= bc;
                }
            }
            Arrays.fill(entropy, (byte)0);
        }
        catch (DigestException e) {
            throw new Error(e);
        }
    }

    public static BlockCipher getCipherByName(String name) {
        try {
            return (BlockCipher)Loader.getInstance("freenet.crypt.ciphers." + name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BlockCipher getCipherByName(String name, int keySize) {
        try {
            return (BlockCipher)Loader.getInstance("freenet.crypt.ciphers." + name, new Class[]{Integer.class}, new Object[]{keySize});
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("write")) {
            Util.writeMPI(new BigInteger("9"), System.out);
            Util.writeMPI(new BigInteger("1234567890123456789"), System.out);
            Util.writeMPI(new BigInteger("100200300400500600700800900"), System.out);
        } else if (args[0].equals("read")) {
            System.out.println("9");
            System.out.println(Util.readMPI(System.in));
            System.out.println("1234567890123456789");
            System.out.println(Util.readMPI(System.in));
            System.out.println("100200300400500600700800900");
            System.out.println(Util.readMPI(System.in));
        } else if (args[0].equals("write-mpi")) {
            Util.writeMPI(new BigInteger(args[1]), System.out);
        } else if (args[0].equals("read-mpi")) {
            System.err.println(Util.readMPI(System.in));
        } else if (args[0].equals("keygen")) {
            byte[] entropy = Util.readMPI(System.in).toByteArray();
            byte[] key = new byte[args.length > 1 ? Integer.parseInt(args[1]) : 16];
            Util.makeKey(entropy, key, 0, key.length);
            System.err.println(HexUtil.bytesToHex(key, 0, key.length));
        } else if (args[0].equals("shatest")) {
            MessageDigest messageDigest = ctx;
            synchronized (messageDigest) {
                ctx.digest();
                ctx.update((byte)97);
                ctx.update((byte)98);
                ctx.update((byte)99);
                System.err.println(HexUtil.bytesToHex(ctx.digest()));
            }
        }
    }

    public static int log2(long n) {
        int log2;
        for (log2 = 0; log2 < 63 && 1L << log2 < n; ++log2) {
        }
        return log2;
    }

    public static void readFully(InputStream in, byte[] b) throws IOException {
        Util.readFully(in, b, 0, b.length);
    }

    public static void readFully(InputStream in, byte[] b, int off, int length) throws IOException {
        int got;
        for (int total = 0; total < length; total += got) {
            got = in.read(b, off + total, length - total);
            if (got != -1) continue;
            throw new EOFException();
        }
    }

    public static double keyDigestAsNormalizedDouble(byte[] digest) {
        long asLong = Math.abs(Fields.bytesToLong(digest));
        if (asLong == Long.MIN_VALUE) {
            asLong = Long.MAX_VALUE;
        }
        return (double)asLong / 9.223372036854776E18;
    }

    static {
        Rijndael.class.toString();
        TWO = BigInteger.valueOf(2L);
        try {
            HashMap<String, Provider> mdProviders_internal = new HashMap<String, Provider>();
            for (String algo : new String[]{"SHA1", "MD5", "SHA-256", "SHA-384", "SHA-512"}) {
                Class<Util> clazz = Util.class;
                Provider sun = JceLoader.SUN;
                MessageDigest md = MessageDigest.getInstance(algo);
                md.digest();
                if (sun != null) {
                    try {
                        MessageDigest sun_md = MessageDigest.getInstance(algo, sun);
                        sun_md.digest();
                        if (md.getProvider() != sun_md.getProvider()) {
                            long time_def = Util.benchmark(md);
                            long time_sun = Util.benchmark(sun_md);
                            System.out.println(algo + " (" + md.getProvider() + "): " + time_def + "ns");
                            System.out.println(algo + " (" + sun_md.getProvider() + "): " + time_sun + "ns");
                            Logger.minor(clazz, algo + " (" + md.getProvider() + "): " + time_def + "ns");
                            Logger.minor(clazz, algo + " (" + sun_md.getProvider() + "): " + time_sun + "ns");
                            if (time_sun < time_def) {
                                md = sun_md;
                            }
                        }
                    }
                    catch (GeneralSecurityException e) {
                        Logger.warning(clazz, algo + "@" + sun + " benchmark failed", (Throwable)e);
                    }
                    catch (Throwable e) {
                        Logger.error(clazz, algo + "@" + sun + " benchmark failed", e);
                    }
                }
                Provider mdProvider = md.getProvider();
                System.out.println(algo + ": using " + mdProvider);
                Logger.normal(clazz, algo + ": using " + mdProvider);
                mdProviders_internal.put(algo, mdProvider);
            }
            mdProviders = Collections.unmodifiableMap(mdProviders_internal);
            ctx = MessageDigest.getInstance("SHA1", mdProviders.get("SHA1"));
            ctx_length = ctx.getDigestLength();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
    }
}

