/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.io.comm.ByteCounter;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.Message;
import freenet.io.comm.MessageFilter;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.PeerContext;
import freenet.io.comm.RetrievalException;
import freenet.io.comm.SlowAsyncMessageFilterCallback;
import freenet.io.xfer.AbortedException;
import freenet.io.xfer.BlockReceiver;
import freenet.io.xfer.PartiallyReceivedBlock;
import freenet.keys.CHKBlock;
import freenet.keys.CHKVerifyException;
import freenet.keys.KeyBlock;
import freenet.keys.NodeCHK;
import freenet.node.CHKInsertSender;
import freenet.node.InsertTag;
import freenet.node.Node;
import freenet.node.PeerNode;
import freenet.node.PrioRunnable;
import freenet.node.SyncSendWaitedTooLongException;
import freenet.store.KeyCollisionException;
import freenet.support.HexUtil;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import freenet.support.ShortBuffer;
import freenet.support.io.NativeThread;
import java.util.concurrent.TimeUnit;

public class CHKInsertHandler
implements PrioRunnable,
ByteCounter {
    private static volatile boolean logMINOR;
    static final long DATA_INSERT_TIMEOUT;
    final Node node;
    final long uid;
    final PeerNode source;
    final NodeCHK key;
    final long startTime;
    private short htl;
    private CHKInsertSender sender;
    private byte[] headers;
    private BlockReceiver br;
    private Thread runThread;
    PartiallyReceivedBlock prb;
    final InsertTag tag;
    private boolean canWriteDatastore;
    private final boolean forkOnCacheable;
    private final boolean preferInsert;
    private final boolean ignoreLowBackoff;
    private final boolean realTimeFlag;
    private boolean canCommit = false;
    private boolean sentCompletion = false;
    private Object sentCompletionLock = new Object();
    private boolean receiveFailed;
    private boolean receiveStarted;
    private boolean receiveCompleted;
    private final Object totalSync = new Object();
    private int totalSentBytes;
    private int totalReceivedBytes;
    private BlockReceiver.BlockReceiverTimeoutHandler myTimeoutHandler = new BlockReceiver.BlockReceiverTimeoutHandler(){

        @Override
        public void onFirstTimeout() {
        }

        @Override
        public void onFatalTimeout(PeerContext receivingFrom) {
            Logger.error(this, "Fatal timeout receiving insert " + CHKInsertHandler.this + " from " + receivingFrom);
            ((PeerNode)receivingFrom).fatalTimeout();
        }
    };

    CHKInsertHandler(NodeCHK key, short htl, PeerNode source, long id, Node node, long startTime, InsertTag tag, boolean forkOnCacheable, boolean preferInsert, boolean ignoreLowBackoff, boolean realTimeFlag) {
        this.node = node;
        this.uid = id;
        this.source = source;
        this.startTime = startTime;
        this.tag = tag;
        this.key = key;
        this.htl = htl;
        this.canWriteDatastore = node.canWriteDatastoreInsert(htl);
        this.forkOnCacheable = forkOnCacheable;
        this.preferInsert = preferInsert;
        this.ignoreLowBackoff = ignoreLowBackoff;
        this.realTimeFlag = realTimeFlag;
    }

    public String toString() {
        return super.toString() + " for " + this.uid;
    }

    @Override
    public void run() {
        Logger.OSThread.logPID(this);
        try {
            this.realRun();
        }
        catch (Throwable t) {
            Logger.error(this, "Caught in run() " + t, t);
            this.tag.handlerThrew(t);
        }
        finally {
            if (logMINOR) {
                Logger.minor(this, "Exiting CHKInsertHandler.run() for " + this.uid);
            }
            this.tag.unlockHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realRun() {
        int status;
        Message msg;
        this.runThread = Thread.currentThread();
        Message accepted = DMT.createFNPAccepted(this.uid);
        try {
            this.source.sendSync(accepted, this, this.realTimeFlag);
        }
        catch (NotConnectedException e1) {
            if (logMINOR) {
                Logger.minor(this, "Lost connection to source");
            }
            return;
        }
        catch (SyncSendWaitedTooLongException e) {
            Logger.error(this, "Unable to send " + accepted + " in a reasonable time to " + this.source);
            return;
        }
        if (this.tag.shouldSlowDown()) {
            try {
                this.source.sendAsync(DMT.createFNPRejectedOverload(this.uid, false, false, this.realTimeFlag), null, this);
            }
            catch (NotConnectedException e) {
                // empty catch block
            }
        }
        MessageFilter mf = this.makeDataInsertFilter(DATA_INSERT_TIMEOUT);
        try {
            msg = this.node.getUSM().waitFor(mf, this);
        }
        catch (DisconnectedException e) {
            Logger.normal(this, "Disconnected while waiting for DataInsert on " + this.uid);
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Received " + msg);
        }
        if (msg == null) {
            this.handleNoDataInsert();
            return;
        }
        if (msg.getSpec() == DMT.FNPDataInsertRejected) {
            try {
                this.source.sendAsync(DMT.createFNPDataInsertRejected(this.uid, msg.getShort("dataInsertRejectedReason")), null, this);
            }
            catch (NotConnectedException e) {
                // empty catch block
            }
            return;
        }
        this.headers = ((ShortBuffer)msg.getObject("blockHeaders")).getData();
        this.prb = new PartiallyReceivedBlock(32, 1024);
        if (this.htl > 0) {
            this.sender = this.node.makeInsertSender(this.key, this.htl, this.uid, this.tag, this.source, this.headers, this.prb, false, false, this.forkOnCacheable, this.preferInsert, this.ignoreLowBackoff, this.realTimeFlag);
        }
        this.br = new BlockReceiver(this.node.getUSM(), this.source, this.uid, this.prb, this, this.node.getTicker(), false, this.realTimeFlag, this.myTimeoutHandler, false);
        DataReceiver dataReceiver = new DataReceiver();
        this.receiveStarted = true;
        this.node.getExecutor().execute(dataReceiver, "CHKInsertHandler$DataReceiver for UID " + this.uid);
        boolean receivedRejectedOverload = false;
        do {
            CHKInsertSender cHKInsertSender = this.sender;
            synchronized (cHKInsertSender) {
                try {
                    if (this.sender.getStatus() == -1) {
                        this.sender.wait(5000L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.receiveFailed()) {
                this.finish(7);
                return;
            }
            if (receivedRejectedOverload || !this.sender.receivedRejectedOverload()) continue;
            receivedRejectedOverload = true;
            Message m = DMT.createFNPRejectedOverload(this.uid, false, true, this.realTimeFlag);
            try {
                this.source.sendAsync(m, null, this);
            }
            catch (NotConnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source");
                }
                return;
            }
        } while ((status = this.sender.getStatus()) == -1);
        if (status == 4 || status == 5 || status == 3) {
            msg = DMT.createFNPRejectedOverload(this.uid, true, true, this.realTimeFlag);
            try {
                this.source.sendSync(msg, this, this.realTimeFlag);
            }
            catch (NotConnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source");
                }
                return;
            }
            catch (SyncSendWaitedTooLongException e) {
                Logger.error(this, "Took too long to send " + msg + " to " + this.source);
                return;
            }
            if (status == 4 || status == 5) {
                this.canCommit = true;
            }
            this.finish(status);
            return;
        }
        if (status == 1 || status == 6) {
            msg = DMT.createFNPRouteNotFound(this.uid, this.sender.getHTL());
            try {
                this.source.sendSync(msg, this, this.realTimeFlag);
            }
            catch (NotConnectedException e) {
                if (logMINOR) {
                    Logger.minor(this, "Lost connection to source");
                }
                return;
            }
            catch (SyncSendWaitedTooLongException e) {
                Logger.error(this, "Took too long to send " + msg + " to " + this.source);
                return;
            }
            this.canCommit = true;
            this.finish(status);
            return;
        }
        if (status == 7) {
            this.finish(status);
            return;
        }
        if (status == 0) {
            msg = DMT.createFNPInsertReply(this.uid);
            try {
                this.source.sendSync(msg, this, this.realTimeFlag);
            }
            catch (NotConnectedException e) {
                Logger.minor(this, "Lost connection to source");
                return;
            }
            catch (SyncSendWaitedTooLongException e) {
                Logger.error(this, "Took too long to send " + msg + " to " + this.source);
                return;
            }
            this.canCommit = true;
            this.finish(status);
            return;
        }
        Logger.error(this, "Unknown status code: " + this.sender.getStatusString());
        msg = DMT.createFNPRejectedOverload(this.uid, true, true, this.realTimeFlag);
        try {
            this.source.sendSync(msg, this, this.realTimeFlag);
        }
        catch (NotConnectedException notConnectedException) {
        }
        catch (SyncSendWaitedTooLongException syncSendWaitedTooLongException) {
            // empty catch block
        }
        this.finish(3);
    }

    private MessageFilter makeDataInsertFilter(long timeout) {
        MessageFilter mfDataInsert = MessageFilter.create().setType(DMT.FNPDataInsert).setField("uid", this.uid).setSource(this.source).setTimeout(timeout);
        MessageFilter mfDataInsertRejected = MessageFilter.create().setType(DMT.FNPDataInsertRejected).setField("uid", this.uid).setSource(this.source).setTimeout(timeout);
        return mfDataInsert.or(mfDataInsertRejected);
    }

    private void handleNoDataInsert() {
        try {
            if (this.source.isConnected() && this.startTime > this.source.timeLastConnectionCompleted() + (long)(Node.HANDSHAKE_TIMEOUT * 4)) {
                Logger.warning(this, "Did not receive DataInsert on " + this.uid + " from " + this.source + " !");
            }
            Message tooSlow = DMT.createFNPRejectedTimeout(this.uid);
            this.source.sendAsync(tooSlow, null, this);
            Message m = DMT.createFNPInsertTransfersCompleted(this.uid, true);
            this.source.sendAsync(m, null, this);
            this.prb = new PartiallyReceivedBlock(32, 1024);
            this.br = new BlockReceiver(this.node.getUSM(), this.source, this.uid, this.prb, this, this.node.getTicker(), false, this.realTimeFlag, null, false);
            this.prb.abort(8, "No DataInsert", true);
            this.source.localRejectedOverload("TimedOutAwaitingDataInsert", this.realTimeFlag);
            MessageFilter mf = this.makeDataInsertFilter(TimeUnit.SECONDS.toMillis(60L));
            this.node.getUSM().addAsyncFilter(mf, new SlowAsyncMessageFilterCallback(){

                @Override
                public void onMatched(Message m) {
                }

                @Override
                public boolean shouldTimeout() {
                    return false;
                }

                @Override
                public void onTimeout() {
                    Logger.error(this, "No DataInsert for " + CHKInsertHandler.this + " from " + CHKInsertHandler.this.source + " (" + CHKInsertHandler.this.source.getVersionNumber() + ")");
                    CHKInsertHandler.this.source.fatalTimeout();
                }

                @Override
                public void onDisconnect(PeerContext ctx) {
                }

                @Override
                public void onRestarted(PeerContext ctx) {
                }

                @Override
                public int getPriority() {
                    return NativeThread.NORM_PRIORITY;
                }
            }, this);
            return;
        }
        catch (NotConnectedException e) {
            if (logMINOR) {
                Logger.minor(this, "Lost connection to source");
            }
            return;
        }
        catch (DisconnectedException e) {
            if (logMINOR) {
                Logger.minor(this, "Lost connection to source");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(int code) {
        boolean sentCompletionWasSet;
        if (logMINOR) {
            Logger.minor(this, "Waiting for receive");
        }
        long transferTimeout = this.realTimeFlag ? CHKInsertSender.TRANSFER_COMPLETION_ACK_TIMEOUT_REALTIME : CHKInsertSender.TRANSFER_COMPLETION_ACK_TIMEOUT_BULK;
        CHKInsertHandler cHKInsertHandler = this;
        synchronized (cHKInsertHandler) {
            while (this.receiveStarted && !this.receiveCompleted) {
                try {
                    this.wait(TimeUnit.SECONDS.toMillis(100L));
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        CHKBlock block = this.verify();
        Object object = this.sentCompletionLock;
        synchronized (object) {
            sentCompletionWasSet = this.sentCompletion;
            this.sentCompletion = true;
        }
        Message m = null;
        boolean routingTookTooLong = false;
        if (this.sender != null && !sentCompletionWasSet) {
            CHKInsertSender cHKInsertSender;
            if (logMINOR) {
                Logger.minor(this, "Waiting for completion");
            }
            long startedTime = System.currentTimeMillis();
            while (true) {
                cHKInsertSender = this.sender;
                synchronized (cHKInsertSender) {
                    block45: {
                        if (this.sender.completed()) {
                            break;
                        }
                        try {
                            int t = (int)Math.min(Integer.MAX_VALUE, startedTime + transferTimeout - System.currentTimeMillis());
                            if (t > 0) {
                                this.sender.wait(t);
                                break block45;
                            }
                            routingTookTooLong = true;
                            break;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (routingTookTooLong) {
                this.tag.timedOutToHandlerButContinued();
                sentCompletionWasSet = true;
                try {
                    this.source.sendAsync(DMT.createFNPInsertTransfersCompleted(this.uid, true), null, this);
                }
                catch (NotConnectedException notConnectedException) {
                    // empty catch block
                }
                Logger.error(this, "Insert took too long, telling downstream that it's finished and reassigning to self on " + this);
                while (true) {
                    cHKInsertSender = this.sender;
                    synchronized (cHKInsertSender) {
                        if (this.sender.completed()) {
                            break;
                        }
                        try {
                            this.sender.wait(TimeUnit.SECONDS.toMillis(10L));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (logMINOR) {
                    Logger.minor(this, "Completed after telling downstream on " + this);
                }
            }
            boolean failed = this.sender.anyTransfersFailed();
            if (!sentCompletionWasSet) {
                m = DMT.createFNPInsertTransfersCompleted(this.uid, failed);
            }
        }
        if (this.sender == null && !sentCompletionWasSet && this.canCommit) {
            m = DMT.createFNPInsertTransfersCompleted(this.uid, false);
        }
        if (block != null) {
            this.commit(block);
            block = null;
        }
        this.tag.unlockHandler();
        if (m != null) {
            try {
                this.source.sendSync(m, this, this.realTimeFlag);
                if (logMINOR) {
                    Logger.minor(this, "Sent completion: " + m + " for " + this);
                }
            }
            catch (NotConnectedException e1) {
                if (logMINOR) {
                    Logger.minor(this, "Not connected: " + this.source + " for " + this);
                }
            }
            catch (SyncSendWaitedTooLongException e) {
                Logger.error(this, "Took too long to send " + m + " to " + this.source);
            }
        }
        if (code != 4 && code != 5 && code != 3 && code != 6 && code != 7 && !this.receiveFailed()) {
            int totalSent = this.getTotalSentBytes();
            int totalReceived = this.getTotalReceivedBytes();
            if (this.sender != null) {
                totalSent += this.sender.getTotalSentBytes();
                totalReceived += this.sender.getTotalReceivedBytes();
            }
            if (logMINOR) {
                Logger.minor(this, "Remote CHK insert cost " + totalSent + '/' + totalReceived + " bytes (" + code + ") receive failed = " + this.receiveFailed());
            }
            this.node.getNodeStats().remoteChkInsertBytesSentAverage.report(totalSent);
            this.node.getNodeStats().remoteChkInsertBytesReceivedAverage.report(totalReceived);
            if (code == 0) {
                if (this.sender != null && this.sender.startedSendingData()) {
                    this.node.getNodeStats().successfulChkInsertBytesSentAverage.report(totalSent);
                }
                this.node.getNodeStats().successfulChkInsertBytesReceivedAverage.report(totalReceived);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CHKBlock verify() {
        CHKBlock block;
        block12: {
            Message toSend = null;
            block = null;
            CHKInsertHandler cHKInsertHandler = this;
            synchronized (cHKInsertHandler) {
                if (this.prb == null || this.prb.isAborted()) {
                    return null;
                }
                try {
                    if (!this.canCommit) {
                        return null;
                    }
                    if (!this.prb.allReceived()) {
                        return null;
                    }
                    block = new CHKBlock(this.prb.getBlock(), this.headers, this.key);
                }
                catch (CHKVerifyException e) {
                    Logger.error(this, "Verify failed in CHKInsertHandler: " + e + " - headers: " + HexUtil.bytesToHex(this.headers), (Throwable)e);
                    toSend = DMT.createFNPDataInsertRejected(this.uid, (short)1);
                }
                catch (AbortedException e) {
                    Logger.error(this, "Receive failed: " + e);
                }
            }
            if (toSend != null) {
                try {
                    this.source.sendAsync(toSend, null, this);
                }
                catch (NotConnectedException e) {
                    if (!logMINOR) break block12;
                    Logger.minor(this, "Lost connection in " + this + " when sending FNPDataInsertRejected");
                }
            }
        }
        return block;
    }

    private void commit(CHKBlock block) {
        try {
            this.node.store((KeyBlock)block, this.node.shouldStoreDeep(this.key, this.source, this.sender == null ? new PeerNode[]{} : this.sender.getRoutedTo()), false, this.canWriteDatastore, false);
        }
        catch (KeyCollisionException keyCollisionException) {
            // empty catch block
        }
        if (logMINOR) {
            Logger.minor(this, "Committed");
        }
    }

    private synchronized boolean receiveFailed() {
        return this.receiveFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sentBytes(int x) {
        Object object = this.totalSync;
        synchronized (object) {
            this.totalSentBytes += x;
        }
        this.node.getNodeStats().insertSentBytes(false, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedBytes(int x) {
        Object object = this.totalSync;
        synchronized (object) {
            this.totalReceivedBytes += x;
        }
        this.node.getNodeStats().insertReceivedBytes(false, x);
    }

    public int getTotalSentBytes() {
        return this.totalSentBytes;
    }

    public int getTotalReceivedBytes() {
        return this.totalReceivedBytes;
    }

    @Override
    public void sentPayload(int x) {
        this.node.sentPayload(x);
        this.node.getNodeStats().insertSentBytes(false, -x);
    }

    @Override
    public int getPriority() {
        return NativeThread.HIGH_PRIORITY;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
            }
        });
        DATA_INSERT_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    }

    public class DataReceiver
    implements PrioRunnable {
        @Override
        public void run() {
            Logger.OSThread.logPID(this);
            if (logMINOR) {
                Logger.minor(this, "Receiving data for " + CHKInsertHandler.this);
            }
            CHKInsertHandler.this.br.receive(new BlockReceiver.BlockReceiverCompletion(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void blockReceived(byte[] buf) {
                    if (logMINOR) {
                        Logger.minor(this, "Received data for " + CHKInsertHandler.this);
                    }
                    CHKInsertHandler cHKInsertHandler = CHKInsertHandler.this;
                    synchronized (cHKInsertHandler) {
                        CHKInsertHandler.this.receiveCompleted = true;
                        CHKInsertHandler.this.notifyAll();
                    }
                    CHKInsertHandler.this.node.getNodeStats().successfulBlockReceive(CHKInsertHandler.this.realTimeFlag, false);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void blockReceiveFailed(RetrievalException e) {
                    CHKInsertHandler cHKInsertHandler = CHKInsertHandler.this;
                    synchronized (cHKInsertHandler) {
                        CHKInsertHandler.this.receiveCompleted = true;
                        CHKInsertHandler.this.receiveFailed = true;
                        CHKInsertHandler.this.notifyAll();
                    }
                    if (CHKInsertHandler.this.sender != null) {
                        CHKInsertHandler.this.sender.onReceiveFailed();
                    }
                    CHKInsertHandler.this.runThread.interrupt();
                    CHKInsertHandler.this.tag.timedOutToHandlerButContinued();
                    Message msg = DMT.createFNPDataInsertRejected(CHKInsertHandler.this.uid, (short)2);
                    try {
                        CHKInsertHandler.this.source.sendSync(msg, CHKInsertHandler.this, CHKInsertHandler.this.realTimeFlag);
                    }
                    catch (NotConnectedException ex) {
                        if (logMINOR) {
                            Logger.minor(this, "Can't send " + msg + " to " + CHKInsertHandler.this.source + ": " + ex);
                        }
                    }
                    catch (SyncSendWaitedTooLongException ex) {
                        Logger.error(this, "Took too long to send " + msg + " to " + CHKInsertHandler.this.source);
                    }
                    if (e.getReason() == 7) {
                        Logger.normal(this, "Failed to retrieve (disconnect): " + e + " for " + CHKInsertHandler.this, (Throwable)e);
                    } else {
                        Logger.normal(this, "Failed to retrieve (" + e.getReason() + "/" + RetrievalException.getErrString(e.getReason()) + "): " + e + " for " + CHKInsertHandler.this, (Throwable)e);
                    }
                    if (!CHKInsertHandler.this.prb.abortedLocally()) {
                        CHKInsertHandler.this.node.getNodeStats().failedBlockReceive(false, false, CHKInsertHandler.this.realTimeFlag, false);
                    }
                }
            });
        }

        public String toString() {
            return super.toString() + " for " + CHKInsertHandler.this.uid;
        }

        @Override
        public int getPriority() {
            return NativeThread.HIGH_PRIORITY;
        }
    }
}

