/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.client.DefaultMIMETypes;
import freenet.io.comm.DMT;
import freenet.io.comm.DisconnectedException;
import freenet.io.comm.FreenetInetAddress;
import freenet.io.comm.Message;
import freenet.io.comm.NotConnectedException;
import freenet.io.comm.Peer;
import freenet.io.comm.PeerParseException;
import freenet.io.comm.ReferenceSignatureVerificationException;
import freenet.io.xfer.BulkReceiver;
import freenet.io.xfer.BulkTransmitter;
import freenet.io.xfer.PartiallyReceivedBulk;
import freenet.keys.FreenetURI;
import freenet.l10n.NodeL10n;
import freenet.node.DarknetPeerNodeStatus;
import freenet.node.FSParseException;
import freenet.node.Node;
import freenet.node.NodeCrypto;
import freenet.node.PeerNode;
import freenet.node.PeerNodeStatus;
import freenet.node.PeerTooOldException;
import freenet.node.UnqueueMessageOnAckCallback;
import freenet.node.useralerts.AbstractUserAlert;
import freenet.node.useralerts.BookmarkFeedUserAlert;
import freenet.node.useralerts.DownloadFeedUserAlert;
import freenet.node.useralerts.N2NTMUserAlert;
import freenet.node.useralerts.UserAlert;
import freenet.node.useralerts.UserAlertManager;
import freenet.support.Base64;
import freenet.support.HTMLNode;
import freenet.support.IllegalBase64Exception;
import freenet.support.Logger;
import freenet.support.SimpleFieldSet;
import freenet.support.SizeUtil;
import freenet.support.api.HTTPUploadedFile;
import freenet.support.api.RandomAccessBuffer;
import freenet.support.io.BucketTools;
import freenet.support.io.ByteArrayRandomAccessBuffer;
import freenet.support.io.FileRandomAccessBuffer;
import freenet.support.io.FileUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.concurrent.TimeUnit;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class DarknetPeerNode
extends PeerNode {
    String myName;
    private boolean isDisabled;
    private boolean isListenOnly;
    private boolean isBurstOnly;
    private boolean ignoreSourcePort;
    private boolean allowLocalAddresses;
    private LinkedHashSet<Integer> extraPeerDataFileNumbers;
    private String privateDarknetComment;
    private int privateDarknetCommentFileNumber;
    private LinkedHashSet<Integer> queuedToSendN2NMExtraPeerDataFileNumbers;
    private FRIEND_TRUST trustLevel;
    private FRIEND_VISIBILITY ourVisibility;
    private FRIEND_VISIBILITY theirVisibility;
    private static volatile boolean logMINOR;
    private final HashMap<Long, FileOffer> myFileOffersByUID = new HashMap();
    private final HashMap<Long, FileOffer> hisFileOffersByUID = new HashMap();
    private boolean sendingFullNoderef;
    private boolean receivingFullNoderef;

    public DarknetPeerNode(SimpleFieldSet fs, Node node2, NodeCrypto crypto, boolean fromLocal, FRIEND_TRUST trust, FRIEND_VISIBILITY visibility2) throws FSParseException, PeerParseException, ReferenceSignatureVerificationException, PeerTooOldException {
        super(fs, node2, crypto, fromLocal);
        String name = fs.get("myName");
        if (name == null) {
            throw new FSParseException("No name");
        }
        this.myName = name;
        if (fromLocal) {
            SimpleFieldSet metadata = fs.subset("metadata");
            this.isDisabled = metadata.getBoolean("isDisabled", false);
            this.isListenOnly = metadata.getBoolean("isListenOnly", false);
            this.isBurstOnly = metadata.getBoolean("isBurstOnly", false);
            this.disableRouting = this.disableRoutingHasBeenSetLocally = metadata.getBoolean("disableRoutingHasBeenSetLocally", false);
            this.ignoreSourcePort = metadata.getBoolean("ignoreSourcePort", false);
            this.allowLocalAddresses = metadata.getBoolean("allowLocalAddresses", false);
            String s = metadata.get("trustLevel");
            if (s != null) {
                this.trustLevel = FRIEND_TRUST.valueOf(s);
            } else {
                this.trustLevel = this.node.getSecurityLevels().getDefaultFriendTrust();
                System.err.println("Assuming friend (" + name + ") trust is opposite of friend seclevel: " + (Object)((Object)this.trustLevel));
            }
            s = metadata.get("ourVisibility");
            if (s != null) {
                this.ourVisibility = FRIEND_VISIBILITY.valueOf(s);
            } else {
                System.err.println("Assuming friend (" + name + ") wants to be invisible");
                this.node.createVisibilityAlert();
                this.ourVisibility = FRIEND_VISIBILITY.NO;
            }
            s = metadata.get("theirVisibility");
            this.theirVisibility = s != null ? FRIEND_VISIBILITY.valueOf(s) : FRIEND_VISIBILITY.NO;
        } else {
            if (trust == null) {
                throw new IllegalArgumentException();
            }
            this.trustLevel = trust;
            this.ourVisibility = visibility2;
        }
        this.privateDarknetComment = "";
        this.privateDarknetCommentFileNumber = -1;
        this.extraPeerDataFileNumbers = new LinkedHashSet();
        this.queuedToSendN2NMExtraPeerDataFileNumbers = new LinkedHashSet();
    }

    @Override
    public synchronized Peer getPeer() {
        Peer detectedPeer = super.getPeer();
        if (this.ignoreSourcePort) {
            int port;
            FreenetInetAddress addr = detectedPeer == null ? null : detectedPeer.getFreenetAddress();
            int n = port = detectedPeer == null ? -1 : detectedPeer.getPort();
            if (this.nominalPeer == null) {
                return detectedPeer;
            }
            for (Peer p : this.nominalPeer) {
                if (p.getPort() == port || !p.getFreenetAddress().equals(addr)) continue;
                return p;
            }
        }
        return detectedPeer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldSendHandshake() {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            if (this.isDisabled) {
                return false;
            }
            if (this.isListenOnly) {
                return false;
            }
            if (!super.shouldSendHandshake()) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected synchronized boolean innerProcessNewNoderef(SimpleFieldSet fs, boolean forARK, boolean forDiffNodeRef, boolean forFullNodeRef) throws FSParseException {
        boolean changedAnything = super.innerProcessNewNoderef(fs, forARK, forDiffNodeRef, forFullNodeRef);
        String name = fs.get("myName");
        if (name == null && forFullNodeRef) {
            throw new FSParseException("No name in full noderef");
        }
        if (name != null && !name.equals(this.myName)) {
            changedAnything = true;
            this.myName = name;
        }
        return changedAnything;
    }

    @Override
    public synchronized SimpleFieldSet exportFieldSet() {
        SimpleFieldSet fs = super.exportFieldSet();
        fs.putSingle("myName", this.getName());
        return fs;
    }

    @Override
    public synchronized SimpleFieldSet exportMetadataFieldSet(long now) {
        SimpleFieldSet fs = super.exportMetadataFieldSet(now);
        if (this.isDisabled) {
            fs.putSingle("isDisabled", "true");
        }
        if (this.isListenOnly) {
            fs.putSingle("isListenOnly", "true");
        }
        if (this.isBurstOnly) {
            fs.putSingle("isBurstOnly", "true");
        }
        if (this.ignoreSourcePort) {
            fs.putSingle("ignoreSourcePort", "true");
        }
        if (this.allowLocalAddresses) {
            fs.putSingle("allowLocalAddresses", "true");
        }
        if (this.disableRoutingHasBeenSetLocally) {
            fs.putSingle("disableRoutingHasBeenSetLocally", "true");
        }
        fs.putSingle("trustLevel", this.trustLevel.name());
        fs.putSingle("ourVisibility", this.ourVisibility.name());
        if (this.theirVisibility != null) {
            fs.putSingle("theirVisibility", this.theirVisibility.name());
        }
        return fs;
    }

    public synchronized String getName() {
        return this.myName;
    }

    @Override
    protected synchronized int getPeerNodeStatus(long now, long backedOffUntilRT, long backedOffUntilBulk, boolean overPingThreshold, boolean noLoadStats) {
        if (this.isDisabled) {
            return 7;
        }
        int status = super.getPeerNodeStatus(now, backedOffUntilRT, backedOffUntilBulk, overPingThreshold, noLoadStats);
        if (status == 1 || status == 11 || status == 2 || status == 12 || status == 3 || status == 4 || status == 14 || status == 13 || status == 15) {
            return status;
        }
        if (this.isListenOnly) {
            return 10;
        }
        if (this.isBurstOnly) {
            return 9;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enablePeer() {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            this.isDisabled = false;
        }
        this.setPeerNodeStatus(System.currentTimeMillis());
        this.node.getPeers().writePeersDarknetUrgent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disablePeer() {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            this.isDisabled = true;
        }
        if (this.isConnected()) {
            this.forceDisconnect();
        }
        this.stopARKFetcher();
        this.setPeerNodeStatus(System.currentTimeMillis());
        this.node.getPeers().writePeersDarknetUrgent();
    }

    @Override
    public synchronized boolean isDisabled() {
        return this.isDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListenOnly(boolean setting) {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            this.isListenOnly = setting;
        }
        if (setting && this.isBurstOnly()) {
            this.setBurstOnly(false);
        }
        if (setting) {
            this.stopARKFetcher();
        }
        this.setPeerNodeStatus(System.currentTimeMillis());
        this.node.getPeers().writePeersDarknetUrgent();
    }

    public synchronized boolean isListenOnly() {
        return this.isListenOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBurstOnly(boolean setting) {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            this.isBurstOnly = setting;
        }
        if (setting && this.isListenOnly()) {
            this.setListenOnly(false);
        }
        long now = System.currentTimeMillis();
        if (!setting) {
            DarknetPeerNode darknetPeerNode2 = this;
            synchronized (darknetPeerNode2) {
                this.sendHandshakeTime = now;
            }
        }
        this.setPeerNodeStatus(now);
        this.node.getPeers().writePeersDarknetUrgent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIgnoreSourcePort(boolean setting) {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            this.ignoreSourcePort = setting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRoutingStatus(boolean shouldRoute, boolean localRequest) {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            if (localRequest) {
                this.disableRoutingHasBeenSetLocally = !shouldRoute;
            } else {
                this.disableRoutingHasBeenSetRemotely = !shouldRoute;
            }
            this.disableRouting = this.disableRoutingHasBeenSetLocally || this.disableRoutingHasBeenSetRemotely;
        }
        if (localRequest) {
            Message msg = DMT.createRoutingStatus(shouldRoute);
            try {
                this.sendAsync(msg, null, this.node.getNodeStats().setRoutingStatusCtr);
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
        }
        this.setPeerNodeStatus(System.currentTimeMillis());
        this.node.getPeers().writePeersDarknetUrgent();
    }

    @Override
    public boolean isIgnoreSource() {
        return this.ignoreSourcePort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBurstOnly() {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            if (this.isBurstOnly) {
                return true;
            }
        }
        return super.isBurstOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allowLocalAddresses() {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            if (this.allowLocalAddresses) {
                return true;
            }
        }
        return super.allowLocalAddresses();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowLocalAddresses(boolean setting) {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            this.allowLocalAddresses = setting;
        }
        this.node.getPeers().writePeersDarknetUrgent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readExtraPeerData() {
        String extraPeerDataDirPath = this.node.getExtraPeerDataDir();
        File extraPeerDataPeerDir = new File(extraPeerDataDirPath + File.separator + this.getIdentityString());
        if (!extraPeerDataPeerDir.exists()) {
            return false;
        }
        if (!extraPeerDataPeerDir.isDirectory()) {
            Logger.error(this, "Extra peer data directory for peer not a directory: " + extraPeerDataPeerDir.getPath());
            return false;
        }
        File[] extraPeerDataFiles = extraPeerDataPeerDir.listFiles();
        if (extraPeerDataFiles == null) {
            return false;
        }
        boolean gotError = false;
        boolean readResult = false;
        for (File extraPeerDataFile : extraPeerDataFiles) {
            Integer fileNumber;
            try {
                fileNumber = Integer.valueOf(extraPeerDataFile.getName());
            }
            catch (NumberFormatException e) {
                gotError = true;
                continue;
            }
            LinkedHashSet<Integer> linkedHashSet = this.extraPeerDataFileNumbers;
            synchronized (linkedHashSet) {
                this.extraPeerDataFileNumbers.add(fileNumber);
            }
            readResult = this.readExtraPeerDataFile(extraPeerDataFile, fileNumber);
            if (readResult) continue;
            gotError = true;
        }
        return !gotError;
    }

    public boolean rereadExtraPeerDataFile(int fileNumber) {
        String extraPeerDataDirPath;
        File extraPeerDataPeerDir;
        if (logMINOR) {
            Logger.minor(this, "Rereading peer data file " + fileNumber + " for " + this.shortToString());
        }
        if (!(extraPeerDataPeerDir = new File((extraPeerDataDirPath = this.node.getExtraPeerDataDir()) + File.separator + this.getIdentityString())).exists()) {
            Logger.error(this, "Extra peer data directory for peer does not exist: " + extraPeerDataPeerDir.getPath());
            return false;
        }
        if (!extraPeerDataPeerDir.isDirectory()) {
            Logger.error(this, "Extra peer data directory for peer not a directory: " + extraPeerDataPeerDir.getPath());
            return false;
        }
        File extraPeerDataFile = new File(extraPeerDataDirPath + File.separator + this.getIdentityString() + File.separator + fileNumber);
        if (!extraPeerDataFile.exists()) {
            Logger.error(this, "Extra peer data file for peer does not exist: " + extraPeerDataFile.getPath());
            return false;
        }
        return this.readExtraPeerDataFile(extraPeerDataFile, fileNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readExtraPeerDataFile(File extraPeerDataFile, int fileNumber) {
        FileInputStream fis;
        if (logMINOR) {
            Logger.minor(this, "Reading " + extraPeerDataFile + " : " + fileNumber + " for " + this.shortToString());
        }
        boolean gotError = false;
        if (!extraPeerDataFile.exists()) {
            if (logMINOR) {
                Logger.minor(this, "Does not exist");
            }
            return false;
        }
        Logger.normal(this, "extraPeerDataFile: " + extraPeerDataFile.getPath());
        try {
            fis = new FileInputStream(extraPeerDataFile);
        }
        catch (FileNotFoundException e1) {
            Logger.normal(this, "Extra peer data file not found: " + extraPeerDataFile.getPath());
            return false;
        }
        InputStreamReader isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
        BufferedReader br = new BufferedReader(isr);
        SimpleFieldSet fs = null;
        try {
            fs = new SimpleFieldSet(br, false, true);
        }
        catch (EOFException e5) {
        }
        catch (IOException e4) {
            Logger.error(this, "Could not read extra peer data file: " + e4, (Throwable)e4);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e5) {
                Logger.error(this, "Ignoring " + e5 + " caught reading " + extraPeerDataFile.getPath(), (Throwable)e5);
            }
        }
        if (fs == null) {
            Logger.normal(this, "Deleting corrupt (too short?) file: " + extraPeerDataFile);
            this.deleteExtraPeerDataFile(fileNumber);
            return true;
        }
        boolean parseResult = false;
        try {
            parseResult = this.parseExtraPeerData(fs, extraPeerDataFile, fileNumber);
            if (!parseResult) {
                gotError = true;
            }
        }
        catch (FSParseException e2) {
            Logger.error(this, "Could not parse extra peer data: " + e2 + '\n' + fs.toString(), (Throwable)e2);
            gotError = true;
        }
        return !gotError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseExtraPeerData(SimpleFieldSet fs, File extraPeerDataFile, int fileNumber) throws FSParseException {
        String extraPeerDataTypeString = fs.get("extraPeerDataType");
        int extraPeerDataType = -1;
        try {
            extraPeerDataType = Integer.parseInt(extraPeerDataTypeString);
        }
        catch (NumberFormatException e) {
            Logger.error(this, "NumberFormatException parsing extraPeerDataType (" + extraPeerDataTypeString + ") in file " + extraPeerDataFile.getPath());
            return false;
        }
        if (extraPeerDataType == 1) {
            this.node.handleNodeToNodeTextMessageSimpleFieldSet(fs, this, fileNumber);
            return true;
        }
        if (extraPeerDataType == 2) {
            String peerNoteTypeString = fs.get("peerNoteType");
            int peerNoteType = -1;
            try {
                peerNoteType = Integer.parseInt(peerNoteTypeString);
            }
            catch (NumberFormatException e) {
                Logger.error(this, "NumberFormatException parsing peerNoteType (" + peerNoteTypeString + ") in file " + extraPeerDataFile.getPath());
                return false;
            }
            if (peerNoteType == 1) {
                DarknetPeerNode e = this;
                synchronized (e) {
                    try {
                        this.privateDarknetComment = Base64.decodeUTF8(fs.get("privateDarknetComment"));
                    }
                    catch (IllegalBase64Exception e2) {
                        Logger.error(this, "Bad Base64 encoding when decoding a private darknet comment SimpleFieldSet", (Throwable)e2);
                        return false;
                    }
                    this.privateDarknetCommentFileNumber = fileNumber;
                }
                return true;
            }
            Logger.error(this, "Read unknown peer note type '" + peerNoteType + "' from file " + extraPeerDataFile.getPath());
            return false;
        }
        if (extraPeerDataType == 3) {
            int type = fs.getInt("n2nType");
            if (this.isConnected()) {
                if (fs.get("extraPeerDataType") != null) {
                    fs.removeValue("extraPeerDataType");
                }
                if (fs.get("senderFileNumber") != null) {
                    fs.removeValue("senderFileNumber");
                }
                fs.putOverwrite("senderFileNumber", String.valueOf(fileNumber));
                if (fs.get("sentTime") != null) {
                    fs.removeValue("sentTime");
                }
                fs.putOverwrite("sentTime", Long.toString(System.currentTimeMillis()));
                Message n2nm = DMT.createNodeToNodeMessage(type, fs.toString().getBytes(StandardCharsets.UTF_8));
                UnqueueMessageOnAckCallback cb = new UnqueueMessageOnAckCallback(this, fileNumber);
                try {
                    this.sendAsync(n2nm, cb, null);
                    Logger.normal(this, "Sending queued (" + fileNumber + ") N2NM to '" + this.getName() + "': " + n2nm);
                }
                catch (NotConnectedException e) {
                    fs.removeValue("sentTime");
                }
            }
            return true;
        }
        if (extraPeerDataType == 4) {
            Logger.normal(this, "Read friend bookmark" + fs.toString());
            this.handleFproxyBookmarkFeed(fs, fileNumber);
            return true;
        }
        if (extraPeerDataType == 5) {
            Logger.normal(this, "Read friend download" + fs.toString());
            this.handleFproxyDownloadFeed(fs, fileNumber);
            return true;
        }
        Logger.error(this, "Read unknown extra peer data type '" + extraPeerDataType + "' from file " + extraPeerDataFile.getPath());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeNewExtraPeerDataFile(SimpleFieldSet fs, int extraPeerDataType) {
        FileOutputStream fos;
        File extraPeerDataPeerDir;
        String extraPeerDataDirPath = this.node.getExtraPeerDataDir();
        if (extraPeerDataType > 0) {
            fs.putOverwrite("extraPeerDataType", Integer.toString(extraPeerDataType));
        }
        if (!(extraPeerDataPeerDir = new File(extraPeerDataDirPath + File.separator + this.getIdentityString())).exists() && !extraPeerDataPeerDir.mkdir()) {
            Logger.error(this, "Extra peer data directory for peer could not be created: " + extraPeerDataPeerDir.getPath());
            return -1;
        }
        if (!extraPeerDataPeerDir.isDirectory()) {
            Logger.error(this, "Extra peer data directory for peer not a directory: " + extraPeerDataPeerDir.getPath());
            return -1;
        }
        int nextFileNumber = 0;
        LinkedHashSet<Integer> linkedHashSet = this.extraPeerDataFileNumbers;
        synchronized (linkedHashSet) {
            int localFileNumber;
            Object[] localFileNumbers = this.extraPeerDataFileNumbers.toArray(new Integer[this.extraPeerDataFileNumbers.size()]);
            Arrays.sort(localFileNumbers);
            Object[] objectArray = localFileNumbers;
            int n = objectArray.length;
            for (int i = 0; i < n && (localFileNumber = ((Integer)objectArray[i]).intValue()) <= nextFileNumber; ++i) {
                nextFileNumber = localFileNumber + 1;
            }
            this.extraPeerDataFileNumbers.add(nextFileNumber);
        }
        File extraPeerDataFile = new File(extraPeerDataPeerDir.getPath() + File.separator + nextFileNumber);
        if (extraPeerDataFile.exists()) {
            Logger.error(this, "Extra peer data file already exists: " + extraPeerDataFile.getPath());
            return -1;
        }
        String f = extraPeerDataFile.getPath();
        try {
            fos = new FileOutputStream(f);
        }
        catch (FileNotFoundException e2) {
            Logger.error(this, "Cannot write extra peer data file to disk: Cannot create " + f + " - " + e2, (Throwable)e2);
            return -1;
        }
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
        BufferedWriter bw = new BufferedWriter(w);
        try {
            fs.writeTo(bw);
            bw.close();
        }
        catch (IOException e) {
            try {
                fos.close();
            }
            catch (IOException e1) {
                Logger.error(this, "Cannot close extra peer data file: " + e, (Throwable)e);
            }
            Logger.error(this, "Cannot write file: " + e, (Throwable)e);
            return -1;
        }
        return nextFileNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteExtraPeerDataFile(int fileNumber) {
        String extraPeerDataDirPath = this.node.getExtraPeerDataDir();
        File extraPeerDataPeerDir = new File(extraPeerDataDirPath, this.getIdentityString());
        if (!extraPeerDataPeerDir.exists()) {
            Logger.error(this, "Extra peer data directory for peer does not exist: " + extraPeerDataPeerDir.getPath());
            return;
        }
        if (!extraPeerDataPeerDir.isDirectory()) {
            Logger.error(this, "Extra peer data directory for peer not a directory: " + extraPeerDataPeerDir.getPath());
            return;
        }
        File extraPeerDataFile = new File(extraPeerDataPeerDir, Integer.toString(fileNumber));
        if (!extraPeerDataFile.exists()) {
            Logger.error(this, "Extra peer data file for peer does not exist: " + extraPeerDataFile.getPath());
            return;
        }
        LinkedHashSet<Integer> linkedHashSet = this.extraPeerDataFileNumbers;
        synchronized (linkedHashSet) {
            this.extraPeerDataFileNumbers.remove(fileNumber);
        }
        if (!extraPeerDataFile.delete()) {
            if (extraPeerDataFile.exists()) {
                Logger.error(this, "Cannot delete file " + extraPeerDataFile + " after sending message to " + this.getPeer() + " - it may be resent on resting the node");
            } else {
                Logger.normal(this, "File does not exist when deleting: " + extraPeerDataFile + " after sending message to " + this.getPeer());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExtraPeerDataDir() {
        String extraPeerDataDirPath = this.node.getExtraPeerDataDir();
        File extraPeerDataPeerDir = new File(extraPeerDataDirPath + File.separator + this.getIdentityString());
        if (!extraPeerDataPeerDir.exists()) {
            Logger.error(this, "Extra peer data directory for peer does not exist: " + extraPeerDataPeerDir.getPath());
            return;
        }
        if (!extraPeerDataPeerDir.isDirectory()) {
            Logger.error(this, "Extra peer data directory for peer not a directory: " + extraPeerDataPeerDir.getPath());
            return;
        }
        Integer[] integerArray = this.extraPeerDataFileNumbers;
        synchronized (this.extraPeerDataFileNumbers) {
            Integer[] localFileNumbers = this.extraPeerDataFileNumbers.toArray(new Integer[this.extraPeerDataFileNumbers.size()]);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (Integer localFileNumber : localFileNumbers) {
                this.deleteExtraPeerDataFile(localFileNumber);
            }
            extraPeerDataPeerDir.delete();
            return;
        }
    }

    public boolean rewriteExtraPeerDataFile(SimpleFieldSet fs, int extraPeerDataType, int fileNumber) {
        FileOutputStream fos;
        File extraPeerDataPeerDir;
        String extraPeerDataDirPath = this.node.getExtraPeerDataDir();
        if (extraPeerDataType > 0) {
            fs.putOverwrite("extraPeerDataType", Integer.toString(extraPeerDataType));
        }
        if (!(extraPeerDataPeerDir = new File(extraPeerDataDirPath + File.separator + this.getIdentityString())).exists()) {
            Logger.error(this, "Extra peer data directory for peer does not exist: " + extraPeerDataPeerDir.getPath());
            return false;
        }
        if (!extraPeerDataPeerDir.isDirectory()) {
            Logger.error(this, "Extra peer data directory for peer not a directory: " + extraPeerDataPeerDir.getPath());
            return false;
        }
        File extraPeerDataFile = new File(extraPeerDataDirPath + File.separator + this.getIdentityString() + File.separator + fileNumber);
        if (!extraPeerDataFile.exists()) {
            Logger.error(this, "Extra peer data file for peer does not exist: " + extraPeerDataFile.getPath());
            return false;
        }
        String f = extraPeerDataFile.getPath();
        try {
            fos = new FileOutputStream(f);
        }
        catch (FileNotFoundException e2) {
            Logger.error(this, "Cannot write extra peer data file to disk: Cannot open " + f + " - " + e2, (Throwable)e2);
            return false;
        }
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
        BufferedWriter bw = new BufferedWriter(w);
        try {
            fs.writeTo(bw);
            bw.close();
        }
        catch (IOException e) {
            try {
                fos.close();
            }
            catch (IOException e1) {
                Logger.error(this, "Cannot close extra peer data file: " + e, (Throwable)e);
            }
            Logger.error(this, "Cannot write file: " + e, (Throwable)e);
            return false;
        }
        return true;
    }

    public synchronized String getPrivateDarknetCommentNote() {
        return this.privateDarknetComment;
    }

    public synchronized void setPrivateDarknetCommentNote(String comment) {
        this.privateDarknetComment = comment;
        int localFileNumber = this.privateDarknetCommentFileNumber;
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.put("peerNoteType", 1);
        fs.putSingle("privateDarknetComment", Base64.encodeUTF8(comment));
        if (localFileNumber == -1) {
            this.privateDarknetCommentFileNumber = localFileNumber = this.writeNewExtraPeerDataFile(fs, 2);
        } else {
            this.rewriteExtraPeerDataFile(fs, 2, localFileNumber);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int queueN2NM(SimpleFieldSet fs) {
        int fileNumber = this.writeNewExtraPeerDataFile(fs, 3);
        LinkedHashSet<Integer> linkedHashSet = this.queuedToSendN2NMExtraPeerDataFileNumbers;
        synchronized (linkedHashSet) {
            this.queuedToSendN2NMExtraPeerDataFileNumbers.add(fileNumber);
        }
        return fileNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unqueueN2NM(int fileNumber) {
        LinkedHashSet<Integer> linkedHashSet = this.queuedToSendN2NMExtraPeerDataFileNumbers;
        synchronized (linkedHashSet) {
            this.queuedToSendN2NMExtraPeerDataFileNumbers.add(fileNumber);
        }
        this.deleteExtraPeerDataFile(fileNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQueuedN2NMs() {
        if (logMINOR) {
            Logger.minor(this, "Sending queued N2NMs for " + this.shortToString());
        }
        Object[] objectArray = this.queuedToSendN2NMExtraPeerDataFileNumbers;
        synchronized (this.queuedToSendN2NMExtraPeerDataFileNumbers) {
            Object[] localFileNumbers = this.queuedToSendN2NMExtraPeerDataFileNumbers.toArray(new Integer[this.queuedToSendN2NMExtraPeerDataFileNumbers.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            Arrays.sort(localFileNumbers);
            for (Object localFileNumber : localFileNumbers) {
                this.rereadExtraPeerDataFile((Integer)localFileNumber);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void startARKFetcher() {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            if (this.isListenOnly) {
                Logger.minor(this, "Not starting ark fetcher for " + this + " as it's in listen-only mode.");
                return;
            }
        }
        super.startARKFetcher();
    }

    @Override
    public String getTMCIPeerInfo() {
        return this.getName() + '\t' + super.getTMCIPeerInfo();
    }

    @Override
    protected void onConnect() {
        super.onConnect();
        this.sendQueuedN2NMs();
    }

    private void storeOffers() {
    }

    public int sendBookmarkFeed(FreenetURI uri, String name, String description, boolean hasAnActiveLink) {
        long now = System.currentTimeMillis();
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("URI", uri.toString());
        fs.putSingle("Name", name);
        fs.put("composedTime", now);
        fs.put("hasAnActivelink", hasAnActiveLink);
        if (description != null) {
            fs.putSingle("Description", Base64.encodeUTF8(description));
        }
        fs.put("type", 5);
        this.sendNodeToNodeMessage(fs, 1, true, now, true);
        this.setPeerNodeStatus(System.currentTimeMillis());
        return this.getPeerNodeStatus();
    }

    public int sendDownloadFeed(FreenetURI URI2, String description) {
        long now = System.currentTimeMillis();
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.putSingle("URI", URI2.toString());
        fs.put("composedTime", now);
        if (description != null) {
            fs.putSingle("Description", Base64.encodeUTF8(description));
        }
        fs.put("type", 6);
        this.sendNodeToNodeMessage(fs, 1, true, now, true);
        this.setPeerNodeStatus(System.currentTimeMillis());
        return this.getPeerNodeStatus();
    }

    public int sendTextFeed(String message) {
        long now = System.currentTimeMillis();
        long msgid = Math.abs(this.node.getRandom().nextLong());
        int requiredN2nCount = 1 + (message.length() - 1) / 1024;
        for (int i = 0; i < requiredN2nCount; ++i) {
            String messagePart = message.substring(i * 1024, Math.min((i + 1) * 1024, message.length()));
            SimpleFieldSet fs = new SimpleFieldSet(true);
            fs.put("type", 1);
            fs.putSingle("text", Base64.encodeUTF8(messagePart));
            fs.put("msgid", msgid);
            fs.put("requiredParts", requiredN2nCount);
            fs.put("partIndex", i);
            fs.put("composedTime", now + (long)i);
            this.sendNodeToNodeMessage(fs, 1, true, now, true);
            this.setPeerNodeStatus(System.currentTimeMillis());
        }
        return this.getPeerNodeStatus();
    }

    public int sendFileOfferAccepted(long uid) {
        long now = System.currentTimeMillis();
        this.storeOffers();
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.put("type", 3);
        fs.put("uid", uid);
        if (logMINOR) {
            Logger.minor(this, "Sending node to node message (file offer accepted):\n" + fs);
        }
        this.sendNodeToNodeMessage(fs, 1, true, now, true);
        this.setPeerNodeStatus(System.currentTimeMillis());
        return this.getPeerNodeStatus();
    }

    public int sendFileOfferRejected(long uid) {
        long now = System.currentTimeMillis();
        this.storeOffers();
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fs.put("type", 4);
        fs.put("uid", uid);
        if (logMINOR) {
            Logger.minor(this, "Sending node to node message (file offer rejected):\n" + fs);
        }
        this.sendNodeToNodeMessage(fs, 1, true, now, true);
        this.setPeerNodeStatus(System.currentTimeMillis());
        return this.getPeerNodeStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int sendFileOffer(String fnam, String mime, String message, RandomAccessBuffer data) throws IOException {
        long uid = this.node.getRandom().nextLong();
        long now = System.currentTimeMillis();
        FileOffer fo = new FileOffer(uid, data, fnam, mime, message);
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            this.myFileOffersByUID.put(uid, fo);
        }
        this.storeOffers();
        SimpleFieldSet fs = new SimpleFieldSet(true);
        fo.toFieldSet(fs);
        if (logMINOR) {
            Logger.minor(this, "Sending node to node message (file offer):\n" + fs);
        }
        fs.put("type", 2);
        this.sendNodeToNodeMessage(fs, 1, true, now, true);
        this.setPeerNodeStatus(System.currentTimeMillis());
        return this.getPeerNodeStatus();
    }

    public int sendFileOffer(File file, String message) throws IOException {
        String fnam = file.getName();
        String mime = DefaultMIMETypes.guessMIMEType(fnam, false);
        FileRandomAccessBuffer data = new FileRandomAccessBuffer(file, true);
        return this.sendFileOffer(fnam, mime, message, data);
    }

    public int sendFileOffer(HTTPUploadedFile file, String message) throws IOException {
        String fnam = file.getFilename();
        String mime = file.getContentType();
        ByteArrayRandomAccessBuffer data = new ByteArrayRandomAccessBuffer(BucketTools.toByteArray(file.getData()));
        return this.sendFileOffer(fnam, mime, message, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFproxyN2NTM(SimpleFieldSet fs, int fileNumber) {
        String text = null;
        long composedTime = fs.getLong("composedTime", -1L);
        long sentTime = fs.getLong("sentTime", -1L);
        long receivedTime = fs.getLong("receivedTime", -1L);
        try {
            text = Base64.decodeUTF8(fs.get("text"));
        }
        catch (IllegalBase64Exception e) {
            Logger.error(this, "Bad Base64 encoding when decoding a N2NTM SimpleFieldSet", (Throwable)e);
            return;
        }
        long msgid = fs.getLong("msgid", -1L);
        String newText = text;
        ArrayList<UserAlert> merged = new ArrayList<UserAlert>();
        if (msgid != -1L) {
            UserAlertManager userAlertManager = this.node.getClientCore().getAlerts();
            synchronized (userAlertManager) {
                for (UserAlert userAlert : this.node.getClientCore().getAlerts().getAlerts()) {
                    N2NTMUserAlert alert;
                    if (!(userAlert instanceof N2NTMUserAlert) || msgid != (alert = (N2NTMUserAlert)userAlert).getMsgid()) continue;
                    if (composedTime == alert.getComposedTime()) {
                        String alertText = alert.getMessageText();
                        if (newText.contains(alertText)) {
                            merged.add(userAlert);
                        } else if (alertText.contains(newText)) {
                            newText = alertText;
                            merged.add(userAlert);
                        } else if (logMINOR) {
                            Logger.minor(this, "failed to merge N2NTMs; there will be at least one duplicate and text might be garbled:\n" + newText + "\n" + alertText);
                        }
                    }
                    if (composedTime == alert.getComposedTime() + 1L) {
                        newText = alert.getMessageText() + newText;
                        merged.add(userAlert);
                        continue;
                    }
                    if (composedTime != alert.getComposedTime() - 1L) continue;
                    newText = newText + alert.getMessageText();
                    merged.add(userAlert);
                }
            }
        }
        int newFileNumber = fileNumber;
        if (merged.size() > 0) {
            fs.putOverwrite("text", Base64.encodeUTF8(newText));
            if (fs.getInt("n2nType", -1) == -1) {
                fs.put("n2nType", 1);
            }
            DarknetPeerNode darknetPeerNode = this;
            synchronized (darknetPeerNode) {
                newFileNumber = this.writeNewExtraPeerDataFile(fs, 1);
                if (newFileNumber == -1) {
                    Logger.error(this, "Failed to write new N2NTM to extra peer data file for N2NTM sfs" + fs);
                    newFileNumber = fileNumber;
                    newText = text;
                    merged.clear();
                } else {
                    this.deleteExtraPeerDataFile(fileNumber);
                }
            }
        }
        N2NTMUserAlert n2NTMUserAlert = new N2NTMUserAlert(this, newText, newFileNumber, composedTime, sentTime, receivedTime, msgid);
        this.node.getClientCore().getAlerts().register(n2NTMUserAlert);
        for (UserAlert alert : merged) {
            this.node.getClientCore().getAlerts().dismissAlert(alert.hashCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFproxyFileOffer(SimpleFieldSet fs, int fileNumber) {
        FileOffer offer;
        try {
            offer = new FileOffer(fs, false);
        }
        catch (FSParseException e) {
            Logger.error(this, "Could not parse offer: " + e + " on " + this + " :\n" + fs, (Throwable)e);
            return;
        }
        Long u = offer.uid;
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            if (this.hisFileOffersByUID.containsKey(u)) {
                return;
            }
            this.hisFileOffersByUID.put(u, offer);
        }
        this.deleteExtraPeerDataFile(fileNumber);
        UserAlert alert = offer.askUserUserAlert();
        this.node.getClientCore().getAlerts().register(alert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptTransfer(long id) {
        FileOffer fo;
        if (logMINOR) {
            Logger.minor(this, "Accepting transfer " + id + " on " + this);
        }
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            fo = this.hisFileOffersByUID.get(id);
        }
        if (fo == null) {
            Logger.error(this, "Cannot accept transfer " + id + " - does not exist");
            return;
        }
        fo.accept();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rejectTransfer(long id) {
        FileOffer fo;
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            fo = this.hisFileOffersByUID.remove(id);
        }
        if (fo == null) {
            Logger.error(this, "Cannot accept transfer " + id + " - does not exist");
            return;
        }
        fo.reject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFproxyFileOfferAccepted(SimpleFieldSet fs, int fileNumber) {
        FileOffer fo;
        long uid;
        this.deleteExtraPeerDataFile(fileNumber);
        try {
            uid = fs.getLong("uid");
        }
        catch (FSParseException e) {
            Logger.error(this, "Could not parse offer accepted: " + e + " on " + this + " :\n" + fs, (Throwable)e);
            return;
        }
        if (logMINOR) {
            Logger.minor(this, "Offer accepted for " + uid);
        }
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            fo = this.myFileOffersByUID.get(uid);
        }
        if (fo == null) {
            Logger.error(this, "No such offer: " + uid);
            try {
                this.sendAsync(DMT.createFNPBulkSendAborted(uid), null, this.node.getNodeStats().nodeToNodeCounter);
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
            return;
        }
        try {
            fo.send();
        }
        catch (DisconnectedException e) {
            Logger.error(this, "Cannot send because node disconnected: " + e + " for " + uid + ":" + fo.filename, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFproxyFileOfferRejected(SimpleFieldSet fs, int fileNumber) {
        FileOffer fo;
        long uid;
        this.deleteExtraPeerDataFile(fileNumber);
        try {
            uid = fs.getLong("uid");
        }
        catch (FSParseException e) {
            Logger.error(this, "Could not parse offer rejected: " + e + " on " + this + " :\n" + fs, (Throwable)e);
            return;
        }
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            fo = this.myFileOffersByUID.remove(uid);
        }
        fo.onRejected();
    }

    public void handleFproxyBookmarkFeed(SimpleFieldSet fs, int fileNumber) {
        String name = fs.get("Name");
        String description = null;
        FreenetURI uri = null;
        boolean hasAnActiveLink = fs.getBoolean("hasAnActivelink", false);
        long composedTime = fs.getLong("composedTime", -1L);
        long sentTime = fs.getLong("sentTime", -1L);
        long receivedTime = fs.getLong("receivedTime", -1L);
        try {
            String s = fs.get("Description");
            if (s != null) {
                description = Base64.decodeUTF8(s);
            }
            uri = new FreenetURI(fs.get("URI"));
        }
        catch (MalformedURLException e) {
            Logger.error(this, "Malformed URI in N2NTM Bookmark Feed message");
            return;
        }
        catch (IllegalBase64Exception e) {
            Logger.error(this, "Bad Base64 encoding when decoding a N2NTM SimpleFieldSet", (Throwable)e);
            return;
        }
        BookmarkFeedUserAlert userAlert = new BookmarkFeedUserAlert(this, name, description, hasAnActiveLink, fileNumber, uri, composedTime, sentTime, receivedTime);
        this.node.getClientCore().getAlerts().register(userAlert);
    }

    public void handleFproxyDownloadFeed(SimpleFieldSet fs, int fileNumber) {
        FreenetURI uri = null;
        String description = null;
        long composedTime = fs.getLong("composedTime", -1L);
        long sentTime = fs.getLong("sentTime", -1L);
        long receivedTime = fs.getLong("receivedTime", -1L);
        try {
            String s = fs.get("Description");
            if (s != null) {
                description = Base64.decodeUTF8(s);
            }
            uri = new FreenetURI(fs.get("URI"));
        }
        catch (MalformedURLException e) {
            Logger.error(this, "Malformed URI in N2NTM File Feed message");
            return;
        }
        catch (IllegalBase64Exception e) {
            Logger.error(this, "Bad Base64 encoding when decoding a N2NTM SimpleFieldSet", (Throwable)e);
            return;
        }
        DownloadFeedUserAlert userAlert = new DownloadFeedUserAlert(this, description, fileNumber, uri, composedTime, sentTime, receivedTime);
        this.node.getClientCore().getAlerts().register(userAlert);
    }

    @Override
    public String userToString() {
        return "" + this.getPeer() + " : " + this.getName();
    }

    @Override
    public PeerNodeStatus getStatus(boolean noHeavy) {
        return new DarknetPeerNodeStatus(this, noHeavy);
    }

    @Override
    public boolean isDarknet() {
        return true;
    }

    @Override
    public boolean isOpennet() {
        return false;
    }

    @Override
    public boolean isSeed() {
        return false;
    }

    @Override
    public void onSuccess(boolean insert, boolean ssk) {
    }

    @Override
    public void onRemove() {
    }

    @Override
    public boolean isRealConnection() {
        return true;
    }

    @Override
    public boolean recordStatus() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DarknetPeerNode) {
            return super.equals(o);
        }
        return false;
    }

    @Override
    public final boolean shouldDisconnectAndRemoveNow() {
        return false;
    }

    @Override
    protected void maybeClearPeerAddedTimeOnConnect() {
        this.peerAddedTime = 0L;
    }

    @Override
    protected boolean shouldExportPeerAddedTime() {
        return true;
    }

    @Override
    protected void maybeClearPeerAddedTimeOnRestart(long now) {
        if (now - this.peerAddedTime > TimeUnit.DAYS.toMillis(30L)) {
            this.peerAddedTime = 0L;
        }
        if (!this.neverConnected) {
            this.peerAddedTime = 0L;
        }
    }

    @Override
    public void fatalTimeout() {
        if (this.node.isStopping()) {
            return;
        }
        Logger.error(this, "Disconnecting from darknet node " + this + " because of fatal timeout", (Throwable)new Exception("error"));
        System.err.println("Your friend node \"" + this.getName() + "\" (" + this.getPeer() + " version " + this.getVersion() + ") is having severe problems. We have disconnected to try to limit the effect on us. It will reconnect soon.");
        this.forceDisconnect();
    }

    public synchronized FRIEND_TRUST getTrustLevel() {
        return this.trustLevel;
    }

    @Override
    public boolean shallWeRouteAccordingToOurPeersLocation(int htl) {
        if (!this.node.shallWeRouteAccordingToOurPeersLocation(htl)) {
            return false;
        }
        return this.trustLevel != FRIEND_TRUST.LOW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTrustLevel(FRIEND_TRUST trust) {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            this.trustLevel = trust;
        }
        this.node.getPeers().writePeersDarknetUrgent();
    }

    public synchronized FRIEND_VISIBILITY getVisibility() {
        if (this.ourVisibility.isStricterThan(this.theirVisibility)) {
            return this.ourVisibility;
        }
        return this.theirVisibility;
    }

    public synchronized FRIEND_VISIBILITY getOurVisibility() {
        return this.ourVisibility;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisibility(FRIEND_VISIBILITY visibility) {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            if (this.ourVisibility == visibility) {
                return;
            }
            this.ourVisibility = visibility;
        }
        this.node.getPeers().writePeersDarknetUrgent();
        try {
            this.sendVisibility();
        }
        catch (NotConnectedException e) {
            Logger.normal(this, "Disconnected while sending visibility update");
        }
    }

    private void sendVisibility() throws NotConnectedException {
        this.sendAsync(DMT.createFNPVisibility(this.getOurVisibility().code), null, this.node.getNodeStats().initialMessagesCtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleVisibility(Message m) {
        FRIEND_VISIBILITY v = FRIEND_VISIBILITY.getByCode(m.getShort("friendVisibility"));
        if (v == null) {
            Logger.error(this, "Bogus visibility setting from peer " + this + " : code " + m.getShort("friendVisibility"));
            v = FRIEND_VISIBILITY.NO;
        }
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            if (this.theirVisibility == v) {
                return;
            }
            this.theirVisibility = v;
        }
        this.node.getPeers().writePeersDarknet();
    }

    public synchronized FRIEND_VISIBILITY getTheirVisibility() {
        if (this.theirVisibility == null) {
            return FRIEND_VISIBILITY.NO;
        }
        return this.theirVisibility;
    }

    @Override
    boolean dontKeepFullFieldSet() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFullNoderef() {
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            if (this.sendingFullNoderef) {
                return;
            }
            this.sendingFullNoderef = true;
        }
        try {
            BulkTransmitter bt;
            SimpleFieldSet myFullNoderef = this.node.exportDarknetPublicFieldSet();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DeflaterOutputStream dos = new DeflaterOutputStream(baos);
            try {
                myFullNoderef.writeTo(dos);
                dos.close();
            }
            catch (IOException e) {
                Logger.error(this, "Impossible: Caught error while writing compressed noderef: " + e, (Throwable)e);
                DarknetPeerNode darknetPeerNode2 = this;
                synchronized (darknetPeerNode2) {
                    this.sendingFullNoderef = false;
                }
                return;
            }
            byte[] data = baos.toByteArray();
            long uid = this.node.getFastWeakRandom().nextLong();
            ByteArrayRandomAccessBuffer raf = new ByteArrayRandomAccessBuffer(data);
            PartiallyReceivedBulk prb = new PartiallyReceivedBulk(this.node.getUSM(), data.length, 1024, raf, true);
            try {
                this.sendAsync(DMT.createFNPMyFullNoderef(uid, data.length), null, this.node.getNodeStats().foafCounter);
            }
            catch (NotConnectedException e1) {
                DarknetPeerNode darknetPeerNode3 = this;
                synchronized (darknetPeerNode3) {
                    this.sendingFullNoderef = false;
                }
                return;
            }
            try {
                bt = new BulkTransmitter(prb, this, uid, false, this.node.getNodeStats().foafCounter, false);
            }
            catch (DisconnectedException e) {
                DarknetPeerNode darknetPeerNode4 = this;
                synchronized (darknetPeerNode4) {
                    this.sendingFullNoderef = false;
                }
                return;
            }
            this.node.getExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        bt.send();
                    }
                    catch (DisconnectedException disconnectedException) {
                        DarknetPeerNode darknetPeerNode = DarknetPeerNode.this;
                        synchronized (darknetPeerNode) {
                            DarknetPeerNode.this.sendingFullNoderef = false;
                        }
                    }
                    finally {
                        DarknetPeerNode darknetPeerNode = DarknetPeerNode.this;
                        synchronized (darknetPeerNode) {
                            DarknetPeerNode.this.sendingFullNoderef = false;
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            DarknetPeerNode darknetPeerNode5 = this;
            synchronized (darknetPeerNode5) {
                this.sendingFullNoderef = false;
            }
            throw e;
        }
        catch (Error e) {
            DarknetPeerNode darknetPeerNode6 = this;
            synchronized (darknetPeerNode6) {
                this.sendingFullNoderef = false;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFullNoderef(Message m) {
        if (this.dontKeepFullFieldSet()) {
            return;
        }
        long uid = m.getLong("uid");
        int length = m.getInt("noderefLength");
        if (length > 8192) {
            return;
        }
        DarknetPeerNode darknetPeerNode = this;
        synchronized (darknetPeerNode) {
            if (this.receivingFullNoderef) {
                return;
            }
            this.receivingFullNoderef = true;
        }
        try {
            final byte[] data = new byte[length];
            ByteArrayRandomAccessBuffer raf = new ByteArrayRandomAccessBuffer(data);
            PartiallyReceivedBulk prb = new PartiallyReceivedBulk(this.node.getUSM(), length, 1024, raf, false);
            final BulkReceiver br = new BulkReceiver(prb, this, uid, this.node.getNodeStats().foafCounter);
            this.node.getExecutor().execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    block31: {
                        try {
                            if (br.receive()) {
                                SimpleFieldSet fs;
                                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                                InflaterInputStream dis = new InflaterInputStream(bais);
                                try {
                                    fs = new SimpleFieldSet(new BufferedReader(new InputStreamReader((InputStream)dis, StandardCharsets.UTF_8)), false, false);
                                }
                                catch (IOException e) {
                                    DarknetPeerNode darknetPeerNode = DarknetPeerNode.this;
                                    synchronized (darknetPeerNode) {
                                        DarknetPeerNode.this.receivingFullNoderef = false;
                                    }
                                    Logger.error(this, "Impossible: " + e, (Throwable)e);
                                    darknetPeerNode = DarknetPeerNode.this;
                                    synchronized (darknetPeerNode) {
                                        DarknetPeerNode.this.receivingFullNoderef = false;
                                    }
                                    return;
                                }
                                try {
                                    DarknetPeerNode.this.processNewNoderef(fs, false, false, true);
                                }
                                catch (FSParseException e) {
                                    Logger.error(this, "Peer " + DarknetPeerNode.this + " sent bogus full noderef: " + e, (Throwable)e);
                                    DarknetPeerNode darknetPeerNode = DarknetPeerNode.this;
                                    synchronized (darknetPeerNode) {
                                        DarknetPeerNode.this.receivingFullNoderef = false;
                                    }
                                    darknetPeerNode = DarknetPeerNode.this;
                                    synchronized (darknetPeerNode) {
                                        DarknetPeerNode.this.receivingFullNoderef = false;
                                    }
                                    return;
                                }
                                DarknetPeerNode darknetPeerNode = DarknetPeerNode.this;
                                synchronized (darknetPeerNode) {
                                    DarknetPeerNode.this.fullFieldSet = fs;
                                }
                                DarknetPeerNode.this.node.getPeers().writePeersDarknet();
                                break block31;
                            }
                            Logger.error(this, "Failed to receive noderef from " + DarknetPeerNode.this);
                        }
                        finally {
                            DarknetPeerNode darknetPeerNode = DarknetPeerNode.this;
                            synchronized (darknetPeerNode) {
                                DarknetPeerNode.this.receivingFullNoderef = false;
                            }
                        }
                    }
                }
            });
        }
        catch (RuntimeException e) {
            DarknetPeerNode darknetPeerNode2 = this;
            synchronized (darknetPeerNode2) {
                this.receivingFullNoderef = false;
            }
            throw e;
        }
        catch (Error e) {
            DarknetPeerNode darknetPeerNode3 = this;
            synchronized (darknetPeerNode3) {
                this.receivingFullNoderef = false;
            }
            throw e;
        }
    }

    @Override
    protected void sendInitialMessages() {
        super.sendInitialMessages();
        try {
            this.sendVisibility();
        }
        catch (NotConnectedException e) {
            Logger.error(this, "Completed handshake with " + this.getPeer() + " but disconnected: " + e, (Throwable)e);
        }
        if (!this.dontKeepFullFieldSet()) {
            try {
                this.sendAsync(DMT.createFNPGetYourFullNoderef(), null, this.node.getNodeStats().foafCounter);
            }
            catch (NotConnectedException notConnectedException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isOpennetForNoderef() {
        return false;
    }

    @Override
    public boolean canAcceptAnnouncements() {
        return this.node.passOpennetRefsThroughDarknet();
    }

    @Override
    protected void writePeers() {
        this.node.getPeers().writePeers(false);
    }

    static {
        Logger.registerClass(DarknetPeerNode.class);
    }

    class FileOffer {
        final long uid;
        final String filename;
        final String mimeType;
        final String comment;
        private File destination;
        private RandomAccessBuffer data;
        final long size;
        final boolean amIOffering;
        private PartiallyReceivedBulk prb;
        private BulkTransmitter transmitter;
        private BulkReceiver receiver;
        private boolean acceptedOrRejected;

        FileOffer(long uid, RandomAccessBuffer data, String filename, String mimeType, String comment) throws IOException {
            this.uid = uid;
            this.data = data;
            this.filename = filename;
            this.mimeType = mimeType;
            this.comment = comment;
            this.size = data.size();
            this.amIOffering = true;
        }

        public FileOffer(SimpleFieldSet fs, boolean amIOffering) throws FSParseException {
            this.uid = fs.getLong("uid");
            this.size = fs.getLong("size");
            this.mimeType = fs.get("metadata.contentType");
            this.filename = FileUtil.sanitize(fs.get("filename"), this.mimeType);
            this.destination = null;
            String s = fs.get("comment");
            if (s != null) {
                try {
                    s = Base64.decodeUTF8(s);
                }
                catch (IllegalBase64Exception e) {
                    Logger.error(this, "Bad Base64 encoding when decoding a private darknet comment SimpleFieldSet", (Throwable)e);
                }
            }
            this.comment = s;
            this.amIOffering = amIOffering;
        }

        public void toFieldSet(SimpleFieldSet fs) {
            fs.put("uid", this.uid);
            fs.putSingle("filename", this.filename);
            fs.putSingle("metadata.contentType", this.mimeType);
            fs.putSingle("comment", Base64.encodeUTF8(this.comment));
            fs.put("size", this.size);
        }

        public void accept() {
            this.acceptedOrRejected = true;
            final String baseFilename = "direct-" + FileUtil.sanitize(DarknetPeerNode.this.getName()) + "-" + this.filename;
            final File dest = DarknetPeerNode.this.node.getClientCore().downloadsDir().file(baseFilename + ".part");
            this.destination = DarknetPeerNode.this.node.getClientCore().downloadsDir().file(baseFilename);
            try {
                this.data = new FileRandomAccessBuffer(dest, this.size, false);
            }
            catch (IOException e) {
                throw new Error("Impossible: FileNotFoundException opening with RAF with rw! " + e, e);
            }
            this.prb = new PartiallyReceivedBulk(DarknetPeerNode.this.node.getUSM(), this.size, 1024, this.data, false);
            this.receiver = new BulkReceiver(this.prb, DarknetPeerNode.this, this.uid, null);
            DarknetPeerNode.this.node.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    if (logMINOR) {
                        Logger.minor(this, "Received file");
                    }
                    try {
                        if (!FileOffer.this.receiver.receive()) {
                            String err = "Failed to receive " + this;
                            Logger.error(this, err);
                            System.err.println(err);
                            FileOffer.this.onReceiveFailure();
                        } else {
                            FileOffer.this.data.close();
                            if (!dest.renameTo(DarknetPeerNode.this.node.getClientCore().downloadsDir().file(baseFilename))) {
                                Logger.error(this, "Failed to rename " + dest.getName() + " to remove .part suffix.");
                            }
                            FileOffer.this.onReceiveSuccess();
                        }
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught " + t + " receiving file", t);
                        FileOffer.this.onReceiveFailure();
                    }
                    finally {
                        FileOffer.this.remove();
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Received file");
                    }
                }
            }, "Receiver for bulk transfer " + this.uid + ":" + this.filename);
            DarknetPeerNode.this.sendFileOfferAccepted(this.uid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void remove() {
            Long l = this.uid;
            DarknetPeerNode darknetPeerNode = DarknetPeerNode.this;
            synchronized (darknetPeerNode) {
                DarknetPeerNode.this.myFileOffersByUID.remove(l);
                DarknetPeerNode.this.hisFileOffersByUID.remove(l);
            }
            this.data.close();
        }

        public void send() throws DisconnectedException {
            this.prb = new PartiallyReceivedBulk(DarknetPeerNode.this.node.getUSM(), this.size, 1024, this.data, true);
            this.transmitter = new BulkTransmitter(this.prb, DarknetPeerNode.this, this.uid, false, DarknetPeerNode.this.node.getNodeStats().nodeToNodeCounter, false);
            if (logMINOR) {
                Logger.minor(this, "Sending " + this.uid);
            }
            DarknetPeerNode.this.node.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    if (logMINOR) {
                        Logger.minor(this, "Sending file");
                    }
                    try {
                        if (!FileOffer.this.transmitter.send()) {
                            String err = "Failed to send " + FileOffer.this.uid + " for " + FileOffer.this;
                            Logger.error(this, err);
                            System.err.println(err);
                        }
                    }
                    catch (Throwable t) {
                        Logger.error(this, "Caught " + t + " sending file", t);
                        FileOffer.this.remove();
                    }
                    if (logMINOR) {
                        Logger.minor(this, "Sent file");
                    }
                }
            }, "Sender for bulk transfer " + this.uid + ":" + this.filename);
        }

        public void reject() {
            this.acceptedOrRejected = true;
            DarknetPeerNode.this.sendFileOfferRejected(this.uid);
        }

        public void onRejected() {
            this.transmitter.cancel("FileOffer: Offer rejected");
            this.prb.abort(9, "Cancelled by receiver");
        }

        protected void onReceiveFailure() {
            AbstractUserAlert alert = new AbstractUserAlert(){

                @Override
                public String dismissButtonText() {
                    return NodeL10n.getBase().getString("UserAlert.hide");
                }

                @Override
                public HTMLNode getHTMLText() {
                    HTMLNode div = new HTMLNode("div");
                    div.addChild("p", FileOffer.this.l10n("failedReceiveHeader", new String[]{"filename", "node"}, new String[]{FileOffer.this.filename, DarknetPeerNode.this.getName()}));
                    FileOffer.this.describeFile(div);
                    return div;
                }

                @Override
                public short getPriorityClass() {
                    return 3;
                }

                @Override
                public String getText() {
                    StringBuilder sb = new StringBuilder();
                    sb.append(FileOffer.this.l10n("failedReceiveHeader", new String[]{"filename", "node"}, new String[]{FileOffer.this.filename, DarknetPeerNode.this.getName()}));
                    sb.append('\n');
                    sb.append(FileOffer.this.l10n("fileLabel"));
                    sb.append(' ');
                    sb.append(FileOffer.this.filename);
                    sb.append('\n');
                    sb.append(FileOffer.this.l10n("sizeLabel"));
                    sb.append(' ');
                    sb.append(SizeUtil.formatSize(FileOffer.this.size));
                    sb.append('\n');
                    sb.append(FileOffer.this.l10n("mimeLabel"));
                    sb.append(' ');
                    sb.append(FileOffer.this.mimeType);
                    sb.append('\n');
                    sb.append(FileOffer.this.l10n("senderLabel"));
                    sb.append(' ');
                    sb.append(DarknetPeerNode.this.getName());
                    sb.append('\n');
                    if (FileOffer.this.comment != null && FileOffer.this.comment.length() > 0) {
                        sb.append(FileOffer.this.l10n("commentLabel"));
                        sb.append(' ');
                        sb.append(FileOffer.this.comment);
                    }
                    return sb.toString();
                }

                @Override
                public String getTitle() {
                    return FileOffer.this.l10n("failedReceiveTitle");
                }

                @Override
                public boolean isValid() {
                    return true;
                }

                @Override
                public void isValid(boolean validity) {
                }

                @Override
                public void onDismiss() {
                }

                @Override
                public boolean shouldUnregisterOnDismiss() {
                    return true;
                }

                @Override
                public boolean userCanDismiss() {
                    return true;
                }

                @Override
                public String getShortText() {
                    return FileOffer.this.l10n("failedReceiveShort", new String[]{"filename", "node"}, new String[]{FileOffer.this.filename, DarknetPeerNode.this.getName()});
                }
            };
            DarknetPeerNode.this.node.getClientCore().getAlerts().register(alert);
        }

        private void onReceiveSuccess() {
            AbstractUserAlert alert = new AbstractUserAlert(){

                @Override
                public String dismissButtonText() {
                    return NodeL10n.getBase().getString("UserAlert.hide");
                }

                @Override
                public HTMLNode getHTMLText() {
                    HTMLNode div = new HTMLNode("div");
                    div.addChild("p", FileOffer.this.l10n("succeededReceiveHeader", new String[]{"filename", "node"}, new String[]{FileOffer.this.filename, DarknetPeerNode.this.getName()}));
                    FileOffer.this.describeFile(div);
                    return div;
                }

                @Override
                public short getPriorityClass() {
                    return 3;
                }

                @Override
                public String getText() {
                    String header = FileOffer.this.l10n("succeededReceiveHeader", new String[]{"filename", "node"}, new String[]{FileOffer.this.filename, DarknetPeerNode.this.getName()});
                    return FileOffer.this.describeFileText(header);
                }

                @Override
                public String getTitle() {
                    return FileOffer.this.l10n("succeededReceiveTitle");
                }

                @Override
                public boolean isValid() {
                    return true;
                }

                @Override
                public void isValid(boolean validity) {
                }

                @Override
                public void onDismiss() {
                }

                @Override
                public boolean shouldUnregisterOnDismiss() {
                    return true;
                }

                @Override
                public boolean userCanDismiss() {
                    return true;
                }

                @Override
                public String getShortText() {
                    return FileOffer.this.l10n("succeededReceiveShort", new String[]{"filename", "node"}, new String[]{FileOffer.this.filename, DarknetPeerNode.this.getName()});
                }
            };
            DarknetPeerNode.this.node.getClientCore().getAlerts().register(alert);
        }

        public UserAlert askUserUserAlert() {
            return new AbstractUserAlert(){

                @Override
                public String dismissButtonText() {
                    return null;
                }

                @Override
                public HTMLNode getHTMLText() {
                    HTMLNode div = new HTMLNode("div");
                    div.addChild("p", FileOffer.this.l10n("offeredFileHeader", "name", DarknetPeerNode.this.getName()));
                    FileOffer.this.describeFile(div);
                    HTMLNode form = DarknetPeerNode.this.node.getClientCore().getToadletContainer().addFormChild(div, "/friends/", "f2fFileOfferAcceptForm");
                    form.addChild("input", new String[]{"type", "name"}, new String[]{"hidden", "node_" + DarknetPeerNode.this.hashCode()});
                    form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"hidden", "id", Long.toString(FileOffer.this.uid)});
                    form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "acceptTransfer", FileOffer.this.l10n("acceptTransferButton")});
                    form.addChild("input", new String[]{"type", "name", "value"}, new String[]{"submit", "rejectTransfer", FileOffer.this.l10n("rejectTransferButton")});
                    return div;
                }

                @Override
                public short getPriorityClass() {
                    return 3;
                }

                @Override
                public String getText() {
                    String header = FileOffer.this.l10n("offeredFileHeader", "name", DarknetPeerNode.this.getName());
                    return FileOffer.this.describeFileText(header);
                }

                @Override
                public String getTitle() {
                    return FileOffer.this.l10n("askUserTitle");
                }

                @Override
                public boolean isValid() {
                    if (FileOffer.this.acceptedOrRejected) {
                        DarknetPeerNode.this.node.getClientCore().getAlerts().unregister(this);
                        return false;
                    }
                    return true;
                }

                @Override
                public void isValid(boolean validity) {
                }

                @Override
                public void onDismiss() {
                }

                @Override
                public boolean shouldUnregisterOnDismiss() {
                    return false;
                }

                @Override
                public boolean userCanDismiss() {
                    return false;
                }

                @Override
                public String getShortText() {
                    return FileOffer.this.l10n("offeredFileShort", new String[]{"filename", "node"}, new String[]{FileOffer.this.filename, DarknetPeerNode.this.getName()});
                }
            };
        }

        protected void addComment(HTMLNode node) {
            String[] lines = this.comment.split("\n");
            int c = lines.length;
            for (int i = 0; i < c; ++i) {
                node.addChild("#", lines[i]);
                if (i == lines.length - 1) continue;
                node.addChild("br");
            }
        }

        private String l10n(String key) {
            return NodeL10n.getBase().getString("FileOffer." + key);
        }

        private String l10n(String key, String pattern, String value) {
            return NodeL10n.getBase().getString("FileOffer." + key, pattern, value);
        }

        private String l10n(String key, String[] pattern, String[] value) {
            return NodeL10n.getBase().getString("FileOffer." + key, pattern, value);
        }

        private String describeFileText(String header) {
            StringBuilder sb = new StringBuilder();
            sb.append(header);
            sb.append('\n');
            sb.append(this.l10n("fileLabel"));
            sb.append(' ');
            sb.append(this.filename);
            sb.append('\n');
            sb.append(this.l10n("sizeLabel"));
            sb.append(' ');
            sb.append(SizeUtil.formatSize(this.size));
            sb.append('\n');
            sb.append(this.l10n("mimeLabel"));
            sb.append(' ');
            sb.append(this.mimeType);
            sb.append('\n');
            sb.append(this.l10n("senderLabel"));
            sb.append(' ');
            sb.append(DarknetPeerNode.this.userToString());
            sb.append('\n');
            if (this.comment != null && this.comment.length() > 0) {
                sb.append(this.l10n("commentLabel"));
                sb.append(' ');
                sb.append(this.comment);
            }
            return sb.toString();
        }

        private void describeFile(HTMLNode div) {
            HTMLNode table = div.addChild("table", "border", "0");
            HTMLNode row = table.addChild("tr");
            row.addChild("td").addChild("#", this.l10n("fileLabel"));
            row.addChild("td").addChild("#", this.filename);
            if (this.destination != null) {
                row = table.addChild("tr");
                row.addChild("td").addChild("#", this.l10n("fileSavedToLabel"));
                row.addChild("td").addChild("#", this.destination.getPath());
            }
            row = table.addChild("tr");
            row.addChild("td").addChild("#", this.l10n("sizeLabel"));
            row.addChild("td").addChild("#", SizeUtil.formatSize(this.size));
            row = table.addChild("tr");
            row.addChild("td").addChild("#", this.l10n("mimeLabel"));
            row.addChild("td").addChild("#", this.mimeType);
            row = table.addChild("tr");
            row.addChild("td").addChild("#", this.l10n("senderLabel"));
            row.addChild("td").addChild("#", DarknetPeerNode.this.getName());
            row = table.addChild("tr");
            if (this.comment != null && this.comment.length() > 0) {
                row.addChild("td").addChild("#", this.l10n("commentLabel"));
                this.addComment(row.addChild("td"));
            }
        }
    }

    public static enum FRIEND_VISIBILITY {
        YES(0),
        NAME_ONLY(1),
        NO(2);

        final short code;

        private FRIEND_VISIBILITY(short code) {
            this.code = code;
        }

        public boolean isStricterThan(FRIEND_VISIBILITY theirVisibility) {
            if (theirVisibility == null) {
                return true;
            }
            return theirVisibility.code < this.code;
        }

        public static FRIEND_VISIBILITY getByCode(short code) {
            for (FRIEND_VISIBILITY f : FRIEND_VISIBILITY.values()) {
                if (f.code != code) continue;
                return f;
            }
            return null;
        }

        public boolean isDefaultValue() {
            return this.equals((Object)YES);
        }
    }

    public static enum FRIEND_TRUST {
        LOW,
        NORMAL,
        HIGH;

        private static final FRIEND_TRUST[] valuesBackwards;

        public static FRIEND_TRUST[] valuesBackwards() {
            return (FRIEND_TRUST[])valuesBackwards.clone();
        }

        public boolean isDefaultValue() {
            return this.equals((Object)NORMAL);
        }

        static {
            FRIEND_TRUST[] values = FRIEND_TRUST.values();
            valuesBackwards = new FRIEND_TRUST[values.length];
            for (int i = 0; i < values.length; ++i) {
                FRIEND_TRUST.valuesBackwards[i] = values[values.length - i - 1];
            }
        }
    }
}

