/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.support.LightweightException;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;

public class LowLevelGetException
extends LightweightException {
    private static volatile boolean logDEBUG;
    private static final long serialVersionUID = 1L;
    public static final int DECODE_FAILED = 1;
    public static final int DATA_NOT_FOUND_IN_STORE = 2;
    public static final int INTERNAL_ERROR = 3;
    public static final int DATA_NOT_FOUND = 4;
    public static final int ROUTE_NOT_FOUND = 5;
    public static final int REJECTED_OVERLOAD = 6;
    public static final int TRANSFER_FAILED = 7;
    public static final int VERIFY_FAILED = 8;
    public static final int CANCELLED = 9;
    public static final int RECENTLY_FAILED = 10;
    public final int code;

    public static String getMessage(int reason) {
        switch (reason) {
            case 1: {
                return "Decode of data failed, probably was bogus at source";
            }
            case 2: {
                return "Data was not in store and request was local-only";
            }
            case 3: {
                return "Internal error - probably a bug";
            }
            case 4: {
                return "Could not find the data";
            }
            case 5: {
                return "Could not find enough nodes to be sure that the data is not out there somewhere";
            }
            case 6: {
                return "A node downstream either timed out or was overloaded (retry)";
            }
            case 7: {
                return "Started to transfer data, then failed (should be rare)";
            }
            case 8: {
                return "Node sent us invalid data";
            }
            case 9: {
                return "Request cancelled";
            }
            case 10: {
                return "Request killed by failure table due to recently DNFing on a downstream node";
            }
        }
        return "Unknown error code: " + reason;
    }

    public LowLevelGetException(int code, String message, Throwable t) {
        super(message, t);
        this.code = code;
    }

    public LowLevelGetException(int code, String message) {
        super(message);
        this.code = code;
    }

    public LowLevelGetException(int reason) {
        super(LowLevelGetException.getMessage(reason));
        this.code = reason;
    }

    public LowLevelGetException(int reason, Throwable t) {
        super(LowLevelGetException.getMessage(reason), t);
        this.code = reason;
    }

    @Override
    public String toString() {
        return super.toString() + ':' + LowLevelGetException.getMessage(this.code);
    }

    @Override
    protected boolean shouldFillInStackTrace() {
        return logDEBUG || this.code == 3 || this.code == 1 || this.code == 8;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }
}

