/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.client.HighLevelSimpleClient;
import freenet.config.Config;
import freenet.config.InvalidConfigValueException;
import freenet.config.SubConfig;
import freenet.crypt.RandomSource;
import freenet.crypt.SSL;
import freenet.io.NetworkInterface;
import freenet.io.SSLNetworkInterface;
import freenet.node.Node;
import freenet.node.NodeClientCore;
import freenet.node.TextModeClientInterface;
import freenet.support.Logger;
import freenet.support.api.BooleanCallback;
import freenet.support.api.IntCallback;
import freenet.support.api.StringCallback;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;

public class TextModeClientInterfaceServer
implements Runnable {
    final RandomSource r;
    final Node n;
    final NodeClientCore core;
    final File downloadsDir;
    int port;
    String bindTo;
    String allowedHosts;
    boolean isEnabled;
    private static boolean ssl = false;
    final NetworkInterface networkInterface;

    TextModeClientInterfaceServer(Node node, NodeClientCore core, int port, String bindTo, String allowedHosts) throws IOException {
        this.n = node;
        this.core = this.n.getClientCore();
        this.r = this.n.getRandom();
        this.downloadsDir = core.getDownloadsDir();
        this.port = port;
        this.bindTo = bindTo;
        this.allowedHosts = allowedHosts;
        this.isEnabled = true;
        this.networkInterface = ssl ? SSLNetworkInterface.create(port, bindTo, allowedHosts, this.n.getExecutor(), true) : NetworkInterface.create(port, bindTo, allowedHosts, this.n.getExecutor(), true);
    }

    void start() {
        Logger.normal(this.core, "TMCI started on " + this.networkInterface.getAllowedHosts() + ':' + this.port);
        System.out.println("TMCI started on " + this.networkInterface.getAllowedHosts() + ':' + this.port);
        this.n.getExecutor().execute(this, "Text mode client interface");
    }

    public static TextModeClientInterfaceServer maybeCreate(Node node, NodeClientCore core, Config config) throws IOException {
        TextModeClientInterfaceServer server = null;
        SubConfig TMCIConfig = config.createSubConfig("console");
        TMCIConfig.register("enabled", false, 1, true, true, "TextModeClientInterfaceServer.enabled", "TextModeClientInterfaceServer.enabledLong", new TMCIEnabledCallback(core));
        TMCIConfig.register("ssl", false, 1, true, true, "TextModeClientInterfaceServer.ssl", "TextModeClientInterfaceServer.sslLong", new TMCISSLCallback());
        TMCIConfig.register("bindTo", "127.0.0.1,0:0:0:0:0:0:0:1", 2, true, false, "TextModeClientInterfaceServer.bindTo", "TextModeClientInterfaceServer.bindToLong", new TMCIBindtoCallback(core));
        TMCIConfig.register("allowedHosts", "127.0.0.1,0:0:0:0:0:0:0:1", 2, true, false, "TextModeClientInterfaceServer.allowedHosts", "TextModeClientInterfaceServer.allowedHostsLong", new TMCIAllowedHostsCallback(core));
        TMCIConfig.register("port", 2323, 1, true, false, "TextModeClientInterfaceServer.telnetPortNumber", "TextModeClientInterfaceServer.telnetPortNumberLong", (IntCallback)new TCMIPortNumberCallback(core), false);
        TMCIConfig.register("directEnabled", false, 1, true, false, "TextModeClientInterfaceServer.enableInputOutput", "TextModeClientInterfaceServer.enableInputOutputLong", new TMCIDirectEnabledCallback(core));
        boolean TMCIEnabled = TMCIConfig.getBoolean("enabled");
        int port = TMCIConfig.getInt("port");
        String bind_ip = TMCIConfig.getString("bindTo");
        String allowedHosts = TMCIConfig.getString("allowedHosts");
        boolean direct = TMCIConfig.getBoolean("directEnabled");
        if (SSL.available()) {
            ssl = TMCIConfig.getBoolean("ssl");
        }
        if (TMCIEnabled) {
            server = new TextModeClientInterfaceServer(node, core, port, bind_ip, allowedHosts);
        }
        if (direct) {
            HighLevelSimpleClient client = core.makeClient((short)1, true, false);
            TextModeClientInterface directTMCI = new TextModeClientInterface(node, core, client, core.getDownloadsDir(), System.in, System.out);
            node.getExecutor().execute(directTMCI, "Direct text mode interface");
            core.setDirectTMCI(directTMCI);
        }
        TMCIConfig.finishedInitialization();
        return server;
    }

    @Override
    public void run() {
        Logger.OSThread.logPID(this);
        while (true) {
            int curPort = this.port;
            String tempBindTo = this.bindTo;
            try {
                this.networkInterface.setSoTimeout(1000);
            }
            catch (SocketException e1) {
                Logger.error(this, "Could not set timeout: " + e1, (Throwable)e1);
                System.err.println("Could not start TMCI: " + e1);
                e1.printStackTrace();
                return;
            }
            while (this.isEnabled && this.port == curPort && this.bindTo.equals(tempBindTo)) {
                try {
                    Socket s = this.networkInterface.accept();
                    if (s == null) continue;
                    InputStream in = s.getInputStream();
                    OutputStream out = s.getOutputStream();
                    TextModeClientInterface tmci = new TextModeClientInterface(this, in, out);
                    this.n.getExecutor().execute(tmci, "Text mode client interface handler for " + s.getPort());
                }
                catch (SocketException e) {
                    Logger.error(this, "Socket error : " + e, (Throwable)e);
                }
                catch (IOException e) {
                    Logger.error(this, "TMCI failed to accept socket: " + e, (Throwable)e);
                }
            }
            try {
                this.networkInterface.close();
                continue;
            }
            catch (IOException e) {
                Logger.error(this, "Error shuting down TMCI", (Throwable)e);
                continue;
            }
            break;
        }
    }

    public void setPort(int val) {
        this.port = val;
    }

    static class TCMIPortNumberCallback
    extends IntCallback {
        final NodeClientCore core;

        TCMIPortNumberCallback(NodeClientCore core) {
            this.core = core;
        }

        @Override
        public Integer get() {
            if (this.core.getTextModeClientInterface() != null) {
                return this.core.getTextModeClientInterface().port;
            }
            return 2323;
        }

        @Override
        public void set(Integer val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            this.core.getTextModeClientInterface().setPort(val);
        }
    }

    static class TMCIAllowedHostsCallback
    extends StringCallback {
        private final NodeClientCore core;

        public TMCIAllowedHostsCallback(NodeClientCore core) {
            this.core = core;
        }

        @Override
        public String get() {
            if (this.core.getTextModeClientInterface() != null) {
                return this.core.getTextModeClientInterface().allowedHosts;
            }
            return "127.0.0.1,0:0:0:0:0:0:0:1";
        }

        @Override
        public void set(String val) throws InvalidConfigValueException {
            if (!val.equals(this.get())) {
                TextModeClientInterfaceServer server = this.core.getTextModeClientInterface();
                if (server != null) {
                    try {
                        server.networkInterface.setAllowedHosts(val);
                    }
                    catch (IllegalArgumentException e) {
                        throw new InvalidConfigValueException(e);
                    }
                    server.allowedHosts = val;
                } else {
                    throw new InvalidConfigValueException("Setting allowedHosts for TMCI (console) server when TMCI is disabled");
                }
            }
        }
    }

    static class TMCIBindtoCallback
    extends StringCallback {
        final NodeClientCore core;

        TMCIBindtoCallback(NodeClientCore core) {
            this.core = core;
        }

        @Override
        public String get() {
            if (this.core.getTextModeClientInterface() != null) {
                return this.core.getTextModeClientInterface().bindTo;
            }
            return "127.0.0.1,0:0:0:0:0:0:0:1";
        }

        @Override
        public void set(String val) throws InvalidConfigValueException {
            if (val.equals(this.get())) {
                return;
            }
            Object[] failedAddresses = this.core.getTextModeClientInterface().networkInterface.setBindTo(val, false);
            if (failedAddresses != null) {
                throw new InvalidConfigValueException("could not change bind to: " + Arrays.toString(failedAddresses));
            }
            this.core.getTextModeClientInterface().bindTo = val;
        }
    }

    static class TMCIDirectEnabledCallback
    extends BooleanCallback {
        final NodeClientCore core;

        TMCIDirectEnabledCallback(NodeClientCore core) {
            this.core = core;
        }

        @Override
        public Boolean get() {
            return this.core.getDirectTMCI() != null;
        }

        @Override
        public void set(Boolean val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            throw new InvalidConfigValueException("Cannot be updated on the fly");
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }

    static class TMCISSLCallback
    extends BooleanCallback {
        TMCISSLCallback() {
        }

        @Override
        public Boolean get() {
            return ssl;
        }

        @Override
        public void set(Boolean val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            if (!SSL.available()) {
                throw new InvalidConfigValueException("Enable SSL support before use ssl with TMCI");
            }
            ssl = val;
            throw new InvalidConfigValueException("Cannot change SSL on the fly, please restart freenet");
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }

    static class TMCIEnabledCallback
    extends BooleanCallback {
        final NodeClientCore core;

        TMCIEnabledCallback(NodeClientCore core) {
            this.core = core;
        }

        @Override
        public Boolean get() {
            return this.core.getTextModeClientInterface() != null;
        }

        @Override
        public void set(Boolean val) throws InvalidConfigValueException {
            if (this.get().equals(val)) {
                return;
            }
            throw new InvalidConfigValueException("Cannot be updated on the fly");
        }

        @Override
        public boolean isReadOnly() {
            return true;
        }
    }
}

